/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.tree;

import com.ibm.team.repository.rcp.ui.internal.tree.ObservableTreeContentProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeNode
implements ISetChangeListener,
IStaleListener {
    private ObservableTreeContentProvider contentProvider;
    private Object element;
    private HashSet parents = null;
    Object parent;
    private IObservableSet children;
    private boolean hasPendingNode = false;
    private boolean isStale;
    private boolean listeningToChildren = false;
    private boolean prefetchEnqueued = false;
    private int ignoreEvents = 0;

    public TreeNode(Object element, ObservableTreeContentProvider cp) {
        this.element = element;
        this.contentProvider = cp;
        if (element == this.contentProvider.getPendingNode()) {
            this.children = Observables.emptyObservableSet();
            this.listeningToChildren = true;
        } else {
            this.children = this.contentProvider.createChildSet(element);
        }
        if (this.children == null) {
            this.children = Observables.emptyObservableSet();
            this.listeningToChildren = true;
        }
        this.hasPendingNode = this.children.isStale();
    }

    public void addParent(Object parent) {
        if (this.parent == null) {
            this.parent = parent;
        } else {
            if (parent.equals(this.parent)) {
                return;
            }
            if (this.parents == null) {
                this.parents = new HashSet();
                this.parents.add(this.parent);
            }
            this.parents.add(parent);
        }
    }

    public void removeParent(Object parent) {
        if (this.parents != null) {
            this.parents.remove(parent);
        }
        if (parent == this.parent) {
            this.parent = this.parents == null || this.parents.isEmpty() ? null : this.parents.iterator().next();
        }
        if (this.parents != null && this.parents.size() <= 1) {
            this.parents = null;
        }
    }

    public Set getChildren() {
        if (!this.listeningToChildren) {
            this.listeningToChildren = true;
            this.children.addSetChangeListener((ISetChangeListener)this);
            this.hasPendingNode = this.children.isEmpty() && this.children.isStale();
            this.children.addStaleListener((IStaleListener)this);
            this.updateStale();
        }
        if (this.hasPendingNode) {
            Object pendingNode = this.contentProvider.getPendingNode();
            return Collections.singleton(pendingNode);
        }
        if (this.children == null) {
            return Collections.EMPTY_SET;
        }
        return this.children;
    }

    public IObservableSet getChildrenSet() {
        return this.children;
    }

    private void updateStale() {
        boolean willBeStale = this.children.isStale();
        if (willBeStale != this.isStale) {
            this.isStale = willBeStale;
            this.contentProvider.changeStale(this.isStale ? 1 : -1);
        }
    }

    public boolean isStale() {
        return this.isStale;
    }

    public boolean shouldShowPlus() {
        if (this.children == null) {
            return true;
        }
        if (!this.listeningToChildren && !this.prefetchEnqueued) {
            this.prefetchEnqueued = true;
            this.contentProvider.enqueuePrefetch(this);
        }
        return !this.listeningToChildren || this.hasPendingNode || !this.children.isEmpty();
    }

    public void dispose() {
        if (this.children != null) {
            if (this.listeningToChildren) {
                this.remove(this.element, (Set<Object>)this.children, true);
                this.children.removeSetChangeListener((ISetChangeListener)this);
                this.children.removeStaleListener((IStaleListener)this);
            }
            this.children.dispose();
            this.children = Observables.emptyObservableSet();
            if (this.listeningToChildren && this.isStale) {
                this.contentProvider.changeStale(-1);
            }
        }
    }

    public boolean isDisposed() {
        return this.children == null;
    }

    public Object getParent() {
        return this.parent;
    }

    public Set getParents() {
        if (this.parents == null) {
            if (this.parent == null) {
                return Collections.EMPTY_SET;
            }
            return Collections.singleton(this.parent);
        }
        return this.parents;
    }

    public void handleSetChange(SetChangeEvent event) {
        Control control;
        event.getObservableSet();
        SetDiff diff = event.diff;
        TreeViewer viewer = this.contentProvider.getViewer();
        if (viewer != null && (control = viewer.getControl()) != null && control.isDisposed()) {
            this.contentProvider.dispose();
            return;
        }
        boolean shouldHavePendingNode = this.children.isEmpty() && this.children.isStale();
        HashSet<Object> additions = diff.getAdditions();
        if (shouldHavePendingNode && !this.hasPendingNode) {
            HashSet<Object> newAdditions = new HashSet<Object>();
            newAdditions.addAll(additions);
            newAdditions.add(this.contentProvider.getPendingNode());
            additions = newAdditions;
            this.hasPendingNode = true;
        }
        HashSet<Object> removals = diff.getRemovals();
        if (!shouldHavePendingNode && this.hasPendingNode) {
            HashSet<Object> newRemovals = new HashSet<Object>();
            newRemovals.addAll(removals);
            newRemovals.add(this.contentProvider.getPendingNode());
            removals = newRemovals;
            this.hasPendingNode = false;
        }
        if (!additions.isEmpty()) {
            this.add(this.element, (Set<Object>)additions);
        }
        if (!removals.isEmpty()) {
            this.remove(this.element, (Set<Object>)removals, this.children.isEmpty() && !this.hasPendingNode);
        }
        this.updateStale();
    }

    public void handleStale(StaleEvent staleEvent) {
        boolean shouldHavePendingNode;
        Control control;
        TreeViewer viewer = this.contentProvider.getViewer();
        if (viewer != null && (control = viewer.getControl()) != null && control.isDisposed()) {
            this.contentProvider.dispose();
            return;
        }
        boolean bl = shouldHavePendingNode = this.children.isEmpty() && this.children.isStale();
        if (shouldHavePendingNode && !this.hasPendingNode) {
            this.hasPendingNode = shouldHavePendingNode;
            this.add(this.element, Collections.singleton(this.contentProvider.getPendingNode()));
        }
        if (!shouldHavePendingNode && this.hasPendingNode) {
            this.hasPendingNode = shouldHavePendingNode;
            this.remove(this.element, Collections.singleton(this.contentProvider.getPendingNode()), true);
        }
        this.updateStale();
    }

    private void remove(Object parent, Set<Object> removals, boolean isLast) {
        if (this.ignoreEvents == 0) {
            this.contentProvider.remove(parent, removals, isLast);
        }
    }

    private void add(Object parent, Set<Object> additions) {
        if (this.ignoreEvents == 0) {
            this.contentProvider.add(parent, additions);
        }
    }

    public Object getElement() {
        return this.element;
    }

    public void prefetch() {
        Control control;
        TreeViewer viewer = this.contentProvider.getViewer();
        if (viewer != null && (control = viewer.getControl()) != null && control.isDisposed()) {
            return;
        }
        Set children = this.getChildren();
        if (!children.isEmpty()) {
            this.add(this.element, children);
        } else if (this.ignoreEvents == 0) {
            this.contentProvider.getViewer().refresh(this.element);
        }
    }

    public void ignoreEvents(boolean shouldIgnore) {
        this.ignoreEvents = shouldIgnore ? ++this.ignoreEvents : --this.ignoreEvents;
    }
}

