/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.tree;

import com.ibm.team.repository.rcp.ui.internal.tree.IObservableTree;
import com.ibm.team.repository.rcp.ui.internal.tree.IParentProvider;
import com.ibm.team.repository.rcp.ui.internal.tree.TreeNode;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableTreeContentProvider
implements ITreeContentProvider,
ITreePathContentProvider {
    private HashMap mapElementToTreeNode = new HashMap();
    private LinkedList enqueuedPrefetches = new LinkedList();
    private IParentProvider rootParentProvider = null;
    private boolean useTreePaths = false;
    KnownElementsSet elements = new KnownElementsSet();
    private ITreeViewerListener expandListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    };
    private Object inputElement;
    private IObservableTree provider;
    private Object pendingNode;
    private int avoidViewerUpdates;
    private TreeViewer treeViewer;
    private int staleCount = 0;
    private boolean useRefresh;
    private int maxPrefetches = 0;

    public ObservableTreeContentProvider(IObservableTree provider, Object pendingNode, boolean useRefresh) {
        this.provider = provider;
        this.pendingNode = pendingNode;
        this.useRefresh = useRefresh;
    }

    public void useTreePaths(boolean usePaths) {
        this.useTreePaths = usePaths;
    }

    public void setRootPath(IParentProvider rootParentProvider) {
        this.rootParentProvider = rootParentProvider;
    }

    public void setMaxPrefetches(int maxPrefetches) {
        this.maxPrefetches = maxPrefetches;
    }

    IObservableSet createChildSet(Object element) {
        return this.provider.createChildSet(element);
    }

    void remove(Object element, Set removals, boolean lastElement) {
        if (removals.isEmpty()) {
            return;
        }
        if (this.avoidViewerUpdates == 0) {
            if (lastElement || this.useRefresh) {
                this.doRefresh(element);
            } else if (this.useTreePaths) {
                ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
                TreePath[] parents = this.getParents(element);
                int i = 0;
                while (i < parents.length) {
                    TreePath parent = parents[i];
                    for (Object elementToRemove : removals) {
                        toRemove.add(parent.createChildPath(element).createChildPath(elementToRemove));
                    }
                    ++i;
                }
                this.treeViewer.remove((Object[])toRemove.toArray(new TreePath[toRemove.size()]));
            } else {
                this.treeViewer.remove(element, removals.toArray());
            }
            for (Object next : removals) {
                TreeNode nextNode = (TreeNode)this.mapElementToTreeNode.get(next);
                if (nextNode == null) continue;
                nextNode.removeParent(element);
                this.removeIfUnused(nextNode);
            }
        }
    }

    void add(Object element, Set additions) {
        if (additions.isEmpty()) {
            return;
        }
        this.elements.deferEvents();
        try {
            this.addParent(element, additions);
            if (this.avoidViewerUpdates == 0) {
                if (this.useRefresh) {
                    this.doRefresh(element);
                } else if (this.useTreePaths) {
                    TreePath[] parents = this.getParents(element);
                    int i = 0;
                    while (i < parents.length) {
                        TreePath parent = parents[i];
                        this.treeViewer.add((Object)parent.createChildPath(element), additions.toArray());
                        ++i;
                    }
                } else {
                    this.treeViewer.add(element, additions.toArray());
                }
            }
        }
        finally {
            this.elements.resumeEvents();
        }
    }

    private void doRefresh(Object element) {
        this.treeViewer.refresh(element);
    }

    private void addParent(Object parent, Set children) {
        this.elements.deferEvents();
        try {
            for (Object next : children) {
                TreeNode nextNode = this.getNode(next);
                nextNode.addParent(parent);
            }
        }
        finally {
            this.elements.resumeEvents();
        }
    }

    public final Object getPendingNode() {
        return this.pendingNode;
    }

    public IObservableSet getChildrenSet(Object parent) {
        IObservableSet result = this.getNode(parent).getChildrenSet();
        return result;
    }

    public void dispose() {
        if (this.treeViewer != null) {
            try {
                ++this.avoidViewerUpdates;
                this.enqueuedPrefetches.clear();
                Object[] keys = this.mapElementToTreeNode.keySet().toArray();
                int i = 0;
                while (i < keys.length) {
                    Object key = keys[i];
                    TreeNode result = (TreeNode)this.mapElementToTreeNode.get(key);
                    if (result != null) {
                        result.dispose();
                    }
                    ++i;
                }
                this.setViewer(null);
            }
            finally {
                --this.avoidViewerUpdates;
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.setViewer(viewer);
        if (oldInput != null && newInput != null && oldInput.equals(newInput)) {
            return;
        }
        this.inputElement = newInput;
        try {
            ++this.avoidViewerUpdates;
            TreeNode oldNode = (TreeNode)this.mapElementToTreeNode.get(oldInput);
            if (oldNode != null) {
                this.removeIfUnused(oldNode);
            }
        }
        finally {
            --this.avoidViewerUpdates;
        }
    }

    private void removeIfUnused(TreeNode toRemove) {
        Object element = toRemove.getElement();
        if (toRemove.getParent() == null) {
            this.mapElementToTreeNode.remove(element);
            this.elements.doFireDiff(Collections.EMPTY_SET, Collections.singleton(element));
            toRemove.dispose();
        }
    }

    private void setViewer(Viewer viewer) {
        if (viewer != null && !(viewer instanceof TreeViewer)) {
            throw new IllegalArgumentException("This content provider can only be used with TreeViewers");
        }
        TreeViewer newTreeViewer = (TreeViewer)viewer;
        if (newTreeViewer != this.treeViewer) {
            if (this.treeViewer != null) {
                this.treeViewer.removeTreeListener(this.expandListener);
            }
            this.treeViewer = newTreeViewer;
            if (newTreeViewer != null) {
                newTreeViewer.addTreeListener(this.expandListener);
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        TreeNode node = this.getNode(parentElement);
        try {
            node.ignoreEvents(true);
            Set result = node.getChildren();
            this.addParent(parentElement, result);
            Object[] objectArray = result.toArray();
            return objectArray;
        }
        finally {
            node.ignoreEvents(false);
        }
    }

    private TreeNode getNode(Object parentElement) {
        TreeNode result = (TreeNode)this.mapElementToTreeNode.get(parentElement);
        if (result == null) {
            result = new TreeNode(parentElement, this);
            this.mapElementToTreeNode.put(parentElement, result);
            this.elements.doFireDiff(Collections.singleton(parentElement), Collections.EMPTY_SET);
        }
        return result;
    }

    public Object getParent(Object element) {
        Object result = this.getNode(element).getParent();
        if (result == null && this.rootParentProvider != null) {
            result = this.rootParentProvider.getParent(element);
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getNode(element).shouldShowPlus();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public IObservableSet getKnownElements() {
        return this.elements;
    }

    void changeStale(int staleDelta) {
        this.staleCount += staleDelta;
        this.processPrefetches();
        this.elements.setStale(this.staleCount != 0);
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public boolean isDirty(Object element) {
        return false;
    }

    void enqueuePrefetch(TreeNode node) {
        if (this.maxPrefetches > 0 || this.maxPrefetches == -1) {
            if (this.staleCount == 0) {
                node.getChildren();
            } else {
                this.enqueuedPrefetches.add(node);
                while (this.maxPrefetches >= 0 && this.enqueuedPrefetches.size() > this.maxPrefetches) {
                    this.enqueuedPrefetches.removeFirst();
                }
            }
        }
    }

    private void processPrefetches() {
        while (this.staleCount == 0 && !this.enqueuedPrefetches.isEmpty()) {
            TreeNode next = (TreeNode)this.enqueuedPrefetches.removeLast();
            if (next.isDisposed()) continue;
            next.prefetch();
        }
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.getChildren(parentPath.getLastSegment());
    }

    public TreePath[] getParents(Object element) {
        Object nextParent;
        List<List> parentPaths = this.computeParents(element, new HashSet());
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (List nextPath : parentPaths) {
            LinkedList<Object> resultPath = new LinkedList<Object>();
            resultPath.addAll(nextPath);
            if (this.rootParentProvider == null && !resultPath.isEmpty()) {
                resultPath.removeFirst();
            }
            Object nextParent2 = resultPath.isEmpty() ? element : resultPath.getFirst();
            while (nextParent2 != null) {
                if (this.rootParentProvider != null) {
                    if ((nextParent2 = this.rootParentProvider.getParent(nextParent2)) == null) continue;
                    resultPath.addFirst(nextParent2);
                    continue;
                }
                nextParent2 = null;
            }
            result.add(new TreePath(resultPath.toArray()));
        }
        if (result.isEmpty() && this.rootParentProvider != null && (nextParent = this.rootParentProvider.getParent(element)) != null) {
            LinkedList<Object> resultPath = new LinkedList<Object>();
            while (nextParent != null) {
                resultPath.addFirst(nextParent);
                nextParent = this.rootParentProvider.getParent(nextParent);
            }
            result.add(new TreePath(resultPath.toArray()));
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private List<List> computeParents(Object node, HashSet toIgnore) {
        ArrayList<List> result = new ArrayList<List>();
        boolean containedNode = toIgnore.add(node);
        TreeNode tn = this.getNode(node);
        HashSet parents = new HashSet();
        parents.addAll(tn.getParents());
        parents.removeAll(toIgnore);
        if (parents.isEmpty()) {
            ArrayList newPath = new ArrayList();
            result.add(newPath);
        } else {
            for (Object parent : parents) {
                List<List> parentPaths = this.computeParents(parent, toIgnore);
                for (List parentPath : parentPaths) {
                    parentPath.add(parent);
                    result.add(parentPath);
                }
            }
        }
        if (containedNode) {
            toIgnore.remove(node);
        }
        return result;
    }

    public boolean hasChildren(TreePath path) {
        return this.hasChildren(path.getLastSegment());
    }

    public int getMaxPrefetches() {
        return this.maxPrefetches;
    }

    class KnownElementsSet
    extends AbstractObservableSet {
        private int eventsDeferred;
        private Set deferredAdditions = new HashSet();
        private Set deferredRemovals = new HashSet();

        protected KnownElementsSet() {
        }

        public void deferEvents() {
            ++this.eventsDeferred;
        }

        public void resumeEvents() {
            --this.eventsDeferred;
            if (this.eventsDeferred == 0) {
                Set adds = this.deferredAdditions;
                Set removals = this.deferredRemovals;
                if (!adds.isEmpty() || !removals.isEmpty()) {
                    this.deferredAdditions = new HashSet();
                    this.deferredRemovals = new HashSet();
                    this.fireSetChange(Diffs.createSetDiff((Set)adds, (Set)removals));
                }
            }
        }

        protected Set getWrappedSet() {
            return ObservableTreeContentProvider.this.mapElementToTreeNode.keySet();
        }

        void doFireDiff(Set added, Set removed) {
            this.deferEvents();
            if (this.eventsDeferred == 0) {
                this.fireSetChange(Diffs.createSetDiff((Set)added, (Set)removed));
            } else {
                for (Object next : added) {
                    if (this.deferredRemovals.remove(next)) continue;
                    this.deferredAdditions.add(next);
                }
                for (Object next : removed) {
                    if (this.deferredAdditions.remove(next)) continue;
                    this.deferredRemovals.add(next);
                }
            }
            Display display = Display.getCurrent();
            if (!display.isDisposed()) {
                SWTUtil.greedyExec(Display.getCurrent(), new Runnable(){

                    public void run() {
                        KnownElementsSet.this.resumeEvents();
                    }
                });
            }
        }

        void doFireStale(boolean isStale) {
            if (isStale) {
                this.fireStale();
            } else {
                this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, (Set)Collections.EMPTY_SET));
            }
        }

        public Object getElementType() {
            return new Object();
        }
    }
}

