/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.tree;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableSetFactoryToSetWithListeners<T>
extends AbstractSetWithListeners<T>
implements IRefreshable {
    private PrivateInterface privateInterface = new PrivateInterface();
    private IObservableSet wrapped;

    public ObservableSetFactoryToSetWithListeners() {
        this.setStale(true);
    }

    @Override
    public boolean canRefresh() {
        return this.wrapped != null && this.wrapped instanceof IRefreshable && ((IRefreshable)this.wrapped).canRefresh();
    }

    @Override
    public void refresh() {
        if (this.wrapped instanceof IRefreshable) {
            IRefreshable refreshable = (IRefreshable)this.wrapped;
            refreshable.refresh();
        }
    }

    protected abstract IObservableSet createSet();

    @Override
    protected Collection computeElements() {
        if (this.wrapped != null) {
            return this.wrapped;
        }
        return Collections.EMPTY_SET;
    }

    @Override
    protected void allocate() {
        this.wrapped = this.createSet();
        this.wrapped.addSetChangeListener((ISetChangeListener)this.privateInterface);
        this.wrapped.addStaleListener((IStaleListener)this.privateInterface);
        this.setStale(this.wrapped.isStale());
        super.allocate();
    }

    @Override
    protected void deallocate() {
        this.wrapped.dispose();
        this.wrapped = null;
        super.deallocate();
    }

    private class PrivateInterface
    implements ISetChangeListener,
    IStaleListener {
        private PrivateInterface() {
        }

        public void handleSetChange(SetChangeEvent event) {
            event.getObservableSet();
            org.eclipse.core.databinding.observable.set.SetDiff diff = event.diff;
            ObservableSetFactoryToSetWithListeners.this.fireDiff(SetDiff.create((Collection)diff.getRemovals(), (Collection)diff.getAdditions()));
            ObservableSetFactoryToSetWithListeners.this.setStale(ObservableSetFactoryToSetWithListeners.this.wrapped.isStale());
        }

        public void handleStale(StaleEvent event) {
            ObservableSetFactoryToSetWithListeners.this.setStale(ObservableSetFactoryToSetWithListeners.this.wrapped.isStale());
        }
    }
}

