/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.selection;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.selection.ITypedSelectionService;
import com.ibm.team.repository.rcp.ui.internal.selection.IWrapperInput;
import com.ibm.team.repository.rcp.ui.parts.IPinnablePart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IDisposable;

public class PageTypedSelectionService
implements ITypedSelectionService,
IDisposable {
    private IWorkbenchPage page;
    private Map mapClassOntoSelectionTypeEntry = new HashMap();
    private List closingParts = new ArrayList();
    private IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                PageTypedSelectionService.this.updateSelections(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            PageTypedSelectionService.this.closingParts.add(partRef);
            PageTypedSelectionService.this.clearSelections(partRef.getPart(false));
            PageTypedSelectionService.this.closingParts.remove(partRef);
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    };
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (PageTypedSelectionService.this.page.getActivePart() == part) {
                PageTypedSelectionService.this.updateSelections(part);
                return;
            }
        }
    };

    public PageTypedSelectionService(IWorkbenchPage page2) {
        this.page = page2;
    }

    private static Collection convertCollection(Collection selection, Class type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object next : selection) {
            Object adapter = Adapters.getAdapter(next, (Class)type);
            if (adapter == null) continue;
            result.add(adapter);
        }
        return result;
    }

    public void addListener(Class selectionType, IChangeListener l) {
        SelectionTypeEntry entry;
        if (this.mapClassOntoSelectionTypeEntry.isEmpty()) {
            this.page.addPartListener(this.partListener);
            this.page.addSelectionListener(this.selectionListener);
        }
        if ((entry = (SelectionTypeEntry)this.mapClassOntoSelectionTypeEntry.get(selectionType)) == null) {
            entry = new SelectionTypeEntry(selectionType);
            this.mapClassOntoSelectionTypeEntry.put(selectionType, entry);
        }
        entry.listeners.add(l);
    }

    protected void clearSelections(IWorkbenchPart partRef) {
        Collection typeEntries = this.mapClassOntoSelectionTypeEntry.values();
        for (SelectionTypeEntry entry : typeEntries) {
            if (entry.targetPart != partRef) continue;
            entry.clearSelection();
        }
    }

    protected void updateSelections(IWorkbenchPart part) {
        Collection selection = PageTypedSelectionService.getSelectionFor(part);
        Collection typeEntries = this.mapClassOntoSelectionTypeEntry.values();
        for (SelectionTypeEntry entry : typeEntries) {
            Collection convertedTypes = PageTypedSelectionService.convertCollection(selection, entry.type);
            if (convertedTypes.isEmpty()) continue;
            entry.setSelection(part, convertedTypes);
        }
    }

    public Collection getSelection(Class selectionType) {
        SelectionTypeEntry entry = (SelectionTypeEntry)this.mapClassOntoSelectionTypeEntry.get(selectionType);
        if (entry == null) {
            entry = new SelectionTypeEntry(selectionType);
            Collection result = entry.getSelection();
            entry.dispose();
            return result;
        }
        return entry.getSelection();
    }

    public static Collection getSelectionFor(IWorkbenchPart part) {
        IWorkbenchPartSite site = part.getSite();
        if (site != null) {
            ISelection selection;
            ISelectionProvider provider = site.getSelectionProvider();
            if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                ArrayList notNull = new ArrayList();
                for (Object next : structuredSelection.toList()) {
                    if (next == null) continue;
                    notNull.add(next);
                }
                return notNull;
            }
            if (part instanceof IEditorPart) {
                IWrapperInput wrapper;
                IEditorPart ep = (IEditorPart)part;
                IEditorInput input = ep.getEditorInput();
                if (input != null && (wrapper = (IWrapperInput)Adapters.getAdapter((Object)input, IWrapperInput.class)) != null) {
                    Object selection2 = wrapper.getWrappedObject();
                    if (selection2 != null) {
                        return Collections.singleton(selection2);
                    }
                    return Collections.EMPTY_LIST;
                }
            } else {
                IPinnablePart partWithInput = (IPinnablePart)Adapters.getAdapter((Object)part, IPinnablePart.class);
                if (partWithInput != null) {
                    Object input = partWithInput.getInput();
                    if (input != null) {
                        return Collections.singleton(input);
                    }
                    return Collections.EMPTY_LIST;
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void removeListener(Class selectionType, IChangeListener l) {
        SelectionTypeEntry entry = (SelectionTypeEntry)this.mapClassOntoSelectionTypeEntry.get(selectionType);
        if (entry != null) {
            entry.listeners.remove(l);
            if (entry.listeners.isEmpty()) {
                this.mapClassOntoSelectionTypeEntry.remove(selectionType);
                entry.dispose();
            }
        }
        if (this.mapClassOntoSelectionTypeEntry.isEmpty()) {
            this.page.removeSelectionListener(this.selectionListener);
            this.page.removePartListener(this.partListener);
        }
    }

    public void dispose() {
        for (SelectionTypeEntry next : this.mapClassOntoSelectionTypeEntry.values()) {
            next.dispose();
        }
        if (!this.mapClassOntoSelectionTypeEntry.isEmpty()) {
            this.page.removeSelectionListener(this.selectionListener);
            this.page.removePartListener(this.partListener);
        }
        this.mapClassOntoSelectionTypeEntry.clear();
    }

    final class SelectionTypeEntry {
        private Class type;
        private ChangeListenerList listeners = new ChangeListenerList();
        private Collection lastKnownSelection;
        private IWorkbenchPart targetPart;
        private ISelectionProvider provider = null;

        public SelectionTypeEntry(Class selectionType) {
            this.type = selectionType;
        }

        Collection getSelection() {
            if (this.lastKnownSelection == null) {
                this.lastKnownSelection = Collections.EMPTY_LIST;
                ArrayList<Object> parts = new ArrayList<Object>();
                parts.add(PageTypedSelectionService.this.page.getActivePartReference());
                parts.addAll(Arrays.asList(PageTypedSelectionService.this.page.getEditorReferences()));
                parts.addAll(Arrays.asList(PageTypedSelectionService.this.page.getViewReferences()));
                parts.removeAll(PageTypedSelectionService.this.closingParts);
                for (IWorkbenchPartReference iWorkbenchPartReference : parts) {
                    Collection selection;
                    Collection adaptedSelection;
                    IWorkbenchPart part;
                    if (iWorkbenchPartReference == null || (part = iWorkbenchPartReference.getPart(false)) == null || (adaptedSelection = PageTypedSelectionService.convertCollection(selection = PageTypedSelectionService.getSelectionFor(part), this.type)).isEmpty()) continue;
                    this.setSelection(part, adaptedSelection);
                    break;
                }
            }
            return this.lastKnownSelection;
        }

        public void setSelection(IWorkbenchPart ref, Collection sel) {
            if (ref == this.targetPart && Util.equals((Object)sel, (Object)this.lastKnownSelection)) {
                return;
            }
            Collection oldSel = this.lastKnownSelection;
            this.lastKnownSelection = sel;
            this.targetPart = ref;
            if (oldSel != null) {
                this.listeners.notifyListeners((Object)this.type, PROP_CHANGED);
            }
        }

        public void clearSelection() {
            this.setSelection(null, null);
        }

        public void dispose() {
            this.clearSelection();
        }
    }
}

