/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;

public abstract class SmartField {
    public DecoratedField field;
    IControlContentAdapter contentAdapter;
    FieldDecoration errorDecoration;
    FieldDecoration warningDecoration;
    private boolean edited = false;

    public SmartField(DecoratedField field, IControlContentAdapter adapter) {
        this.field = field;
        this.contentAdapter = adapter;
    }

    public String getContents() {
        return this.contentAdapter.getControlContents(this.field.getControl());
    }

    public boolean isRequiredField() {
        return true;
    }

    public FieldDecoration getErrorDecoration() {
        if (this.errorDecoration == null) {
            FieldDecoration standardError = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.errorDecoration = this.getErrorMessage() == null ? standardError : new FieldDecoration(standardError.getImage(), this.getErrorMessage());
        }
        return this.errorDecoration;
    }

    public void setEditor(boolean edited) {
        this.edited = edited;
    }

    public boolean getEdited() {
        return this.edited;
    }

    public FieldDecoration getWarningDecoration() {
        if (this.warningDecoration == null) {
            FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
            this.warningDecoration = this.getWarningMessage() == null ? standardWarning : new FieldDecoration(standardWarning.getImage(), this.getWarningMessage());
        }
        return this.warningDecoration;
    }

    public abstract boolean isValid();

    public abstract boolean isWarning();

    public String getErrorMessage() {
        return null;
    }

    public String getWarningMessage() {
        return null;
    }
}

