/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.RecursivePreferenceListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.workingcopy.AbstractWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IPreferencesWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class PreferencesWorkingCopy
extends AbstractWorkingCopy
implements IPreferencesWorkingCopy {
    private IEclipsePreferences original;
    private IEclipsePreferences workingCopy;
    private RecursivePreferenceListener modifiedListener;
    private volatile boolean modified;
    private RecursivePreferenceListener dirtyListener;
    private String name;
    private ISaveParticipant participant;

    public PreferencesWorkingCopy(String name, IEclipsePreferences original, ISaveParticipant participant) throws BackingStoreException {
        this.original = original;
        this.participant = participant;
        this.workingCopy = PreferencesUtil.createPreferences();
        PreferencesUtil.copyTree((Preferences)this.workingCopy, (Preferences)original, null);
        this.modifiedListener = new RecursivePreferenceListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                PreferencesWorkingCopy.this.modified = true;
            }
        });
        this.modifiedListener.attachTo(original);
        this.dirtyListener = new RecursivePreferenceListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                PreferencesWorkingCopy.this.setDirty(true);
            }
        });
        this.dirtyListener.attachTo(this.workingCopy);
        this.name = name;
    }

    public PreferencesWorkingCopy(String name, IEclipsePreferences original) throws BackingStoreException {
        this(name, original, null);
    }

    protected void savePreferences(IEclipsePreferences prefs, IProgressMonitor monitor) throws BackingStoreException {
        prefs.flush();
        if (this.participant != null) {
            this.participant.saved(prefs, monitor);
        }
    }

    public IEclipsePreferences getPreferences() {
        return this.workingCopy;
    }

    public void save(IProgressMonitor progress) throws CoreException, SaveConflictException {
        if (!this.isValid()) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            PreferencesUtil.copyTree((Preferences)this.original, (Preferences)this.workingCopy, (IProgressMonitor)monitor.newChild(10));
            this.savePreferences(this.original, (IProgressMonitor)monitor.newChild(90));
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        this.modified = false;
        this.setDirty(false);
    }

    public void dispose() {
        try {
            this.modifiedListener.detachFrom(this.original);
            this.dirtyListener.detachFrom(this.workingCopy);
            this.workingCopy.removeNode();
        }
        catch (BackingStoreException e) {
            RepositoryUiPlugin.log(e);
        }
    }

    public ImageDescriptor getImage() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return "";
    }

    public void setValid(boolean isValid) {
        super.setValid(isValid);
    }

    public void revert(IProgressMonitor progress) throws CoreException {
        try {
            PreferencesUtil.copyTree((Preferences)this.workingCopy, (Preferences)this.original, (IProgressMonitor)progress);
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        this.modified = false;
        this.setDirty(false);
    }

    public void saveAndOverwrite(IProgressMonitor progress) throws CoreException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            PreferencesUtil.copyTree((Preferences)this.original, (Preferences)this.workingCopy, (IProgressMonitor)monitor.newChild(90));
            this.savePreferences(this.original, (IProgressMonitor)monitor.newChild(90));
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        this.modified = false;
        this.setDirty(false);
    }

    public static interface ISaveParticipant {
        public void saved(IEclipsePreferences var1, IProgressMonitor var2);
    }
}

