/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PreferencesWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferencesInputFactory
implements IWorkingCopyFactory,
IPersistableElement,
IAdaptable {
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String SCOPE = "scope";
    private IScopeContext context;
    private String path;
    private String name;

    public static IWorkingCopyFactory getPreferencesWorkingCopy(String scope, String path, String readableName) {
        return new PreferencesInputFactory(scope, path, readableName);
    }

    public PreferencesInputFactory(String scope, String path, String name) {
        this.context = PreferencesInputFactory.getContext(scope);
        if (this.context == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Unknown scope ID: {0}", (Object)scope));
        }
        this.path = path;
        this.name = name;
    }

    private static IScopeContext getContext(String id) {
        if (id.equals("configuration")) {
            return new ConfigurationScope();
        }
        if (id.equals("instance")) {
            return new InstanceScope();
        }
        if (id.equals("default")) {
            return new DefaultScope();
        }
        return null;
    }

    public IWorkingCopy createWorkingCopy() throws CoreException {
        try {
            return new PreferencesWorkingCopy(this.name, this.context.getNode(this.path));
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PreferencesInputFactory) {
            PreferencesInputFactory factory = (PreferencesInputFactory)obj;
            return factory.path.equals(this.path) && factory.context.getName().equals(this.context.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode() + this.context.getName().hashCode();
    }

    public String getFactoryId() {
        return "com.ibm.team.repository.rcp.ui.preferenceFactory";
    }

    public void saveState(IMemento memento) {
        memento.putString(SCOPE, this.context.getName());
        memento.putString(PATH, this.path);
        memento.putString(NAME, this.name);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

