/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.IPreferenceProvider;
import com.ibm.team.repository.rcp.ui.internal.parts.ISharedObjectStore;
import com.ibm.team.repository.rcp.ui.internal.parts.PreferenceProviderWorkingCopy;
import com.ibm.team.repository.rcp.ui.internal.utils.MementoUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyFactory;
import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceProviderInputFactory
extends PlatformObject
implements IWorkingCopyFactory {
    private static final String REFERENCE = "reference";
    private static final String STORE_NAMESPACE = "storeNamespace";
    private static final String STORE_NAME = "storeName";
    private static final String NAME = "name";
    String name;
    Object toEdit;
    IPreferenceProvider preferenceProvider;
    ISharedObjectStore sharedObjectStore;
    private IPersistableElement persistableElement = null;
    private boolean adapterLoaded = false;

    public PreferenceProviderInputFactory(Object toEdit, String name) {
        this.name = name;
        this.toEdit = toEdit;
        this.sharedObjectStore = null;
        this.preferenceProvider = (IPreferenceProvider)Adapters.getAdapter((Object)toEdit, IPreferenceProvider.class);
        Assert.isNotNull((Object)this.preferenceProvider, (String)"This factory only works on elements that are adaptable to IPreferenceProvider");
    }

    public PreferenceProviderInputFactory(Object toEdit, ISharedObjectStore store, String name) {
        this.name = name;
        this.toEdit = toEdit;
        this.sharedObjectStore = store;
        this.preferenceProvider = (IPreferenceProvider)Adapters.getAdapter((Object)toEdit, IPreferenceProvider.class);
        Assert.isNotNull((Object)this.preferenceProvider, (String)"This factory only works on elements that are adaptable to IPreferenceProvider");
    }

    public PreferenceProviderInputFactory(ISharedObjectStore store, String name) {
        this.sharedObjectStore = store;
        this.name = name;
    }

    PreferenceProviderInputFactory(IMemento memento) throws CoreException {
        this.name = MementoUtil.getString(memento, NAME);
        String storeName = MementoUtil.getString(memento, STORE_NAME);
        String storeNamespace = MementoUtil.getString(memento, STORE_NAMESPACE);
        ClassIdentifier cid = new ClassIdentifier(storeNamespace, storeName);
        try {
            Class theClass = cid.loadClass();
            this.sharedObjectStore = (ISharedObjectStore)theClass.newInstance();
        }
        catch (Exception e) {
            throw new CoreException(StatusUtil.newStatus(PreferenceProviderInputFactory.class, (Throwable)e));
        }
        IMemento referenceMemento = memento.getChild(REFERENCE);
        if (referenceMemento != null) {
            Preferences prefs = MementoUtil.getPreferencesFor(referenceMemento);
            this.toEdit = this.sharedObjectStore.getReference(prefs);
            this.preferenceProvider = (IPreferenceProvider)Adapters.getAdapter((Object)this.toEdit, IPreferenceProvider.class);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPersistableElement.class) {
            if (this.adapterLoaded) {
                return this.persistableElement;
            }
            this.adapterLoaded = true;
            Constructor<?> defaultConstructor = null;
            if (this.sharedObjectStore != null) {
                try {
                    defaultConstructor = this.sharedObjectStore.getClass().getConstructor(new Class[0]);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (defaultConstructor != null) {
                    this.persistableElement = new IPersistableElement(){

                        public void saveState(IMemento memento) {
                            memento.putString(PreferenceProviderInputFactory.NAME, PreferenceProviderInputFactory.this.name);
                            ClassIdentifier cid = new ClassIdentifier(PreferenceProviderInputFactory.this.sharedObjectStore.getClass());
                            memento.putString(PreferenceProviderInputFactory.STORE_NAMESPACE, cid.getNamespace());
                            memento.putString(PreferenceProviderInputFactory.STORE_NAME, cid.getTypeName());
                            if (PreferenceProviderInputFactory.this.toEdit != null) {
                                IMemento reference = memento.createChild(PreferenceProviderInputFactory.REFERENCE);
                                Preferences prefs = MementoUtil.getPreferencesFor(reference);
                                PreferenceProviderInputFactory.this.sharedObjectStore.saveHandle(PreferenceProviderInputFactory.this.toEdit, prefs);
                            }
                        }

                        public String getFactoryId() {
                            return "com.ibm.team.repository.rcp.ui.preferenceProviderFactoryElementFactory";
                        }
                    };
                }
            }
        }
        return super.getAdapter(adapter);
    }

    public IWorkingCopy createWorkingCopy() throws CoreException {
        try {
            return new PreferenceProviderWorkingCopy(this);
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PreferenceProviderInputFactory) {
            PreferenceProviderInputFactory fact = (PreferenceProviderInputFactory)obj;
            if (this.toEdit == null) {
                return fact == this;
            }
            return fact.toEdit != null && this.toEdit.equals(fact.toEdit);
        }
        return false;
    }

    public int hashCode() {
        if (this.toEdit == null) {
            return super.hashCode();
        }
        return this.toEdit.hashCode();
    }
}

