/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class PartSiteJobRunner
extends JobRunner {
    private IWorkbenchSiteProgressService service;
    private String explicitName = "";
    private final IWorkbenchPartSite site;

    public PartSiteJobRunner(IWorkbenchPartSite site, boolean isUser) {
        super(PartSiteJobRunner.computeName(site), isUser);
        this.site = site;
        this.service = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
    }

    protected void updateName() {
        if (this.explicitName.equals("")) {
            this.setJobName(PartSiteJobRunner.computeName(this.site));
        } else {
            this.setJobName(this.explicitName);
        }
    }

    protected Shell getParentShell() {
        return this.site.getShell();
    }

    public void setName(String name) {
        this.explicitName = name;
        super.setName(name);
    }

    private static String computeName(IWorkbenchPartSite site) {
        String mostSpecificName = site.getRegisteredName();
        IWorkbenchPartReference wpr = PartSiteJobRunner.getPartReference(site);
        if (wpr != null) {
            mostSpecificName = wpr.getPartName();
        }
        String result = "";
        result = site instanceof IViewSite ? NLS.bind((String)Messages.PartSiteJobRunner_3, (Object)mostSpecificName) : (site instanceof IEditorSite ? NLS.bind((String)Messages.PartSiteJobRunner_4, (Object)mostSpecificName) : NLS.bind((String)Messages.PartSiteJobRunner_5, (Object)mostSpecificName));
        return result;
    }

    private static IWorkbenchPartReference getPartReference(IWorkbenchPartSite site) {
        return site.getPage().getReference(site.getPart());
    }

    protected void schedule(Job theJob) {
        this.updateName();
        if (this.service != null) {
            this.service.schedule(theJob);
        } else {
            super.schedule(theJob);
        }
    }
}

