/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.ui.internal.parts.PartSearchPageHost;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSearchResult;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PartSearchQuery
implements ISearchQuery {
    private Object input;
    private String name;
    private String tooltip;
    private ImageDescriptor image;
    private IPartFactory factory;
    private Display display;
    private boolean hasRun = false;

    public PartSearchQuery(Display display, Object input, String name, String tooltip, ImageDescriptor image, IPartFactory factory) {
        this.display = display;
        Assert.isNotNull((Object)display);
        this.input = input;
        this.name = name;
        this.image = image;
        this.factory = factory;
        this.tooltip = tooltip;
    }

    public Object getInput() {
        return this.input;
    }

    public ImageDescriptor getImage() {
        return this.image;
    }

    public IPartFactory getFactory() {
        return this.factory;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return this.name;
    }

    public ISearchResult getSearchResult() {
        return new PartSearchResult(this);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (!this.hasRun) {
            this.hasRun = true;
            return Status.OK_STATUS;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                ExistingSearchView foundSearchView = PartSearchQuery.findSearchResultViewPart(PartSearchQuery.this.getInput());
                if (foundSearchView != null) {
                    foundSearchView.getPartSearchPageHost().refresh();
                }
            }
        });
        return Status.OK_STATUS;
    }

    public static ExistingSearchView findSearchResultViewPart(Object input) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow workbenchWindow = windows[i];
            IWorkbenchPage where = workbenchWindow.getActivePage();
            IViewReference[] references = where.getViewReferences();
            int j = 0;
            while (j < references.length) {
                PartSearchQuery partSearchQuery;
                PartSearchPageHost pageHost;
                ISearchQuery query;
                ISearchResultViewPart srvp;
                ISearchResultPage resultPage;
                IViewReference viewReference = references[j];
                IViewPart part = viewReference.getView(false);
                if (part instanceof ISearchResultViewPart && (resultPage = (srvp = (ISearchResultViewPart)part).getActivePage()) instanceof PartSearchPageHost && (query = (pageHost = (PartSearchPageHost)resultPage).getSearchResult().getQuery()) instanceof PartSearchQuery && (partSearchQuery = (PartSearchQuery)query).getInput().equals(input)) {
                    return new ExistingSearchView(srvp, pageHost, partSearchQuery);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public static class ExistingSearchView {
        private ISearchResultViewPart searchResultViewPart;
        private PartSearchPageHost partSearchPageHost;
        private PartSearchQuery partSearchQuery;

        public ExistingSearchView(ISearchResultViewPart searchResultViewPart, PartSearchPageHost partSearchPageHost, PartSearchQuery partSearchQuery) {
            this.searchResultViewPart = searchResultViewPart;
            this.partSearchPageHost = partSearchPageHost;
            this.partSearchQuery = partSearchQuery;
        }

        public ISearchResultViewPart getSearchResultViewPart() {
            return this.searchResultViewPart;
        }

        public PartSearchPageHost getPartSearchPageHost() {
            return this.partSearchPageHost;
        }

        public PartSearchQuery getPartSearchQuery() {
            return this.partSearchQuery;
        }
    }
}

