/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.parts.EnhancedFillLayout;
import com.ibm.team.repository.rcp.ui.internal.parts.ErrorDetailsPart;
import com.ibm.team.repository.rcp.ui.internal.parts.StackLayoutExt;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ChoiceEnumeration;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationState;
import com.ibm.team.repository.rcp.ui.operations.RetryQueue;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.services.IDisposable;

public final class ErrorHandlingPart
implements IDisposable {
    private RetryQueue retryQueue;
    private boolean oldState = false;
    private Display display;
    private Composite control;
    private Composite nestedControl;
    private Runnable updateErrorStateRunnable = new Runnable(){

        public void run() {
            ErrorHandlingPart.this.updateErrorState();
        }
    };
    private ISetListener errorListener = new ISetListener(){

        public void changed(SetDiff diff) {
            SWTUtil.runOnce(ErrorHandlingPart.this.display, (Control)ErrorHandlingPart.this.control, ErrorHandlingPart.this.updateErrorStateRunnable);
        }
    };
    private Control errorControl;
    private StackLayoutExt layout;
    private WidgetFactoryContext context;

    public ErrorHandlingPart(Composite control, WidgetFactoryContext context) {
        this.control = control;
        this.context = context;
        WidgetToolkit toolkit = context.getToolkit();
        this.layout = new StackLayoutExt();
        control.setLayout((Layout)this.layout);
        this.display = control.getDisplay();
        this.retryQueue = new RetryQueue(context.getBackgroundOperationRunner());
        this.retryQueue.getErrors().addListener(this.errorListener);
        this.nestedControl = toolkit.createComposite(control, 0);
        this.nestedControl.setLayout((Layout)new EnhancedFillLayout());
        this.layout.setCurrent((Control)this.nestedControl);
    }

    public void setMargins(Rectangle newMargins) {
        this.layout.setMargins(newMargins);
    }

    protected void updateErrorState() {
        boolean newState = this.retryQueue.hasErrors();
        if (this.oldState != newState) {
            this.oldState = newState;
            if (newState) {
                this.showErrorIndicator();
            } else {
                this.hideErrorIndicator();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    private void hideErrorIndicator() {
        if (this.errorControl == null) {
            return;
        }
        this.layout.setCurrent((Control)this.nestedControl);
        this.control.layout(false);
        this.errorControl.dispose();
        this.errorControl = null;
    }

    private void showErrorIndicator() {
        WidgetToolkit toolkit = this.context.getToolkit();
        Composite errorComposite = toolkit.createComposite(this.control, 0);
        this.errorControl = errorComposite;
        Label errorIcon = toolkit.createLabel(errorComposite, "");
        errorIcon.setImage(Display.getCurrent().getSystemImage(1));
        IStatus finalStatus = Status.OK_STATUS;
        Collection errors = this.retryQueue.getErrors().toCollection();
        if (errors.size() >= 1) {
            finalStatus = ((IOperationState)errors.iterator().next()).getStatus();
        }
        toolkit.createLabel(errorComposite, NLS.bind((String)Messages.ErrorHandlingPart_1, (Object)finalStatus.getMessage()), 64);
        ButtonBar buttons = new ButtonBar(errorComposite, new ChoiceEnumeration().add(MessageDialogFactory.OKAY), new IPartResult(){

            public void setResult(Object result) {
                if (result == MessageDialogFactory.OKAY.getValue()) {
                    ErrorHandlingPart.this.retryQueue.ignoreAllErrors();
                }
            }
        }, this.context, false);
        GridDataFactory.fillDefaults().align(0x1000000, 4).span(2, 1).applyTo(buttons.getControl());
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout(errorComposite);
        this.control.layout(true);
        this.layout.setCurrent(this.errorControl);
        this.control.layout(false);
    }

    public IOperationRunner getOperationRunner() {
        return this.retryQueue;
    }

    public Composite getNestedControl() {
        return this.nestedControl;
    }

    protected void ignore(IOperationState state) {
        this.retryQueue.dequeue(state.getOperation());
    }

    protected void retry(IOperationState state) {
        this.retryQueue.enqueue(state.getName(), state.getOperation());
    }

    protected void showDetails(IOperationState state) {
        Parts.openDialog(this.control.getShell(), state, new PartFactory(ErrorDetailsPart.class));
    }

    private void updateButtonEnablement(SimpleTableViewer table, ButtonBar buttons) {
        Button[] buttonArray = buttons.getButtons();
        boolean enabled = !table.getSelectionProvider().getSelection().isEmpty();
        int i = 0;
        while (i < buttonArray.length) {
            Button button = buttonArray[i];
            button.setEnabled(enabled);
            ++i;
        }
    }

    public void dispose() {
        this.retryQueue.getErrors().removeListener(this.errorListener);
        this.retryQueue.dispose();
    }
}

