/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.ui.internal.menus.AbstractMenuViewer;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public final class MenuViewer
extends AbstractMenuViewer {
    private static final String DIRTY = "dirty";
    static final String IMAGE_DESCRIPTOR = "image_descriptor";
    private Menu theMenu;
    private HashMap mapActionsOntoMenuItems = new HashMap();

    public MenuViewer(Menu theMenu, IMenuExt entries) {
        super((Widget)theMenu, entries);
        this.theMenu = theMenu;
    }

    protected void dirty(IActionExt ext) {
        MenuItem item = (MenuItem)this.mapActionsOntoMenuItems.get(ext);
        if (item != null) {
            this.setDirty(item);
        }
    }

    protected void removeEntry(IActionExt ext) {
        this.unmap(ext);
        super.removeEntry(ext);
    }

    private void unmap(IActionExt ext) {
        MenuItem item = (MenuItem)this.mapActionsOntoMenuItems.get(ext);
        if (item != null) {
            this.mapActionsOntoMenuItems.remove(ext);
            ActionUtil.updateAction(item, this.getResources(), null);
            item.dispose();
        }
    }

    protected void update() {
        MenuItem[] menuItems = this.theMenu.getItems();
        int itemIndex = 0;
        List actions = this.getSortedEntries();
        for (IActionExt next : actions) {
            MenuItem item;
            IActionExt action;
            if (!next.isVisible()) {
                this.unmap(next);
                continue;
            }
            if (itemIndex < menuItems.length && (action = (IActionExt)(item = this.theMenu.getItem(itemIndex)).getData()) == next) {
                if (this.isDirty(item)) {
                    this.clearDirty(item);
                    ActionUtil.updateAction(item, this.getResources(), next);
                }
                ++itemIndex;
                continue;
            }
            this.unmap(next);
            item = ActionUtil.createItem(this.theMenu, this.getResources(), itemIndex, next);
            if (item == null) continue;
            item.setData((Object)next);
            this.mapActionsOntoMenuItems.put(next, item);
            ++itemIndex;
        }
    }

    private void setDirty(MenuItem temp) {
        temp.setData(DIRTY, (Object)DIRTY);
    }

    private void clearDirty(MenuItem temp) {
        temp.setData(DIRTY, null);
    }

    private boolean isDirty(MenuItem temp) {
        return temp.getData(DIRTY) == DIRTY;
    }

    protected boolean isUpdating() {
        return this.theMenu.isVisible();
    }
}

