/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;

public final class MenuExt
implements IMenuExt {
    private ArrayList entryList = new ArrayList();
    private HashMap cachedIndices = null;
    private Comparator order = new Comparator(){

        public int compare(Object o1, Object o2) {
            int i1 = MenuExt.this.getIndex(o1);
            int i2 = MenuExt.this.getIndex(o2);
            return i1 - i2;
        }
    };
    private EntriesSet entries = new EntriesSet();

    public void clear() {
        ArrayList oldEntryList = this.entryList;
        this.entryList = new ArrayList();
        this.entries.doFireRemoveAll(oldEntryList);
    }

    public void add(IActionExt toAdd) {
        this.entryList.add(toAdd);
        this.entries.doFireAdded(toAdd);
    }

    public void insertAfter(IActionExt position, IActionExt toAdd) {
        int idx;
        int n = idx = position == null ? 0 : this.entryList.indexOf(position);
        if (idx == -1) {
            throw new IllegalArgumentException("Unknown position");
        }
        this.entryList.add(idx, toAdd);
        this.entries.doFireAdded(toAdd);
        this.cachedIndices = null;
    }

    public void remove(IActionExt toRemove) {
        this.entryList.remove(toRemove);
        this.entries.doFireRemoved(toRemove);
        this.cachedIndices = null;
    }

    public ISetWithListeners getEntries() {
        return this.entries;
    }

    protected int getIndex(Object o1) {
        Integer idx;
        if (this.cachedIndices != null && (idx = (Integer)this.cachedIndices.get(o1)) != null) {
            return idx;
        }
        int idx2 = this.entryList.indexOf(o1);
        if (idx2 != -1) {
            if (this.cachedIndices == null) {
                this.cachedIndices = new HashMap();
            }
            this.cachedIndices.put(o1, new Integer(idx2));
        }
        return idx2;
    }

    public Comparator getOrder() {
        return this.order;
    }

    private class EntriesSet
    extends AbstractSetWithListeners {
        private EntriesSet() {
        }

        protected Collection computeElements() {
            return MenuExt.this.entryList;
        }

        public void doFireAdded(Object added) {
            this.fireAdded(added);
        }

        public void doFireRemoved(Object removed) {
            this.fireRemoved(removed);
        }

        public void doFireRemoveAll(Collection removed) {
            this.fireCollectionRemoved(removed);
        }
    }
}

