/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AddRemoveConverter;
import com.ibm.team.repository.rcp.ui.internal.viewers.IAddRemoveListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

abstract class AbstractMenuViewer {
    private IMenuExt menuEntries;
    private ISetListener<IActionExt> entryListener = new AddRemoveConverter<IActionExt>(new IAddRemoveListener<IActionExt>(){

        @Override
        public void added(IActionExt added) {
            AbstractMenuViewer.this.addEntry(added);
        }

        @Override
        public void removed(IActionExt removed) {
            AbstractMenuViewer.this.removeEntry(removed);
        }
    });
    private ResourceManager resources;
    private IChangeListener actionListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            AbstractMenuViewer.this.dirty((IActionExt)source);
            AbstractMenuViewer.this.makeDirty();
        }
    };
    private Runnable updateRunnable = new Runnable(){

        public void run() {
            if (AbstractMenuViewer.this.widget.isDisposed()) {
                return;
            }
            if (AbstractMenuViewer.this.isUpdating()) {
                AbstractMenuViewer.this.updateIfNecessary();
            }
        }
    };
    private Widget widget;
    private Listener widgetListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 9 || event.type == 22) {
                AbstractMenuViewer.this.updateIfNecessary();
            } else if (event.type == 12) {
                AbstractMenuViewer.this.dispose();
            }
        }
    };
    private boolean dirty = false;
    private List sortedEntries = null;

    public AbstractMenuViewer(Widget theWidget, IMenuExt entries) {
        this.menuEntries = entries;
        this.menuEntries.getEntries().addListener(this.entryListener);
        this.widget = theWidget;
        this.widget.addListener(9, this.widgetListener);
        this.widget.addListener(22, this.widgetListener);
        this.widget.addListener(12, this.widgetListener);
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        for (IActionExt nextAction : entries.getEntries().toCollection()) {
            this.addEntry(nextAction);
        }
    }

    protected void updateIfNecessary() {
        if (this.dirty) {
            this.dirty = false;
            this.update();
        }
    }

    protected final void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.scheduleUpdate();
        }
    }

    protected abstract boolean isUpdating();

    protected abstract void dirty(IActionExt var1);

    protected abstract void update();

    private final IMenuExt getEntries() {
        return this.menuEntries;
    }

    protected final List getSortedEntries() {
        if (this.sortedEntries == null) {
            this.sortedEntries = ActionUtil.getSortedEntries(this.getEntries());
        }
        return this.sortedEntries;
    }

    protected void removeEntry(IActionExt ext) {
        this.sortedEntries = null;
        ext.removeChangeListener(this.actionListener);
        this.makeDirty();
    }

    private void scheduleUpdate() {
        SWTUtil.runOnce(Display.getCurrent(), this.updateRunnable);
    }

    protected void addEntry(IActionExt nextAction) {
        this.sortedEntries = null;
        nextAction.addChangeListener(this.actionListener);
        this.makeDirty();
    }

    protected final ResourceManager getResources() {
        return this.resources;
    }

    protected void dispose() {
        for (IActionExt nextAction : this.menuEntries.getEntries().toCollection()) {
            this.removeEntry(nextAction);
        }
        this.menuEntries.getEntries().removeListener(this.entryListener);
        this.resources.dispose();
        this.widget.removeListener(9, this.widgetListener);
        this.widget.removeListener(22, this.widgetListener);
        this.widget.removeListener(12, this.widgetListener);
        SWTUtil.cancelExec(Display.getCurrent(), this.updateRunnable);
    }
}

