/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;

public abstract class AbstractActionExt
implements IActionExt {
    private String id;
    private ChangeListenerList changeListeners = new ChangeListenerList();
    private ImageDescriptor image;
    private ImageDescriptor disabledImage;
    private ImageDescriptor hoverImage;
    private String text = "";
    private String tooltip = "";
    private boolean enabled = true;
    private boolean visible = true;

    public AbstractActionExt(String text) {
        this(null, null, text, "");
    }

    public AbstractActionExt(ImageDescriptor image, String text) {
        this(image, image, text, LegacyActionTools.removeMnemonics((String)text));
    }

    public AbstractActionExt(ImageDescriptor image, ImageDescriptor hoverImage, ImageDescriptor disabledImage, String text, String tooltip) {
        Assert.isNotNull((Object)text);
        Assert.isNotNull((Object)tooltip);
        this.text = text;
        this.image = image;
        this.tooltip = tooltip;
        this.hoverImage = hoverImage;
        this.disabledImage = disabledImage;
    }

    public AbstractActionExt(ImageDescriptor image, ImageDescriptor hoverImage, String text, String tooltip) {
        this(image, hoverImage, image == null ? null : ImageDescriptor.createWithFlags((ImageDescriptor)image, (int)1), text, tooltip);
    }

    public AbstractActionExt(ImageDescriptor image, ImageDescriptor disabledImage, String text) {
        this(image, image, disabledImage, text, SWTUtil.filterMnemonics(text));
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setHoverImage(ImageDescriptor img) {
        if (!Util.equals((Object)img, (Object)this.hoverImage)) {
            this.hoverImage = img;
            this.firePropertyChange(PROP_APPEARANCE);
        }
    }

    protected void setImage(ImageDescriptor img) {
        if (!Util.equals((Object)img, (Object)this.image)) {
            this.image = img;
            this.firePropertyChange(PROP_APPEARANCE);
        }
    }

    protected void setDisabledImage(ImageDescriptor img) {
        if (!Util.equals((Object)img, (Object)this.disabledImage)) {
            this.disabledImage = img;
            this.firePropertyChange(PROP_APPEARANCE);
        }
    }

    protected void setText(String text) {
        Assert.isNotNull((Object)text);
        if (!Util.equals((Object)text, (Object)this.text)) {
            this.text = text;
            this.firePropertyChange(PROP_APPEARANCE);
        }
    }

    protected void setTooltip(String text) {
        Assert.isNotNull((Object)text);
        if (!Util.equals((Object)text, (Object)this.tooltip)) {
            this.tooltip = text;
            this.firePropertyChange(PROP_APPEARANCE);
        }
    }

    protected void setEnabled(boolean isEnabled) {
        if (isEnabled != this.enabled) {
            this.enabled = isEnabled;
            this.firePropertyChange(PROP_ENABLEMENT);
        }
    }

    protected void setVisible(boolean isVisible) {
        if (isVisible != this.visible) {
            this.visible = isVisible;
            this.firePropertyChange(PROP_VISIBILITY);
        }
    }

    private void firePropertyChange(Object property) {
        this.changeListeners.notifyListeners((Object)this, property);
    }

    public final void addChangeListener(IChangeListener listener) {
        if (this.changeListeners.isEmpty()) {
            this.allocate();
        }
        this.changeListeners.add(listener);
    }

    protected void allocate() {
    }

    public final void removeChangeListener(IChangeListener listener) {
        if (this.changeListeners.isEmpty()) {
            return;
        }
        this.changeListeners.remove(listener);
        if (this.changeListeners.isEmpty()) {
            this.deallocate();
        }
    }

    protected void deallocate() {
    }

    public final ImageDescriptor getImage() {
        return this.image;
    }

    public final ImageDescriptor getDisabledImage() {
        return this.disabledImage;
    }

    public final String getTooltipText() {
        return this.tooltip;
    }

    public final ImageDescriptor getHoverImage() {
        return this.hoverImage;
    }

    public final String getText() {
        return this.text;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public boolean getSelection() {
        return false;
    }

    public IMenuExt getSubmenu() {
        return null;
    }

    public abstract void run();

    public abstract int getStyle();

    protected final void fireChangeEvent(Object event) {
        this.changeListeners.notifyListeners((Object)this, event);
    }
}

