/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.databinding;

import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;

public class DatabindingUtil {
    private DatabindingUtil() {
    }

    public static IStatus createNoIconMessage(int severity, String message) {
        return new Status(severity, RepositoryUiPlugin.PLUGIN_ID, -1163014131, message, null);
    }

    public static void setMessage(DialogPage page, IStatus status, boolean forceNone) {
        if (status == null) {
            page.setMessage(null);
            return;
        }
        int severity = status.getSeverity();
        if (severity <= 0) {
            page.setMessage(null);
        } else if (severity <= 1) {
            page.setMessage(status.getMessage(), forceNone ? 0 : 1);
        } else if (severity <= 2) {
            page.setMessage(status.getMessage(), forceNone ? 0 : 2);
        } else {
            page.setMessage(status.getMessage(), forceNone ? 0 : 3);
        }
    }

    public static void setMessage(TitleAreaDialog dialog, IStatus status, boolean forceNone, String defaultMessage) {
        if (status == null) {
            dialog.setMessage(defaultMessage);
            return;
        }
        int severity = status.getSeverity();
        if (severity <= 0) {
            dialog.setMessage(defaultMessage);
        } else if (severity <= 1) {
            dialog.setMessage(status.getMessage(), forceNone ? 0 : 1);
        } else if (severity <= 2) {
            dialog.setMessage(status.getMessage(), forceNone ? 0 : 2);
        } else {
            dialog.setMessage(status.getMessage(), forceNone ? 0 : 3);
        }
    }

    public static void bindMessage(DialogPage page, IObservableValue status) {
        new PageBindingSupport(page, status);
    }

    public static void bindMessage(IControlSite site, IObservableValue validationStatus) {
        final SiteBindingSupport bindingSupport = new SiteBindingSupport(site, validationStatus);
        site.getParent().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                bindingSupport.dispose();
            }
        });
    }

    public static void bindMessage(TitleAreaDialog dialog, Button okButton, IObservableValue validationStatus, String defaultMessage) {
        new TitleAreaDialogBindingSupport(dialog, okButton, validationStatus, defaultMessage);
    }

    private static final class PageBindingSupport {
        private boolean initialStatus = true;
        private IObservableValue status;
        private DialogPage page;
        private IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                PageBindingSupport.this.updateMessage();
            }
        };

        public PageBindingSupport(DialogPage page, IObservableValue _status) {
            this.status = _status;
            this.page = page;
            this.status.addChangeListener(this.changeListener);
            page.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PageBindingSupport.this.status.removeChangeListener(PageBindingSupport.this.changeListener);
                }
            });
            this.updateMessage();
        }

        private void updateMessage() {
            IStatus statusValue = (IStatus)this.status.getValue();
            DatabindingUtil.setMessage(this.page, statusValue, this.initialStatus || statusValue.getCode() == -1163014131);
            if (this.page instanceof WizardPage) {
                WizardPage wp = (WizardPage)this.page;
                wp.setPageComplete(statusValue.getSeverity() < 4);
            } else if (this.page instanceof PreferencePage) {
                PreferencePage pp = (PreferencePage)this.page;
                pp.setValid(statusValue.getSeverity() < 4);
            }
            this.initialStatus = false;
        }
    }

    private static final class SiteBindingSupport {
        private IObservableValue status;
        private IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                SiteBindingSupport.this.updateMessage();
            }
        };
        private IControlSite site;

        public SiteBindingSupport(IControlSite site, IObservableValue _status) {
            this.site = site;
            this.status = _status;
            this.status.addChangeListener(this.changeListener);
            this.updateMessage();
        }

        public void updateMessage() {
            this.site.setStatus((IStatus)this.status.getValue());
        }

        public void dispose() {
            this.status.removeChangeListener(this.changeListener);
        }
    }

    private static class TitleAreaDialogBindingSupport {
        private boolean initialStatus = true;
        private TitleAreaDialog dialog;
        private Button okButton;
        private IObservableValue status;
        private String defaultMessage;
        private IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                TitleAreaDialogBindingSupport.this.updateMessage();
            }
        };

        public TitleAreaDialogBindingSupport(TitleAreaDialog dialog, Button okButton, IObservableValue status, String defaultMessage) {
            this.dialog = dialog;
            this.okButton = okButton;
            this.status = status;
            this.defaultMessage = defaultMessage;
            status.addChangeListener(this.changeListener);
            dialog.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TitleAreaDialogBindingSupport.this.status.removeChangeListener(TitleAreaDialogBindingSupport.this.changeListener);
                }
            });
            this.updateMessage();
        }

        private void updateMessage() {
            IStatus statusValue = (IStatus)this.status.getValue();
            DatabindingUtil.setMessage(this.dialog, statusValue, this.initialStatus || statusValue.getCode() == -1163014131, this.defaultMessage);
            this.okButton.setEnabled(statusValue.getSeverity() < 4);
            this.initialStatus = false;
        }
    }
}

