/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal.xml;

import com.ibm.team.repository.common.IHelper;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.NamespaceRegistry;
import com.ibm.team.repository.common.serialize.internal.Serializer;
import com.ibm.team.repository.common.serialize.internal.SerializingWriter;
import com.ibm.team.repository.common.serialize.internal.Util;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class XMLSerializer_04
extends Serializer {
    private static final IPrimitiveRegistry PrimitiveReg = IPrimitiveRegistry.INSTANCE;
    private static final NamespaceRegistry NamespaceReg = NamespaceRegistry.INSTANCE;
    public static final String NS_PREFIX = NamespaceReg.getPrefix("http://www.ibm.com/team/1.0.0/Serializer/0.4");
    public static final String NS = "http://www.ibm.com/team/1.0.0/Serializer/0.4";
    public static final String STRING_SER_PREFIX = NamespaceReg.getPrefix("http://www.ibm.com/team/1.0.0/Serializer/0.4");
    public static final String STRING_LIST_TAG = "list";
    public static final String STRING_ITEM_TAG = "item";
    public static final String STRING_NULL_TAG = "null";
    public static final String STRING_LIST_BEGIN = "<" + STRING_SER_PREFIX + ":" + "list" + ">";
    public static final String STRING_LIST_END = "</" + STRING_SER_PREFIX + ":" + "list" + ">";
    public static final String STRING_ITEM_BEGIN = "<" + STRING_SER_PREFIX + ":" + "item" + ">";
    public static final String STRING_ITEM_END = "</" + STRING_SER_PREFIX + ":" + "item" + ">";
    public static final String STRING_ITEM_NULL = "<" + STRING_SER_PREFIX + ":" + "null" + "/>";
    public static final String RESPONSE_CLOSE = "</" + NS_PREFIX + ":response>";
    public static final String ITEM_CLOSE = "</" + NS_PREFIX + ":item>";
    public static final String HREF_OPEN = "<" + NS_PREFIX + ":href>";
    public static final String HREF_CLOSE = "</" + NS_PREFIX + ":href>";
    public static final String ITEMTYPE_OPEN = "<" + NS_PREFIX + ":type>";
    public static final String ITEMTYPE_CLOSE = "</" + NS_PREFIX + ":type>";
    public static final String ITEMTYPE_NS_OPEN = "<" + NS_PREFIX + ":typeNS>";
    public static final String ITEMTYPE_NS_CLOSE = "</" + NS_PREFIX + ":typeNS>";
    public static final String ITEMTYPE_NAME_OPEN = "<" + NS_PREFIX + ":typeName>";
    public static final String ITEMTYPE_NAME_CLOSE = "</" + NS_PREFIX + ":typeName>";

    public String getFormat() {
        return "xml";
    }

    public String getVersion() {
        return "0.4";
    }

    public void serializeEObject(SerializingWriter sWriter, EObject eObject, Class expectedType) throws SerializeException {
        try {
            sWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            sWriter.write(XMLSerializer_04.responseOpen(eObject));
            this.serializeEObject(sWriter, eObject, expectedType, true);
            sWriter.write(RESPONSE_CLOSE);
        }
        catch (IOException e) {
            throw SerializeException.from(e);
        }
    }

    private void serializeEObject(SerializingWriter sWriter, EObject eObject, Class expectedType, boolean first) throws SerializeException, IOException {
        if (eObject == null) {
            return;
        }
        sWriter.write(XMLSerializer_04.itemOpen(eObject));
        IItemHandle item = XMLSerializer_04.eObjectToItemHandle(eObject);
        if (item != null) {
            sWriter.write(HREF_OPEN);
            Location loc = Location.itemLocation((IItemHandle)item, (String)this.getRepoUri());
            String absUri = null;
            try {
                absUri = loc.toAbsoluteUri().toString();
            }
            catch (Exception e) {
                SerializeException.from(e);
            }
            sWriter.write(absUri);
            sWriter.write(HREF_CLOSE);
        }
        if (XMLSerializer_04.isItemOrHelper(eObject)) {
            String[] typeInfo = XMLSerializer_04.getTypeInfo(eObject);
            sWriter.write(ITEMTYPE_OPEN);
            sWriter.write(ITEMTYPE_NS_OPEN);
            sWriter.write(typeInfo[1]);
            sWriter.write(ITEMTYPE_NS_CLOSE);
            sWriter.write(ITEMTYPE_NAME_OPEN);
            sWriter.write(typeInfo[0]);
            sWriter.write(ITEMTYPE_NAME_CLOSE);
            sWriter.write(ITEMTYPE_CLOSE);
        }
        if (this.shouldMorphItemToHandle(eObject, expectedType)) {
            eObject = this.morphItemToHandle(eObject);
        }
        EClass eClass = eObject.eClass();
        String nsPrefix = NamespaceReg.getPrefix(eClass.getEPackage());
        List sfs = Util.getStructuralFeatures(eClass, null);
        for (EStructuralFeature sf : sfs) {
            Object value = eObject.eGet(sf);
            if (!eObject.eIsSet(sf)) continue;
            sWriter.write("<");
            sWriter.write(nsPrefix);
            sWriter.write(":");
            sWriter.write(sf.getName());
            sWriter.write(">");
            this.serializeObject(sWriter, value, sf.getEType().getInstanceClass());
            sWriter.write("</");
            sWriter.write(nsPrefix);
            sWriter.write(":");
            sWriter.write(sf.getName());
            sWriter.write(">");
        }
        sWriter.write(XMLSerializer_04.itemClose(eObject));
    }

    private void serializeObject(SerializingWriter sWriter, Object object, Class expectedType) throws SerializeException, IOException {
        if (object == null) {
            sWriter.write(STRING_ITEM_NULL);
            return;
        }
        if (PrimitiveReg.isPrimitive(object.getClass())) {
            this.serializePrimitive(sWriter, object);
            return;
        }
        if (object instanceof Enumerator) {
            this.writeEscapedString(((Enumerator)object).getLiteral(), sWriter);
            return;
        }
        if (object instanceof List) {
            this.serializeArrayOrList(sWriter, object, expectedType);
            return;
        }
        if (object.getClass().isArray()) {
            this.serializeArrayOrList(sWriter, object, expectedType);
            return;
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            this.serializeEObject(sWriter, eObject, expectedType, false);
            return;
        }
        throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLSerializer_04.ErrorUnserializableObject"), (Object)object, (Object[])new Object[0]));
    }

    private void serializePrimitive(SerializingWriter sWriter, Object object) throws SerializeException, IOException {
        IPrimitiveHandler primHandler = IPrimitiveRegistry.INSTANCE.getHandler(object.getClass());
        if (primHandler == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLSerializer_04.ErrorMissingHandler"), object.getClass(), (Object[])new Object[0]));
        }
        String value = primHandler.objectToString(object);
        this.writeEscapedString(value, sWriter);
    }

    private void serializeArrayOrList(SerializingWriter sWriter, Object arrayOrList, Class expectedType) throws SerializeException, IOException {
        int length;
        List list = null;
        Object array = null;
        if (arrayOrList instanceof List) {
            list = (List)arrayOrList;
            length = list.size();
        } else {
            array = arrayOrList;
            length = Array.getLength(array);
        }
        sWriter.write(STRING_LIST_BEGIN);
        int index = 0;
        while (index < length) {
            Object element = list != null ? list.get(index) : Array.get(array, index);
            this.serializeObject(sWriter, element, expectedType);
            ++index;
        }
        sWriter.write(STRING_LIST_END);
    }

    private static List gatherNsURIs(EObject object) throws SerializeException {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        ePackages.add(object.eClass().getEPackage());
        return ePackages;
    }

    private void writeEscapedString(String string, SerializingWriter sWriter) throws SerializeException, IOException {
        StringBuffer sb = new StringBuffer(string);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            switch (c) {
                case '&': {
                    sb.replace(i, i + 1, "&amp;");
                    i += 4;
                    break;
                }
                case '<': {
                    sb.replace(i, i + 1, "&lt;");
                    i += 3;
                    break;
                }
                case '>': {
                    sb.replace(i, i + 1, "&gt;");
                    i += 3;
                }
            }
            ++i;
        }
        sWriter.write(sb.toString());
    }

    private static String formatNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("xmlns:");
        buf.append(prefix);
        buf.append("=");
        if (!uri.startsWith("\"")) {
            buf.append("\"");
            buf.append(uri);
            buf.append("\"");
        } else {
            buf.append(uri);
        }
        return buf.toString();
    }

    private static String formatNamespaces(EObject eObject) throws SerializeException {
        StringBuffer buf = new StringBuffer();
        List ePackages = XMLSerializer_04.gatherNsURIs(eObject);
        for (EPackage ePackage : ePackages) {
            String prefix = NamespaceReg.getPrefix(ePackage);
            String nsURI = ePackage.getNsURI();
            buf.append(XMLSerializer_04.formatNamespace(prefix, nsURI));
            buf.append(' ');
        }
        return buf.toString();
    }

    private static String responseOpen(EObject eObject) throws SerializeException {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(String.valueOf(NS_PREFIX) + ":response ");
        buf.append(XMLSerializer_04.formatNamespace(NS_PREFIX, NS));
        buf.append(">");
        return buf.toString();
    }

    private static String itemOpen(EObject eObject) throws SerializeException {
        StringBuffer buf = new StringBuffer();
        String prefix = NamespaceReg.getPrefix(eObject.eClass());
        String ns = NamespaceReg.getURI(prefix);
        buf.append("<");
        buf.append(String.valueOf(prefix) + ":item ");
        buf.append(XMLSerializer_04.formatNamespace(prefix, ns));
        buf.append(">");
        return buf.toString();
    }

    private static String itemClose(EObject eObject) throws SerializeException {
        StringBuffer buf = new StringBuffer();
        String prefix = NamespaceReg.getPrefix(eObject.eClass());
        buf.append("</");
        buf.append(String.valueOf(prefix) + ":item>");
        return buf.toString();
    }

    private static IItemHandle eObjectToItemHandle(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (IItemHandle.class.isAssignableFrom(eObject.getClass())) {
            return (IItemHandle)eObject;
        }
        return null;
    }

    private static boolean isItem(EObject eObject) {
        return eObject instanceof IItemHandle;
    }

    private static boolean isHelper(EObject eObject) {
        return eObject instanceof IHelper;
    }

    private static boolean isItemOrHelper(EObject eObject) {
        return XMLSerializer_04.isItem(eObject) || XMLSerializer_04.isHelper(eObject);
    }

    private static String[] getTypeInfo(EObject eObject) {
        if (!XMLSerializer_04.isItemOrHelper(eObject)) {
            throw new IllegalArgumentException("referenced eObject must be handle or helper");
        }
        String[] result = new String[2];
        if (XMLSerializer_04.isItem(eObject)) {
            IItemHandle itemHandle = (IItemHandle)eObject;
            result[0] = itemHandle.getItemType().getName();
            result[1] = itemHandle.getItemType().getNamespaceURI();
        } else {
            IHelper helper = (IHelper)eObject;
            result[0] = helper.getHelperType().getName();
            result[1] = helper.getHelperType().getNamespaceURI();
        }
        return result;
    }
}

