/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal.json;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.Util;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JSONDeserializer_03 {
    private static final String KEY_EPACKAGE = "@EPackage";
    private static final String KEY_ECLASS = "@EClass";

    public EObject deserializeEObject(JSONObject object) throws SerializeException {
        if (object == null) {
            return null;
        }
        Object ePackageName = object.get((Object)KEY_EPACKAGE);
        Object eClassName = object.get((Object)KEY_ECLASS);
        if (ePackageName == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorExpectedKey"), (Object)KEY_EPACKAGE, (Object[])new Object[0]));
        }
        if (eClassName == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorExpectedKey"), (Object)KEY_ECLASS, (Object[])new Object[0]));
        }
        if (!(ePackageName instanceof String)) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorExpectedString"), (Object)KEY_EPACKAGE, (Object[])new Object[0]));
        }
        if (!(ePackageName instanceof String)) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorExpectedString"), (Object)KEY_ECLASS, (Object[])new Object[0]));
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage((String)ePackageName);
        if (ePackage == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorMissingPackage"), (Object)ePackageName, (Object[])new Object[0]));
        }
        EClassifier eClassifier = ePackage.getEClassifier((String)eClassName);
        if (eClassifier == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorMissingClass"), (Object)eClassName, (Object[])new Object[0]));
        }
        if (!(eClassifier instanceof EClass)) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorWrongClassType"), (Object)eClassName, (Object[])new Object[0]));
        }
        EClass eClass = (EClass)eClassifier;
        EObject result = ePackage.getEFactoryInstance().create(eClass);
        List sfs = Util.getStructuralFeatures(eClass, null);
        for (EStructuralFeature sf : sfs) {
            String sfName = sf.getName();
            if (!object.containsKey((Object)sfName)) continue;
            Object value = object.get((Object)sfName);
            EClassifier valueClassifier = sf.getEType();
            Object eValue = this.deserializeObject(value, valueClassifier);
            if (sf.isMany()) {
                if (!(eValue instanceof List)) {
                    throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorUnexpectedListValue"), (Object)eValue, (Object[])new Object[0]));
                }
                List eValueList = (List)result.eGet(sf);
                eValueList.addAll((List)eValue);
                continue;
            }
            result.eSet(sf, eValue);
        }
        return result;
    }

    private Object deserializeObject(Object object, EClassifier eClassifier) throws SerializeException {
        if (object == null) {
            return object;
        }
        if (object instanceof JSONObject) {
            return this.deserializeEObject((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return this.deserializeList((JSONArray)object, eClassifier);
        }
        Class expectedType = eClassifier.getInstanceClass();
        if (object instanceof Boolean) {
            if (Boolean.class == expectedType || Boolean.TYPE == expectedType) {
                return object;
            }
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorUnexpectedBooleanType"), (Object)object, (Object[])new Object[0]));
        }
        if (object instanceof String) {
            if (String.class == expectedType) {
                return object;
            }
            if (Object.class == expectedType) {
                return object;
            }
            if (eClassifier instanceof EEnum) {
                EEnum eEnum = (EEnum)eClassifier;
                return eEnum.getEEnumLiteral((String)object).getInstance();
            }
            IPrimitiveHandler primHandler = IPrimitiveRegistry.INSTANCE.getHandler(expectedType);
            if (primHandler != null) {
                return primHandler.stringToObject((String)object);
            }
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorUnexpectedPrimitiveType"), (Object)object, (Object[])new Object[0]));
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Byte.class == expectedType || Byte.TYPE == expectedType) {
                return new Byte(number.byteValue());
            }
            if (Short.class == expectedType || Short.TYPE == expectedType) {
                return new Short(number.shortValue());
            }
            if (Character.class == expectedType || Character.TYPE == expectedType) {
                return new Character((char)number.shortValue());
            }
            if (Integer.class == expectedType || Integer.TYPE == expectedType) {
                return new Integer(number.intValue());
            }
            if (Long.class == expectedType || Long.TYPE == expectedType) {
                return new Long(number.longValue());
            }
            if (Float.class == expectedType || Float.TYPE == expectedType) {
                return new Float(number.floatValue());
            }
            if (Double.class == expectedType || Double.TYPE == expectedType) {
                return new Double(number.doubleValue());
            }
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorUnsupportedNumber"), (Object)object, (Object[])new Object[0]));
        }
        throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorUnsupportedPropertyValue"), (Object)object, (Object[])new Object[0]));
    }

    private List deserializeList(JSONArray array, EClassifier eClassifier) throws SerializeException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : array) {
            Object eElement = this.deserializeObject(element, eClassifier);
            result.add(eElement);
        }
        return result;
    }
}

