/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal.json;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.serialize.IDeserializeResult;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.DeserializeResult;
import com.ibm.team.repository.common.serialize.internal.Deserializer;
import com.ibm.team.repository.common.serialize.internal.json.JSONDeserializer_03;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.emf.ecore.EObject;

public class JSONDeserializer
extends Deserializer {
    private static JSONDeserializer_03 jsonDeserializer_03 = new JSONDeserializer_03();

    public String getFormat() {
        return "json";
    }

    public IDeserializeResult deserialize(Reader reader) throws SerializeException {
        JSONObject jsonObject;
        try {
            jsonObject = JSONObject.parse((Reader)reader);
        }
        catch (IOException e) {
            throw SerializeException.from(e);
        }
        catch (RuntimeException e) {
            throw SerializeException.from(e);
        }
        String mvAttrName = "@serializeVersion";
        if (!jsonObject.containsKey((Object)mvAttrName)) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorMissingAttr"), (Object)mvAttrName, (Object[])new Object[0]));
        }
        Object value = jsonObject.get((Object)mvAttrName);
        if (!(value instanceof String)) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorMissingAttrValue"), (Object)mvAttrName, (Object[])new Object[0]));
        }
        String string = (String)value;
        if (string.equals("0.3")) {
            EObject eObject = jsonDeserializer_03.deserializeEObject(jsonObject);
            return new DeserializeResult(eObject, string);
        }
        throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorWrongVersion"), (Object)string, (Object[])new Object[0]));
    }
}

