/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtual;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.util.NLS;
import java.net.URI;

public class UriSerializer
implements IURISerializer {
    public IItemHandle getItemHandle(URI loc) throws SerializeException {
        Location itemLoc = null;
        try {
            itemLoc = Location.location((URI)loc);
        }
        catch (TeamRepositoryException e) {
            String msg = NLS.bind((String)Messages.getServerString("UriSerializer.0"), (Object)loc, (Object[])new Object[]{e.getMessage()});
            throw new SerializeException(msg);
        }
        return itemLoc.getItemHandle();
    }

    public URI getUri(Object item) throws SerializeException {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (!(item instanceof IItemHandle) && !(item instanceof IVirtual)) {
            throw new IllegalArgumentException("item must be of type IType or IVirtual");
        }
        if (item instanceof IItemHandle) {
            return Location.itemLocation((IItemHandle)((IItemHandle)item), null).toRelativeUri();
        }
        String uri = ((IVirtual)item).getLocation();
        if (uri == null) {
            throw new IllegalArgumentException("referenced virtual contains no location information");
        }
        try {
            return Location.location((URI)new URI(uri)).toRelativeUri();
        }
        catch (Exception e) {
            throw new SerializeException(e.getMessage());
        }
    }

    public IType getType(URI loc) throws SerializeException {
        if (loc == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        Location itemLoc = null;
        try {
            itemLoc = Location.location((URI)loc);
        }
        catch (TeamRepositoryException e) {
            String msg = NLS.bind((String)Messages.getServerString("UriSerializer.0"), (Object)loc, (Object[])new Object[]{e.getMessage()});
            throw new SerializeException(msg);
        }
        return itemLoc.getType();
    }
}

