/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshalPackage;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingExceptionReasonCode;
import com.ibm.team.repository.common.internal.marshal.impl.BigDecimalMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.BooleanMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.ByteMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.CharacterMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.ComplexArrayMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.DateMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.DoubleMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectJSONMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectMigrationMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.EnumeratorMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.IntegerArrayMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.IntegerMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.LongMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.ObjectArrayMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.PrimitiveArrayMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.ShortMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.StringMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.TimestampMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.UUIDArrayMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.UUIDMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class MarshalFactoryImpl
extends EFactoryImpl
implements MarshalFactory {
    private HashMap registeredPrimitiveMarshallers = new HashMap();
    private List registeredComplexMarshallers = new ArrayList();
    private List registeredArrayMarshallers = new ArrayList();
    private Marshaller objectArrayMarshaller;

    public static MarshalFactory init() {
        try {
            MarshalFactory theMarshalFactory = (MarshalFactory)EPackage.Registry.INSTANCE.getEFactory("com.ibm.team.common.marshaller");
            if (theMarshalFactory != null) {
                return theMarshalFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MarshalFactoryImpl();
    }

    public MarshalFactoryImpl() {
        this.initializeMarshallers();
    }

    private void initializeMarshallers() {
        this.initializePrimitiveMarshallers();
        this.initializeComplexMarshallers();
        this.initializeArrayMarshallers();
        this.initializeObjectArrayMarshaller();
    }

    private void initializePrimitiveMarshallers() {
        CharacterMarshaller characterMarshaller = new CharacterMarshaller();
        this.registeredPrimitiveMarshallers.put(characterMarshaller.getSupportedType(), characterMarshaller);
        this.registeredPrimitiveMarshallers.put(Character.class, characterMarshaller);
        ByteMarshaller byteMarshaller = new ByteMarshaller();
        this.registeredPrimitiveMarshallers.put(byteMarshaller.getSupportedType(), byteMarshaller);
        this.registeredPrimitiveMarshallers.put(Byte.class, byteMarshaller);
        BooleanMarshaller booleanMarshaller = new BooleanMarshaller();
        this.registeredPrimitiveMarshallers.put(booleanMarshaller.getSupportedType(), booleanMarshaller);
        this.registeredPrimitiveMarshallers.put(Boolean.class, booleanMarshaller);
        StringMarshaller stringMarshaller = new StringMarshaller();
        this.registeredPrimitiveMarshallers.put(stringMarshaller.getSupportedType(), stringMarshaller);
        IntegerMarshaller integerMarshaller = new IntegerMarshaller();
        this.registeredPrimitiveMarshallers.put(integerMarshaller.getSupportedType(), integerMarshaller);
        this.registeredPrimitiveMarshallers.put(Integer.class, integerMarshaller);
        ShortMarshaller shortMarshaller = new ShortMarshaller();
        this.registeredPrimitiveMarshallers.put(shortMarshaller.getSupportedType(), shortMarshaller);
        this.registeredPrimitiveMarshallers.put(Short.class, shortMarshaller);
        LongMarshaller longMarshaller = new LongMarshaller();
        this.registeredPrimitiveMarshallers.put(longMarshaller.getSupportedType(), longMarshaller);
        this.registeredPrimitiveMarshallers.put(Long.class, longMarshaller);
        DoubleMarshaller doubleMarshaller = new DoubleMarshaller();
        this.registeredPrimitiveMarshallers.put(doubleMarshaller.getSupportedType(), doubleMarshaller);
        this.registeredPrimitiveMarshallers.put(Double.class, doubleMarshaller);
        BigDecimalMarshaller bigDecimalMarshaller = new BigDecimalMarshaller();
        this.registeredPrimitiveMarshallers.put(bigDecimalMarshaller.getSupportedType(), bigDecimalMarshaller);
        this.registeredPrimitiveMarshallers.put(BigDecimal.class, bigDecimalMarshaller);
        DateMarshaller dateMarshaller = new DateMarshaller();
        this.registeredPrimitiveMarshallers.put(dateMarshaller.getSupportedType(), dateMarshaller);
        TimestampMarshaller timstampMarshaller = new TimestampMarshaller();
        this.registeredPrimitiveMarshallers.put(timstampMarshaller.getSupportedType(), timstampMarshaller);
        UUIDMarshaller uuidMarshaller = new UUIDMarshaller();
        this.registeredPrimitiveMarshallers.put(uuidMarshaller.getSupportedType(), uuidMarshaller);
    }

    private void initializeComplexMarshallers() {
        EnumeratorMarshaller enumeratorMarshaller = new EnumeratorMarshaller();
        this.registeredComplexMarshallers.add(enumeratorMarshaller);
        EObjectMarshaller eObjectMarshaller = new EObjectMarshaller();
        this.registeredComplexMarshallers.add(eObjectMarshaller);
        EObjectJSONMarshaller jsonMarshaller = new EObjectJSONMarshaller();
        this.registeredComplexMarshallers.add(jsonMarshaller);
        EObjectMigrationMarshaller migrationMarshaller = new EObjectMigrationMarshaller();
        this.registeredComplexMarshallers.add(migrationMarshaller);
        this.registeredComplexMarshallers.add(WebServicesMarshaller.INSTANCE);
    }

    private void initializeArrayMarshallers() {
        PrimitiveArrayMarshaller primitiveArrayMarshaller = new PrimitiveArrayMarshaller();
        this.registeredArrayMarshallers.add(primitiveArrayMarshaller);
        IntegerArrayMarshaller integerArrayMarshaller = new IntegerArrayMarshaller();
        this.registeredArrayMarshallers.add(integerArrayMarshaller);
        UUIDArrayMarshaller uuidArrayMarshaller = new UUIDArrayMarshaller();
        this.registeredArrayMarshallers.add(uuidArrayMarshaller);
        ComplexArrayMarshaller complexArrayMarshaller = new ComplexArrayMarshaller();
        this.registeredArrayMarshallers.add(complexArrayMarshaller);
    }

    private void initializeObjectArrayMarshaller() {
        this.objectArrayMarshaller = new ObjectArrayMarshaller();
    }

    public Marshaller getMarshaller(Class classZ) {
        if (classZ.isArray()) {
            return this.getArrayMarshaller(classZ);
        }
        Marshaller marshaller = (Marshaller)this.registeredPrimitiveMarshallers.get(classZ);
        if (marshaller == null) {
            for (Marshaller complexMarshaller : this.registeredComplexMarshallers) {
                if (!complexMarshaller.canMarshal(classZ)) continue;
                return complexMarshaller;
            }
        }
        return marshaller;
    }

    private Marshaller getArrayMarshaller(Class classZ) {
        if (this.objectArrayMarshaller.canMarshal(classZ)) {
            return this.objectArrayMarshaller;
        }
        Marshaller arrayMarshaller2 = null;
        for (Marshaller arrayMarshaller2 : this.registeredArrayMarshallers) {
            if (!arrayMarshaller2.canMarshal(classZ)) continue;
            return arrayMarshaller2;
        }
        return arrayMarshaller2;
    }

    public Marshaller getMarshaller(MarshallerType marshallerType) {
        for (Marshaller primitiveMarshaller : this.registeredPrimitiveMarshallers.values()) {
            if (!((Object)((Object)primitiveMarshaller.getMarshallerType())).equals((Object)marshallerType)) continue;
            return primitiveMarshaller;
        }
        for (Marshaller complexMarshaller : this.registeredComplexMarshallers) {
            if (!((Object)((Object)complexMarshaller.getMarshallerType())).equals((Object)marshallerType)) continue;
            return complexMarshaller;
        }
        return null;
    }

    public Marshaller getMarshaller(DataArgType dataArgType) {
        for (Marshaller primitiveMarshaller : this.registeredPrimitiveMarshallers.values()) {
            if (!primitiveMarshaller.getSupportedDataArgType().equals(dataArgType)) continue;
            return primitiveMarshaller;
        }
        if (this.objectArrayMarshaller.getSupportedDataArgType().equals(dataArgType)) {
            return this.objectArrayMarshaller;
        }
        for (Marshaller complexMarshaller : this.registeredComplexMarshallers) {
            if (!complexMarshaller.getSupportedDataArgType().equals(dataArgType)) continue;
            return complexMarshaller;
        }
        return null;
    }

    public EObject create(EClass eClass) {
        eClass.getClassifierID();
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createMarshallerTypeFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createMarshallingExceptionReasonCodeFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createClassFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertMarshallerTypeToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertMarshallingExceptionReasonCodeToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertClassToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public MarshallerType createMarshallerTypeFromString(EDataType eDataType, String initialValue) {
        MarshallerType result = MarshallerType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMarshallerTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public MarshallingExceptionReasonCode createMarshallingExceptionReasonCodeFromString(EDataType eDataType, String initialValue) {
        MarshallingExceptionReasonCode result = MarshallingExceptionReasonCode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMarshallingExceptionReasonCodeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Class createClassFromString(EDataType eDataType, String initialValue) {
        return (Class)super.createFromString(eDataType, initialValue);
    }

    public String convertClassToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public MarshalPackage getMarshalPackage() {
        return (MarshalPackage)this.getEPackage();
    }

    public static MarshalPackage getPackage() {
        return MarshalPackage.eINSTANCE;
    }
}

