/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.MarshallerImpl;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.NullDataArg;
import com.ibm.team.repository.common.transport.internal.services.ObjectArrayDataArg;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import com.ibm.team.repository.common.util.NLS;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

public class IntegerArrayMarshaller
extends MarshallerImpl {
    public IntegerArrayMarshaller() {
        this.setSupportedType(Integer.TYPE);
        this.setMarshallerType(MarshallerType.INTEGER_ARRAY_LITERAL);
    }

    public DataArgType getSupportedDataArgType() {
        return DataArgType.OBJECT_ARRAY_LITERAL;
    }

    public boolean canMarshal(Class type) {
        if (type.isArray()) {
            return Integer.TYPE.equals(type.getComponentType());
        }
        return false;
    }

    public void marshalObjectToOutputStream(Object object, OutputStream outputStream) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    public void marshalObjectToOutputStream(Object object, OutputStream outputStream, Charset charset) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    public DataArgType getDataArgType() {
        return DataArgType.OBJECT_ARRAY_LITERAL;
    }

    public String marshalObjectToString(Object object) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    public Object demarshalInputStreamToObject(InputStream inputStream) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    public Object demarshalInputStreamToObject(InputStream inputStream, Charset charset) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    public DataArg marshalObjectToDataArg(Object object) {
        if (object == null) {
            return this.createNullDataArg();
        }
        ObjectArrayDataArg objectArrayDataArg = ServicesFactory.eINSTANCE.createObjectArrayDataArg();
        objectArrayDataArg.setType(DataArgType.OBJECT_ARRAY_LITERAL);
        int[] objectArray = (int[])object;
        int i = 0;
        while (i < objectArray.length) {
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(Integer.TYPE);
            if (marshaller != null) {
                objectArrayDataArg.getDataArgs().add((Object)marshaller.marshalObjectToDataArg(objectArray[i]));
            } else {
                String pattern = Messages.getServerString("IntegerArrayMarshaller.CannotMarshalObject");
                String message = NLS.bind((String)pattern, (Object)objectArray[i], (Object[])new Object[0]);
                System.out.println(message);
            }
            ++i;
        }
        return objectArrayDataArg;
    }

    private DataArg createNullDataArg() {
        NullDataArg nullDataArg = ServicesFactory.eINSTANCE.createNullDataArg();
        nullDataArg.setType(DataArgType.NULL_LITERAL);
        return nullDataArg;
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class type) {
        ObjectArrayDataArg objectArrayDataArg = (ObjectArrayDataArg)dataArg;
        int[] objectArray = new int[objectArrayDataArg.getDataArgs().size()];
        int k = 0;
        for (DataArg dataArg2 : objectArrayDataArg.getDataArgs()) {
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(dataArg2.getType());
            if (marshaller == null) continue;
            objectArray[k++] = (Integer)marshaller.demarshalDataArgToObject(dataArg2, Integer.TYPE);
        }
        return objectArray;
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class type, List containedReferences) {
        return this.demarshalDataArgToObject(dataArg, type);
    }
}

