/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class OptionalFeatureSearchCategory
extends BaseSearchCategory {
    private IUpdateSearchQuery[] queries;
    private ArrayList vids = new ArrayList();
    private static final String CATEGORY_ID = "org.eclipse.update.core.unified-search";

    public void addVersionedIdentifier(VersionedIdentifier vid) {
        this.vids.add(vid);
    }

    public void clear() {
        this.vids.clear();
    }

    public OptionalFeatureSearchCategory() {
        super(CATEGORY_ID);
        this.queries = new IUpdateSearchQuery[]{new OptionalQuery()};
    }

    public IUpdateSearchQuery[] getQueries() {
        return this.queries;
    }

    private class OptionalQuery
    implements IUpdateSearchQuery {
        private OptionalQuery() {
        }

        public void run(ISite site, String[] categoriesToSkip, IUpdateSearchFilter filter, IUpdateSearchResultCollector collector, IProgressMonitor monitor) {
            monitor.beginTask("", OptionalFeatureSearchCategory.this.vids.size());
            int i = 0;
            while (i < OptionalFeatureSearchCategory.this.vids.size()) {
                VersionedIdentifier vid = (VersionedIdentifier)OptionalFeatureSearchCategory.this.vids.get(i);
                monitor.subTask(vid.toString());
                IFeature feature = this.createFeature(site, vid, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (feature != null && filter.accept(feature)) {
                    collector.accept(feature);
                }
                ++i;
            }
        }

        private IFeature createFeature(ISite site, VersionedIdentifier vid, IProgressMonitor monitor) {
            try {
                URL siteURL = site.getURL();
                String relative = vid.toString();
                URL featureURL = new URL(siteURL, "features/" + relative + ".jar");
                return site.createFeature("org.eclipse.update.core.packaged", featureURL, monitor);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return null;
        }
    }
}

