/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.internal.AbstractCompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.CompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.LocalFileCompareEditorInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.jface.dialogs.IDialogConstants;

public class RestOpenInExternalCompareDilemmaHandler
extends OpenInExternalCompareDilemmaHandler {
    private final boolean TRACE = Boolean.getBoolean(System.getProperty("jazz.scm.externalCompare.trace", Boolean.toString(false)));
    private CompareRestClient compareRESTClient;

    public RestOpenInExternalCompareDilemmaHandler(CompareRestClient compareRESTClient) {
        this.compareRESTClient = compareRESTClient;
    }

    protected AbstractCompareRestClient getCompareRestClient() {
        return this.compareRESTClient;
    }

    public int differentContentTypeInLocalCompare(IShareable shareable, FileState remoteFileState, String errorMessage) throws TeamRepositoryException {
        if (shareable == null || remoteFileState == null) {
            throw new IllegalArgumentException();
        }
        this.openFilteredLocalFileCompareEditor(shareable, remoteFileState);
        this.TRACE(errorMessage);
        return 0;
    }

    public int differentLineDelimitersInLocalCompare(IShareable shareable, FileState remoteFileState, String errorMessage) throws TeamRepositoryException {
        if (shareable == null || remoteFileState == null) {
            throw new IllegalArgumentException();
        }
        this.openFilteredLocalFileCompareEditor(shareable, remoteFileState);
        this.TRACE(errorMessage);
        return 0;
    }

    public int filesMovedButDidNotChangeStatesInRemoteCompare(FileState leftState, FileState rightState, String errorMessage) throws TeamRepositoryException {
        this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_2, NLS.bind((String)Messages.WarnRESTOpenInExternalCompare_3, (Object)rightState.getPath(), (Object[])new Object[]{leftState.getPath()}), new String[]{IDialogConstants.OK_LABEL}, 4, 1);
        this.TRACE(errorMessage);
        return 1;
    }

    public int differentContentTypeInRemoteCompare(FileState leftFileState, String givenLeftLabel, FileState rightFileState, String givenRightLabel, String errorMessage) throws TeamRepositoryException {
        if (leftFileState == null || rightFileState == null) {
            throw new IllegalArgumentException();
        }
        this.openFilteredFileChangeCompareEditor(leftFileState, givenLeftLabel, rightFileState, givenRightLabel);
        this.TRACE(errorMessage);
        return 0;
    }

    public int differentLineDelimitersInRemoteCompare(FileState leftFileState, String givenLeftLabel, FileState rightFileState, String givenRightLabel, String errorMessage) throws TeamRepositoryException {
        if (leftFileState == null || rightFileState == null) {
            throw new IllegalArgumentException();
        }
        this.openFilteredFileChangeCompareEditor(leftFileState, givenLeftLabel, rightFileState, givenRightLabel);
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeIsAMoveConflict(IConflictItem conflict, String errorMessage) throws TeamRepositoryException {
        this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_4, NLS.bind((String)Messages.WarnRESTOpenInExternalCompare_5, (Object)conflict.getName(false), (Object[])new Object[0]), new String[]{IDialogConstants.OK_LABEL}, 4, 1);
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeHasUnloadedComponent(IComponentSyncContext context, String errorMessage) throws TeamRepositoryException {
        this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_6, NLS.bind((String)Messages.WarnRESTOpenInExternalCompare_7, (Object)context.getComponent().getName(), (Object[])new Object[0]), new String[]{IDialogConstants.OK_LABEL}, 4, 1);
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeIsDeleteToDeleteConflict(IConflictItem conflict, String errorMessage) throws TeamRepositoryException {
        this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_8, Messages.WarnRESTOpenInExternalCompare_9, new String[]{IDialogConstants.OK_LABEL}, 4, 1);
        this.TRACE(errorMessage);
        return 1;
    }

    private void openFilteredLocalFileCompareEditor(IShareable shareable, FileState remoteFileState) throws TeamRepositoryException {
        if (this.doOpenInternalCompare() == 0) {
            LocalFileCompareEditorInput editorInput = new LocalFileCompareEditorInput(shareable, null, remoteFileState, true);
            this.compareRESTClient.showInput((CompareEditorInput)editorInput);
        }
    }

    private void openFilteredFileChangeCompareEditor(FileState leftFileState, String givenLeftLabel, FileState rightFileState, String givenRightLabel) throws TeamRepositoryException {
        if (this.doOpenInternalCompare() == 0) {
            FileChangeEditorInput editorInput = FileChangeEditorInput.createFrom((FileState)leftFileState, (FileState)rightFileState, (boolean)true);
            editorInput.setLabels(givenLeftLabel, givenRightLabel);
            this.compareRESTClient.showInput((CompareEditorInput)editorInput);
        }
    }

    protected int doOpenInternalCompare() throws TeamRepositoryException {
        int code = this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_0, Messages.WarnRESTOpenInExternalCompare_1, new String[]{"Yes", "No"}, 4, 0);
        return code;
    }

    private void TRACE(String message) {
        if (this.TRACE) {
            System.out.println("WarnOpenInExternalCompare dilemma message: " + message);
        }
    }
}

