/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.internal.AbstractCompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.PlainPerspective;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.PlainWorkbenchAdvisor;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.RestOpenConflictInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.RestOpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.client.daemon.IServerController;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONMethod;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.rest.LifecycleRestClient;
import com.ibm.team.filesystem.rcp.ui.internal.compare.ICompareEditorInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;

public class CompareRestClient
extends AbstractCompareRestClient {
    private static final Object displayThreadLock = new Object();
    private static WorkbenchJob displayThread = null;
    private static IWorkbenchWindow compareWindow;
    private CoreException exception;
    private IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow arg0) {
        }

        public void windowDeactivated(IWorkbenchWindow arg0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(IWorkbenchWindow window) {
            Object object = lock;
            synchronized (object) {
                if (window == compareWindow) {
                    compareWindow = null;
                }
                PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    };

    public void showInput(final CompareEditorInput input) throws TeamRepositoryException {
        this.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IEditorPart editor;
                    Object object = lock;
                    synchronized (object) {
                        if (compareWindow == null) {
                            PlatformUI.getWorkbench().addWindowListener(CompareRestClient.this.windowListener);
                            compareWindow = PlatformUI.getWorkbench().openWorkbenchWindow(PlainPerspective.ID, null);
                        }
                    }
                    if (input instanceof ICompareEditorInput) {
                        ICompareEditorInput si = (ICompareEditorInput)input;
                        si.setPage(CompareRestClient.this.getCompareWindowPage());
                    }
                    if ((editor = CompareRestClient.this.findMatchingEditor(input)) == null) {
                        CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)CompareRestClient.this.getCompareWindowPage());
                    } else {
                        CompareRestClient.this.getCompareWindowPage().activate((IWorkbenchPart)editor);
                    }
                    compareWindow.getShell().setMinimized(false);
                    compareWindow.getShell().forceActive();
                }
                catch (WorkbenchException e) {
                    CompareRestClient.this.exception = (CoreException)e;
                }
            }
        });
    }

    public int showMessageButtonsBlocking(final String title, final String message, final String[] buttons, final int severity, final int defaultButton) throws TeamRepositoryException {
        final int[] returnValue = new int[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                MessageDialog messageDialog = new MessageDialog(shell, title, null, message, severity, buttons, defaultButton);
                returnValue[0] = messageDialog.open();
            }
        });
        return returnValue[0];
    }

    private IEditorPart findMatchingEditor(CompareEditorInput input) {
        IEditorReference[] editorRefs = compareWindow.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    protected void checkState() throws TeamRepositoryException {
        if (this.exception != null) {
            TeamRepositoryException e = new TeamRepositoryException(Messages.CompareRestClient_0, (Throwable)this.exception);
            this.exception = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkbenchWindow getCompareWindow() {
        Object object = lock;
        synchronized (object) {
            return compareWindow;
        }
    }

    private IWorkbenchPage getCompareWindowPage() {
        return compareWindow.getActivePage();
    }

    public void installationNotification(IServerController controller, JSONHandler handler) {
        this.jsonHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Display getDisplay() throws TeamRepositoryException {
        Object object = displayThreadLock;
        synchronized (object) {
            IJobManager jobManager = Job.getJobManager();
            jobManager.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getJob() instanceof WorkbenchJob && !event.getResult().isOK()) {
                        CompareRestClient.this.exception = new CoreException(event.getResult());
                    }
                }
            });
            if (displayThread == null) {
                displayThread = new WorkbenchJob("Compare Editor");
                displayThread.schedule();
            }
        }
        int count = 0;
        while (!this.isWorkbenchReady()) {
            try {
                ++count;
                Thread.sleep(100L);
                if (this.exception != null) {
                    CoreException e = this.exception;
                    this.exception = null;
                    if (!e.getStatus().isMultiStatus() && e.getStatus().getException() != null) {
                        throw new TeamRepositoryException(e.getStatus().getException());
                    }
                    throw new TeamRepositoryException((Throwable)e);
                }
                if (count < 600) continue;
                throw new TeamRepositoryException(Messages.CompareRestClient_1);
            }
            catch (InterruptedException interruptedException) {}
        }
        return PlatformUI.getWorkbench().getDisplay();
    }

    private boolean isWorkbenchReady() {
        return PlatformUI.isWorkbenchRunning() && !((Workbench)PlatformUI.getWorkbench()).isStarting();
    }

    protected OpenInExternalCompareDilemmaHandler getConflictExternalCompareDilemmaHandler(IConflictItem conflict) {
        return new RestOpenConflictInExternalCompareDilemmaHandler(this, conflict);
    }

    protected OpenInExternalCompareDilemmaHandler getFileItemExternalCompareDilemmaHandler() {
        return new RestOpenInExternalCompareDilemmaHandler(this);
    }

    protected OpenInExternalCompareDilemmaHandler getShareableExternalCompareDilemmaHandler() {
        return new RestOpenInExternalCompareDilemmaHandler(this);
    }

    private class WorkbenchJob
    extends Job {
        WorkbenchJob(String name) {
            super(name);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            final Display display = Display.getDefault();
            if (!PlatformUI.isWorkbenchRunning()) {
                display.syncExec(new Runnable(){

                    public void run() {
                        LifecycleRestClient client = WorkbenchJob.this.findClient();
                        LifecycleRestClient.TimeoutBlocker blocker = new LifecycleRestClient.TimeoutBlocker(){

                            public boolean mayShutdownDueToTimeout() {
                                return compareWindow == null;
                            }
                        };
                        try {
                            client.addTimeoutBlocker(blocker);
                            PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new PlainWorkbenchAdvisor());
                        }
                        finally {
                            client.removeTimeoutBlocker(blocker);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }

        protected LifecycleRestClient findClient() {
            JSONMethod method = CompareRestClient.this.jsonHandler.getMethod(HttpMethod.POST, new String[]{"service", ILifecycleRestClient.class.getName(), "Timeout"});
            return (LifecycleRestClient)method.getReceiver();
        }
    }
}

