/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.ICompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONReceiver;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncDescription;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenConflictInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.filesystem.rcp.ui.internal.compare.ConflictCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.filesystem.rcp.ui.internal.compare.LocalFileCompareEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class AbstractCompareRestClient
extends JSONReceiver
implements ICompareRestClient {
    protected static final int WAIT_INCR = 100;
    protected static final int MAX_WAIT = 600;
    protected JSONHandler jsonHandler;
    protected static Object lock = new Object();

    protected abstract void checkState() throws TeamRepositoryException;

    protected abstract void showInput(CompareEditorInput var1) throws TeamRepositoryException;

    protected abstract OpenInExternalCompareDilemmaHandler getConflictExternalCompareDilemmaHandler(IConflictItem var1);

    protected abstract OpenInExternalCompareDilemmaHandler getFileItemExternalCompareDilemmaHandler();

    protected abstract OpenInExternalCompareDilemmaHandler getShareableExternalCompareDilemmaHandler();

    private static boolean isValidExecutable(String commandLine) {
        boolean isValid = false;
        String[] commandArray = ExternalCompareToolsUtil.createCommandArray((String)commandLine);
        if (commandArray.length > 0) {
            String filePath = commandArray[0];
            if (filePath == null || filePath.length() == 0) {
                isValid = false;
            } else {
                try {
                    try {
                        isValid = PathUtils.exists((IPath)new Path(filePath), (IProgressMonitor)TempHelper.MONITOR);
                    }
                    catch (FileSystemClientException fileSystemClientException) {
                        isValid = false;
                    }
                }
                catch (SecurityException securityException) {
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    private static IShareable getShareable(String sandboxPath, String filePath) throws TeamRepositoryException {
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((IPath)new Path(sandboxPath), true);
        if (sandbox == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_5, (Object)sandboxPath, (Object[])new Object[0]));
        }
        return sandbox.findShareable((IPath)new Path(filePath), ResourceType.FILE);
    }

    public void postShowConflictCompare(ParmsSyncDescription parms) throws TeamRepositoryException {
        Object element = SyncViewDTOUtil.find((Object)ComponentSyncModel.getInstance(), (int)parms.id);
        if (!(element instanceof IConflictItem)) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_2, (Object)parms.id, (Object[])new Object[0]));
        }
        IConflictItem conflict = (IConflictItem)element;
        if (parms.externalCompareTool == null || !(conflict.getLogicalChange().item() instanceof IFileItemHandle)) {
            this.showConflictEclipseCompare(conflict, parms);
        } else {
            this.showConflictExternalCompare(conflict, parms);
        }
    }

    private void showConflictEclipseCompare(IConflictItem conflict, ParmsSyncDescription parms) throws TeamRepositoryException {
        this.checkState();
        ConflictCompareEditorInput input = new ConflictCompareEditorInput(conflict, true);
        this.showInput((CompareEditorInput)input);
    }

    private void showConflictExternalCompare(IConflictItem conflict, ParmsSyncDescription parms) throws TeamRepositoryException {
        if (!AbstractCompareRestClient.isValidExecutable(parms.externalCompareTool)) {
            throw new TeamRepositoryException(Messages.CompareRestClient_EXTERNAL_TOOLS_1);
        }
        OpenConflictInExternalCompareOperation externalCompareOperation = this.getOpenConflictInExternalCompareOperation(parms.externalCompareTool, conflict);
        try {
            externalCompareOperation.run(null);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    protected OpenConflictInExternalCompareOperation getOpenConflictInExternalCompareOperation(String externalCompareTool, IConflictItem conflict) {
        OpenConflictInExternalCompareOperation externalCompareOperation = new OpenConflictInExternalCompareOperation(externalCompareTool, conflict, this.getConflictExternalCompareDilemmaHandler(conflict));
        return externalCompareOperation;
    }

    public void postShowFileItemCompare(ICompareRestClient.ParmsShowItemCompare parms) throws TeamRepositoryException {
        this.checkState();
        if (parms.externalCompareTool == null || !"file".equals(parms.versionableItemType)) {
            this.showFileItemEclipseCompare(parms);
        } else {
            this.showFileItemExternalCompare(parms, null);
        }
    }

    private void showFileItemEclipseCompare(ICompareRestClient.ParmsShowItemCompare parms) throws TeamRepositoryException {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_3, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        StateId beforeState = parms.beforeStateId == null ? new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), StateId.STATE_DELETED) : new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), UUID.valueOf((String)parms.beforeStateId));
        StateId afterState = parms.afterStateId == null ? new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), StateId.STATE_DELETED) : new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), UUID.valueOf((String)parms.afterStateId));
        Path beforePath = parms.beforePathHint == null ? new Path(parms.afterPathHint) : new Path(parms.beforePathHint);
        Path afterPath = parms.afterPathHint == null ? beforePath : new Path(parms.afterPathHint);
        FileChangeEditorInput input = FileChangeEditorInput.createFrom((ITeamRepository)repo, (StateId)afterState, (IPath)afterPath, (StateId)beforeState, (IPath)beforePath);
        this.showInput((CompareEditorInput)input);
    }

    private void showFileItemExternalCompare(ICompareRestClient.ParmsShowItemCompare parms, IProgressMonitor monitor) throws TeamRepositoryException {
        FileState afterFileState;
        int afterStateIndex;
        FileState beforeFileState;
        boolean hasAfterState;
        if (!AbstractCompareRestClient.isValidExecutable(parms.externalCompareTool)) {
            throw new TeamRepositoryException(Messages.CompareRestClient_EXTERNAL_TOOLS_0);
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_3, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        UUID itemUUID = UUID.valueOf((String)parms.itemId);
        ArrayList<IFileItemHandle> toFetch = new ArrayList<IFileItemHandle>();
        boolean hasBeforeState = false;
        if (parms.beforeStateId == null || parms.beforeStateId.length() == 0) {
            hasBeforeState = false;
        } else {
            UUID beforeStateUUID = UUID.valueOf((String)parms.beforeStateId);
            IFileItemHandle filehandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, itemUUID, beforeStateUUID);
            toFetch.add(filehandle);
            hasBeforeState = true;
        }
        if (parms.afterStateId == null || parms.afterStateId.length() == 0) {
            hasAfterState = false;
        } else {
            UUID afterStateUUID = UUID.valueOf((String)parms.afterStateId);
            IFileItemHandle filehandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, itemUUID, afterStateUUID);
            toFetch.add(filehandle);
            hasAfterState = true;
        }
        List versionables = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteStates(toFetch, monitor);
        if (hasBeforeState && versionables.get(0) != null) {
            IVersionable versionable = (IVersionable)versionables.get(0);
            beforeFileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionable.getItemType(), (IVersionable)versionable);
            afterStateIndex = 1;
        } else {
            beforeFileState = FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null);
            afterStateIndex = 0;
        }
        if (hasAfterState && versionables.get(afterStateIndex) != null) {
            IVersionable versionable = (IVersionable)versionables.get(afterStateIndex);
            afterFileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionable.getItemType(), (IVersionable)versionable);
        } else {
            afterFileState = FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null);
        }
        OpenFileItemInExternalCompareOperation externalCompareOperation = this.getOpenFileItemInExternalCompareOperation(parms.externalCompareTool, beforeFileState, afterFileState);
        try {
            externalCompareOperation.run(null);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    protected OpenFileItemInExternalCompareOperation getOpenFileItemInExternalCompareOperation(String externalCompareTool, FileState beforeFileState, FileState afterFileState) {
        OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(externalCompareTool, afterFileState, beforeFileState, this.getFileItemExternalCompareDilemmaHandler());
        return externalCompareOperation;
    }

    public void postShowLocalFileChangeCompare(ICompareRestClient.ParmsShowLocalChangeCompare parms) throws TeamRepositoryException {
        if (parms.externalCompareTool == null || !"file".equals(parms.versionableItemType)) {
            this.showLocalFileChangeEclipseCompare(parms);
        } else {
            this.showLocalFileChangeExternalCompare(parms);
        }
    }

    private void showLocalFileChangeEclipseCompare(ICompareRestClient.ParmsShowLocalChangeCompare parms) throws TeamRepositoryException {
        this.checkState();
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_4, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        IShareable shareable = AbstractCompareRestClient.getShareable(parms.sandboxPath, parms.path);
        if (shareable != null) {
            LocalFileCompareEditorInput input;
            if (parms.itemId == null || parms.stateId == null || parms.itemId.length() == 0 || parms.stateId.length() == 0) {
                input = new LocalFileCompareEditorInput(shareable, null, FileState.getDeletedState((IItemType)parms.getItemType(), null), false);
            } else {
                StateId remote = new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), UUID.valueOf((String)parms.stateId));
                FileStateComputer comp = new FileStateComputer(repo, remote);
                input = new LocalFileCompareEditorInput(shareable, comp.getLeft(), false);
            }
            this.showInput((CompareEditorInput)input);
        }
    }

    private void showLocalFileChangeExternalCompare(ICompareRestClient.ParmsShowLocalChangeCompare parms) throws TeamRepositoryException {
        if (!AbstractCompareRestClient.isValidExecutable(parms.externalCompareTool)) {
            throw new TeamRepositoryException(Messages.CompareRestClient_EXTERNAL_TOOLS_0);
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_4, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        IShareable shareable = AbstractCompareRestClient.getShareable(parms.sandboxPath, parms.path);
        if (shareable != null) {
            FileState remoteFileState;
            if (parms.itemId == null || parms.stateId == null || parms.itemId.length() == 0 || parms.stateId.length() == 0) {
                remoteFileState = FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null);
            } else {
                UUID itemUUID = UUID.valueOf((String)parms.itemId);
                UUID stateUUID = UUID.valueOf((String)parms.stateId);
                IFileItemHandle filehandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, itemUUID, stateUUID);
                IFileItem versionable = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)filehandle, null);
                remoteFileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)filehandle.getItemType(), (IVersionable)versionable);
            }
            OpenShareableInExternalCompareOperation externalCompareOperation = this.getOpenShareableInExternalCompareOperation(parms.externalCompareTool, shareable, remoteFileState);
            try {
                externalCompareOperation.run(null);
            }
            catch (FileSystemClientException e) {
                throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
            }
        }
    }

    protected OpenShareableInExternalCompareOperation getOpenShareableInExternalCompareOperation(String externalCompareTool, IShareable shareable, FileState remoteFileState) {
        OpenShareableInExternalCompareOperation externalCompareOperation = new OpenShareableInExternalCompareOperation(externalCompareTool, shareable, remoteFileState, this.getShareableExternalCompareDilemmaHandler());
        return externalCompareOperation;
    }
}

