/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare;

import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncDescription;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;

public interface ICompareRestClient {
    public void postShowFileItemCompare(ParmsShowItemCompare var1) throws TeamRepositoryException;

    public void postShowConflictCompare(ParmsSyncDescription var1) throws TeamRepositoryException;

    public void postShowLocalFileChangeCompare(ParmsShowLocalChangeCompare var1) throws TeamRepositoryException;

    public static class ParmsShowItemCompare
    implements IValidatingParameterWrapper {
        public String repositoryUrl;
        public String versionableItemType;
        public String itemId;
        public String beforeStateId;
        public String afterStateId;
        public String beforePathHint;
        public String afterPathHint;
        public String externalCompareTool;

        public ParmsShowItemCompare() {
        }

        public ParmsShowItemCompare(String repositoryUrl, String itemId, String versionableItemType, String beforeStateId, String beforePathHint, String afterStateId, String afterPathHint) {
            this.repositoryUrl = repositoryUrl;
            this.itemId = itemId;
            this.versionableItemType = versionableItemType;
            this.beforeStateId = beforeStateId;
            this.beforePathHint = beforePathHint;
            this.afterStateId = afterStateId;
            this.afterPathHint = afterPathHint;
        }

        public void validate(String requestName, Object ... path) {
            ParmValidation.requiredValue((Object)this.repositoryUrl, (String)requestName, (Object[])new Object[]{path, "repositoryUrl"});
            ParmValidation.requiredValue((Object)this.itemId, (String)requestName, (Object[])new Object[]{path, "itemId"});
            ParmValidation.requiredValue((Object)this.versionableItemType, (String)requestName, (Object[])new Object[]{path, "versionableItemType"});
            ParmValidation.inEnum((String)this.versionableItemType, (String)requestName, (String[])new String[]{"file", "symbolic_link"}, (Object[])new Object[]{"versionableItemType"});
            if (this.afterStateId == null) {
                ParmValidation.requiredValue((Object)this.beforeStateId, (String)requestName, (Object[])new Object[]{path, "beforeStateId"});
            }
            if (this.afterPathHint == null) {
                ParmValidation.requiredValue((Object)this.beforePathHint, (String)requestName, (Object[])new Object[]{path, "beforePathHint"});
            }
        }

        public IVersionableHandle getVersionableHandle(ITeamRepository repo) throws TeamRepositoryException {
            if ("file".equals(this.versionableItemType)) {
                return (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
            }
            if ("folder".equals(this.versionableItemType)) {
                return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
            }
            if ("symbolic_link".equals(this.versionableItemType)) {
                return (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
            }
            return null;
        }

        public IItemType getItemType() throws TeamRepositoryException {
            if ("file".equals(this.versionableItemType)) {
                return IFileItem.ITEM_TYPE;
            }
            if ("folder".equals(this.versionableItemType)) {
                return IFolder.ITEM_TYPE;
            }
            if ("symbolic_link".equals(this.versionableItemType)) {
                return ISymbolicLink.ITEM_TYPE;
            }
            return null;
        }
    }

    public static class ParmsShowLocalChangeCompare
    implements IValidatingParameterWrapper {
        public String repositoryUrl;
        public String sandboxPath;
        public String path;
        public String versionableItemType;
        public String itemId;
        public String stateId;
        public String externalCompareTool;

        public ParmsShowLocalChangeCompare() {
        }

        public ParmsShowLocalChangeCompare(String repositoryUrl, String sandboxPath, String path, String itemId, String versionableItemType, String stateId) {
            this.repositoryUrl = repositoryUrl;
            this.sandboxPath = sandboxPath;
            this.path = path;
            this.itemId = itemId;
            this.versionableItemType = versionableItemType;
            this.stateId = stateId;
        }

        public void validate(String requestName, Object ... path) {
            ParmValidation.requiredValue((Object)this.repositoryUrl, (String)requestName, (Object[])new Object[]{path, "repositoryUrl"});
            ParmValidation.requiredValue((Object)this.sandboxPath, (String)requestName, (Object[])new Object[]{path, "sandboxPath"});
            ParmValidation.requiredValue((Object)path, (String)requestName, (Object[])new Object[]{path, "filePath"});
            ParmValidation.requiredValue((Object)this.versionableItemType, (String)requestName, (Object[])new Object[]{path, "versionableItemType"});
            ParmValidation.inEnum((String)this.versionableItemType, (String)requestName, (String[])new String[]{"file", "symbolic_link"}, (Object[])new Object[]{path, "versionableItemType"});
        }

        public IItemType getItemType() throws TeamRepositoryException {
            if ("file".equals(this.versionableItemType)) {
                return IFileItem.ITEM_TYPE;
            }
            if ("folder".equals(this.versionableItemType)) {
                return IFolder.ITEM_TYPE;
            }
            if ("symbolic_link".equals(this.versionableItemType)) {
                return ISymbolicLink.ITEM_TYPE;
            }
            return null;
        }
    }
}

