/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.ReferenceMap;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.internal.registry.RegistryTimestamp;
import org.eclipse.core.internal.registry.osgi.Activator;
import org.eclipse.core.internal.registry.osgi.EclipseBundleListener;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class RegistryStrategyOSGI
extends RegistryStrategy {
    private Object token;
    protected boolean DEBUG;
    protected boolean DEBUG_REGISTRY_EVENTS;
    private ServiceTracker xmlTracker = null;
    private boolean trackTimestamp;
    private static float DEFAULT_BUNDLECACHE_LOADFACTOR = 0.75f;
    private static int DEFAULT_BUNDLECACHE_SIZE = 200;
    private ReferenceMap bundleMap = new ReferenceMap(1, DEFAULT_BUNDLECACHE_SIZE, DEFAULT_BUNDLECACHE_LOADFACTOR);
    private EclipseBundleListener pluginBundleListener = null;
    static Class class$0;

    public RegistryStrategyOSGI(File[] fileArray, boolean[] blArray, Object object) {
        super(fileArray, blArray);
        this.token = object;
        BundleContext bundleContext = Activator.getContext();
        this.trackTimestamp = bundleContext != null ? "true".equalsIgnoreCase(bundleContext.getProperty("osgi.checkConfiguration")) : false;
    }

    public final String translate(String string, ResourceBundle resourceBundle) {
        return ResourceTranslator.getResourceString(null, (String)string, (ResourceBundle)resourceBundle);
    }

    private Bundle getBundle(String string) {
        long l;
        if (string == null) {
            return null;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Bundle bundle = (Bundle)this.bundleMap.get((int)l);
        if (bundle != null) {
            return bundle;
        }
        bundle = Activator.getContext().getBundle(l);
        this.bundleMap.put((int)l, bundle);
        return bundle;
    }

    public Object createExecutableExtension(RegistryContributor registryContributor, String string, String string2) throws CoreException {
        Bundle bundle = string2 != null && !string2.equals("") ? OSGIUtils.getDefault().getBundle(string2) : this.getBundle(registryContributor.getId());
        if (bundle == null) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)"UNKNOWN BUNDLE", (Object)string), new InvalidRegistryObjectException());
        }
        Class clazz = null;
        try {
            clazz = bundle.loadClass(string);
        }
        catch (Exception exception) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)bundle.getSymbolicName(), (Object)string), exception);
        }
        catch (LinkageError linkageError) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)bundle.getSymbolicName(), (Object)string), linkageError);
        }
        Object var6_8 = null;
        try {
            var6_8 = clazz.newInstance();
        }
        catch (Exception exception) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_instantiateClassError, (Object)bundle.getSymbolicName(), (Object)string), exception);
        }
        catch (LinkageError linkageError) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_instantiateClassError, (Object)bundle.getSymbolicName(), (Object)string), linkageError);
        }
        return var6_8;
    }

    private void throwException(String string, Throwable throwable) throws CoreException {
        throw (Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, string, throwable));
    }

    public void onStart(IExtensionRegistry iExtensionRegistry, boolean bl) {
        super.onStart(iExtensionRegistry, bl);
        if (!(iExtensionRegistry instanceof ExtensionRegistry)) {
            return;
        }
        this.pluginBundleListener = new EclipseBundleListener((ExtensionRegistry)iExtensionRegistry, this.token, this);
        Activator.getContext().addBundleListener((BundleListener)this.pluginBundleListener);
        if (!bl) {
            this.pluginBundleListener.processBundles(Activator.getContext().getBundles());
        }
    }

    public void onStop(IExtensionRegistry iExtensionRegistry) {
        if (this.pluginBundleListener != null) {
            Activator.getContext().removeBundleListener((BundleListener)this.pluginBundleListener);
        }
        if (this.xmlTracker != null) {
            this.xmlTracker.close();
            this.xmlTracker = null;
        }
        super.onStop(iExtensionRegistry);
    }

    public boolean cacheUse() {
        return !"true".equals(RegistryProperties.getProperty("eclipse.noRegistryCache"));
    }

    public boolean cacheLazyLoading() {
        return !"true".equalsIgnoreCase(RegistryProperties.getProperty("eclipse.noLazyRegistryCacheLoading"));
    }

    public long getContributionsTimestamp() {
        if (!this.checkContributionsTimestamp()) {
            return 0L;
        }
        RegistryTimestamp registryTimestamp = new RegistryTimestamp();
        BundleContext bundleContext = Activator.getContext();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = 0;
        while (n < bundleArray.length) {
            URL uRL = EclipseBundleListener.getExtensionURL(bundleArray[n], false);
            if (uRL != null) {
                long l = this.getExtendedTimestamp(bundleArray[n], uRL);
                registryTimestamp.add(l);
            }
            ++n;
        }
        return registryTimestamp.getContentsTimestamp();
    }

    public boolean checkContributionsTimestamp() {
        return this.trackTimestamp;
    }

    public long getExtendedTimestamp(Bundle bundle, URL uRL) {
        if (uRL == null) {
            return 0L;
        }
        try {
            return uRL.openConnection().getLastModified() + bundle.getBundleId();
        }
        catch (IOException iOException) {
            if (this.debug()) {
                System.out.println("Unable to obtain timestamp for the bundle " + bundle.getSymbolicName());
                iOException.printStackTrace();
            }
            return 0L;
        }
    }

    public SAXParserFactory getXMLParser() {
        if (this.xmlTracker == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.xml.parsers.SAXParserFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            this.xmlTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            this.xmlTracker.open();
        }
        return (SAXParserFactory)this.xmlTracker.getService();
    }
}

