/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.eclipse.core.internal.registry.ReferenceMap$HardRef;
import org.eclipse.core.internal.registry.ReferenceMap$IEntry;
import org.eclipse.core.internal.registry.ReferenceMap$SoftRef;

public class ReferenceMap {
    public static final int HARD = 0;
    public static final int SOFT = 1;
    private int entryCount;
    private float loadFactor;
    private transient ReferenceQueue queue = new ReferenceQueue();
    private transient int size;
    private transient ReferenceMap$IEntry[] table;
    private transient int threshold;
    int valueType;

    public ReferenceMap(int n, int n2, float f) {
        if (n != 0 && n != 1) {
            throw (Throwable)new IllegalArgumentException(" must be HARD or SOFT.");
        }
        if (n2 <= 0) {
            throw (Throwable)new IllegalArgumentException("capacity must be positive");
        }
        if (f <= 0.0f || f >= 1.0f) {
            throw (Throwable)new IllegalArgumentException("Load factor must be greater than 0 and less than 1.");
        }
        this.valueType = n;
        int n3 = 1;
        while (n3 < n2) {
            n3 *= 2;
        }
        this.table = new ReferenceMap$IEntry[n3];
        this.loadFactor = f;
        this.threshold = (int)((float)n3 * f);
    }

    private Object doRemove(int n, boolean bl) {
        int n2 = this.indexFor(n);
        ReferenceMap$IEntry referenceMap$IEntry = null;
        ReferenceMap$IEntry referenceMap$IEntry2 = this.table[n2];
        while (referenceMap$IEntry2 != null) {
            if (!(n != referenceMap$IEntry2.getKey() || bl && referenceMap$IEntry2.getValue() != null)) {
                if (referenceMap$IEntry == null) {
                    this.table[n2] = referenceMap$IEntry2.getNext();
                } else {
                    referenceMap$IEntry.setNext(referenceMap$IEntry2.getNext());
                }
                --this.size;
                return referenceMap$IEntry2.getValue();
            }
            referenceMap$IEntry = referenceMap$IEntry2;
            referenceMap$IEntry2 = referenceMap$IEntry2.getNext();
        }
        return null;
    }

    public Object get(int n) {
        this.purge();
        ReferenceMap$IEntry referenceMap$IEntry = this.table[this.indexFor(n)];
        while (referenceMap$IEntry != null) {
            if (referenceMap$IEntry.getKey() == n) {
                return referenceMap$IEntry.getValue();
            }
            referenceMap$IEntry = referenceMap$IEntry.getNext();
        }
        return null;
    }

    private int indexFor(int n) {
        n += ~(n << 15);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += ~(n << 11);
        n ^= n >>> 16;
        return n & this.table.length - 1;
    }

    private ReferenceMap$IEntry newEntry(int n, Object object, ReferenceMap$IEntry referenceMap$IEntry) {
        ++this.entryCount;
        switch (this.valueType) {
            case 0: {
                return new ReferenceMap$HardRef(n, object, referenceMap$IEntry);
            }
            case 1: {
                return new ReferenceMap$SoftRef(n, object, referenceMap$IEntry, this.queue);
            }
        }
        throw (Throwable)new Error();
    }

    private void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.doRemove(((ReferenceMap$IEntry)((Object)reference)).getKey(), true);
            reference.clear();
            reference = this.queue.poll();
        }
    }

    public void put(int n, Object object) {
        if (object == null) {
            throw (Throwable)new NullPointerException("null values not allowed");
        }
        this.purge();
        if (this.size + 1 > this.threshold) {
            this.resize();
        }
        int n2 = this.indexFor(n);
        ReferenceMap$IEntry referenceMap$IEntry = null;
        ReferenceMap$IEntry referenceMap$IEntry2 = this.table[n2];
        while (referenceMap$IEntry2 != null) {
            if (n == referenceMap$IEntry2.getKey()) {
                if (referenceMap$IEntry == null) {
                    this.table[n2] = this.newEntry(n, object, referenceMap$IEntry2.getNext());
                } else {
                    referenceMap$IEntry.setNext(this.newEntry(n, object, referenceMap$IEntry2.getNext()));
                }
                return;
            }
            referenceMap$IEntry = referenceMap$IEntry2;
            referenceMap$IEntry2 = referenceMap$IEntry2.getNext();
        }
        ++this.size;
        this.table[n2] = this.newEntry(n, object, this.table[n2]);
    }

    public Object remove(int n) {
        this.purge();
        return this.doRemove(n, false);
    }

    private void resize() {
        ReferenceMap$IEntry[] referenceMap$IEntryArray = this.table;
        this.table = new ReferenceMap$IEntry[referenceMap$IEntryArray.length * 2];
        int n = 0;
        while (n < referenceMap$IEntryArray.length) {
            ReferenceMap$IEntry referenceMap$IEntry = referenceMap$IEntryArray[n];
            while (referenceMap$IEntry != null) {
                ReferenceMap$IEntry referenceMap$IEntry2 = referenceMap$IEntry;
                referenceMap$IEntry = referenceMap$IEntry.getNext();
                int n2 = this.indexFor(referenceMap$IEntry2.getKey());
                referenceMap$IEntry2.setNext(this.table[n2]);
                this.table[n2] = referenceMap$IEntry2;
            }
            referenceMap$IEntryArray[n] = null;
            ++n;
        }
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }
}

