/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.lang.ref.SoftReference;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.runtime.IContributor;

public class ExtensionPoint
extends RegistryObject {
    public static final ExtensionPoint[] EMPTY_ARRAY = new ExtensionPoint[0];
    private Object extraInformation;
    private static final byte LABEL = 0;
    private static final byte SCHEMA = 1;
    private static final byte QUALIFIED_NAME = 2;
    private static final byte NAMESPACE = 3;
    private static final byte CONTRIBUTOR_ID = 4;
    private static final int EXTRA_SIZE = 5;

    protected ExtensionPoint(ExtensionRegistry extensionRegistry, boolean bl) {
        super(extensionRegistry, bl);
    }

    protected ExtensionPoint(int n, int[] nArray, int n2, ExtensionRegistry extensionRegistry, boolean bl) {
        super(extensionRegistry, bl);
        this.setObjectId(n);
        this.setRawChildren(nArray);
        this.setExtraDataOffset(n2);
    }

    protected String getSimpleIdentifier() {
        return this.getUniqueIdentifier().substring(this.getUniqueIdentifier().lastIndexOf(46) + 1);
    }

    private String[] getExtraData() {
        if (this.noExtraData()) {
            if (this.extraInformation != null) {
                return (String[])this.extraInformation;
            }
            return new String[5];
        }
        String[] stringArray = null;
        if (this.extraInformation == null || (stringArray = this.extraInformation instanceof SoftReference ? (String[])((SoftReference)this.extraInformation).get() : (String[])this.extraInformation) == null) {
            stringArray = this.registry.getTableReader().loadExtensionPointExtraData(this.getExtraDataOffset());
            this.extraInformation = new SoftReference<String[]>(stringArray);
        }
        return stringArray;
    }

    private void ensureExtraInformationType() {
        if (this.extraInformation instanceof SoftReference) {
            this.extraInformation = ((SoftReference)this.extraInformation).get();
        }
        if (this.extraInformation == null) {
            this.extraInformation = new String[5];
        }
    }

    protected String getSchemaReference() {
        String[] stringArray = this.getExtraData();
        return stringArray[1] == null ? "" : stringArray[1].replace(File.separatorChar, '/');
    }

    protected String getLabel() {
        String[] stringArray = this.getExtraData();
        return stringArray[0] == null ? "" : stringArray[0];
    }

    protected String getUniqueIdentifier() {
        return this.getExtraData()[2];
    }

    public String getNamespace() {
        return this.getExtraData()[3];
    }

    protected String getContributorId() {
        return this.getExtraData()[4];
    }

    public IContributor getContributor() {
        return this.registry.getObjectManager().getContributor(this.getContributorId());
    }

    void setSchema(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[1] = string;
    }

    void setLabel(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[0] = string;
    }

    void setUniqueIdentifier(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[2] = string;
    }

    void setNamespace(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[3] = string;
    }

    void setContributorId(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[4] = string;
    }

    public String toString() {
        return this.getUniqueIdentifier();
    }
}

