/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import org.eclipse.core.internal.registry.Contribution$$Cold;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class Contribution
implements KeyedElement {
    static final int[] EMPTY_CHILDREN = new int[2];
    protected ExtensionRegistry registry;
    protected final String contributorId;
    private String defaultNamespace = null;
    protected boolean persist;
    private int[] children = EMPTY_CHILDREN;
    public static final byte EXTENSION_POINT = 0;
    public static final byte EXTENSION = 1;

    protected Contribution(String string, ExtensionRegistry extensionRegistry, boolean bl) {
        this.contributorId = string;
        this.registry = extensionRegistry;
        this.persist = bl;
    }

    void setRawChildren(int[] nArray) {
        this.children = nArray;
    }

    protected String getContributorId() {
        return this.contributorId;
    }

    protected int[] getRawChildren() {
        return this.children;
    }

    protected int[] getExtensions() {
        int[] nArray = new int[this.children[1]];
        System.arraycopy(this.children, 2 + this.children[0], nArray, 0, this.children[1]);
        return nArray;
    }

    protected int[] getExtensionPoints() {
        int[] nArray = new int[this.children[0]];
        System.arraycopy(this.children, 2, nArray, 0, this.children[0]);
        return nArray;
    }

    public String getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = this.registry.getObjectManager().getContributor(this.contributorId).getName();
        }
        return this.defaultNamespace;
    }

    public int getKeyHashCode() {
        return this.getKey().hashCode();
    }

    public Object getKey() {
        return this.contributorId;
    }

    public boolean compare(KeyedElement keyedElement) {
        return this.contributorId.equals(((Contribution)keyedElement).contributorId);
    }

    public boolean shouldPersist() {
        return this.persist;
    }

    void mergeContribution(Contribution contribution) {
        Assert.isTrue((boolean)this.contributorId.equals(contribution.contributorId));
        Assert.isTrue((this.registry == contribution.registry ? 1 : 0) != 0);
        if (this.shouldPersist() != contribution.shouldPersist()) {
            this.persist = true;
        }
        int[] nArray = this.getRawChildren();
        int[] nArray2 = contribution.getRawChildren();
        int n = nArray[0] + nArray2[0];
        int n2 = nArray[1] + nArray2[1];
        int[] nArray3 = new int[2 + n + n2];
        nArray3[0] = n;
        System.arraycopy(nArray, 2, nArray3, 2, nArray[0]);
        System.arraycopy(nArray2, 2, nArray3, 2 + nArray[0], nArray2[0]);
        nArray3[1] = n2;
        System.arraycopy(nArray, 2 + nArray[0], nArray3, 2 + n, nArray[1]);
        System.arraycopy(nArray2, 2 + nArray2[0], nArray3, 2 + n + nArray[1], nArray2[1]);
        this.children = nArray3;
    }

    public String toString() throws  {
        return Contribution$$Cold.toString(this);
    }

    public void unlinkChild(int n) {
        int n2 = -1;
        int n3 = 2;
        while (n3 < this.children.length) {
            if (this.children[n3] == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            throw (Throwable)new InvalidRegistryObjectException();
        }
        int[] nArray = new int[this.children.length - 1];
        System.arraycopy(this.children, 0, nArray, 0, n2);
        System.arraycopy(this.children, n2 + 1, nArray, n2, this.children.length - n2 - 1);
        if (n2 < this.children[0] + 2) {
            nArray[0] = nArray[0] - 1;
        } else {
            nArray[1] = nArray[1] - 1;
        }
        this.children = nArray;
    }

    public boolean isEmpty() {
        return this.children[0] == 0 || this.children[1] == 0;
    }

    public boolean hasChild(int n) {
        int n2 = 2;
        while (n2 < this.children.length) {
            if (this.children[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

