/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.adapter;

import java.util.ArrayList;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.EquinoxUtils;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class AdapterFactoryProxy
implements IAdapterFactory,
IAdapterFactoryExt {
    private IConfigurationElement element;
    private IAdapterFactory factory;
    private boolean factoryLoaded = false;
    private String ownerId;
    private int internalOwnerID = -1;

    AdapterFactoryProxy() {
    }

    public static AdapterFactoryProxy createProxy(IConfigurationElement iConfigurationElement) {
        AdapterFactoryProxy adapterFactoryProxy = new AdapterFactoryProxy();
        adapterFactoryProxy.element = iConfigurationElement;
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        adapterFactoryProxy.ownerId = iExtension.getUniqueIdentifier();
        if (iExtension instanceof Handle) {
            adapterFactoryProxy.internalOwnerID = ((Handle)((Object)iExtension)).getId();
        }
        if ("factory".equals(iConfigurationElement.getName())) {
            return adapterFactoryProxy;
        }
        adapterFactoryProxy.logError();
        return null;
    }

    public boolean originatesFrom(IExtension iExtension) {
        String string = iExtension.getUniqueIdentifier();
        if (string != null) {
            return string.equals(this.ownerId);
        }
        if (!(iExtension instanceof Handle)) {
            return false;
        }
        return this.internalOwnerID == ((Handle)((Object)iExtension)).getId();
    }

    String getAdaptableType() {
        String string = this.element.getAttribute("adaptableType");
        if (string != null) {
            return string;
        }
        this.logError();
        return "";
    }

    public Object getAdapter(Object object, Class clazz) {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : this.factory.getAdapter(object, clazz);
    }

    public Class[] getAdapterList() {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : this.factory.getAdapterList();
    }

    public String[] getAdapterNames() {
        IConfigurationElement[] iConfigurationElementArray = this.element.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string;
            if ("adapter".equals(iConfigurationElementArray[n].getName()) && (string = iConfigurationElementArray[n].getAttribute("type")) != null) {
                arrayList.add(string);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            this.logError();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    IExtension getExtension() {
        return this.element.getDeclaringExtension();
    }

    public synchronized IAdapterFactory loadFactory(boolean bl) {
        boolean bl2;
        if (this.factory != null || this.factoryLoaded) {
            return this.factory;
        }
        String string = this.element.getContributor().getName();
        try {
            bl2 = EquinoxUtils.isActive(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl2 = true;
        }
        if (!bl && !bl2) {
            return null;
        }
        this.factoryLoaded = true;
        try {
            this.factory = (IAdapterFactory)this.element.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            String string2 = NLS.bind((String)RegistryMessages.adapters_cantInstansiate, (Object)this.getAdaptableType(), (Object)this.element.getContributor().getName());
            RuntimeLog.log((IStatus)((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, string2, (Throwable)coreException)));
        }
        return this.factory;
    }

    private void logError() {
        String string = NLS.bind((String)RegistryMessages.adapters_badAdapterFactory, (Object)this.element.getContributor().getName());
        RuntimeLog.log((IStatus)((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, string, null)));
    }
}

