/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropStreamSegment;
import com.ibm.rational.wvcm.interop.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.VersionSet;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteropStream {
    private static final String CONCAT_PATH = "{0}/{1}";
    private static final String TRUNC_PATH = ".../{0}";
    private static final String CONCAT_NAME = "{0}_{1}";
    private static final String CONCAT_MSG = "{0}\n{1}";
    public static final String CLONE_NAME = "CLONE";
    public static final String INTERNAL_NAME = "INTERNAL";
    private static final String CLONE_WORKSPACE_NAME = "CLONE_{0}";
    private static final String INTERNAL_WORKSPACE_NAME = "INTERNAL_{0}";
    private static final String TRUE_STRING = Boolean.TRUE.toString();
    private static final String FALSE_STRING = Boolean.FALSE.toString();
    private static final String EMPTY_STRING = new String();
    public static final String DOT = String.valueOf('.');
    public static final String SCM_CONNECTOR_NAMESPACE = "com.ibm.team.connector.scm";
    public static final String INTEROP_NAMESPACE = "com.ibm.team.interop";
    public static final String IMPORTER_NAMESPACE = "com.ibm.team.importer";
    public static final String RATIONAL_WVCM_NAMESPACE = "com.ibm.rational.wvcm";
    public static final String IA_PREFIX = "com.ibm.team.connector.scm" + DOT;
    public static final String IA_WORKSPACE_PATH = "com.ibm.rational.wvcm" + DOT + "WORKSPACE_LOCATION";
    public static final String IA_LINE_SEPARATOR = String.valueOf(IA_PREFIX) + "LINE_DELIMITER";
    public static final String IA_WORKSPACE_LINE_SEPARATOR = String.valueOf(IA_PREFIX) + "LINE_DELIMITER_WORKSPACE";
    public static final String IA_CHARACTER_SET = String.valueOf(IA_PREFIX) + "CHARACTER_SET";
    public static final String IA_MERGE_WORKSPACE = "com.ibm.team.interop" + DOT + "MERGE_WORKSPACE";
    public static final String IA_OTHER_WORKSPACE_NAME = "com.ibm.team.interop" + DOT + "OTHER_WORKSPACE_NAME";
    public static final String IA_OTHER_STREAM_LOCATION = "com.ibm.team.interop" + DOT + "OTHER_STREAM_LOCATION";
    public static final String IA_IGNORE_TASK_CREATION_FAILURE = "com.ibm.team.interop" + DOT + "IGNORE_TASK_CREATION_FAILURE";
    public static final String IA_FORCE_EXCEPTION = "com.ibm.team.interop" + DOT + "FORCE_EXCEPTION";
    public static int MAX_FORCE_EXCEPTION = 28;
    public static final String IA_DESYNC = "com.ibm.team.interop" + DOT + "DESYNC";
    public static final String DESYNC_TREE = "tree";
    public static final String DESYNC_COMPONENT = "component";
    public static final String TERMINATOR1 = "\n\n\n.";
    public static final String TERMINATOR2 = "\n\n.";
    public static final String TERMINATOR3 = "\n.";
    public static final String IA_IMPORT_ONLY = "com.ibm.team.interop" + DOT + "IMPORT_ONLY";
    public static final String IA_BASELINE_FILTER = "com.ibm.team.importer" + DOT + "BASELINE_ATTRIBUTE";
    public static final String IA_IS_THIS_PROVIDER = "com.ibm.team.interop" + DOT + "IS_THIS_PROVIDER";
    public static final PropertyNameList.PropertyName<String> PN_INTEROP_STREAM = new PropertyNameList.PropertyName("com.ibm.team.interop", "INTEROP_STREAM");
    public static final PropertyNameList.PropertyName<String> PN_INTEROP_STREAM_LOCKED = new PropertyNameList.PropertyName("com.ibm.team.interop", "INTEROP_STREAM_LOCKED");
    public static final PropertyNameList.PropertyName<String> PN_CLONE = new PropertyNameList.PropertyName("com.ibm.team.interop", "CLONE");
    public static final PropertyNameList.PropertyName<String> PN_RESERVE_FOR_INTEROP = new PropertyNameList.PropertyName("com.ibm.team.interop", "RESERVE_FOR_INTEROP");
    public static final PropertyNameList.PropertyName<String> PN_RESERVED_FOR_INTEROP = new PropertyNameList.PropertyName("com.ibm.team.interop", "RESERVED_FOR_INTEROP");
    public static final PropertyNameList.PropertyName<String> PN_LINE_SEPARATOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "PN_LINE_SEPARATOR_CONVERSION");
    public static final PropertyNameList.PropertyName<String> PN_TASK_IDS = new PropertyNameList.PropertyName("com.ibm.team.interop", "TASK_IDS");
    private static final String NO_CLONE_PREFIX = "NO_CLONE";
    private static final Workspace.MergeFlag[] MF_NO_CHECKOUTS = new Workspace.MergeFlag[]{Workspace.MergeFlag.NO_CHECKOUT};
    private static final Workspace.MergeFlag[] MF_NO_CHECKOUTS_UPDATE = new Workspace.MergeFlag[]{Workspace.MergeFlag.NO_CHECKOUT, Workspace.MergeFlag.UPDATE_STREAM};
    public static int numChanges = 0;
    public static int numClones = 0;
    public static int numFilesCreated = 0;
    public static int numFilesUpdated = 0;
    public static int numFoldersCreated = 0;
    public static int numFoldersUpdated = 0;
    public static int numSymlinksCreated = 0;
    private static Map<String, SyncStats> _syncStatsMap;
    private InteropStreamSegment _thisSegment;
    private InteropStreamSegment _otherSegment;
    private long _minorVersion;
    private long _lastAttemptedSyncDate;
    private long _lastSyncDate;
    private long _stateId;
    private InteropStreamOperation _operation;
    private String[] _newSyncRootPaths;
    private static final PropertyRequestItem.PropertyRequest PR_CA_COMMENT_TASKS;
    PropertyRequestItem.PropertyRequest PR_RFIS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.DISPLAY_NAME, PN_RESERVED_FOR_INTEROP});
    public static PropertyRequestItem.PropertyRequest PR_PATH;
    public static final PropertyRequestItem.PropertyRequest PR_VH_CLONE;
    private static final PropertyRequestItem.PropertyRequest PR_VERSION_CHILDMAP;
    public static final PropertyRequestItem.PropertyRequest PR_VH;
    public static final VersionSet.CompareFlag[] CF_ACT_NEW;
    public static final PropertyNameList.PropertyName<String> PN_TASK_ID;
    public static final PropertyRequestItem.PropertyRequest PR_CHANGED_VERSIONS_ACT;
    public static final PropertyRequestItem.PropertyRequest PR_CI_DN;
    private static final PropertyRequestItem.PropertyRequest PR_CHILDMAP;
    private static final PropertyRequestItem.PropertyRequest PR_CR_CHILD_CLONE;
    private static final PropertyRequestItem.PropertyRequest PR_PATH_CR_CHILD_CLONE;
    private static final PropertyRequestItem.PropertyRequest PR_PATH_VH_CR_CHILD_CLONE;
    private static final PropertyRequestItem.PropertyRequest PR_CI_LINK_TARGET;
    public static final PropertyRequestItem.PropertyRequest PR_CI;
    public static final PropertyRequestItem.PropertyRequest PR_NEW_CONTENT_CHARACTERISTICS;
    private static final PropertyRequestItem.PropertyRequest PR_VH_NAME;
    private static final String IA_HAS_CLONE_INFO;
    private static final PropertyRequestItem.PropertyRequest PR_CI_VH_CLONE;
    private static final PropertyRequestItem.PropertyRequest PR_CI_VH_VERSION_CHILDMAP;
    private static final PropertyRequestItem.PropertyRequest PR_CA_TASKS_COMMENT;
    private static final PropertyRequestItem.PropertyRequest PR_COMMENT;
    private static final PropertyRequestItem.PropertyRequest PR_STREAM;
    private static int CURRENT_MAJOR_VERSION;
    private static int CURRENT_MINOR_VERSION;
    private static final PropertyRequestItem.PropertyRequest PR_CFG_WS_VH_CLONE;
    private static PropertyRequestItem.PropertyRequest PR_CFG_RF;
    private static final PropertyRequestItem.PropertyRequest PR_CFG_RF_WS_VH_CLONE;
    private static PropertyRequestItem.PropertyRequest PR_RF_VH;
    private static PropertyRequestItem.PropertyRequest PR_ROOT_DN;
    public static PropertyRequestItem.PropertyRequest PR_CLONE;
    private static final PropertyRequestItem.PropertyRequest PR_CONFIG_VH;
    private static PropertyRequestItem.PropertyRequest PR_BL;
    private static final PropertyRequestItem.PropertyRequest PR_PATH_VH_CLONE;
    private static final PropertyRequestItem.PropertyRequest PR_CONFIG_VH_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_IS;
    private static final PropertyRequestItem.PropertyRequest PR_WORKSPACE;

    static {
        PR_CA_COMMENT_TASKS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.CURRENT_ACTIVITY.nest(new PropertyRequestItem[]{Activity.COMMENT, Activity.TASK_LIST})});
        PR_PATH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION});
        PR_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER, PN_CLONE})});
        PR_VERSION_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, FolderVersion.CHILD_MAP.nest(new PropertyRequestItem[]{PN_CLONE})});
        PR_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER})});
        CF_ACT_NEW = new VersionSet.CompareFlag[]{VersionSet.CompareFlag.ACTIVITIES, VersionSet.CompareFlag.NEW_ONLY};
        PN_TASK_ID = new PropertyNameList.PropertyName(INTEROP_NAMESPACE, "TASK_ID");
        PR_CHANGED_VERSIONS_ACT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, Activity.TASK_LIST.nest(new PropertyRequestItem[]{PN_CLONE, Resource.DISPLAY_NAME, Resource.COMMENT, PN_TASK_ID})});
        PR_CI_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{Baseline.DISPLAY_NAME})});
        PR_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.CHILD_MAP});
        PR_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.CHILD_MAP.nest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN, PR_VH_CLONE})});
        PR_PATH_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.PATHNAME_LOCATION, PR_CR_CHILD_CLONE});
        PR_PATH_VH_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableFolder.PATHNAME_LOCATION, ControllableFolder.VERSION_HISTORY, PR_CR_CHILD_CLONE});
        PR_CI_LINK_TARGET = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{SymbolicLinkVersion.LINK_TARGET})});
        PR_CI = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN});
        PR_NEW_CONTENT_CHARACTERISTICS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.CONTENT_TYPE, Version.CONTENT_CHARACTER_SET, Version.IS_EXECUTABLE, PN_LINE_SEPARATOR});
        PR_VH_NAME = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Configuration.VERSION_HISTORY.nest(new PropertyRequestItem[]{Component.DISPLAY_NAME})});
        IA_HAS_CLONE_INFO = RATIONAL_WVCM_NAMESPACE + DOT + "HAS_CLONE_INFO";
        PR_CI_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
        PR_CI_VH_VERSION_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{PR_VERSION_CHILDMAP, PR_NEW_CONTENT_CHARACTERISTICS})});
        PR_CA_TASKS_COMMENT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.CURRENT_ACTIVITY.nest(new PropertyRequestItem[]{Activity.TASK_LIST.nest(new PropertyRequestItem[]{Task.COMMENT})})});
        PR_COMMENT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Task.COMMENT});
        PR_STREAM = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.STREAM});
        CURRENT_MAJOR_VERSION = 8;
        CURRENT_MINOR_VERSION = 1;
        PR_CFG_WS_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE, ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{Configuration.VERSION_HISTORY})});
        PR_CFG_RF = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableFolder.CONFIGURATION.nest(new PropertyRequestItem[]{Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{ControllableFolder.PATHNAME_LOCATION}), Configuration.VERSION_HISTORY.nest(new PropertyRequestItem[]{Component.DISPLAY_NAME, PN_CLONE})})});
        PR_CFG_RF_WS_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE, PR_CFG_RF});
        PR_RF_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
        PR_ROOT_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Component.ROOT_VERSION, Component.DISPLAY_NAME});
        PR_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_CLONE});
        PR_CONFIG_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{PR_VH})});
        PR_BL = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Baseline.SUCCESSOR_LIST});
        PR_PATH_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.PATHNAME_LOCATION, PR_VH_CLONE});
        PR_CONFIG_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
        PR_IS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_INTEROP_STREAM});
        PR_WORKSPACE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Stream.WORKSPACE});
    }

    private static boolean isFakeClonePath(String cloneVHPath) {
        return cloneVHPath != null && cloneVHPath.startsWith(NO_CLONE_PREFIX);
    }

    private static int LP(int percentDone, int index, int size, int begin, int end) {
        return begin + ((end - begin) * index + (end - begin) * percentDone / 100) / size;
    }

    private static void incrementSyncStat(SyncStatType statType, Resource resource, int amount) throws WvcmException {
        String key = resource.provider().rootLocation().string();
        SyncStats syncStats = _syncStatsMap.get(key);
        if (syncStats == null) {
            syncStats = new SyncStats();
            _syncStatsMap.put(key, syncStats);
        }
        syncStats.incrementSyncStat(statType, amount);
    }

    private static SyncStats getSyncStats(Provider provider) {
        String key = provider.rootLocation().string();
        SyncStats result = _syncStatsMap.get(key);
        if (result == null) {
            result = new SyncStats();
        }
        return result;
    }

    public SyncStats getThisSyncStats() throws WvcmException {
        return InteropStream.getSyncStats((Provider)this.thisProvider());
    }

    public SyncStats getOtherSyncStats() throws WvcmException {
        return InteropStream.getSyncStats((Provider)this.otherProvider());
    }

    private static boolean shouldForceException(Provider p, int i) {
        String faultRequestedVal = (String)p.initArgs().get(IA_FORCE_EXCEPTION);
        if (faultRequestedVal == null || faultRequestedVal.length() == 0) {
            return false;
        }
        int faultRequested = Integer.parseInt(faultRequestedVal);
        return i == faultRequested;
    }

    private static void forceWvcmException(Provider p, int i) throws WvcmException {
        if (InteropStream.shouldForceException(p, i)) {
            throw new WvcmException("Aborted", WvcmException.ReasonCode.ABORTED);
        }
    }

    private static void forceAbortWvcmException(Provider p, int i, Feedback f) {
        if (InteropStream.shouldForceException(p, i)) {
            f.abortRequested(true);
        }
    }

    public static <T> T getOrReadProperty(Resource resource, PropertyNameList.PropertyName<T> requestedPropertyName, Feedback feedback) throws WvcmException {
        if (Arrays.asList(resource.propertyNameList().getPropertyNames()).contains(requestedPropertyName)) {
            return (T)resource.getProperty(requestedPropertyName);
        }
        return InteropStream.doReadProperty(resource, requestedPropertyName, feedback);
    }

    public static <T> T doReadProperty(Resource resource, PropertyNameList.PropertyName<T> propName, Feedback feedback) throws WvcmException {
        PropertyRequestItem.PropertyRequest pr = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{propName});
        PropertyRequestItem.PropertyRequest f = feedback == null ? pr : feedback.nest(pr);
        resource = resource.doReadProperties((Feedback)f);
        return (T)resource.getProperty(propName);
    }

    private InteropStream(InteropStreamSegment thisSegment, InteropStreamSegment otherSegment, long minorVersion, long lastAttemptedSyncDate, long lastSyncDate, long stateId, InteropStreamOperation operation, String[] roots) {
        this._thisSegment = thisSegment;
        this._otherSegment = otherSegment;
        this._minorVersion = minorVersion;
        this._lastAttemptedSyncDate = lastAttemptedSyncDate;
        this._lastSyncDate = lastSyncDate;
        this._stateId = stateId;
        this._operation = operation;
        this._newSyncRootPaths = roots;
        _syncStatsMap = new HashMap<String, SyncStats>(2);
    }

    public InteropStream(InteropStreamSegment thisSegment, InteropStreamSegment otherSegment) {
        this(thisSegment, otherSegment, 0L, 0L, 0L, 0L, InteropStreamOperation.INITIALIZE, null);
    }

    public static Workspace createWorkspace(String name, boolean isIsolated, Stream stream, boolean reservedForInterop, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Workspace ws = p.workspace(p.rootLocation().child(name));
        if (isIsolated) {
            ws.setIsolatedTarget(stream);
        } else {
            ws.setTarget(stream);
        }
        if (reservedForInterop) {
            ws.setProperty(PN_RESERVE_FOR_INTEROP, (Object)TRUE_STRING);
        }
        ws = ws.doCreateGeneratedResource(feedback);
        return ws;
    }

    private static boolean getIgnoreTaskCreationFailure(WorkspaceProvider p) {
        return TRUE_STRING.equals(p.initArgs().get(IA_IGNORE_TASK_CREATION_FAILURE));
    }

    private static Task createTask(String taskName, Workspace tgtWs, Feedback f) throws WvcmException {
        WorkspaceProvider p = tgtWs.workspaceProvider();
        try {
            InteropStream.forceAbortWvcmException((Provider)p, 1, f);
            Task task = p.task(tgtWs.location().child(Messages.getString("InteropStream.ID_SYNCHRONIZE_TASK")));
            if (taskName == null) {
                String dateStr = InteropStream.currentDate();
                taskName = f.format(Messages.getString("InteropStream.NAME_SYNCHRONIZE_TASK"), new Object[]{dateStr});
            }
            task.setDisplayName(taskName);
            task = task.doCreateGeneratedResource(f);
            return task;
        }
        catch (WvcmException e) {
            if (!InteropStream.getIgnoreTaskCreationFailure(p)) {
                throw e;
            }
            f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_CREATE_TASK"), new Object[]{taskName, e.getMessage()}));
            return null;
        }
    }

    public static Stream createStream(String name, WorkspaceProvider p, Stream target, Feedback feedback) throws WvcmException {
        Stream stream = p.stream(p.rootLocation().child(name));
        if (target != null) {
            stream.setTarget(target);
        }
        return (Stream)stream.doCreateGeneratedResource(feedback);
    }

    private static String currentDate() {
        return DateFormat.getDateTimeInstance(2, 2).format(new Date().getTime());
    }

    private static void closeCurrentActivity(Workspace ws, Feedback f) throws WvcmException {
        Activity activity = (ws = (Workspace)ws.doReadProperties(f.nest(PR_CA_COMMENT_TASKS, 25))).getCurrentActivity();
        if (activity != null) {
            Task task;
            if (activity.getComment() == null) {
                activity.setComment(Messages.getString("InteropStream.SYNCHRONIZE"));
            }
            if (activity.getTaskList().size() == 0 && (task = InteropStream.createTask(null, ws, f.nest(50))) != null) {
                activity.setTaskList(InteropStream.makeList(task));
            }
            activity.setIsComplete(true);
            activity.setOriginWorkspace(ws);
            activity.doWriteProperties(f.nest(75));
            ws.setCurrentActivity(null);
            ws.doWriteProperties(f.nest(100));
        }
    }

    private static void updateStreamWithWorkspace(Stream stream, Workspace ws, Feedback f) throws WvcmException {
        InteropStream.closeCurrentActivity(ws, f.nest(30));
        stream.doUpdate(InteropStream.makeList(ws), f.nest(100));
    }

    private String createOtherWorkspaceName(String otherSyncStreamName, Feedback f) {
        String wsName = this.otherSegment().get_initArgs().get(IA_OTHER_WORKSPACE_NAME);
        if (wsName == null || wsName.length() == 0) {
            String OTHER_WORKSPACE_NAME = Messages.getString("InteropStream.OTHER_WORKSPACE_NAME");
            wsName = f.format(OTHER_WORKSPACE_NAME, new Object[]{otherSyncStreamName});
        }
        return wsName;
    }

    private static String getFriendlyPathname(Resource resource, int maxLength, Feedback f) throws WvcmException {
        Location loc = resource.getPathnameLocation();
        int remainder = maxLength;
        String name = loc.lastSegment();
        while ((loc = loc.parent()) != null && loc.parent() != null && loc.parent().parent() != null) {
            if (maxLength > 0 && loc.lastSegment().length() > remainder + 5) {
                name = f.format(TRUNC_PATH, new Object[]{name});
                return name;
            }
            name = f.format(CONCAT_PATH, new Object[]{loc.lastSegment(), name});
        }
        return name;
    }

    private static String readFriendlyPathname(Resource resource, int maxLength, Feedback f) throws WvcmException {
        Resource r = resource;
        if (!(resource.lookupProperty(Resource.PATHNAME_LOCATION) instanceof String)) {
            r = resource.doReadProperties(f.nest(PR_PATH, 100));
        }
        return InteropStream.getFriendlyPathname(r, 0, f);
    }

    private void reserveOtherStream(Feedback f) throws WvcmException {
        Stream otherSyncStream = this.otherSyncStream();
        String thisStreamName = (String)InteropStream.doReadProperty((Resource)this.thisSyncStream(), Resource.DISPLAY_NAME, f.nest(10));
        otherSyncStream.initProperty(PN_RESERVED_FOR_INTEROP, (Object)thisStreamName);
        try {
            otherSyncStream.doWriteProperties(f.nest(100));
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.CANNOT_OVERWRITE)) {
                String reservedBy = InteropStream.doReadProperty((Resource)otherSyncStream, PN_RESERVED_FOR_INTEROP, f.nest());
                throw new WvcmException(f.format(Messages.getString("InteropStream.ERROR_STREAM_RESERVED"), new Object[]{reservedBy}), (Resource)otherSyncStream, WvcmException.ReasonCode.CONFLICT, (Throwable)e);
            }
            throw e;
        }
    }

    private void reserveInteropStream(Feedback f) throws WvcmException {
        Stream stream = this.thisSyncStream();
        InteropStream currentIS = this.refresh(f.nest(50));
        if (this._stateId != currentIS._stateId) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_STALE_DATA"), WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN);
        }
        stream.initProperty(PN_INTEROP_STREAM_LOCKED, (Object)TRUE_STRING);
        try {
            stream.doWriteProperties(f.nest(100));
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.CANNOT_OVERWRITE)) {
                String streamName = (String)InteropStream.doReadProperty((Resource)stream, Resource.DISPLAY_NAME, f.nest());
                throw new WvcmException(f.format(Messages.getString("InteropStream.ERROR_STREAM_LOCKED"), new Object[]{streamName}), (Resource)stream, WvcmException.ReasonCode.CONFLICT, (Throwable)e);
            }
            throw e;
        }
    }

    private void updateISMetadata(Feedback f) throws WvcmException {
        Stream thisSyncStream = this.thisSyncStream();
        ++this._stateId;
        thisSyncStream.setProperty(PN_INTEROP_STREAM, (Object)this.unparse());
        thisSyncStream.doWriteProperties(f.nest(100));
    }

    private void unreserveInteropStream(Feedback f) throws WvcmException {
        Stream thisSyncStream = this.thisSyncStream();
        try {
            InteropStream.forceAbortWvcmException((Provider)thisSyncStream.workspaceProvider(), 2, f);
            thisSyncStream.removeProperty(PN_INTEROP_STREAM_LOCKED);
            thisSyncStream.doWriteProperties(f.nest(100));
        }
        catch (Exception exception) {
            String streamName = new String();
            try {
                streamName = (String)InteropStream.doReadProperty((Resource)thisSyncStream, Resource.DISPLAY_NAME, f.nest(100));
            }
            catch (Exception exception2) {}
            f.notifyWarning(f.format(Messages.getString("InteropStream.ERROR_COULD_NOT_UNLOCK"), new Object[]{streamName}));
        }
    }

    private void unreserveOtherStream(Feedback f) throws WvcmException {
        Stream otherSyncStream = this.otherSyncStream();
        try {
            InteropStream.forceAbortWvcmException((Provider)otherSyncStream.workspaceProvider(), 3, f);
            otherSyncStream.removeProperty(PN_RESERVED_FOR_INTEROP);
            otherSyncStream.doWriteProperties(f.nest(100));
        }
        catch (Exception exception) {
            f.notifyWarning(Messages.getString("InteropStream.ERROR_COULD_NOT_UNRESERVE_STREAM"));
        }
    }

    private static List<ControllableResource> getSyncRoots(Workspace ws, InteropStreamSegment segment, Feedback f) throws WvcmException {
        Feedback nowork = f.nest(f.getPropertyRequestForResult());
        ArrayList<ControllableResource> roots = new ArrayList<ControllableResource>();
        WorkspaceProvider p = ws.workspaceProvider();
        String[] paths = segment.get_syncRootPaths();
        int n = paths.length;
        int i = 0;
        String[] stringArray = paths;
        int n2 = paths.length;
        int n3 = 0;
        while (n3 < n2) {
            String path = stringArray[n3];
            VersionHistory vh = p.versionHistory(p.location(path));
            roots.add(InteropStream.doFindCRInWorkspace(ws, vh, nowork));
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
            ++n3;
        }
        return roots;
    }

    private List<ControllableResource> getPrunedSyncRoots(boolean isThis, Workspace ws, Feedback f) throws WvcmException {
        Feedback fResult = f.nest(f.getPropertyRequestForResult());
        InteropStreamSegment segment = isThis ? this.thisSegment() : this.otherSegment();
        ArrayList<ControllableResource> roots = new ArrayList<ControllableResource>();
        ArrayList<VersionHistory> prunedRoots = new ArrayList<VersionHistory>();
        WorkspaceProvider p = ws.workspaceProvider();
        String[] paths = segment.get_syncRootPaths();
        int n = paths.length;
        int i = 0;
        String[] stringArray = paths;
        int n2 = paths.length;
        int n3 = 0;
        while (n3 < n2) {
            String path = stringArray[n3];
            VersionHistory vh = p.versionHistory(p.location(path));
            ControllableResource root = InteropStream.doFindCRInWorkspace(ws, vh, fResult);
            if (root == null) {
                prunedRoots.add(vh);
            } else {
                roots.add(root);
            }
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
            ++n3;
        }
        this.internalDeleteSyncRoots(isThis, prunedRoots, f.nest());
        return roots;
    }

    private void sendoverThisStream(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace mergedWs = this.thisInternalWs();
        Stream mergedStream = this.thisInternalStream();
        Workspace cloneWs = this.thisCloneWs();
        Stream cloneStream = this.thisCloneStream();
        Workspace otherSyncWs = this.otherSyncWs();
        Stream otherSyncStream = this.otherSyncStream();
        InteropStream.closeCurrentActivity(otherSyncWs, nowork);
        WorkspaceProvider srcP = mergedStream.workspaceProvider();
        ResourceList srcChangedVersions = srcP.resourceList((Resource[])new Version[0]);
        ResourceList srcTasks = srcP.resourceList((Resource[])new Task[0]);
        f.notifyActive(Messages.getString("InteropStream.MSG_CHANGES_IN_STREAM"));
        InteropStream.computeNewVersionList((ResourceList<Version>)srcChangedVersions, (ResourceList<Task>)srcTasks, (ResourceList.ResponseIterator<VersionSet.CompareReport>)cloneStream.doCompareReport((VersionSet)mergedStream, CF_ACT_NEW, f.nest(PR_CHANGED_VERSIONS_ACT, 50)));
        if (srcChangedVersions.size() > 0) {
            f.notifyActive(Messages.getString("InteropStream.MSG_COMPUTING_OTHER_ROOTS"));
            List<ControllableResource> tgtRoots = this.otherSyncRoots(this.otherSyncWs(), f.nest(PR_PATH, 55));
            HashSet<String> tgtRootPaths = new HashSet<String>();
            for (ControllableResource tgtRoot : tgtRoots) {
                if (tgtRoot == null) continue;
                tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
            }
            this.setTaskIdsProperty(f, otherSyncWs, (List<Task>)srcTasks);
            InteropStream.sendoverChanges(otherSyncWs, otherSyncStream, tgtRootPaths, (ResourceList<Version>)srcChangedVersions, mergedWs, false, null, f.nest(90));
            InteropStream.sendoverTasks(otherSyncWs, otherSyncStream, null, null, (ResourceList<Task>)srcTasks, f.nest(95));
            this.setOtherSentover(f.nest(100));
        }
        cloneWs.doUpdate(InteropStream.makeList(mergedStream), nowork);
        cloneStream.doUpdate(InteropStream.makeList(cloneWs), nowork);
        InteropStream.closeCurrentActivity(otherSyncWs, nowork);
    }

    private void setTaskIdsProperty(Feedback f, Workspace tgtSyncWs, List<Task> srcTasks) throws WvcmException {
        ArrayList<String> taskIds = new ArrayList<String>(srcTasks.size());
        for (Task srcTask : srcTasks) {
            String taskId = InteropStream.getProperty((Resource)srcTask, PN_TASK_ID);
            if (taskId == null) continue;
            taskIds.add(taskId);
        }
        if (taskIds.size() > 0) {
            String evValue = ((Object)taskIds).toString();
            tgtSyncWs.initProperty(PN_TASK_IDS, (Object)evValue.substring(1, evValue.length() - 1));
            tgtSyncWs.doWriteProperties(f.nest(100));
        }
    }

    private ResourceList<Baseline> getSentoverBaselines() throws WvcmException {
        WorkspaceProvider otherP = this.otherProvider();
        ResourceList baselines = otherP.resourceList((Resource[])new Baseline[0]);
        String[] stringArray = this.otherSegment().get_sentoverBaselinePaths();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String srcBlName = stringArray[n2];
            baselines.add((Object)otherP.baseline(otherP.location(srcBlName)));
            ++n2;
        }
        return baselines;
    }

    private ResourceList<Baseline> readSentoverBaselines(Feedback f) throws WvcmException {
        ResourceList result = this.otherProvider().resourceList((Resource[])new Baseline[0]);
        ResourceList.ResponseIterator baselines = this.getSentoverBaselines().doReadProperties(f);
        while (baselines.hasNext()) {
            result.add((Object)((Baseline)baselines.next()));
        }
        return result;
    }

    private ResourceList<Component> readSentoverComponents(Feedback f) throws WvcmException {
        ResourceList result = this.otherProvider().resourceList((Resource[])new Component[0]);
        ResourceList<Baseline> oldBaselines = this.readSentoverBaselines(f.nest(PR_VH, 100));
        for (Baseline b : oldBaselines) {
            result.add((Object)((Component)b.getVersionHistory()));
        }
        return result;
    }

    private ResourceList<Component> readSentoverComponentsWithNames(Feedback f) throws WvcmException {
        ResourceList result = this.otherProvider().resourceList((Resource[])new Component[0]);
        ResourceList<Baseline> oldBaselines = this.readSentoverBaselines(f.nest(PR_VH_NAME, 100));
        for (Baseline b : oldBaselines) {
            result.add((Object)((Component)b.getVersionHistory()));
        }
        return result;
    }

    private void sendoverOtherBaselines(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace srcWs = this.otherSyncWs();
        Stream srcStream = this.otherSyncStream();
        Workspace tgtWs = this.thisCloneWs();
        Stream tgtStream = this.thisCloneStream();
        List<ControllableResource> tgtRoots = this.thisSyncRoots(this.thisCloneWs(), f.nest(PR_PATH, 5));
        HashSet<String> tgtRootPaths = new HashSet<String>();
        for (ControllableResource tgtRoot : tgtRoots) {
            if (tgtRoot == null) continue;
            tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
        }
        InteropStream.closeCurrentActivity(tgtWs, nowork);
        WorkspaceProvider srcP = srcStream.workspaceProvider();
        boolean srcHasChanges = false;
        ResourceList<Baseline> srcOldBaselines = this.getSentoverBaselines();
        ResourceList<Component> srcComponents = this.readSentoverComponentsWithNames(f.nest(10));
        int n = srcOldBaselines.size();
        String[] srcResultBaselineNames = new String[srcOldBaselines.size()];
        int i = 0;
        while (i < n) {
            Baseline srcOldBaseline = (Baseline)srcOldBaselines.get(i);
            Component comp = (Component)srcComponents.get(i);
            ResourceList srcChangedVersions = srcP.resourceList((Resource[])new Version[0]);
            ResourceList srcTasks = srcP.resourceList((Resource[])new Task[0]);
            Configuration conf = InteropStream.doFindConfigurationInWorkspace(srcWs, comp, f.nest(PR_CI_DN, InteropStream.LP(5, i, n, 10, 95)));
            Baseline srcNewBaseline = (Baseline)conf.getCheckedIn();
            srcResultBaselineNames[i] = srcNewBaseline.getResourceIdentifier();
            String compName = comp.getDisplayName();
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CHANGES_IN_COMPONENT"), new Object[]{compName}));
            InteropStream.computeNewVersionList((ResourceList<Version>)srcChangedVersions, (ResourceList<Task>)srcTasks, (ResourceList.ResponseIterator<VersionSet.CompareReport>)srcOldBaseline.doCompareReport((VersionSet)srcNewBaseline, CF_ACT_NEW, f.nest(PR_CHANGED_VERSIONS_ACT, InteropStream.LP(40, i, n, 10, 95))));
            if (srcChangedVersions.size() > 0) {
                srcHasChanges = true;
                if (srcTasks.size() > 0) {
                    InteropStream.closeCurrentActivity(tgtWs, nowork);
                }
                ResourceList<Version> srcVersions = this.updateVersionsToThoseSelectedByWorkspace(srcWs, (ResourceList<Version>)srcChangedVersions, f.nest(InteropStream.LP(60, i, n, 10, 95)));
                InteropStream.sendoverChanges(tgtWs, tgtStream, tgtRootPaths, srcVersions, srcWs, false, null, f.nest(InteropStream.LP(95, i, n, 10, 95)));
                String summaryName = f.format(Messages.getString("InteropStream.MSG_BRING_OVER_TASKNAME"), new Object[]{srcNewBaseline.getDisplayName()});
                String summaryComment = f.format(Messages.getString("InteropStream.MSG_SYNCHRONIZED_TASK_EMPTY_COMMENT"), new Object[]{summaryName});
                InteropStream.sendoverTasks(tgtWs, tgtStream, summaryName, summaryComment, (ResourceList<Task>)srcTasks, f.nest(InteropStream.LP(100, i, n, 10, 95)));
            }
            ++i;
        }
        if (srcHasChanges) {
            InteropStream.updateStreamWithWorkspace(tgtStream, tgtWs, f.nest(100));
            this.otherSegment().set_sentoverBaselinePaths(srcResultBaselineNames);
        }
    }

    private ResourceList<Version> updateVersionsToThoseSelectedByWorkspace(Workspace srcWs, ResourceList<Version> srcVersions, Feedback fb) throws WvcmException {
        Map<VersionHistory, Version> srcVh2srcVersion = InteropStream.computeSrvVh2srcVersionMap(srcVersions);
        Map<VersionHistory, ControllableResource> crs = InteropStream.doFindCRsInWorkspace(srcWs, srcVh2srcVersion.keySet(), fb.nest(PR_CI_VH_CLONE));
        ResourceList results = srcWs.provider().resourceList((Resource[])new Version[0]);
        for (VersionHistory srcVH : crs.keySet()) {
            ControllableResource cr = crs.get(srcVH);
            if (cr == null) continue;
            results.add((Object)cr.getCheckedIn());
        }
        return results;
    }

    private static Map<VersionHistory, Version> computeSrvVh2srcVersionMap(ResourceList<Version> srcVersions) throws WvcmException {
        HashMap<VersionHistory, Version> srcVh2srcVersion = new HashMap<VersionHistory, Version>(srcVersions.size());
        for (Version srcVersion : srcVersions) {
            srcVh2srcVersion.put(srcVersion.getVersionHistory(), srcVersion);
        }
        return srcVh2srcVersion;
    }

    private static void sendoverTasks(Workspace tgtWs, Stream tgtStream, String summaryName, String summaryComment, ResourceList<Task> srcTasks, Feedback f) throws WvcmException {
        if (summaryComment == null && srcTasks.size() == 0) {
            return;
        }
        WorkspaceProvider tgtP = tgtWs.workspaceProvider();
        Activity tgtAct = (tgtWs = (Workspace)tgtWs.doReadProperties(f.nest(PR_CA_TASKS_COMMENT, 25))).getCurrentActivity();
        if (tgtAct == null) {
            return;
        }
        Task tgtSummaryTask = null;
        String tgtSummaryComment = EMPTY_STRING;
        ResourceList tgtTasks = tgtAct.getTaskList();
        boolean isTaskAdded = false;
        if (tgtTasks.size() > 0) {
            tgtSummaryTask = (Task)tgtTasks.get(0);
            tgtSummaryComment = tgtSummaryTask.getComment();
        }
        String comment = summaryComment;
        for (Task srcTask : srcTasks) {
            String taskName = srcTask.getDisplayName();
            String taskId = InteropStream.getProperty((Resource)srcTask, PN_TASK_ID);
            Task tgtTask = InteropStream.lookupClone(srcTask, tgtP);
            comment = InteropStream.formatComment(f, comment, taskName, taskId);
            if (tgtTask == null || tgtTasks.contains((Object)tgtTask)) continue;
            tgtTasks.add((Object)tgtTask);
            isTaskAdded = true;
        }
        if (comment != null) {
            Task task;
            if (tgtSummaryTask == null && (task = InteropStream.createTask(summaryName, tgtWs, f.nest(50))) != null) {
                tgtSummaryTask = task;
                tgtTasks.add((Object)task);
                isTaskAdded = true;
            }
            if (tgtSummaryTask != null) {
                if (tgtSummaryComment != null && tgtSummaryComment.length() > 0) {
                    comment = f.format(CONCAT_MSG, new Object[]{tgtSummaryComment, comment});
                }
                try {
                    InteropStream.forceAbortWvcmException((Provider)tgtP, 4, f);
                    tgtSummaryTask.setComment(comment);
                    tgtSummaryTask.doWriteProperties(f.nest(75));
                }
                catch (WvcmException e) {
                    if (!InteropStream.getIgnoreTaskCreationFailure(tgtP)) {
                        throw e;
                    }
                    f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_UPDATE_COMMENT"), new Object[]{tgtSummaryTask.location()}));
                }
            }
        }
        if (isTaskAdded) {
            try {
                InteropStream.forceAbortWvcmException((Provider)tgtP, 5, f);
                tgtAct.setTaskList(tgtTasks);
                tgtAct.doWriteProperties(f.nest(100));
            }
            catch (WvcmException wvcmException) {
                f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_UPDATE_TASK_LIST"), new Object[]{tgtAct.location()}));
            }
        }
    }

    private static String formatComment(Feedback f, String comment, String taskName, String taskId) {
        String result = null;
        result = comment == null ? (taskId == null ? f.format(Messages.getString("InteropStream.MSG_SYNCHRONIZED_TASK_FIRST_TASK_NAME_PREFIX"), new Object[]{taskName}) : f.format(Messages.getString("InteropStream.MSG_SYNCHRONIZED_TASK_FIRST_TASK_ID_NAME_PREFIX"), new Object[]{taskId, taskName})) : (taskId == null ? f.format(Messages.getString("InteropStream.MSG_SYNCHRONIZED_TASK_NAME_PREFIX"), new Object[]{comment, taskName}) : f.format(Messages.getString("InteropStream.MSG_SYNCHRONIZED_TASK_ID_NAME_PREFIX"), new Object[]{comment, taskId, taskName}));
        return result;
    }

    private static void computeNewVersionList(ResourceList<Version> changes, ResourceList<Task> newTasks, ResourceList.ResponseIterator<VersionSet.CompareReport> compares) throws WvcmException {
        while (compares.hasNext()) {
            VersionSet.CompareReport change = (VersionSet.CompareReport)compares.next();
            if (change instanceof VersionSet.AddedVersion) {
                changes.add((Object)((VersionSet.AddedVersion)change).getVersion());
                continue;
            }
            if (change instanceof VersionSet.ChangedVersion) {
                changes.add((Object)((VersionSet.ChangedVersion)change).getNewVersion());
                continue;
            }
            if (change instanceof VersionSet.AddedActivity) {
                newTasks.addAll((Collection)((VersionSet.AddedActivity)change).getActivity().getTaskList());
                continue;
            }
            if (change instanceof VersionSet.PartiallyAddedActivity) {
                newTasks.addAll((Collection)((VersionSet.PartiallyAddedActivity)change).getActivity().getTaskList());
                continue;
            }
            if (!(change instanceof VersionSet.ChangedActivity)) continue;
            newTasks.addAll((Collection)((VersionSet.ChangedActivity)change).getActivity().getTaskList());
        }
    }

    private static void createFile(ControllableResource tgtCR, Version srcVersion, Feedback f) throws WvcmException {
        String bn = tgtCR.location().lastSegment();
        f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_FILE"), new Object[]{bn}));
        InteropStream.copyVersionToCR(tgtCR, srcVersion, true, f.nest(100));
        InteropStream.incrementSyncStat(SyncStatType.FILES_CREATED, (Resource)tgtCR, 1);
    }

    private static void createFiles(Workspace tgtWorkspace, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        int n = tgtCr2srcVer.size();
        if (n == 0) {
            return;
        }
        Provider tgtP = tgtWorkspace.provider();
        Provider srcP = null;
        ResourceList tgtCRs = tgtP.resourceList((Resource[])new ControllableResource[0]);
        int i = 1;
        for (ControllableResource tgtCR : tgtCr2srcVer.keySet()) {
            Version srcVersion = tgtCr2srcVer.get(tgtCR);
            if (srcP == null) {
                srcP = srcVersion.provider();
            }
            InteropStream.createFile(tgtCR, srcVersion, f.nest(70 * (i + 1) / n));
            tgtCRs.add((Object)tgtCR);
            ++i;
        }
        tgtWorkspace.doVersionControl(tgtCRs, f.nest(80));
        ResourceList.ResponseIterator tgtCRIter = tgtCRs.doReadProperties(f.nest(PR_VH_CLONE, 90));
        boolean tgtHasCloneInfo = InteropStream.hasCloneInfo(tgtP.initArgs());
        ResourceList vHs = tgtHasCloneInfo ? tgtP.resourceList((Resource[])new VersionHistory[0]) : srcP.resourceList((Resource[])new VersionHistory[0]);
        for (Version srcVer : tgtCr2srcVer.values()) {
            ControllableResource tgtCR = (ControllableResource)tgtCRIter.next();
            VersionHistory tgtVH = tgtCR.getVersionHistory();
            VersionHistory srcVH = srcVer.getVersionHistory();
            if (tgtHasCloneInfo) {
                InteropStream.initClone((Resource)tgtVH, (Resource)srcVH);
                vHs.add((Object)tgtVH);
                continue;
            }
            InteropStream.initClone((Resource)srcVH, (Resource)tgtVH);
            vHs.add((Object)srcVH);
        }
        vHs.doWriteProperties(f.nest(100));
    }

    private static void sendoverChanges(Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, ResourceList<Version> srcChangedVersions, Workspace srcWorkspace, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Feedback f) throws WvcmException {
        InteropStream.incrementSyncStat(SyncStatType.CHANGES, (Resource)tgtWorkspace, srcChangedVersions.size());
        Map<VersionHistory, Version> tgtVh2srcVer = InteropStream.computeTargetVh2SrcVerMap(tgtWorkspace.workspaceProvider(), srcChangedVersions, srcWorkspace.workspaceProvider());
        HashMap<VersionHistory, FolderVersion> tgtChildRemoved = new HashMap<VersionHistory, FolderVersion>();
        ArrayList<VersionHistory> tgtProcessed = new ArrayList<VersionHistory>();
        HashMap<ControllableResource, Version> tgtCr2srcVer = new HashMap<ControllableResource, Version>();
        InteropStream.sendoverFolders(tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtChildRemoved, tgtProcessed, srcWorkspace, isTree, srcVh2srcVer, tgtCr2srcVer, f.nest(30));
        InteropStream.sendoverContent(tgtWorkspace, tgtRootPaths, tgtVh2srcVer, tgtProcessed, isTree, f.nest(50));
        InteropStream.createFiles(tgtWorkspace, tgtCr2srcVer, f.nest(70));
        InteropStream.removeDeletedChildren(tgtWorkspace, tgtChildRemoved, f.nest(95));
        f.notifyActive(Messages.getString("InteropStream.MSG_CHECKING_IN_CHANGES"));
        tgtWorkspace.doCheckinAll(null, null, f.nest(100));
    }

    private static Map<VersionHistory, Version> computeTargetVh2SrcVerMap(WorkspaceProvider tgtProv, ResourceList<Version> srcChangedVersions, WorkspaceProvider srcProv) throws WvcmException {
        Map<VersionHistory, Version> srcVh2srcVersion = InteropStream.computeSrvVh2srcVersionMap(srcChangedVersions);
        Set<VersionHistory> srcVersionHistories = srcVh2srcVersion.keySet();
        Map<VersionHistory, String> srcVh2ClonePath = InteropStream.lookupClonePaths(srcProv, srcVersionHistories, tgtProv);
        HashMap<VersionHistory, Version> results = new HashMap<VersionHistory, Version>(srcChangedVersions.size());
        for (VersionHistory srcVersionHistory : srcVersionHistories) {
            VersionHistory tgtVH;
            String tgtCloneVHPath = srcVh2ClonePath.get(srcVersionHistory);
            if (tgtCloneVHPath == null || InteropStream.isFakeClonePath(tgtCloneVHPath) || (tgtVH = InteropStream.lookupClone(srcVersionHistory, tgtProv, tgtCloneVHPath)) == null) continue;
            results.put(tgtVH, srcVh2srcVersion.get(srcVersionHistory));
        }
        return results;
    }

    private static void sendoverFolders(Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, Map<VersionHistory, FolderVersion> tgtChildRemoved, List<VersionHistory> tgtProcessed, Workspace srcWorkspace, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        InteropStream.forceAbortWvcmException((Provider)tgtWorkspace.workspaceProvider(), 6, f);
        ArrayList<VersionHistory> tgtNewVH = new ArrayList<VersionHistory>();
        tgtNewVH.addAll(tgtVh2srcVer.keySet());
        int n = tgtNewVH.size();
        int i = 0;
        while (!tgtNewVH.isEmpty()) {
            ArrayList<VersionHistory> tgtVHAdded = new ArrayList<VersionHistory>();
            for (VersionHistory tgtVH : tgtNewVH) {
                Version srcVersion = tgtVh2srcVer.get(tgtVH);
                if (srcVersion == null) continue;
                if (srcVersion instanceof FolderVersion && !tgtProcessed.contains(tgtVH)) {
                    FolderVersion srcFV = (FolderVersion)InteropStream.doFindVersionInWorkspace(srcWorkspace, srcVersion.getVersionHistory(), f.nest(PR_VERSION_CHILDMAP));
                    if (srcFV == null) {
                        tgtProcessed.add(tgtVH);
                    } else {
                        ControllableFolder tgtCF = (ControllableFolder)InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtVH, f.nest(PR_PATH_CR_CHILD_CLONE));
                        if (tgtCF != null && (isTree || InteropStream.isBelowRootPath((ControllableResource)tgtCF, tgtRootPaths))) {
                            InteropStream.sendoverFolder(tgtCF, tgtVH, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtVHAdded, tgtChildRemoved, tgtProcessed, (Version)srcFV, srcWorkspace, isTree, srcVh2srcVer, tgtCr2srcVer, nowork);
                        }
                    }
                }
                f.notifyPercentComplete(100 * (i + 1) / n);
            }
            tgtNewVH = tgtVHAdded;
            ++i;
        }
    }

    private static boolean isRootPath(ControllableResource cr, Set<String> rootPaths) throws WvcmException {
        String path = cr.getPathnameLocation().string();
        return rootPaths.contains(path);
    }

    private static boolean isBelowRootPath(ControllableResource cr, Set<String> rootPaths) throws WvcmException {
        String path = cr.getPathnameLocation().string();
        for (String rootPath : rootPaths) {
            if (!path.startsWith(rootPath)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAboveRootPath(ControllableResource cr, Set<String> rootPaths) throws WvcmException {
        String path = cr.getPathnameLocation().string();
        for (String rootPath : rootPaths) {
            if (!rootPath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private static void sendoverFolder(ControllableFolder tgtCF, VersionHistory tgtVH, Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, List<VersionHistory> tgtVHAdded, Map<VersionHistory, FolderVersion> tgtChildRemoved, List<VersionHistory> tgtProcessed, Version srcVersion, Workspace srcWorkspace, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        VersionHistory tgtChildVH;
        VersionHistory srcChildVH;
        if (tgtCF instanceof ControllableSymbolicLink) {
            return;
        }
        Feedback nowork = f.nest();
        WorkspaceProvider tgtProv = tgtCF.workspaceProvider();
        boolean isChildRemoved = false;
        boolean isChildAdded = false;
        FolderVersion srcFV = (FolderVersion)srcVersion;
        Map tgtCFChildMap = tgtCF.getChildMap();
        Map srcFVChildMap = srcFV.getChildMap();
        Set<String> srcFVChildNames = srcFVChildMap.keySet();
        tgtProcessed.add(tgtVH);
        int n = srcFVChildNames.size();
        int i = 0;
        HashSet<String> rebindNames = new HashSet<String>();
        for (String srcBN : srcFVChildNames) {
            Version srcVer;
            srcChildVH = (VersionHistory)srcFVChildMap.get(srcBN);
            if (!tgtCFChildMap.containsKey(srcBN)) continue;
            VersionHistory tgtWantedChildVH = InteropStream.lookupClone(srcChildVH, tgtProv);
            ControllableResource tgtChild = (ControllableResource)tgtCFChildMap.get(srcBN);
            tgtChildVH = tgtChild.getVersionHistory();
            Version tgtChildVersion = tgtChild.getCheckedIn();
            String origPath = ((Location)InteropStream.getOrReadProperty((Resource)tgtChild, ControllableResource.PATHNAME_LOCATION, nowork)).string();
            if (!InteropStream.isSame(tgtChildVH, tgtWantedChildVH, tgtChildVersion, srcChildVH, srcWorkspace, nowork)) {
                InteropStream.rebindToTmp(tgtCF, srcBN, srcFVChildNames, origPath, tgtRootPaths, nowork);
                isChildRemoved = true;
                rebindNames.add(srcBN);
            } else if (isTree && !tgtRootPaths.contains(origPath) && (srcVer = InteropStream.doFindVersionInWorkspace(srcWorkspace, srcChildVH, f.nest(PR_VERSION_CHILDMAP))) != null) {
                tgtVh2srcVer.put(tgtChildVH, srcVer);
            }
            f.notifyPercentComplete(20 * (i + 1) / n);
            ++i;
        }
        n = srcFVChildNames.size();
        i = 0;
        for (String srcBN : srcFVChildNames) {
            ControllableResource tgtChild;
            srcChildVH = (VersionHistory)srcFVChildMap.get(srcBN);
            if (rebindNames.contains(srcBN) || !tgtCFChildMap.containsKey(srcBN)) {
                isChildAdded = true;
                InteropStream.bindVersionHistory(tgtCF, srcBN, srcChildVH, srcWorkspace, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtChildRemoved, tgtProcessed, tgtVHAdded, isTree, srcVh2srcVer, tgtCr2srcVer, nowork);
            } else if (isTree && !((tgtChild = (ControllableResource)tgtCFChildMap.get(srcBN)) instanceof ControllableSymbolicLink) && tgtChild instanceof ControllableFolder) {
                ControllableFolder tgtChildCF = (ControllableFolder)tgtChild.doReadProperties(f.nest(PR_PATH_VH_CR_CHILD_CLONE));
                tgtChildVH = tgtChildCF.getVersionHistory();
                Version srcChildVer = tgtVh2srcVer.get(tgtChildVH);
                if (srcChildVer == null && (srcChildVer = InteropStream.doFindVersionInWorkspace(srcWorkspace, srcChildVH, f.nest(PR_VH_CLONE))) != null) {
                    tgtVh2srcVer.put(tgtChildVH, srcChildVer);
                }
                if (!tgtRootPaths.contains(tgtChildCF.getPathnameLocation().string())) {
                    InteropStream.sendoverFolder(tgtChildCF, tgtChildVH, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtVHAdded, tgtChildRemoved, tgtProcessed, srcChildVer, srcWorkspace, isTree, srcVh2srcVer, tgtCr2srcVer, nowork);
                }
            }
            f.notifyPercentComplete(InteropStream.LP(100, i, n, 20, 100));
            ++i;
        }
        for (String bn : tgtCFChildMap.keySet()) {
            if (srcFVChildMap.containsKey(bn)) continue;
            isChildRemoved = true;
        }
        if (isChildRemoved) {
            tgtChildRemoved.put(tgtVH, srcFV);
        }
        if (isChildRemoved || isChildAdded) {
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_UPDATING_FOLDER"), new Object[]{InteropStream.getFriendlyPathname((Resource)tgtCF, 200, nowork)}));
            InteropStream.incrementSyncStat(SyncStatType.FOLDERS_UPDATED, (Resource)tgtCF, 1);
        }
    }

    public static boolean isEquivalentLinkTarget(Location loc1, Location loc2) {
        Location parent1 = loc1.parent();
        Location parent2 = loc2.parent();
        if (parent1 == null || parent2 == null) {
            return parent1 == parent2;
        }
        if (!loc1.lastSegment().equals(loc2.lastSegment())) {
            return false;
        }
        return InteropStream.isEquivalentLinkTarget(parent1, parent2);
    }

    private static boolean isSame(VersionHistory curVH, VersionHistory cloneVH, Version curVersion, VersionHistory srcVH, Workspace srcWs, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        if (cloneVH != null) {
            return curVH.equals(cloneVH);
        }
        if (!(curVersion instanceof SymbolicLinkVersion)) {
            return false;
        }
        ControllableResource srcCR = InteropStream.doFindCRInWorkspace(srcWs, srcVH, f.nest(PR_CI_LINK_TARGET, 100));
        Version srcVersion = null;
        srcVersion = srcCR == null ? (Version)InteropStream.doReadProperty((Resource)srcVH, VersionHistory.ROOT_VERSION, nowork) : srcCR.getCheckedIn();
        if (!(srcVersion instanceof SymbolicLinkVersion)) {
            return false;
        }
        Location target1 = (Location)InteropStream.doReadProperty((Resource)curVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
        Location target2 = (Location)InteropStream.doReadProperty((Resource)srcVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
        return InteropStream.isEquivalentLinkTarget(target1, target2);
    }

    private static void removeDeletedChildren(Workspace tgtWorkspace, Map<VersionHistory, FolderVersion> tgtChildRemoved, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        boolean isFirstUnbind = true;
        int n = tgtChildRemoved.size();
        int i = 0;
        for (VersionHistory tgtVH : tgtChildRemoved.keySet()) {
            ControllableFolder tgtCF = (ControllableFolder)InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtVH, f.nest(PR_CHILDMAP));
            if (tgtCF != null) {
                FolderVersion srcFV = tgtChildRemoved.get(tgtVH);
                Map tgtCFChildMap = tgtCF.getChildMap();
                Map srcFVChildMap = srcFV.getChildMap();
                for (String bn : tgtCFChildMap.keySet()) {
                    if (srcFVChildMap.containsKey(bn)) continue;
                    if (isFirstUnbind) {
                        tgtWorkspace.doCheckinAll(null, null, null);
                        isFirstUnbind = false;
                    }
                    f.notifyActive(f.format(Messages.getString("InteropStream.MSG_DELETING"), new Object[]{bn}));
                    tgtCF.doUnbindChild(bn, nowork);
                }
            }
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
        }
    }

    private static void sendoverContent(Workspace tgtWorkspace, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, List<VersionHistory> tgtProcessed, boolean isTree, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Set<VersionHistory> tgtVhs = tgtVh2srcVer.keySet();
        Map<VersionHistory, ControllableResource> tgtVhs2Crs = InteropStream.doFindCRsInWorkspace(tgtWorkspace, tgtVhs, f.nest(PR_PATH, 10));
        int n = tgtVh2srcVer.size();
        int i = 0;
        for (VersionHistory tgtVH : tgtVhs) {
            Version srcVersion = tgtVh2srcVer.get(tgtVH);
            ControllableResource tgtCR = tgtVhs2Crs.get(tgtVH);
            if (tgtCR == null || tgtProcessed.contains(tgtVH) || srcVersion instanceof FolderVersion || srcVersion instanceof SymbolicLinkVersion || !isTree && !InteropStream.isBelowRootPath(tgtCR, tgtRootPaths)) continue;
            tgtProcessed.add(tgtVH);
            String name = InteropStream.getFriendlyPathname((Resource)tgtCR, 200, f);
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_UPDATING"), new Object[]{name}));
            InteropStream.copyVersionToCR(tgtCR, srcVersion, false, nowork);
            f.notifyPercentComplete(InteropStream.LP(100, i, n, 10, 100));
            InteropStream.incrementSyncStat(SyncStatType.FILES_UPDATED, (Resource)tgtCR, 1);
            ++i;
        }
    }

    private static <T> T getProperty(Resource r, PropertyNameList.PropertyName<T> pName) throws WvcmException {
        Object value = r.lookupProperty(pName);
        if (value instanceof WvcmException) {
            WvcmException e = (WvcmException)((Object)value);
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.PROPERTY_NOT_DEFINED_FOR_RESOURCE) || e.getReasonCode().equals((Object)WvcmException.ReasonCode.PROPERTY_NOT_SUPPORTED_BY_SERVER)) {
                return null;
            }
            throw e;
        }
        Object result = value;
        return (T)result;
    }

    private static <T> T tryGetProperty(Resource r, PropertyNameList.PropertyName<T> pName) throws WvcmException {
        Object value = r.lookupProperty(pName);
        if (value instanceof WvcmException) {
            return null;
        }
        Object result = value;
        return (T)result;
    }

    private static void bindVersionHistory(ControllableFolder tgtParentCF, String bn, VersionHistory srcVH, Workspace srcWorkspace, Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, Map<VersionHistory, FolderVersion> tgtChildRemoved, List<VersionHistory> tgtProcessed, List<VersionHistory> tgtVHAdded, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider tgtProv = tgtParentCF.workspaceProvider();
        Version tgtPredecessor = null;
        Version srcVersion = srcVh2srcVer != null ? srcVh2srcVer.get(srcVH) : InteropStream.doFindVersionInWorkspace(srcWorkspace, srcVH, f.nest(PR_VERSION_CHILDMAP, 5));
        if (srcVersion == null) {
            throw new RuntimeException("Could not find source version in source workspace");
        }
        VersionHistory tgtVH = InteropStream.lookupClone(srcVH, tgtProv);
        if (tgtVH != null) {
            ControllableResource tgtOrigCR = InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtVH, f.nest(PR_PATH, 10));
            if (tgtOrigCR != null) {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_MOVING"), new Object[]{bn}));
                boolean tgtOrigIsRoot = InteropStream.isRootPath(tgtOrigCR, tgtRootPaths);
                boolean tgtOrigIsBelowRoot = InteropStream.isBelowRootPath(tgtOrigCR, tgtRootPaths);
                InteropStream.rebindFixup(tgtParentCF, bn, tgtOrigCR, tgtRootPaths, f.nest(15));
                if (isTree && !tgtOrigIsRoot || !tgtOrigIsBelowRoot) {
                    if (tgtOrigCR instanceof ControllableSymbolicLink) {
                        throw new RuntimeException("Symbolic link should not be marked as a clone: " + tgtOrigCR.location());
                    }
                    if (tgtOrigCR instanceof ControllableFolder) {
                        ControllableFolder tgtCF = tgtProv.controllableFolder(tgtParentCF.location().child(bn));
                        tgtCF = (ControllableFolder)tgtCF.doReadProperties(f.nest(PR_PATH_CR_CHILD_CLONE));
                        InteropStream.sendoverFolder(tgtCF, tgtVH, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtVHAdded, tgtChildRemoved, tgtProcessed, srcVersion, srcWorkspace, true, srcVh2srcVer, tgtCr2srcVer, f.nest(100));
                    } else {
                        ControllableResource tgtCR = tgtProv.controllableResource(tgtParentCF.location().child(bn));
                        f.notifyActive(f.format(Messages.getString("InteropStream.MSG_UPDATING"), new Object[]{bn}));
                        tgtProcessed.add(tgtVH);
                        InteropStream.copyVersionToCR(tgtCR, srcVersion, true, f.nest(100));
                        InteropStream.incrementSyncStat(SyncStatType.FILES_UPDATED, (Resource)tgtCR, 1);
                    }
                }
                return;
            }
            tgtPredecessor = (Version)InteropStream.doReadProperty((Resource)tgtVH, VersionHistory.ROOT_VERSION, f.nest(20));
        }
        if (srcVersion instanceof FolderVersion) {
            FolderVersion srcFolderVersion = (FolderVersion)srcVersion;
            ControllableFolder tgtCF = tgtProv.controllableFolder(tgtParentCF.location().child(bn));
            InteropStream.incrementSyncStat(SyncStatType.FOLDERS_CREATED, (Resource)tgtCF, 1);
            if (tgtPredecessor == null) {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_FOLDER"), new Object[]{bn}));
                tgtCF.doCreateResource(nowork);
                tgtCF = (ControllableFolder)tgtCF.doVersionControl(f.nest(PR_VH_CLONE));
                tgtVH = tgtCF.getVersionHistory();
                InteropStream.linkClones((Resource)srcVH, (Resource)tgtVH, nowork);
            } else {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RESTORING_FOLDER"), new Object[]{bn}));
                tgtCF = (ControllableFolder)tgtCF.doCreateVersionControlledResource(tgtPredecessor, f.nest(PR_CHILDMAP));
                for (String childName : tgtCF.getChildMap().keySet()) {
                    tgtCF.doUnbindChild(childName, nowork);
                }
            }
            f.notifyPercentComplete(50);
            Map srcFVChildMap = srcFolderVersion.getChildMap();
            int n = srcFVChildMap.keySet().size();
            int i = 0;
            for (String childName : srcFVChildMap.keySet()) {
                InteropStream.bindVersionHistory(tgtCF, childName, (VersionHistory)srcFVChildMap.get(childName), srcWorkspace, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtChildRemoved, tgtProcessed, tgtVHAdded, isTree, srcVh2srcVer, tgtCr2srcVer, f.nest(InteropStream.LP(100, i, n, 50, 100)));
                ++i;
            }
        } else if (srcVersion instanceof SymbolicLinkVersion) {
            ControllableSymbolicLink tgtCSL = tgtProv.controllableSymbolicLink(tgtParentCF.location().child(bn));
            InteropStream.incrementSyncStat(SyncStatType.SYMLINKS_CREATED, (Resource)tgtCSL, 1);
            Location linkTarget = (Location)InteropStream.doReadProperty((Resource)srcVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
            tgtCSL.setLinkTarget(linkTarget);
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_SYMLINK"), new Object[]{bn}));
            tgtCSL.doCreateResource(nowork);
            tgtCSL.doVersionControl(nowork);
            f.notifyPercentComplete(100);
        } else {
            ControllableResource tgtCR = tgtProv.controllableResource(tgtParentCF.location().child(bn));
            if (tgtPredecessor == null) {
                if (isTree) {
                    tgtCr2srcVer.put(tgtCR, srcVersion);
                } else {
                    InteropStream.createFile(tgtCR, srcVersion, f.nest(90));
                    tgtCR = tgtCR.doVersionControl(f.nest(PR_VH_CLONE, 95));
                    tgtVH = tgtCR.getVersionHistory();
                    InteropStream.linkClones((Resource)srcVH, (Resource)tgtVH, f.nest(100));
                }
            } else {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RESTORING_FILE"), new Object[]{bn}));
                tgtCR.doCreateVersionControlledResource(tgtPredecessor, f.nest(50));
                InteropStream.incrementSyncStat(SyncStatType.FILES_CREATED, (Resource)tgtCR, 1);
                InteropStream.copyVersionToCR(tgtCR, srcVersion, true, f.nest(100));
            }
        }
    }

    private static void rebindFixup(ControllableFolder parent, String bn, ControllableResource newChild, Set<String> rootPaths, Feedback f) throws WvcmException {
        parent.doRebindAll(bn, (Resource)newChild, null, f.nest(100));
        if (!InteropStream.isAboveRootPath(newChild, rootPaths)) {
            return;
        }
        String oldPath = newChild.getPathnameLocation().string();
        Location parentLoc = (Location)InteropStream.doReadProperty((Resource)parent, ControllableFolder.PATHNAME_LOCATION, f.nest());
        String newPath = parentLoc.child(bn).string();
        HashSet<String> removedPaths = new HashSet<String>();
        HashSet<String> addedPaths = new HashSet<String>();
        for (String rootPath : rootPaths) {
            if (!rootPath.startsWith(oldPath)) continue;
            removedPaths.add(rootPath);
            addedPaths.add(String.valueOf(newPath) + rootPath.substring(oldPath.length()));
        }
        rootPaths.removeAll(removedPaths);
        rootPaths.addAll(addedPaths);
    }

    public static Version doFindVersionInWorkspace(Workspace workspace, VersionHistory vh, Feedback f) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        Version vQuery = p.version(p.rootLocation());
        VersionHistory vhQuery = p.versionHistory(p.rootLocation());
        vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
        Workspace wsQuery = p.workspace(p.rootLocation());
        wsQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
        ResourceList wsQueryList = p.resourceList((Resource[])new Workspace[0]);
        wsQueryList.add((Object)wsQuery);
        vQuery.setProperty(Version.VERSION_HISTORY, (Object)vhQuery);
        vQuery.setProperty(Version.IN_WORKSPACE_LIST, (Object)wsQueryList);
        return (Version)vQuery.doFind(f);
    }

    public static ControllableResource doFindCRInWorkspace(Workspace workspace, VersionHistory vh, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        ControllableResource crQuery = p.controllableResource(p.rootLocation());
        VersionHistory vhQuery = p.versionHistory(p.rootLocation());
        vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
        Workspace workspaceQuery = p.workspace(p.rootLocation());
        workspaceQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
        crQuery.setProperty(ControllableResource.VERSION_HISTORY, (Object)vhQuery);
        crQuery.setProperty(ControllableResource.WORKSPACE, (Object)workspaceQuery);
        return (ControllableResource)crQuery.doFind(feedback);
    }

    public static Map<VersionHistory, ControllableResource> doFindCRsInWorkspace(Workspace workspace, Collection<VersionHistory> tgtVhs, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        ResourceList queries = p.resourceList((Resource[])new ControllableResource[0]);
        for (VersionHistory vh : tgtVhs) {
            ControllableResource crQuery = p.controllableResource(p.rootLocation());
            VersionHistory vhQuery = p.versionHistory(p.rootLocation());
            vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
            Workspace workspaceQuery = p.workspace(p.rootLocation());
            workspaceQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
            crQuery.setProperty(ControllableResource.VERSION_HISTORY, (Object)vhQuery);
            crQuery.setProperty(ControllableResource.WORKSPACE, (Object)workspaceQuery);
            queries.add((Object)crQuery);
        }
        HashMap<VersionHistory, ControllableResource> results = new HashMap<VersionHistory, ControllableResource>(tgtVhs.size());
        ResourceList.ResponseIterator findings = queries.doFind(feedback);
        for (VersionHistory vh : tgtVhs) {
            Object result = findings.next();
            if (result instanceof WvcmException) {
                throw (WvcmException)((Object)result);
            }
            results.put(vh, (ControllableResource)result);
        }
        return results;
    }

    public static Component doFindComponent(WorkspaceProvider p, String componentName, Feedback f) throws WvcmException {
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.DISPLAY_NAME, (Object)componentName);
        return (Component)compQuery.doFind(f);
    }

    public static Configuration doFindConfigurationInWorkspace(Workspace workspace, Component comp, Feedback f) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        Configuration configQuery = p.configuration(p.rootLocation());
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)comp.location());
        Workspace workspaceQuery = p.workspace(p.rootLocation());
        workspaceQuery.setProperty(Workspace.PATHNAME_LOCATION, (Object)workspace.location());
        configQuery.setProperty(Configuration.VERSION_HISTORY, (Object)compQuery);
        configQuery.setProperty(Configuration.WORKSPACE, (Object)workspaceQuery);
        return (Configuration)configQuery.doFind(f);
    }

    public static List<Baseline> doFindAllBaselinesInStreamInComponent(Stream stream, Component comp, Feedback f) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Baseline baselinesQuery = p.baseline(p.rootLocation());
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)comp.location());
        Stream streamQuery = p.stream(p.rootLocation());
        streamQuery.setProperty(Workspace.PATHNAME_LOCATION, (Object)stream.location());
        baselinesQuery.setProperty(Baseline.VERSION_HISTORY, (Object)compQuery);
        baselinesQuery.setProperty(Baseline.ACTIVITY, (Object)streamQuery);
        ResourceList.ResponseIterator baselines = baselinesQuery.doFindAll(f);
        ArrayList<Baseline> result = new ArrayList<Baseline>();
        while (baselines.hasNext()) {
            result.add((Baseline)baselines.next());
        }
        return result;
    }

    public static void copyVersionToCR(ControllableResource tgtCR, Version srcVersion, boolean isNew, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        if (tgtCR instanceof ControllableSymbolicLink) {
            throw new RuntimeException("Cannot copy content for symbolic link: " + tgtCR.location());
        }
        PipedInputStream pins = new PipedInputStream();
        PipedOutputStream pouts = InteropStream.createPipedOutputStream(tgtCR, pins);
        ChildException childEx = new ChildException();
        WorkspaceProvider tgtP = tgtCR.workspaceProvider();
        Resource accept = null;
        String tgtDefaultLSVal = (String)tgtP.initArgs().get(IA_WORKSPACE_LINE_SEPARATOR);
        if (tgtDefaultLSVal != null) {
            accept = tgtP.resource(tgtCR.location());
            accept.setProperty(PN_LINE_SEPARATOR, (Object)tgtDefaultLSVal);
        }
        ContentReader reader = new ContentReader((Resource)srcVersion, pouts, accept, childEx, nowork);
        if (isNew) {
            InteropStream.initializeContentProperties(tgtCR, srcVersion);
        }
        try {
            InteropStream.forceAbortWvcmException(tgtCR.provider(), 27, f);
            tgtCR.doWriteContent((InputStream)pins, null, f.nest(100));
        }
        catch (WvcmException wvcmException) {
            InteropStream.closePipedInputStream(tgtCR, pins);
            reader.interrupt();
            pins = new PipedInputStream();
            pouts = InteropStream.createPipedOutputStream(tgtCR, pins);
            childEx = new ChildException();
            new ContentReader((Resource)srcVersion, pouts, null, childEx, nowork);
            InteropStream.setBinaryContentProperties(tgtCR);
            tgtCR.doWriteContent((InputStream)pins, null, f.nest(100));
            f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_BROUGHT_OVER_AS_BINARY"), new Object[]{InteropStream.doReadProperty((Resource)srcVersion, Resource.DISPLAY_NAME, nowork)}));
        }
        InteropStream.closePipedInputStream(tgtCR, pins);
        if (childEx.ex != null) {
            if (childEx.ex instanceof WvcmException) {
                throw (WvcmException)childEx.ex;
            }
            throw new WvcmException(Messages.getString("InteropStream.ERROR_CONTENT_READER_DIED"), (Resource)tgtCR, WvcmException.ReasonCode.CONFLICT, childEx.ex);
        }
    }

    private static void closePipedInputStream(ControllableResource tgtCR, PipedInputStream pins) throws WvcmException {
        try {
            if (InteropStream.shouldForceException(tgtCR.provider(), 10)) {
                throw new IOException("Abort");
            }
            pins.close();
        }
        catch (IOException e) {
            throw new WvcmException("Could not close pipe", (Resource)tgtCR, WvcmException.ReasonCode.WRITE_FAILED, (Throwable)e);
        }
    }

    private static PipedOutputStream createPipedOutputStream(ControllableResource tgtCR, PipedInputStream pins) throws WvcmException {
        PipedOutputStream pouts;
        try {
            if (InteropStream.shouldForceException(tgtCR.provider(), 9)) {
                throw new IOException("Abort");
            }
            pouts = new PipedOutputStream(pins);
        }
        catch (IOException e) {
            throw new WvcmException("Could not open pipe", (Resource)tgtCR, WvcmException.ReasonCode.WRITE_FAILED, (Throwable)e);
        }
        return pouts;
    }

    private static boolean isTextContentType(String contentType) {
        return contentType.trim().toLowerCase().startsWith("text");
    }

    private static void initializeContentProperties(ControllableResource tgtCR, Version srcVersion) throws WvcmException {
        Version srcV = srcVersion;
        if (srcV.lookupProperty(Resource.CONTENT_TYPE) instanceof WvcmException) {
            srcV = (Version)srcVersion.doReadProperties((Feedback)PR_NEW_CONTENT_CHARACTERISTICS);
        }
        tgtCR.setContentType(srcV.getContentType());
        if (InteropStream.isTextContentType(srcV.getContentType())) {
            InteropStream.setIfNotNull((Resource)tgtCR, (Resource)srcV, PN_LINE_SEPARATOR);
            InteropStream.setIfNotNull((Resource)tgtCR, (Resource)srcV, Resource.CONTENT_CHARACTER_SET);
        } else {
            tgtCR.setProperty(PN_LINE_SEPARATOR, (Object)LineSeparator.UNSPECIFIED.name());
        }
        InteropStream.setIfNotNull((Resource)tgtCR, (Resource)srcV, Resource.IS_EXECUTABLE);
    }

    private static void setBinaryContentProperties(ControllableResource tgtCR) {
        tgtCR.setProperty(Resource.CONTENT_TYPE, (Object)"application/unknown");
        tgtCR.setContentCharacterSet(null);
        tgtCR.setProperty(PN_LINE_SEPARATOR, (Object)LineSeparator.UNSPECIFIED.name());
    }

    private static <T> void setIfNotNull(Resource target, Resource source, PropertyNameList.PropertyName<T> propertyName) throws WvcmException {
        Object obj = source.lookupProperty(propertyName);
        if (obj == null) {
            return;
        }
        if (obj instanceof WvcmException) {
            throw (WvcmException)((Object)obj);
        }
        Object value = obj;
        target.setProperty(propertyName, value);
    }

    public static void linkClones(Resource thisResource, Resource otherResource, Feedback f) throws WvcmException {
        if (InteropStream.hasCloneInfo(thisResource.provider().initArgs())) {
            InteropStream.initClone(thisResource, otherResource);
            thisResource.doWriteProperties(f.nest(100));
        } else if (InteropStream.hasCloneInfo(otherResource.provider().initArgs())) {
            InteropStream.initClone(otherResource, thisResource);
            otherResource.doWriteProperties(f.nest(100));
        } else {
            throw new WvcmException("Neither provider is storing clone information", thisResource, WvcmException.ReasonCode.FORBIDDEN);
        }
    }

    private static void initClone(Resource thisResource, Resource otherResource) throws WvcmException {
        if (InteropStream.getProperty(thisResource, PN_CLONE) != null) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_ALREADY_HAS_CLONE"), thisResource, WvcmException.ReasonCode.CONFLICT);
        }
        thisResource.initProperty(PN_CLONE, (Object)otherResource.getResourceIdentifier());
        InteropStream.incrementSyncStat(SyncStatType.CLONES, thisResource, 1);
    }

    public static <T extends Resource> T lookupClone(T thisResource, WorkspaceProvider otherP) throws WvcmException {
        String path = InteropStream.lookupClonePath(thisResource, otherP);
        return InteropStream.lookupClone(thisResource, otherP, path);
    }

    public static <T extends Resource> T lookupClone(T thisResource, WorkspaceProvider otherP, String path) throws WvcmException {
        if (path == null) {
            return null;
        }
        Class<?> type = thisResource.getClass();
        return (T)otherP.buildProxy(type, otherP.location(path));
    }

    private static <T extends Resource> String lookupClonePath(T thisResource, WorkspaceProvider otherProvider) throws WvcmException {
        if (InteropStream.hasCloneInfo(thisResource.provider().initArgs())) {
            return InteropStream.getProperty(thisResource, PN_CLONE);
        }
        if (!InteropStream.hasCloneInfo(otherProvider.initArgs())) {
            throw new WvcmException("Neither provider is storing clone information", thisResource, WvcmException.ReasonCode.FORBIDDEN);
        }
        Class<?> type = thisResource.getClass();
        Resource otherResourceQuery = otherProvider.buildProxy(type, otherProvider.rootLocation());
        otherResourceQuery.setProperty(PN_CLONE, (Object)thisResource.getResourceIdentifier());
        Resource otherResource = otherResourceQuery.doFind(null);
        if (otherResource == null) {
            return null;
        }
        return otherResource.getResourceIdentifier();
    }

    private static Map<VersionHistory, String> lookupClonePaths(WorkspaceProvider srcProv, Set<VersionHistory> srcVersionHistories, WorkspaceProvider tgtProv) throws WvcmException {
        HashMap<VersionHistory, String> results = new HashMap<VersionHistory, String>(srcVersionHistories.size());
        if (InteropStream.hasCloneInfo(srcProv.initArgs())) {
            for (VersionHistory versionHistory : srcVersionHistories) {
                results.put(versionHistory, InteropStream.getProperty((Resource)versionHistory, PN_CLONE));
            }
            return results;
        }
        if (!InteropStream.hasCloneInfo(tgtProv.initArgs())) {
            throw new WvcmException("Neither provider is storing clone information", null, WvcmException.ReasonCode.FORBIDDEN);
        }
        ResourceList queries = tgtProv.resourceList((Resource[])new VersionHistory[0]);
        for (VersionHistory srcVh : srcVersionHistories) {
            VersionHistory queryElement = tgtProv.versionHistory(tgtProv.rootLocation());
            queryElement.setProperty(PN_CLONE, (Object)srcVh.getResourceIdentifier());
            queries.add((Object)queryElement);
        }
        ResourceList.ResponseIterator clones = queries.doFind(null);
        for (VersionHistory srcVh : srcVersionHistories) {
            VersionHistory clone = (VersionHistory)clones.next();
            String value = clone != null ? clone.getResourceIdentifier() : null;
            results.put(srcVh, value);
        }
        return results;
    }

    public static <T extends Resource> ResourceList<T> makeList(T r) throws WvcmException {
        ResourceList resourceList = r.provider().resourceList(new Resource[]{r});
        return resourceList;
    }

    private static String rebindToTmp(ControllableFolder sourceFolder, String bindingName, Collection<String> reservedNames, String origPath, Set<String> rootPaths, Feedback f) throws WvcmException {
        int i = 0;
        while (true) {
            try {
                String newName;
                do {
                    if (InteropStream.shouldForceException(sourceFolder.provider(), 12)) {
                        i = 101;
                        throw new WvcmException("Abort", WvcmException.ReasonCode.ABORTED);
                    }
                    newName = f.format(CONCAT_NAME, new Object[]{bindingName, String.valueOf(++i)});
                } while (reservedNames != null && reservedNames.contains(newName));
                WorkspaceProvider p = sourceFolder.workspaceProvider();
                Location newChildLoc = sourceFolder.location().child(bindingName);
                ControllableResource newChild = p.controllableResource(newChildLoc);
                newChild = (ControllableResource)newChild.doReadProperties(f.nest(PR_PATH));
                InteropStream.rebindFixup(sourceFolder, newName, newChild, rootPaths, f.nest(100));
                return newName;
            }
            catch (WvcmException e) {
                if (i <= 100) continue;
                throw e;
            }
            break;
        }
    }

    private void createOtherBaselinesForRoots(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace otherSyncWs = this.otherSyncWs();
        Stream otherSyncStream = this.otherSyncStream();
        ResourceList<Component> oldComponents = this.readSentoverComponentsWithNames(f.nest());
        int n = oldComponents.size();
        int i = 0;
        for (Component comp : oldComponents) {
            Configuration conf = InteropStream.doFindConfigurationInWorkspace(otherSyncWs, comp, nowork);
            String compName = comp.getDisplayName();
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_BASELINING_COMPONENT"), new Object[]{compName}));
            conf.doCheckout(null, nowork);
            conf.doCheckin(null, nowork);
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
        }
        InteropStream.updateStreamWithWorkspace(otherSyncStream, otherSyncWs, nowork);
    }

    private void setOtherSentover(Feedback f) throws WvcmException {
        if (this.otherSegment().numSyncRoots() == 0) {
            return;
        }
        Feedback nowork = f.nest();
        ResourceList<Component> oldComponents = this.readSentoverComponents(nowork);
        int n = oldComponents.size();
        if (n > 0 && InteropStream.shouldForceException((Provider)this.otherProvider(), 13)) {
            n = 0;
        }
        if (n == 0) {
            throw new WvcmException("No baselines found", WvcmException.ReasonCode.CONFLICT);
        }
        String[] baselineNames = new String[n];
        Feedback f_PR_VH_NAME = f.nest(PR_VH_NAME);
        Feedback f_PR_CI = f.nest(PR_CI);
        int i = 0;
        for (VersionHistory comp : oldComponents) {
            Configuration conf = InteropStream.doFindConfigurationInWorkspace(this.otherSyncWs(), (Component)comp, f_PR_VH_NAME);
            String compName = conf.getVersionHistory().getDisplayName();
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_BASELINING_COMPONENT"), new Object[]{compName}));
            conf.doCheckout(null, nowork);
            conf = (Configuration)conf.doCheckin(null, f_PR_CI);
            baselineNames[i] = conf.getCheckedIn().getResourceIdentifier();
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
        }
        this.otherSegment().set_sentoverBaselinePaths(baselineNames);
    }

    private void setOtherSentover(boolean isImport, Set<Configuration> otherConfigurations, Feedback f) throws WvcmException {
        int n = otherConfigurations.size();
        if (n == 0) {
            return;
        }
        HashMap<VersionHistory, Object> components = new HashMap<VersionHistory, Object>();
        ResourceList<Baseline> oldBaselines = this.getSentoverBaselines();
        ResourceList<Component> oldComponents = this.readSentoverComponents(f.nest());
        int i = 0;
        while (i < oldComponents.size()) {
            components.put((VersionHistory)oldComponents.get(i), (Version)oldBaselines.get(i));
            ++i;
        }
        HashSet<VersionHistory> newComponents = new HashSet<VersionHistory>();
        int i2 = 0;
        for (Configuration configuration : otherConfigurations) {
            VersionHistory vh = configuration.getVersionHistory();
            if (!newComponents.contains(vh)) {
                newComponents.add(vh);
                if (!isImport || !components.keySet().contains(vh)) {
                    Feedback nFB = f.nest(PR_CI, 100 * (i2 + 1) / n);
                    if (this.isImportOnly()) {
                        configuration = (Configuration)configuration.doReadProperties(nFB);
                    } else {
                        configuration.doCheckout(null, null);
                        configuration = (Configuration)configuration.doCheckin(null, nFB);
                    }
                    WorkspaceProvider otherP = configuration.workspaceProvider();
                    Baseline b = otherP.baseline(otherP.location(configuration.getCheckedIn().getResourceIdentifier()));
                    components.put(vh, b);
                }
            }
            ++i2;
        }
        String[] baselineNames = new String[components.keySet().size()];
        i2 = 0;
        for (VersionHistory component : components.keySet()) {
            baselineNames[i2] = ((Version)components.get(component)).location().string();
            ++i2;
        }
        this.otherSegment().set_sentoverBaselinePaths(baselineNames);
    }

    private static void setHasCloneInfo(Map<String, String> initArgs, boolean hasCloneInfo) {
        if (hasCloneInfo) {
            initArgs.put(IA_HAS_CLONE_INFO, TRUE_STRING);
        } else {
            initArgs.remove(IA_HAS_CLONE_INFO);
        }
    }

    public static boolean hasCloneInfo(Map<String, String> initArgs) {
        return initArgs.containsKey(IA_HAS_CLONE_INFO);
    }

    private static void sendoverTree(ControllableResource tgtCR, Stream tgtStream, Set<String> tgtRootPaths, ControllableResource srcCR, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider otherP = srcCR.workspaceProvider();
        Workspace tgtWs = tgtCR.getWorkspace();
        ResourceList srcChangedVersions = otherP.resourceList((Resource[])new Version[0]);
        String rootName = InteropStream.getFriendlyPathname((Resource)srcCR, 100, nowork);
        f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RETRIEVING_METADATA"), new Object[]{rootName}));
        ControllableResource srcRootCR = (ControllableResource)srcCR.doReadProperties(f.nest(PR_CI_VH_CLONE, 5));
        srcChangedVersions.add((Object)srcRootCR.getCheckedIn());
        Map<VersionHistory, Version> srcVh2srcVer = InteropStream.create_srcVh2srcVer(srcRootCR, tgtCR, tgtRootPaths, f.nest(30));
        InteropStream.sendoverChanges(tgtWs, tgtStream, tgtRootPaths, (ResourceList<Version>)srcChangedVersions, srcCR.getWorkspace(), true, srcVh2srcVer, f.nest(100));
    }

    private static Map<VersionHistory, Version> create_srcVh2srcVer(ControllableResource srcCR, ControllableResource tgtCR, Set<String> tgtRootPaths, Feedback f) throws WvcmException {
        HashMap<VersionHistory, Version> srcVh2srcVer = null;
        if (!(tgtCR instanceof ControllableSymbolicLink) && tgtCR instanceof ControllableFolder && !InteropStream.isAboveRootPath(tgtCR, tgtRootPaths)) {
            ControllableFolder srcCF = (ControllableFolder)srcCR;
            srcVh2srcVer = new HashMap<VersionHistory, Version>();
            ResourceList.ResponseIterator srcCrIterator = srcCF.doReadMemberList(true, f.nest(PR_CI_VH_VERSION_CHILDMAP, 100));
            while (srcCrIterator.hasNext()) {
                ControllableResource srcCr = (ControllableResource)srcCrIterator.next();
                Version srcVer = srcCr.getCheckedIn();
                srcVh2srcVer.put(srcVer.getVersionHistory(), srcVer);
            }
        }
        return srcVh2srcVer;
    }

    private static void commitChanges(ControllableResource srcRoot, Workspace tgtWs, Stream tgtStream, boolean isTree, Feedback f) throws WvcmException {
        WorkspaceProvider tgtP = tgtWs.workspaceProvider();
        Feedback nowork = f.nest();
        String rootName = InteropStream.getFriendlyPathname((Resource)srcRoot, 100, nowork);
        Activity tgtAct = (tgtWs = (Workspace)tgtWs.doReadProperties(f.nest(PR_CA_TASKS_COMMENT))).getCurrentActivity();
        if (tgtAct != null) {
            if (tgtAct.getTaskList().size() == 0) {
                String msg = isTree ? Messages.getString("InteropStream.MSG_OVERWRITE_TASKNAME") : Messages.getString("InteropStream.MSG_BRING_OVER_TASKNAME");
                String taskName = f.format(msg, new Object[]{rootName});
                try {
                    InteropStream.forceAbortWvcmException((Provider)tgtP, 14, f);
                    Task tgtTask = tgtP.task(tgtWs.location().child(Messages.getString("InteropStream.ID_SYNCHRONIZE_TASK")));
                    tgtTask.setDisplayName(taskName);
                    tgtTask = tgtTask.doCreateGeneratedResource(f.nest(PR_COMMENT));
                    tgtAct.setTaskList(InteropStream.makeList(tgtTask));
                    tgtAct.doWriteProperties(nowork);
                }
                catch (WvcmException e) {
                    f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_CREATE_TASK"), new Object[]{taskName, e.getMessage()}));
                }
            } else {
                Task tgtTask = (Task)tgtAct.getTaskList().get(0);
                if (isTree) {
                    String comment = f.format(Messages.getString("InteropStream.MSG_OVERWRITE_TASKNAME"), new Object[]{rootName});
                    String origComment = tgtTask.getComment();
                    if (origComment != null && origComment.length() > 0) {
                        comment = f.format(CONCAT_MSG, new Object[]{comment, origComment});
                    }
                    tgtTask.setComment(comment);
                    tgtTask.doWriteProperties(nowork);
                }
            }
            InteropStream.closeCurrentActivity(tgtWs, nowork);
            f.notifyPercentComplete(50);
        }
        InteropStream.updateStreamWithWorkspace(tgtStream, tgtWs, nowork);
        f.notifyPercentComplete(100);
    }

    private Workspace newInteropStreamWs(String wsName, InteropStreamSegment segment, Workspace oldWorkspace, boolean isIsolated, Stream stream, Feedback f) throws WvcmException {
        Workspace ws = InteropStream.createWorkspace(wsName, isIsolated, stream, true, f);
        if (segment.get_initArgs().get(IA_WORKSPACE_PATH) != null) {
            segment.put_initArgs(IA_WORKSPACE_PATH, ws.location().string());
        }
        try {
            oldWorkspace.doUnbindAll(f.nest());
        }
        catch (Exception exception) {}
        return ws;
    }

    private static String getVersionField(String[] fields) {
        return fields[0];
    }

    private static String getStateIdField(String[] fields) {
        return fields[5];
    }

    private static InteropStream parse(String interopStreamValue, ProviderFactory.Callback callback, Feedback f) {
        if (interopStreamValue == null) {
            return null;
        }
        String[] field = interopStreamValue.split(TERMINATOR1, -1);
        int version = Integer.parseInt(InteropStream.getVersionField(field));
        if (version > CURRENT_MAJOR_VERSION) {
            throw new RuntimeException(f.format(Messages.getString("InteropStream.ERROR_OLD_CLIENT"), new Object[]{CURRENT_MAJOR_VERSION}));
        }
        if (version < CURRENT_MAJOR_VERSION) {
            try {
                f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_UPGRADING_METADATA_VERSION"), new Object[]{String.valueOf(version), String.valueOf(CURRENT_MAJOR_VERSION)}));
            }
            catch (WvcmException wvcmException) {}
        }
        InteropStreamSegment thisSegment = new InteropStreamSegment(field[1], version, callback);
        InteropStreamSegment otherSegment = new InteropStreamSegment(field[2], version, callback);
        long lastAttemptedSyncDate = Long.parseLong(field[3]);
        long lastSyncDate = Long.parseLong(field[4]);
        long stateId = Long.parseLong(InteropStream.getStateIdField(field));
        InteropStreamOperation operation = InteropStreamOperation.valueOf(field[6]);
        String[] roots = null;
        roots = field[7].split(TERMINATOR3);
        if (roots.length == 0) {
            roots = null;
        }
        long minor_version = Long.parseLong(field[8]);
        InteropStream is = new InteropStream(thisSegment, otherSegment, minor_version, lastAttemptedSyncDate, lastSyncDate, stateId, operation, roots);
        return is;
    }

    private String unparse() {
        StringBuffer s = new StringBuffer();
        s.append(CURRENT_MAJOR_VERSION);
        s.append(TERMINATOR1);
        s.append(this._thisSegment.toString());
        s.append(TERMINATOR1);
        s.append(this._otherSegment.toString());
        s.append(TERMINATOR1);
        s.append(this._lastAttemptedSyncDate);
        s.append(TERMINATOR1);
        s.append(this._lastSyncDate);
        s.append(TERMINATOR1);
        s.append(this._stateId);
        s.append(TERMINATOR1);
        s.append((Object)this._operation);
        s.append(TERMINATOR1);
        if (this._newSyncRootPaths != null && this._newSyncRootPaths.length > 0) {
            String[] stringArray = this._newSyncRootPaths;
            int n = this._newSyncRootPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                s.append(path);
                s.append(TERMINATOR3);
                ++n2;
            }
        } else {
            s.append(TERMINATOR3);
        }
        s.append(TERMINATOR1);
        s.append(this._minorVersion);
        return s.toString();
    }

    private void internalSetSyncState(InteropStreamState state, Feedback f) throws WvcmException {
        this.set_state(state);
        this.updateISMetadata(f);
    }

    private void internalSync(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace thisCloneWs = this.thisCloneWs();
        thisCloneWs.doCheckinAll(Messages.getString("InteropStream.MSG_LEFTOVER_CHECKOUTS"), null, nowork);
        InteropStream.closeCurrentActivity(thisCloneWs, nowork);
        if (this.thisSegment().numSyncRoots() == 0) {
            thisCloneWs.doUpdate(InteropStream.makeList(this.thisSyncStream()), f.nest(20));
            InteropStream.updateStreamWithWorkspace(this.thisCloneStream(), thisCloneWs, f.nest(40));
            this.thisInternalWs().doUpdate(InteropStream.makeList(this.thisCloneStream()), f.nest(60));
            InteropStream.updateStreamWithWorkspace(this.thisInternalStream(), this.thisInternalWs(), f.nest(80));
            if (this.otherSegment().get_sentoverBaselinePaths().length > 0) {
                this.otherSegment().set_sentoverBaselinePaths(new String[0]);
            }
            this.otherSyncWs().doMerge(InteropStream.makeList(this.otherSyncStream()), MF_NO_CHECKOUTS, f.nest(100));
            return;
        }
        Workspace otherSyncWs = this.otherSyncWs();
        otherSyncWs.doCheckinAll(Messages.getString("InteropStream.MSG_LEFTOVER_CHECKOUTS"), null, nowork);
        InteropStream.closeCurrentActivity(otherSyncWs, nowork);
        otherSyncWs.doMerge(InteropStream.makeList(this.otherSyncStream()), MF_NO_CHECKOUTS, f.nest(5));
        this.createOtherBaselinesForRoots(f.nest(15));
        this.sendoverOtherBaselines(f.nest(50));
        Workspace thisInternalWs = this.thisInternalWs();
        thisInternalWs.doUpdate(InteropStream.makeList(this.thisCloneStream()), nowork);
        thisInternalWs.doMerge(InteropStream.makeList(this.thisSyncStream()), MF_NO_CHECKOUTS_UPDATE, f.nest(55));
        InteropStream.updateStreamWithWorkspace(this.thisInternalStream(), thisInternalWs, nowork);
        this.sendoverThisStream(f.nest(100));
        this.set_state(InteropStreamState.OPERATION_ACTIVE);
        this.updateISMetadata(nowork);
    }

    private static ControllableFolder getTgtBaselineControlledFolder(Workspace tgtCloneWs, Configuration srcConfig, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider tgtProvider = tgtCloneWs.workspaceProvider();
        Component srcComponent = (Component)srcConfig.getVersionHistory();
        String compName = srcComponent.getDisplayName();
        Component tgtComponent = InteropStream.lookupClone(srcComponent, tgtProvider);
        ControllableFolder tgtBCF = null;
        if (tgtComponent == null && (tgtComponent = InteropStream.doFindComponent(tgtProvider, compName, f.nest(PR_CLONE, 10))) != null) {
            InteropStream.linkClones((Resource)tgtComponent, (Resource)srcComponent, nowork);
        }
        if (tgtComponent == null) {
            ControllableFolder root = (ControllableFolder)InteropStream.doReadProperty((Resource)tgtCloneWs, Workspace.CONFIGURATION_ROOT_FOLDER_HOME, nowork);
            tgtBCF = tgtProvider.controllableFolder(root.location().child(compName));
            try {
                InteropStream.forceAbortWvcmException(tgtBCF.provider(), 16, f);
                tgtBCF = (ControllableFolder)tgtBCF.doReadProperties(f.nest(PR_CFG_RF, 50));
            }
            catch (WvcmException e) {
                if (e.getReasonCode() != WvcmException.ReasonCode.NOT_FOUND) {
                    throw e;
                }
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_COMPONENT"), new Object[]{compName}));
                tgtBCF = tgtBCF.doBaselineControl(f.nest(PR_CFG_RF, 50));
            }
            tgtComponent = (Component)tgtBCF.getConfiguration().getVersionHistory();
            InteropStream.linkClones((Resource)tgtComponent, (Resource)srcComponent, nowork);
        } else {
            Configuration tgtConfig = InteropStream.doFindConfigurationInWorkspace(tgtCloneWs, tgtComponent, f.nest(PR_RF_VH, 50));
            if (tgtConfig != null) {
                tgtBCF = tgtConfig.getRootFolder();
            } else {
                tgtComponent = (Component)tgtComponent.doReadProperties(f.nest(PR_ROOT_DN, 75));
                Baseline thisRootB = (Baseline)tgtComponent.getRootVersion();
                String tgtCompName = tgtComponent.getDisplayName();
                tgtBCF = tgtProvider.controllableFolder(tgtCloneWs.location().child(tgtCompName));
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RESTORING_COMPONENT"), new Object[]{tgtCompName}));
                tgtBCF = tgtBCF.doCreateBaselineControlledFolder(thisRootB, f.nest(PR_VH_CLONE, 100));
            }
        }
        return tgtBCF;
    }

    private static ControllableResource createCloneRoot(boolean isRoot, ControllableFolder tgtBCF, Workspace tgtWorkspace, ControllableResource srcRoot, Location srcBCFLoc, Feedback f) throws WvcmException {
        WorkspaceProvider tgtP = tgtBCF.workspaceProvider();
        WorkspaceProvider srcP = srcRoot.workspaceProvider();
        Feedback nowork = f.nest();
        String lastSegment = srcRoot.location().lastSegment();
        ControllableResource tgtRoot = null;
        ControllableResource srcRootWithCloneInfo = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_VH_CLONE, 25));
        VersionHistory srcRootVH = srcRootWithCloneInfo.getVersionHistory();
        String tgtCloneVHPath = InteropStream.lookupClonePath(srcRootVH, tgtP);
        if (InteropStream.isFakeClonePath(tgtCloneVHPath)) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_ONLY_ONE_SYNCHRONIZED_PROJECT"), WvcmException.ReasonCode.FORBIDDEN);
        }
        VersionHistory tgtCloneVH = null;
        if (tgtCloneVHPath != null && (tgtRoot = InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtCloneVH = InteropStream.lookupClone(srcRootVH, tgtP, tgtCloneVHPath), f.nest(PR_VH_CLONE, 50))) != null) {
            return tgtRoot;
        }
        if (srcBCFLoc.equals(srcRoot.location())) {
            ResourceList children = (ResourceList)InteropStream.doReadProperty((Resource)tgtBCF, ControllableFolder.CHILD_LIST, f);
            if (isRoot && !children.isEmpty()) {
                String path = InteropStream.readFriendlyPathname((Resource)tgtBCF, 0, nowork);
                String msg = f.format(Messages.getString("InteropStream.ERROR_DEST_MUST_BE_EMPTY"), new Object[]{path});
                throw new WvcmException(msg, WvcmException.ReasonCode.CANNOT_OVERWRITE);
            }
            tgtRoot = tgtBCF;
            srcRoot = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_VH_CLONE));
            InteropStream.linkClones((Resource)tgtRoot.getVersionHistory(), (Resource)srcRoot.getVersionHistory(), nowork);
            return tgtRoot;
        }
        Location srcParentLoc = srcRoot.location().parent();
        ControllableFolder srcParent = srcP.controllableFolder(srcParentLoc);
        ControllableResource tgtParent = InteropStream.createCloneRoot(false, tgtBCF, tgtWorkspace, (ControllableResource)srcParent, srcBCFLoc, nowork);
        Location tgtRootLoc = tgtParent.location().child(lastSegment);
        if (srcRootWithCloneInfo instanceof ControllableFolder) {
            tgtRoot = tgtP.controllableFolder(tgtRootLoc);
            InteropStream.incrementSyncStat(SyncStatType.FOLDERS_CREATED, (Resource)tgtRoot, 1);
        } else {
            tgtRoot = tgtP.controllableResource(tgtRootLoc);
            InteropStream.incrementSyncStat(SyncStatType.FILES_CREATED, (Resource)tgtRoot, 1);
        }
        try {
            InteropStream.forceAbortWvcmException(tgtRoot.provider(), 17, f);
            String path = InteropStream.readFriendlyPathname((Resource)tgtRoot, 0, nowork);
            String msg = f.format(Messages.getString("InteropStream.ERROR_CLONE_TARGET_EXISTS"), new Object[]{path});
            throw new WvcmException(msg, WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        catch (WvcmException e) {
            if (!e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) {
                throw e;
            }
            if (tgtCloneVH != null) {
                Version tgtPredecessor = (Version)InteropStream.doReadProperty((Resource)tgtCloneVH, VersionHistory.ROOT_VERSION, nowork);
                String msgPrefix = isRoot ? Messages.getString("InteropStream.MSG_RESTORING_ROOT") : Messages.getString("InteropStream.MSG_RESTORING_ANCESTOR");
                f.notifyActive(f.format(msgPrefix, new Object[]{lastSegment}));
                tgtRoot = tgtRoot.doCreateVersionControlledResource(tgtPredecessor, f.nest(100));
            } else {
                tgtRoot.doCreateResource(f.nest(75));
                if (!(tgtRoot instanceof ControllableFolder)) {
                    Version srcVersion = (Version)InteropStream.doReadProperty((Resource)srcRoot, ControllableResource.CHECKED_IN, nowork);
                    InteropStream.copyVersionToCR(tgtRoot, srcVersion, true, nowork);
                }
                tgtRoot = tgtRoot.doVersionControl(f.nest(PR_VH_CLONE, 100));
                InteropStream.linkClones((Resource)tgtRoot.getVersionHistory(), (Resource)srcRootWithCloneInfo.getVersionHistory(), nowork);
            }
            return tgtRoot;
        }
    }

    private static ControllableResource createClone(Workspace tgtWorkspace, Stream tgtStream, InteropStreamSegment tgtSegment, ControllableResource srcCloneRoot, Workspace srcWorkspace, Feedback f) throws WvcmException {
        WorkspaceProvider tgtP = tgtWorkspace.workspaceProvider();
        WorkspaceProvider srcP = srcWorkspace.workspaceProvider();
        ControllableResource tgtCloneRoot = null;
        boolean isOverwrite = false;
        VersionHistory srcVH = srcCloneRoot.getVersionHistory();
        String tgtCloneVHPath = InteropStream.lookupClonePath(srcVH, tgtP);
        if (InteropStream.isFakeClonePath(tgtCloneVHPath)) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_ONLY_ONE_SYNCHRONIZED_PROJECT"), WvcmException.ReasonCode.FORBIDDEN);
        }
        VersionHistory tgtCloneVH = InteropStream.lookupClone(srcVH, tgtP, tgtCloneVHPath);
        if (tgtCloneVH != null) {
            isOverwrite = true;
            tgtCloneRoot = InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtCloneVH, f.nest(PR_CFG_WS_VH_CLONE));
        }
        if (tgtCloneRoot == null) {
            Configuration srcConfig = srcCloneRoot.getConfiguration();
            ControllableFolder tgtBCF = InteropStream.getTgtBaselineControlledFolder(tgtWorkspace, srcConfig, f.nest(PR_VH_CLONE));
            Location srcBCFPath = srcConfig.getRootFolder().getPathnameLocation();
            ControllableResource srcRoot = srcP.controllableResource(srcCloneRoot.getPathnameLocation());
            tgtCloneRoot = InteropStream.createCloneRoot(true, tgtBCF, tgtWorkspace, srcRoot, srcBCFPath, f.nest(10));
            tgtCloneRoot = (ControllableResource)tgtCloneRoot.doReadProperties(f.nest(PR_CFG_WS_VH_CLONE));
        }
        List<ControllableResource> tgtRoots = InteropStream.getSyncRoots(tgtWorkspace, tgtSegment, f.nest(PR_PATH));
        HashSet<String> tgtRootPaths = new HashSet<String>();
        for (ControllableResource tgtRoot : tgtRoots) {
            if (tgtRoot == null) continue;
            tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
        }
        InteropStream.sendoverTree(tgtCloneRoot, tgtStream, tgtRootPaths, srcCloneRoot, f.nest(90));
        InteropStream.commitChanges(srcCloneRoot, tgtWorkspace, tgtStream, isOverwrite, f.nest(100));
        return tgtCloneRoot;
    }

    private static ControllableResource findCloneRoot(ControllableResource cr, Workspace ws, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        VersionHistory vh = (VersionHistory)InteropStream.doReadProperty((Resource)cr, ControllableResource.VERSION_HISTORY, nowork);
        if (vh == null) {
            String msg = Messages.getString("InteropStream.ERROR_MUST_BE_UNDER_VERSION_CONTROL");
            String name = InteropStream.readFriendlyPathname((Resource)cr, 200, nowork);
            throw new WvcmException(f.format(msg, new Object[]{name}), (Resource)cr, WvcmException.ReasonCode.CONFLICT);
        }
        ControllableResource rootCR = InteropStream.doFindCRInWorkspace(ws, vh, f);
        if (rootCR == null) {
            Version ver = InteropStream.doFindVersionInWorkspace(ws, vh, nowork);
            String msg = ver != null && ver instanceof SymbolicLinkVersion ? Messages.getString("InteropStream.ERROR_SYMLINK_CANNOT_BE_A_ROOT") : Messages.getString("InteropStream.ERROR_ROOT_NOT_FOUND");
            String name = InteropStream.readFriendlyPathname((Resource)cr, 200, nowork);
            throw new WvcmException(f.format(msg, new Object[]{name}), (Resource)cr, WvcmException.ReasonCode.CONFLICT);
        }
        if (rootCR.getConfiguration() == null) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_ROOT_MUST_BE_IN_CONFIGURATION"), (Resource)rootCR, WvcmException.ReasonCode.CONFLICT);
        }
        return rootCR;
    }

    private void internalDeleteSyncRoots(boolean isThis, Collection<VersionHistory> deletedSyncRoots, Feedback f) throws WvcmException {
        if (deletedSyncRoots.size() == 0) {
            return;
        }
        HashSet<String> dsrPaths = new HashSet<String>(deletedSyncRoots.size());
        for (VersionHistory dvh : deletedSyncRoots) {
            dsrPaths.add(dvh.location().string());
        }
        String[] thisSyncRootPaths = this.thisSegment().get_syncRootPaths();
        String[] otherSyncRootPaths = this.otherSegment().get_syncRootPaths();
        String[] compareSyncRootPaths = isThis ? thisSyncRootPaths : otherSyncRootPaths;
        ArrayList<String> newThisSyncRootList = new ArrayList<String>();
        ArrayList<String> newOtherSyncRootList = new ArrayList<String>();
        int i = 0;
        while (i < compareSyncRootPaths.length) {
            if (!dsrPaths.contains(compareSyncRootPaths[i])) {
                newThisSyncRootList.add(thisSyncRootPaths[i]);
                newOtherSyncRootList.add(otherSyncRootPaths[i]);
            }
            ++i;
        }
        int newSize = newThisSyncRootList.size();
        String[] newThisSyncRootPaths = new String[newSize];
        String[] newOtherSyncRootPaths = new String[newSize];
        int i2 = 0;
        while (i2 < newSize) {
            newThisSyncRootPaths[i2] = (String)newThisSyncRootList.get(i2);
            newOtherSyncRootPaths[i2] = (String)newOtherSyncRootList.get(i2);
            ++i2;
        }
        this.thisSegment().set_syncRootPaths(newThisSyncRootPaths);
        this.otherSegment().set_syncRootPaths(newOtherSyncRootPaths);
        HashSet<VersionHistory> otherComponents = new HashSet<VersionHistory>();
        List<ControllableResource> otherRoots = this.otherSyncRoots(this.otherSyncWs(), f.nest(PR_CONFIG_VH, 70));
        for (ControllableResource otherRoot : otherRoots) {
            otherComponents.add(otherRoot.getConfiguration().getVersionHistory());
        }
        ArrayList<String> newBaselines = new ArrayList<String>();
        ResourceList<Baseline> oldBaselines = this.getSentoverBaselines();
        ResourceList<Component> oldComponents = this.readSentoverComponents(f.nest(100));
        int i3 = 0;
        while (i3 < oldBaselines.size()) {
            Baseline oldBaseline = (Baseline)oldBaselines.get(i3);
            Component oldComponent = (Component)oldComponents.get(i3);
            if (otherComponents.contains(oldComponent)) {
                newBaselines.add(oldBaseline.location().string());
            }
            ++i3;
        }
        String[] baselineNames = newBaselines.toArray(new String[newBaselines.size()]);
        this.otherSegment().set_sentoverBaselinePaths(baselineNames);
    }

    private void deleteAllSyncRoots() {
        this.thisSegment().set_syncRootPaths(new String[0]);
        this.otherSegment().set_syncRootPaths(new String[0]);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void internalSetCloneRoot(boolean isImport, InteropStreamSegment srcSegment, Workspace srcWorkspace, InteropStreamSegment tgtSegment, Workspace tgtWorkspace, Stream tgtStream, String[] syncRootPaths, Feedback f) throws WvcmException {
        block22: {
            nowork = f.nest();
            fcrNoWork = f.nest(InteropStream.PR_CFG_RF_WS_VH_CLONE);
            srcP = srcSegment.provider();
            n = syncRootPaths.length;
            processedSyncRootPaths = new ArrayList<String>(n);
            processedSrcRootNames = new ArrayList<String>(n);
            processedTgtRootNames = new ArrayList<String>(n);
            otherConfigurations = new HashSet<Configuration>();
            exceptions = new ArrayList<WvcmException>();
            try {
                InteropStream.forceAbortWvcmException((Provider)srcP, 18, f);
                i = 0;
                while (i < n) {
                    srcCFPath = syncRootPaths[i];
                    try {
                        InteropStream.forceAbortWvcmException((Provider)srcP, 19, f);
                        srcCR = srcP.controllableResource(srcP.location(srcCFPath));
                        srcCloneRoot = InteropStream.findCloneRoot(srcCR, srcWorkspace, fcrNoWork);
                        f.notifyPercentComplete(InteropStream.LP(4, i, n, 0, 80));
                        tgtCloneRoot = InteropStream.createClone(tgtWorkspace, tgtStream, tgtSegment, srcCloneRoot, srcWorkspace, f.nest(InteropStream.LP(100, i, n, 0, 80)));
                        processedSyncRootPaths.add(srcCFPath);
                        processedSrcRootNames.add(srcCloneRoot.getVersionHistory().location().string());
                        processedTgtRootNames.add(tgtCloneRoot.getVersionHistory().location().string());
                        if (isImport) {
                            otherConfigurations.add(srcCloneRoot.getConfiguration());
                        } else {
                            otherConfigurations.add(tgtCloneRoot.getConfiguration());
                        }
                    }
                    catch (WvcmException e) {
                        exceptions.add(e);
                    }
                    ++i;
                }
            }
            finally {
                numberProcessed = processedSrcRootNames.size();
                if (numberProcessed <= 0) break block22;
                oldSize = srcSegment.numSyncRoots();
                oldSrcRootPaths = new HashSet<String>(oldSize);
                path /* !! */  = srcSegment.get_syncRootPaths();
                errSyncRootPaths = path /* !! */ .length;
                newTgtRootNames = 0;
                ** while (newTgtRootNames < errSyncRootPaths)
            }
lbl-1000:
            // 1 sources

            {
                oldPath = path /* !! */ [newTgtRootNames];
                oldSrcRootPaths.add(oldPath);
                ++newTgtRootNames;
                continue;
            }
lbl54:
            // 1 sources

            newSrcRootNames = new ArrayList<String>();
            newTgtRootNames = new ArrayList<String>();
            i = 0;
            while (i < numberProcessed) {
                if (!oldSrcRootPaths.contains(processedSrcRootNames.get(i))) {
                    newSrcRootNames.add((String)processedSrcRootNames.get(i));
                    newTgtRootNames.add((String)processedTgtRootNames.get(i));
                }
                ++i;
            }
            if (newSrcRootNames.size() > 0) {
                newSrcRootPaths = new String[oldSize + numberProcessed];
                newTgtRootPaths = new String[oldSize + numberProcessed];
                i = 0;
                while (i < oldSize) {
                    newSrcRootPaths[i] = srcSegment.get_syncRootPaths()[i];
                    newTgtRootPaths[i] = tgtSegment.get_syncRootPaths()[i];
                    ++i;
                }
                i = 0;
                while (i < numberProcessed) {
                    newSrcRootPaths[i + oldSize] = (String)processedSrcRootNames.get(i);
                    newTgtRootPaths[i + oldSize] = (String)processedTgtRootNames.get(i);
                    ++i;
                }
                srcSegment.set_syncRootPaths(newSrcRootPaths);
                tgtSegment.set_syncRootPaths(newTgtRootPaths);
            }
            if (numberProcessed == this._newSyncRootPaths.length) {
                this._newSyncRootPaths = null;
            } else {
                errSyncRootPaths = new ArrayList<String[]>();
                var33_51 = this._newSyncRootPaths;
                var32_53 = this._newSyncRootPaths.length;
                var31_49 = 0;
                while (var31_49 < var32_53) {
                    path /* !! */  = var33_51[var31_49];
                    if (!processedSyncRootPaths.contains(path /* !! */ )) {
                        errSyncRootPaths.add(path /* !! */ );
                    }
                    ++var31_49;
                }
                this._newSyncRootPaths = errSyncRootPaths.size() == 0 ? null : errSyncRootPaths.toArray(new String[errSyncRootPaths.size()]);
            }
            this.updateISMetadata(nowork);
        }
        this.setOtherSentover(isImport, otherConfigurations, f.nest(90));
        if (isImport) {
            thisInternalWs = this.thisInternalWs();
            thisInternalWs.doUpdate(InteropStream.makeList(this.thisCloneStream()), f.nest(95));
            thisInternalWs.doMerge(InteropStream.makeList(this.thisSyncStream()), InteropStream.MF_NO_CHECKOUTS_UPDATE, f.nest(100));
        }
        if (exceptions.size() > 0) {
            msg = Messages.getString("InteropStream.ERROR_ADD_SYNC_FILES_FAILED");
            if (isImport) {
                thisCloneWs = this.thisCloneWs();
                thisCloneWs.doCheckinAll(Messages.getString("InteropStream.MSG_FAILED_IMPORT"), null, nowork);
                InteropStream.updateStreamWithWorkspace(this.thisCloneStream(), thisCloneWs, nowork);
            }
            if (exceptions.size() == 1) {
                throw (WvcmException)exceptions.get(0);
            }
            e = new WvcmException(msg, null, WvcmException.ReasonCode.CONFLICT, (Throwable)exceptions.get(0), (Throwable[])exceptions.toArray(new WvcmException[exceptions.size()]));
            throw e;
        }
    }

    private void internalSetCloneRoots(Feedback f) throws WvcmException {
        boolean isImport;
        if (this._operation.equals((Object)InteropStreamOperation.EXPORT)) {
            isImport = false;
        } else if (this._operation.equals((Object)InteropStreamOperation.IMPORT)) {
            isImport = true;
        } else {
            throw new WvcmException("Illegal operation: " + (Object)((Object)this._operation), WvcmException.ReasonCode.FORBIDDEN);
        }
        if (isImport) {
            this.internalSetCloneRoot(isImport, this.otherSegment(), this.otherSyncWs(), this.thisSegment(), this.thisCloneWs(), this.thisCloneStream(), this._newSyncRootPaths, f.nest(100));
        } else {
            this.internalSetCloneRoot(isImport, this.thisSegment(), this.thisCloneWs(), this.otherSegment(), this.otherSyncWs(), this.otherSyncStream(), this._newSyncRootPaths, f.nest(100));
        }
    }

    private Baseline nextBLInStream(Baseline bl, List<Baseline> streamBaselines) throws WvcmException {
        if (bl.lookupProperty(Baseline.SUCCESSOR_LIST) instanceof WvcmException) {
            int i = streamBaselines.indexOf(bl) + 1;
            if (i == streamBaselines.size()) {
                return null;
            }
            return streamBaselines.get(i);
        }
        for (Version nextBL : bl.getSuccessorList()) {
            int i = streamBaselines.indexOf(nextBL);
            if (i < 0) continue;
            return streamBaselines.get(i);
        }
        return null;
    }

    private List<ResourceList<Baseline>> createCompositeBaselines(List<ResourceList<Baseline>> baselineHistoryGraphs) throws WvcmException {
        ArrayList<ResourceList<Baseline>> result = new ArrayList<ResourceList<Baseline>>();
        for (List list : baselineHistoryGraphs) {
            int i = 0;
            while (i < list.size()) {
                if (i >= result.size()) {
                    result.add(InteropStream.makeList((Baseline)list.get(i)));
                } else {
                    ((ResourceList)result.get(i)).add((Object)((Baseline)list.get(i)));
                }
                ++i;
            }
        }
        return result;
    }

    private void throwBaselineNotFoundMsg(Baseline baseline, List<Baseline> baselines, Component component, Feedback f) throws WvcmException {
        String blMsg = "";
        for (Baseline b : baselines) {
            blMsg = String.valueOf(blMsg) + "\n   loc=" + b.location() + " id=" + (String)InteropStream.tryGetProperty((Resource)b, Baseline.RESOURCE_IDENTIFIER);
        }
        throw new WvcmException(f.format(Messages.getString("InteropStream.ERROR_BASELINE_NOT_FOUND"), new Object[]{component.location(), this.otherSyncStream().location(), baseline.location(), InteropStream.tryGetProperty((Resource)baseline, Baseline.RESOURCE_IDENTIFIER), blMsg}), null, WvcmException.ReasonCode.NOT_FOUND);
    }

    private void importBaseline(ResourceList<Baseline> importBaselines, Feedback f) throws WvcmException {
        this.otherSyncWs().doUpdate(importBaselines, f.nest(10));
        Workspace thisCloneWs = this.thisCloneWs();
        thisCloneWs.doCheckinAll(Messages.getString("InteropStream.MSG_LEFTOVER_CHECKOUTS"), null, f.nest(11));
        InteropStream.closeCurrentActivity(thisCloneWs, f.nest(12));
        if (this.thisSegment().numSyncRoots() == 0) {
            thisCloneWs.doUpdate(InteropStream.makeList(this.thisSyncStream()), f.nest(25));
            InteropStream.updateStreamWithWorkspace(this.thisCloneStream(), thisCloneWs, f.nest(50));
            this.thisInternalWs().doUpdate(InteropStream.makeList(this.thisCloneStream()), f.nest(75));
            InteropStream.updateStreamWithWorkspace(this.thisInternalStream(), this.thisInternalWs(), f.nest(100));
            if (this.otherSegment().get_sentoverBaselinePaths().length > 0) {
                this.otherSegment().set_sentoverBaselinePaths(new String[0]);
            }
            return;
        }
        this.sendoverOtherBaselines(f.nest(100));
    }

    /*
     * Exception decompiling
     */
    private void importStream(Feedback f) throws WvcmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void desync(String desyncVal, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider thisP = this.thisProvider();
        this.reserveInteropStream(nowork);
        try {
            InteropStream.forceAbortWvcmException((Provider)thisP, 20, f);
            this.internalSetSyncState(InteropStreamState.OPERATION_ACTIVE, nowork);
            if (!this._operation.equals((Object)InteropStreamOperation.EXPORT)) {
                throw new WvcmException("Can only DESYNC Jazz files", WvcmException.ReasonCode.CONFLICT);
            }
            int n = this._newSyncRootPaths.length;
            int i = 0;
            String[] stringArray = this._newSyncRootPaths;
            int n2 = this._newSyncRootPaths.length;
            int n3 = 0;
            while (n3 < n2) {
                String thisRootPath = stringArray[n3];
                try {
                    InteropStream.forceAbortWvcmException((Provider)thisP, 21, f);
                    ControllableResource root = thisP.controllableResource(thisP.location(thisRootPath));
                    root = (ControllableResource)root.doReadProperties(f.nest(PR_PATH_VH_CLONE));
                    String name = InteropStream.getFriendlyPathname((Resource)root, 0, f);
                    if (desyncVal.equals(DESYNC_COMPONENT)) {
                        root = (ControllableResource)root.doReadProperties(f.nest(PR_CONFIG_VH_CLONE));
                        root = root.getConfiguration();
                        name = f.format(Messages.getString("InteropStream.MSG_COMPONENT_OF"), new Object[]{name});
                    }
                    VersionHistory vh = root.getVersionHistory();
                    String msg = f.format(Messages.getString("InteropStream.MSG_NOT_CURRENTLY_SYNCHRONIZED"), new Object[]{name});
                    if (InteropStream.getProperty((Resource)vh, PN_CLONE) != null) {
                        vh.removeProperty(PN_CLONE);
                        vh.doWriteProperties(nowork);
                        msg = f.format(Messages.getString("InteropStream.MSG_DESYNCHRONIZED"), new Object[]{name});
                    }
                    f.notifyActive(msg);
                }
                catch (WvcmException e) {
                    String msg = f.format(Messages.getString("InteropStream.ERROR_TRYING_TO_DESYNCHRONIZE"), new Object[]{e.getMessage()});
                    f.notifyWarning(msg);
                }
                f.notifyPercentComplete(100 * (i + 1) / n);
                ++i;
                ++n3;
            }
        }
        finally {
            this._newSyncRootPaths = null;
            this.thisSegment().put_initArgs(IA_DESYNC, EMPTY_STRING);
            this.set_state(InteropStreamState.OK);
            this.updateISMetadata(nowork);
            this.unreserveInteropStream(nowork);
        }
    }

    private void internalPostOperation(InteropStreamOperation operation, List<ControllableResource> roots) {
        this._operation = operation;
        this._newSyncRootPaths = null;
        if (roots != null) {
            this._newSyncRootPaths = new String[roots.size()];
            int i = 0;
            while (i < roots.size()) {
                this._newSyncRootPaths[i] = roots.get(i).location().string();
                ++i;
            }
        }
        this.set_state(InteropStreamState.OPERATION_PENDING);
    }

    private void postOperation(InteropStreamOperation operation, List<ControllableResource> roots, Feedback f) throws WvcmException {
        this.reserveInteropStream(f);
        try {
            InteropStream.forceAbortWvcmException((Provider)this.thisProvider(), 22, f);
            this.internalPostOperation(operation, roots);
            this.updateISMetadata(f.nest(40));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public String toString() {
        try {
            InteropStream.forceWvcmException((Provider)this.thisProvider(), 23);
            return (String)InteropStream.doReadProperty((Resource)this.thisSyncStream(), Stream.DISPLAY_NAME, null);
        }
        catch (WvcmException wvcmException) {
            return this.unparse();
        }
    }

    public InteropStreamSegment thisSegment() {
        return this._thisSegment;
    }

    public InteropStreamSegment otherSegment() {
        return this._otherSegment;
    }

    public InteropStreamState get_state() {
        return this.thisSegment().get_state();
    }

    private void set_state(InteropStreamState state) {
        this.thisSegment().set_state(state);
    }

    public InteropStreamOperation get_operation() {
        if (this.get_state().equals((Object)InteropStreamState.OPERATION_PENDING) && this._newSyncRootPaths == null) {
            return InteropStreamOperation.SYNCHRONIZE;
        }
        return this._operation;
    }

    public String[] get_unprocessedArguments() {
        if (this._newSyncRootPaths != null) {
            return (String[])this._newSyncRootPaths.clone();
        }
        return null;
    }

    public long lastAttemptedSyncDate() {
        return this._lastAttemptedSyncDate;
    }

    public long lastSyncDate() {
        return this._lastSyncDate;
    }

    public WorkspaceProvider thisProvider() throws WvcmException {
        return this.thisSegment().provider();
    }

    public WorkspaceProvider otherProvider() throws WvcmException {
        return this.otherSegment().provider();
    }

    public Stream thisCloneStream() throws WvcmException {
        return this.thisSegment().cloneStream();
    }

    public Workspace thisCloneWs() throws WvcmException {
        return this.thisSegment().cloneWs();
    }

    public Stream thisSyncStream() throws WvcmException {
        return this.thisSegment().syncStream();
    }

    public Workspace thisSyncWs() throws WvcmException {
        return this.thisSegment().syncWs();
    }

    public Stream thisInternalStream() throws WvcmException {
        return this.thisSegment().internalStream();
    }

    public Workspace thisInternalWs() throws WvcmException {
        return this.thisSegment().internalWs();
    }

    public Workspace thisMergeWs() throws WvcmException {
        WorkspaceProvider p = this.thisProvider();
        String wsPath = (String)this.thisProvider().initArgs().get(IA_MERGE_WORKSPACE);
        if (wsPath == null) {
            return null;
        }
        return p.workspace(p.location(wsPath));
    }

    public List<ControllableResource> thisSyncRoots(Workspace ws, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        List<ControllableResource> roots = this.getPrunedSyncRoots(true, ws, f);
        f.notifyPercentComplete(100);
        return roots;
    }

    public Stream otherSyncStream() throws WvcmException {
        return this.otherSegment().syncStream();
    }

    public Workspace otherSyncWs() throws WvcmException {
        return this.otherSegment().syncWs();
    }

    public List<ControllableResource> otherSyncRoots(Workspace ws, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        List<ControllableResource> roots = this.getPrunedSyncRoots(false, ws, f);
        f.notifyPercentComplete(100);
        return roots;
    }

    public static InteropStream getInteropStream(Stream syncStream, Feedback feedback) throws WvcmException {
        if (syncStream == null) {
            return null;
        }
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Stream stream = (Stream)syncStream.doReadProperties(f.nest(PR_IS, 100));
        return InteropStream.parse(InteropStream.getProperty((Resource)stream, PN_INTEROP_STREAM), syncStream.provider().callback(), f);
    }

    public void initialize(Stream otherStream, Feedback feedback) throws WvcmException {
        long syncDate;
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        Stream otherSyncStream = otherStream;
        this.otherSegment().set_syncStreamPath(otherSyncStream.location().string());
        String otherSyncStreamName = (String)InteropStream.doReadProperty((Resource)otherSyncStream, Stream.DISPLAY_NAME, nowork);
        f.notifyPercentComplete(10);
        String otherWsName = this.createOtherWorkspaceName(otherSyncStreamName, nowork);
        Workspace otherSyncWs = InteropStream.createWorkspace(otherWsName, this.isImportOnly(), otherSyncStream, true, nowork);
        f.notifyPercentComplete(40);
        this.otherSegment().set_syncWsPath(otherSyncWs.location().string());
        f.notifyPercentComplete(60);
        HashMap<String, String> otherInitArgs = new HashMap<String, String>();
        InteropStream.setHasCloneInfo(otherInitArgs, false);
        otherInitArgs.put(IA_OTHER_WORKSPACE_NAME, EMPTY_STRING);
        otherInitArgs.put(IA_OTHER_STREAM_LOCATION, otherStream.location().string());
        otherInitArgs.put(IA_WORKSPACE_PATH, otherSyncWs.location().string());
        otherInitArgs.put(IA_FORCE_EXCEPTION, EMPTY_STRING);
        this.otherSegment().putAll_initArgs(otherInitArgs);
        HashMap<String, String> thisInitArgs = new HashMap<String, String>();
        InteropStream.setHasCloneInfo(thisInitArgs, true);
        thisInitArgs.put(IA_IS_THIS_PROVIDER, TRUE_STRING);
        thisInitArgs.put(IA_DESYNC, EMPTY_STRING);
        thisInitArgs.put(IA_FORCE_EXCEPTION, EMPTY_STRING);
        this.thisSegment().putAll_initArgs(thisInitArgs);
        WorkspaceProvider thisP = this.thisProvider();
        Stream thisSyncStream = InteropStream.createStream(otherSyncStreamName, thisP, null, f.nest(PR_WORKSPACE));
        this.thisSegment().set_syncStreamPath(thisSyncStream.location().string());
        Workspace thisSyncWs = thisSyncStream.getWorkspace();
        this.thisSegment().set_syncWsPath(thisSyncWs.location().string());
        f.notifyPercentComplete(70);
        String internalWsName = f.format(INTERNAL_WORKSPACE_NAME, new Object[]{otherSyncStreamName});
        Workspace thisInternalWs = InteropStream.createWorkspace(internalWsName, true, thisSyncStream, true, f.nest(PR_STREAM));
        this.thisSegment().set_internalWsPath(thisInternalWs.location().string());
        Stream thisInternalStream = thisInternalWs.getStream();
        this.thisSegment().set_internalStreamPath(thisInternalStream.location().string());
        f.notifyPercentComplete(80);
        String cloneWsName = f.format(CLONE_WORKSPACE_NAME, new Object[]{otherSyncStreamName});
        Workspace thisCloneWs = InteropStream.createWorkspace(cloneWsName, true, thisSyncStream, true, f.nest(PR_STREAM));
        this.thisSegment().set_cloneWsPath(thisCloneWs.location().string());
        Stream thisCloneStream = thisCloneWs.getStream();
        this.thisSegment().set_cloneStreamPath(thisCloneStream.location().string());
        f.notifyPercentComplete(90);
        this._minorVersion = CURRENT_MINOR_VERSION;
        this._lastAttemptedSyncDate = syncDate = new Date().getTime();
        this._lastSyncDate = syncDate;
        this.updateISMetadata(nowork);
        f.notifyPercentComplete(100);
    }

    public boolean isImportOnly() throws WvcmException {
        String importOnlyInitArg = (String)this.otherProvider().initArgs().get(IA_IMPORT_ONLY);
        boolean isImportOnly = Boolean.parseBoolean(importOnlyInitArg);
        return isImportOnly;
    }

    public void setIsImportOnly(boolean isImportOnly, Feedback feedback) throws WvcmException {
        HashMap<String, String> newInitArgs = new HashMap<String, String>();
        newInitArgs.put(IA_IMPORT_ONLY, isImportOnly ? TRUE_STRING : FALSE_STRING);
        this.updateOtherInitArgs(newInitArgs, feedback);
    }

    public String getBaselineFilter() throws WvcmException {
        String baselineFilter = (String)this.otherProvider().initArgs().get(IA_BASELINE_FILTER);
        return baselineFilter;
    }

    public void setBaselineFilter(String baselineFilter, Feedback feedback) throws WvcmException {
        HashMap<String, String> newInitArgs = new HashMap<String, String>();
        newInitArgs.put(IA_BASELINE_FILTER, baselineFilter);
        this.updateOtherInitArgs(newInitArgs, feedback);
    }

    public boolean isLocked(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        String reservedBy = InteropStream.doReadProperty((Resource)this.otherSyncStream(), PN_RESERVED_FOR_INTEROP, f.nest(50));
        if (reservedBy != null) {
            return true;
        }
        String reserved = InteropStream.doReadProperty((Resource)this.thisSyncStream(), PN_INTEROP_STREAM_LOCKED, f.nest(100));
        return reserved != null;
    }

    public void unlock(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.unreserveOtherStream(f.nest(50));
        this.unreserveInteropStream(f.nest(100));
    }

    public void delete(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.thisSyncStream().doUnbindAll(f.nest(20));
        try {
            InteropStream.forceAbortWvcmException((Provider)this.thisProvider(), 24, f);
            this.otherSyncWs().doUnbindAll(f);
        }
        catch (WvcmException e) {
            f.notifyWarning(e.getLocalizedMessage());
        }
        f.notifyPercentComplete(100);
    }

    public InteropStream refresh(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        String interopStreamValue = InteropStream.doReadProperty((Resource)this.thisSyncStream(), PN_INTEROP_STREAM, f.nest(50));
        String[] field = interopStreamValue.split(TERMINATOR1, -1);
        long stateId = Long.parseLong(InteropStream.getStateIdField(field));
        if (stateId == this._stateId) {
            return this;
        }
        InteropStream result = InteropStream.parse(interopStreamValue, this.thisProvider().callback(), f);
        f.notifyPercentComplete(100);
        return result;
    }

    public void updateThisInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(25));
        try {
            this.thisSegment().putAll_initArgs(newInitArgs);
            this.updateISMetadata(f.nest(50));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void updateOtherInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(25));
        try {
            this.otherSegment().putAll_initArgs(newInitArgs);
            this.updateISMetadata(f.nest(50));
        }
        finally {
            this.unreserveInteropStream(f.nest(75));
            if (newInitArgs.containsKey(IA_LINE_SEPARATOR)) {
                this.newOtherSyncWs(f.nest(100));
            }
        }
    }

    public void setSyncPending(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(25));
        try {
            this.internalSetSyncState(InteropStreamState.OPERATION_PENDING, f.nest(50));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void setSyncFailed(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(40));
        try {
            this.internalSetSyncState(InteropStreamState.OPERATION_ERROR, f.nest(60));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void newOtherSyncStream(Stream otherStream, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.reserveInteropStream(nowork);
        try {
            this.otherSegment().set_syncStreamPath(otherStream.location().string());
            String streamName = (String)InteropStream.doReadProperty((Resource)otherStream, Stream.DISPLAY_NAME, nowork);
            String wsName = this.createOtherWorkspaceName(streamName, nowork);
            Workspace otherWs = this.newInteropStreamWs(wsName, this.otherSegment(), this.otherSyncWs(), false, this.otherSyncStream(), f.nest(50));
            this.otherSegment().set_syncWsPath(otherWs.location().string());
            List<ControllableResource> roots = this.otherSyncRoots(this.otherSyncWs(), f.nest(90));
            this.internalPostOperation(InteropStreamOperation.IMPORT, roots);
            this.deleteAllSyncRoots();
            this.updateISMetadata(nowork);
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void newOtherSyncWs(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.reserveInteropStream(nowork);
        try {
            String streamName = (String)InteropStream.doReadProperty((Resource)this.otherSyncStream(), Stream.DISPLAY_NAME, nowork);
            String wsName = this.createOtherWorkspaceName(streamName, f);
            Workspace ws = this.newInteropStreamWs(wsName, this.otherSegment(), this.otherSyncWs(), false, this.otherSyncStream(), f.nest(95));
            this.otherSegment().set_syncWsPath(ws.location().string());
            this.updateISMetadata(nowork);
        }
        finally {
            this.unreserveInteropStream(nowork);
            f.notifyPercentComplete(100);
        }
    }

    public void newThisCloneWs(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.reserveInteropStream(nowork);
        try {
            String streamName = (String)InteropStream.doReadProperty((Resource)this.otherSyncStream(), Stream.DISPLAY_NAME, nowork);
            String wsName = f.format(INTERNAL_WORKSPACE_NAME, new Object[]{streamName});
            Workspace internalWs = this.newInteropStreamWs(wsName, this.thisSegment(), this.thisInternalWs(), true, this.thisSyncStream(), f.nest(PR_STREAM, 50));
            this.thisSegment().set_internalWsPath(internalWs.location().string());
            this.thisSegment().set_internalStreamPath(internalWs.getStream().location().string());
            wsName = f.format(CLONE_WORKSPACE_NAME, new Object[]{streamName});
            Workspace cloneWs = this.newInteropStreamWs(wsName, this.thisSegment(), this.thisCloneWs(), true, this.thisSyncStream(), f.nest(PR_STREAM, 95));
            this.thisSegment().set_cloneWsPath(cloneWs.location().string());
            this.thisSegment().set_cloneStreamPath(cloneWs.getStream().location().string());
            this.updateISMetadata(nowork);
            Workspace mergeWs = this.thisMergeWs();
            try {
                InteropStream.forceAbortWvcmException((Provider)this.thisProvider(), 25, f);
                mergeWs.setSourceList(InteropStream.makeList(this.thisCloneStream()));
                mergeWs.doWriteProperties(feedback);
            }
            catch (WvcmException wvcmException) {
                String mergeWsName = (String)InteropStream.doReadProperty((Resource)mergeWs, Workspace.DISPLAY_NAME, feedback);
                String msg = f.format(Messages.getString("InteropStream.WARNING_CANNOT_UPDATE_MERGEWS"), new Object[]{mergeWsName});
                f.notifyWarning(msg);
            }
        }
        finally {
            this.unreserveInteropStream(nowork);
            f.notifyPercentComplete(100);
        }
    }

    public Workspace newThisMergeWs(String name, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        WorkspaceProvider thisP = this.thisProvider();
        Location loc = thisP.rootLocation().child(name);
        Workspace ws = thisP.workspace(loc);
        Stream stream = this.thisSyncStream();
        ws.setIsolatedTarget(stream);
        ResourceList streamList = thisP.resourceList((Resource[])new Stream[]{this.thisCloneStream()});
        ws.setSourceList(streamList);
        this.reserveInteropStream(f.nest(10));
        try {
            ws = ws.doCreateGeneratedResource(f.nest(50));
            this.thisSegment().put_initArgs(IA_MERGE_WORKSPACE, ws.getResourceIdentifier());
            this.updateISMetadata(f.nest(55));
            ws.doUpdate(InteropStream.makeList(stream), f.nest(90));
            Workspace workspace = ws;
            return workspace;
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void deleteThisSyncRoots(Collection<VersionHistory> thisSyncRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(10));
        try {
            this.internalDeleteSyncRoots(true, thisSyncRoots, f.nest(90));
            this.updateISMetadata(f.nest(95));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void deleteOtherSyncRoots(Collection<VersionHistory> otherSyncRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(10));
        try {
            this.internalDeleteSyncRoots(false, otherSyncRoots, f.nest(90));
            this.updateISMetadata(f.nest(95));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void importCloneRoots(List<ControllableResource> otherRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropStreamOperation.IMPORT, otherRoots, f.nest(100));
    }

    public void exportCloneRoots(List<ControllableResource> thisRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropStreamOperation.EXPORT, thisRoots, f.nest(100));
    }

    public void sync(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropStreamOperation.SYNCHRONIZE, null, f.nest(100));
    }

    /*
     * Exception decompiling
     */
    public void doOperation(Feedback feedback) throws WvcmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class ChildException {
        public volatile Throwable ex = null;
    }

    private static class ContentReader
    extends Thread {
        private PipedOutputStream _pouts;
        private Resource _resource;
        private Resource _accept;
        private Feedback _feedback;
        private ChildException _childException;

        public ContentReader(Resource resource, PipedOutputStream pouts, Resource accept, ChildException childException, Feedback f) {
            this._resource = resource;
            this._accept = accept;
            this._pouts = pouts;
            this._childException = childException;
            this._feedback = f;
            this.start();
        }

        public void run() {
            try {
                try {
                    InteropStream.forceAbortWvcmException(this._resource.provider(), 7, this._feedback);
                    this._resource.doReadContent((OutputStream)this._pouts, this._accept, this._feedback);
                }
                catch (Exception e) {
                    this._childException.ex = e;
                    try {
                        InteropStream.shouldForceException(this._resource.provider(), 8);
                        this._pouts.close();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException("Could not close output stream", e2);
                    }
                }
            }
            finally {
                try {
                    InteropStream.shouldForceException(this._resource.provider(), 8);
                    this._pouts.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close output stream", e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InteropStreamOperation {
        INITIALIZE,
        SYNCHRONIZE,
        EXPORT,
        IMPORT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InteropStreamState {
        OK,
        MERGE_NEEDED,
        OPERATION_PENDING,
        OPERATION_ACTIVE,
        OPERATION_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineSeparator {
        UNSPECIFIED,
        LF,
        CR,
        CRLF,
        PLATFORM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SyncStatType {
        FILES_CREATED,
        FILES_UPDATED,
        FOLDERS_CREATED,
        FOLDERS_UPDATED,
        CHANGES,
        CLONES,
        SYMLINKS_CREATED;

    }

    public static class SyncStats {
        private Map<SyncStatType, Integer> _stats = new HashMap<SyncStatType, Integer>();

        private void incrementSyncStat(SyncStatType type, int amount) {
            this._stats.put(type, this.getAmount(type) + amount);
            if (type == SyncStatType.FILES_CREATED) {
                numFilesCreated += amount;
            } else if (type == SyncStatType.FILES_UPDATED) {
                numFilesUpdated += amount;
            } else if (type == SyncStatType.FOLDERS_CREATED) {
                numFoldersCreated += amount;
            } else if (type == SyncStatType.FOLDERS_UPDATED) {
                numFoldersUpdated += amount;
            } else if (type == SyncStatType.SYMLINKS_CREATED) {
                numSymlinksCreated += amount;
            } else if (type == SyncStatType.CHANGES) {
                numChanges += amount;
            } else if (type == SyncStatType.CLONES) {
                numClones += amount;
            }
        }

        public int getAmount(SyncStatType type) {
            Integer result = this._stats.get((Object)type);
            if (result == null) {
                return 0;
            }
            return result;
        }
    }
}

