/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.internal;

import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.client.internal.Messages;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.interop.common.IExternalState;
import com.ibm.team.interop.common.IExternalStateHandle;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.common.internal.ExternalProxy;
import com.ibm.team.interop.common.internal.query.BaseExternalProxyQueryModel;
import com.ibm.team.interop.common.service.IInteropService;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteropManager
implements IInteropManager {
    protected final IClientLibraryContext fContext;

    public InteropManager(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.fContext = context;
    }

    @Override
    public IExternalProxy saveProxy(IExternalProxy proxyWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxyWorkingCopy == null) {
            throw new IllegalArgumentException("proxyWorkingCopy cannot be null");
        }
        if (proxyWorkingCopy.isNewItem() || !proxyWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("proxyWorkingCopy must be a working copy (not a new item)");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SAVE_PROXY_TASK_NAME, 100);
            List<IAuditable> sharedItems = this.doSave(proxyWorkingCopy, null, null, null);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy saveProxyWithTargetItem(IExternalProxy proxy, IItemHandle targetItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        if (!proxy.isWorkingCopy()) {
            throw new IllegalArgumentException("proxy must be a working copy");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SAVE_PROXY_TASK_NAME, 100);
            List<IAuditable> sharedItems = this.doSave(proxy, null, targetItemHandle, null);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy saveProxyWithUri(IExternalProxy proxy, URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        if (!proxy.isWorkingCopy()) {
            throw new IllegalArgumentException("proxy must be a working copy");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SAVE_PROXY_TASK_NAME, 100);
            List<IAuditable> sharedItems = this.doSave(proxy, null, null, uri);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy saveProxyWithState(IExternalProxy proxy, IExternalState state, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy arg cannot be null");
        }
        if (proxy.isNewItem() || !proxy.isWorkingCopy()) {
            throw new IllegalArgumentException("proxy must be a working copy (not a new item)");
        }
        if (state == null) {
            throw new IllegalArgumentException("state arg cannot be null");
        }
        if (!state.isWorkingCopy()) {
            throw new IllegalArgumentException("state must be a working copy");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SAVE_PROXY_WITH_STATE_TASK_NAME, 100);
            List<IAuditable> sharedItems = this.doSave(proxy, state, null, null);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy saveProxyWithStateAndUri(IExternalProxy proxy, IExternalState state, URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("state cannot be null");
        }
        if (!proxy.isWorkingCopy()) {
            throw new IllegalArgumentException("proxy must be a working copy");
        }
        if (!state.isWorkingCopy()) {
            throw new IllegalArgumentException("state must be a working copy");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SAVE_PROXY_WITH_STATE_AND_URI_TASK_NAME, 100);
            List<IAuditable> sharedItems = this.doSave(proxy, state, null, uri);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy findProxybyUri(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_FIND_PROXY_BY_URI_TASK_NAME, 100);
            IExternalProxy proxy = this.getService().findProxybyUri(uri.toASCIIString());
            if (proxy == null) {
                return null;
            }
            List sharedItems = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Collections.singletonList(proxy), monitor);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy findProxybyTargetItem(IItemHandle targetItem, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetItem == null) {
            throw new IllegalArgumentException("targetItem cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_FIND_PROXY_BY_TARGET_ITEM_TASK_NAME, 100);
            IExternalProxy proxy = this.getService().findProxybyTargetItem(this.minimize(targetItem));
            if (proxy == null) {
                return null;
            }
            List sharedItems = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Collections.singletonList(proxy), monitor);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxyHandle[] findProxiesBySyncRule(ISyncRuleHandle syncRuleHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Object[] queryArgs;
            IPredicate filter;
            IQueryService queryService = ((TeamRepository)this.teamRepository()).getQueryService();
            BaseExternalProxyQueryModel.ExternalProxyQueryModel qm = BaseExternalProxyQueryModel.ExternalProxyQueryModel.ROOT;
            IItemQuery q = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)qm);
            if (syncRuleHandle == null) {
                filter = qm.syncRule()._isNull();
                queryArgs = IQueryService.EMPTY_PARAMETERS;
            } else {
                filter = qm.syncRule()._eq(q.newItemHandleArg());
                queryArgs = new Object[]{syncRuleHandle};
            }
            q.filter(filter);
            IItemQueryPage page = queryService.queryItems(q, queryArgs, 100);
            IExternalProxyHandle[] results = new IExternalProxyHandle[page.getResultSize()];
            if (page.getResultSize() == 0) {
                IExternalProxyHandle[] iExternalProxyHandleArray = results;
                return iExternalProxyHandleArray;
            }
            ArrayList resultsList = new ArrayList(page.getResultSize());
            progress.worked(50);
            SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(page.getResultSize());
            while (page != null) {
                resultsList.addAll(page.getItemHandles());
                loopProgress.worked(page.getSize());
                if (!page.hasNext()) break;
                page = (IItemQueryPage)queryService.fetchPage(page.getToken(), page.getNextStartPosition(), page.getSize());
            }
            IExternalProxyHandle[] iExternalProxyHandleArray = resultsList.toArray(results);
            return iExternalProxyHandleArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IExternalState findExternalStatebyUri(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_FIND_STATE_BY_URI_TASK_NAME, 100);
            IExternalState xstate = this.getService().findExternalStatebyUri(uri.toASCIIString());
            if (xstate == null) {
                return null;
            }
            IExternalState iExternalState = xstate;
            return iExternalState;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Map<String, Object> getLastSyncedInExternalState(IExternalProxy proxy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_LAST_SYNCED_IN_STATE_TASK_NAME, 100);
            IExternalState xstate = this.getService().getLastSyncedInExternalState(proxy);
            if (xstate == null) {
                return null;
            }
            Map map = xstate.getState();
            return map;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Map<String, Object> getLastSyncedOutExternalState(IExternalProxy proxy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_LAST_SYNCED_OUT_STATE_TASK_NAME, 100);
            IExternalState xstate = this.getService().getLastSyncedOutExternalState(proxy);
            if (xstate == null) {
                return null;
            }
            Map map = xstate.getState();
            return map;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Map<String, Object> getLatestState(IExternalProxy proxy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        IExternalState xstate = this.getExternalState(proxy, monitor);
        if (xstate == null) {
            return null;
        }
        return xstate.getState();
    }

    @Override
    public IExternalState getExternalState(IExternalProxy proxy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_STATE_TASK_NAME, 100);
            IExternalState xstate = this.getService().getExternalState(proxy);
            if (xstate == null) {
                return null;
            }
            IExternalState iExternalState = xstate;
            return iExternalState;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalState saveExternalState(IExternalState stateWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (stateWorkingCopy == null) {
            throw new IllegalArgumentException("stateWorkingCopy cannot be null");
        }
        if (!stateWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("stateWorkingCopy must be a working copy");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SAVE_STATE_TASK_NAME, 100);
            List<IAuditable> sharedItems = this.doSave(null, stateWorkingCopy, null, null);
            IExternalState iExternalState = (IExternalState)sharedItems.get(1);
            return iExternalState;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public URI getUri(IExternalProxyHandle proxy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_URI_TASK_NAME, 100);
            String uriString = this.getService().getUri(proxy);
            if (uriString == null) {
                return null;
            }
            URI uRI = URI.create(uriString);
            return uRI;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IItemHandle getTargetItem(IExternalProxyHandle proxy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_EXTERNAL_ID_TASK_NAME, 100);
            IItemHandle iItemHandle = this.getService().getTargetItem(proxy);
            return iItemHandle;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Map<String, Object> getTargetItemState(IExternalProxyHandle proxyHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxyHandle == null) {
            throw new IllegalArgumentException("proxyHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_TARGET_ITEM_STATE_TASK_NAME, 100);
            IExternalState xstate = this.getService().getTargetItemState(proxyHandle);
            if (xstate == null) {
                return null;
            }
            Map map = xstate.getState();
            return map;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxyHandle[] getBlockingProxies(IExternalProxyHandle proxyHandle, boolean incoming, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxyHandle == null) {
            throw new IllegalArgumentException("proxyHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_BLOCKING_PROXIES_TASK_NAME, 100);
            IExternalProxyHandle[] iExternalProxyHandleArray = this.getService().getBlockingProxies(proxyHandle, incoming);
            return iExternalProxyHandleArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteSyncRule(ISyncRuleHandle syncRuleHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (syncRuleHandle == null) {
            throw new IllegalArgumentException("syncRuleHandle cannot be null");
        }
        DeleteSyncRuleRunnable runnable = new DeleteSyncRuleRunnable(syncRuleHandle);
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_DELETE_SYNCRULE_TASK_NAME, 100);
            this.processClient().execute((ProcessRunnable)runnable, Messages.InteropManager_DELETE_SYNCRULE_TASK_NAME, monitor);
            TeamRepository repository = (TeamRepository)this.teamRepository();
            repository.itemManager().applyItemDeletes(Collections.singletonList(syncRuleHandle));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISyncRule saveSyncRule(ISyncRule syncRuleWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!syncRuleWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("syncRuleWorkingCopy must be a working copy");
        }
        SaveSyncRuleRunnable runnable = new SaveSyncRuleRunnable(syncRuleWorkingCopy);
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SAVE_SYNCRULE_TASK_NAME, 100);
            this.processClient().execute((ProcessRunnable)runnable, Messages.InteropManager_SAVE_SYNCRULE_TASK_NAME, monitor);
            ISyncRule savedSyncRule = runnable.getSavedItem();
            TeamRepository repository = (TeamRepository)this.teamRepository();
            List sharedItems = repository.itemManager().applyItemUpdates(Collections.singletonList(savedSyncRule));
            ISyncRule iSyncRule = (ISyncRule)sharedItems.get(0);
            return iSyncRule;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISyncRule findSyncRule(String name, IProgressMonitor monitor) throws TeamRepositoryException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_FIND_SYNCRULES_TASK_NAME, 100);
            ISyncRule syncRule = this.getService().findSyncRule(name);
            if (syncRule == null) {
                return null;
            }
            List sharedItems = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Collections.singletonList(syncRule), monitor);
            ISyncRule iSyncRule = (ISyncRule)sharedItems.get(0);
            return iSyncRule;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISyncRuleHandle[] findSyncRulesByExternalTypeName(String typeName, IProgressMonitor monitor) throws TeamRepositoryException {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("typeName cannot be null or empty");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_FIND_SYNCRULES_TASK_NAME, 100);
            ISyncRuleHandle[] iSyncRuleHandleArray = this.getService().findSyncRulesByExternalTypeName(typeName);
            return iSyncRuleHandleArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISyncRuleHandle[] findSyncRulesByProjectArea(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_FIND_SYNCRULES_TASK_NAME, 100);
            ISyncRuleHandle[] iSyncRuleHandleArray = this.getService().findSyncRulesByProjectArea(projectAreaHandle);
            return iSyncRuleHandleArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISyncRuleHandle[] findSyncRulesByExternalTypeNameAndProjectArea(String typeName, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("typeName cannot be null or empty");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_FIND_SYNCRULES_TASK_NAME, 100);
            ISyncRuleHandle[] iSyncRuleHandleArray = this.getService().findSyncRulesByExternalTypeNameAndProjectArea(typeName, projectAreaHandle);
            return iSyncRuleHandleArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Timestamp getLastSearchTime(ISyncRule syncRule, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_LAST_SEARCH_TIME_TASK_NAME, 100);
            Timestamp timestamp = this.getService().getLastSearchTime(syncRule);
            return timestamp;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void resetLastSearchTime(ISyncRule syncRule, boolean asAllModified, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_RESET_LAST_SEARCH_TIME_TASK_NAME, 100);
            this.getService().resetLastSearchTime(syncRule, asAllModified);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean isSynchronizationEnabled(ISyncRule syncRule, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_SYNC_ENABLED_FLAG_TASK_NAME, 100);
            boolean bl = this.getService().isSynchronizationEnabled(syncRule);
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setSynchronizationEnabled(ISyncRule syncRule, boolean enabled, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SET_SYNC_ENABLED_FLAG_TASK_NAME, 100);
            this.getService().setSynchronizationEnabled(syncRule, enabled);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISyncRuleHandle[] getAllSyncRules(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_GET_ALL_SYNCRULES_TASK_NAME, 100);
            ISyncRuleHandle[] iSyncRuleHandleArray = this.getService().getAllSyncRules();
            return iSyncRuleHandleArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void synchronizeIncoming(IExternalProxyHandle proxyHandle, IExternalStateHandle xstateHandle, IAuditableHandle syncedItemStateHandle, ISyncRuleHandle syncRuleHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxyHandle == null) {
            throw new IllegalArgumentException("proxyHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SYNC_INCOMING_TASK_NAME, 100);
            this.getService().synchronizeIncoming((IExternalProxyHandle)this.minimize((IItemHandle)proxyHandle), xstateHandle, syncedItemStateHandle, (ISyncRuleHandle)this.minimize((IItemHandle)syncRuleHandle));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy synchronizeIncomingAndWait(IExternalProxyHandle proxyHandle, IExternalStateHandle xstateHandle, IAuditableHandle syncedItemStateHandle, ISyncRuleHandle syncRuleHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxyHandle == null) {
            throw new IllegalArgumentException("proxyHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SYNC_INCOMING_TASK_NAME, 100);
            IExternalProxy proxy = this.getService().synchronizeIncomingAndWait((IExternalProxyHandle)this.minimize((IItemHandle)proxyHandle), xstateHandle, syncedItemStateHandle, (ISyncRuleHandle)this.minimize((IItemHandle)syncRuleHandle));
            if (proxy == null) {
                return null;
            }
            List sharedItems = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Collections.singletonList(proxy), monitor);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void synchronizeOutgoing(IItemHandle itemHandle, IExternalStateHandle syncedXstateHandle, ISyncRuleHandle syncRuleHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException("itemHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SYNC_OUTGOING_TASK_NAME, 100);
            this.getService().synchronizeOutgoing(itemHandle, syncedXstateHandle, syncRuleHandle);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalProxy synchronizeOutgoingAndWait(IItemHandle itemHandle, IExternalStateHandle syncedXstateHandle, ISyncRuleHandle syncRuleHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException("itemHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SYNC_OUTGOING_TASK_NAME, 100);
            IExternalProxy proxy = this.getService().synchronizeOutgoingAndWait(itemHandle, syncedXstateHandle, syncRuleHandle);
            if (proxy == null) {
                return null;
            }
            List sharedItems = this.teamRepository().itemManager().applyItemUpdatesOrRefresh(Collections.singletonList(proxy), monitor);
            IExternalProxy iExternalProxy = (IExternalProxy)sharedItems.get(0);
            return iExternalProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void synchronizeDeletion(IExternalProxyHandle proxyHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxyHandle == null) {
            throw new IllegalArgumentException("proxyHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.InteropManager_SYNC_DELETE_TASK_NAME, 100);
            this.getService().synchronizeDeletion((IExternalProxyHandle)this.minimize((IItemHandle)proxyHandle));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void synchronizeDeletionAndWait(IExternalProxyHandle proxyHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (proxyHandle == null) {
            throw new IllegalArgumentException("proxyHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        TeamRepository repository = (TeamRepository)this.teamRepository();
        try {
            monitor.beginTask(Messages.InteropManager_SYNC_DELETE_TASK_NAME, 100);
            IExternalStateHandle xsh = null;
            if (proxyHandle.hasFullState()) {
                IExternalProxy proxy = (IExternalProxy)proxyHandle.getFullState();
                xsh = proxy.getExternalStateItemHandle();
            }
            this.getService().synchronizeDeletionAndWait((IExternalProxyHandle)this.minimize((IItemHandle)proxyHandle));
            ArrayList<Object> deletedItems = new ArrayList<Object>();
            deletedItems.add(proxyHandle);
            if (xsh != null) {
                deletedItems.add(xsh);
            }
            repository.itemManager().applyItemDeletes(deletedItems);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setOutgoingSyncJobState(boolean enabled) {
        this.getService().setOutgoingSyncJobState(enabled);
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.getContext().teamRepository();
    }

    IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected IProgressMonitor getMonitor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    private List<IAuditable> doSave(IExternalProxy proxy, IExternalState xstate, IItemHandle targetItemHandle, URI uri) throws TeamRepositoryException {
        if (targetItemHandle != null && uri != null) {
            throw new IllegalArgumentException("At least one of targetItemHandle and uri must be null");
        }
        IExternalProxy savedProxy = null;
        IExternalState savedState = null;
        if (xstate != null && xstate.isWorkingCopy()) {
            if (xstate.getContextId() == null && proxy != null) {
                xstate.setContextId(proxy.getContextId());
            }
            savedState = this.getService().saveExternalState(xstate);
        }
        if (proxy != null) {
            ExternalProxy workingProxy = null;
            if (savedState != null && ((ExternalProxy)proxy).getExternalState() == null) {
                workingProxy = proxy.isWorkingCopy() ? (ExternalProxy)proxy : (ExternalProxy)proxy.getWorkingCopy();
                workingProxy.setExternalState((IExternalStateHandle)savedState);
            } else if (proxy.isWorkingCopy()) {
                workingProxy = (ExternalProxy)proxy;
            }
            if (workingProxy != null) {
                savedProxy = targetItemHandle != null ? this.getService().saveProxyWithTargetItem((IExternalProxy)workingProxy, targetItemHandle) : (uri != null ? this.getService().saveProxyWithUri((IExternalProxy)workingProxy, uri.toASCIIString()) : this.getService().saveProxy((IExternalProxy)workingProxy));
            }
        }
        if (savedState != null) {
            if (savedProxy == null) {
                savedProxy = this.getService().findProxybyExternalState(savedState);
            }
            if (savedProxy != null) {
                this.getService().synchronizeIncoming((IExternalProxyHandle)this.minimize((IItemHandle)savedProxy), (IExternalStateHandle)savedState, null, null);
            }
        }
        TeamRepository repository = (TeamRepository)this.teamRepository();
        ArrayList<IAuditable> sharedItems = new ArrayList<IAuditable>(2);
        if (savedProxy != null) {
            List items = repository.itemManager().applyItemUpdates(Collections.singletonList(savedProxy));
            sharedItems.add((IAuditable)items.get(0));
        } else {
            sharedItems.add((IAuditable)proxy);
        }
        if (savedState != null) {
            sharedItems.add((IAuditable)savedState);
        } else {
            sharedItems.add((IAuditable)xstate);
        }
        return sharedItems;
    }

    protected IItemHandle minimize(IItemHandle handle) {
        if (handle == null) {
            return null;
        }
        if (!handle.hasFullState() && !handle.hasStateId()) {
            return handle;
        }
        return handle.getItemType().createItemHandle(handle.getItemId(), null);
    }

    protected IInteropService getService() {
        return (IInteropService)this.fContext.getServiceInterface(IInteropService.class);
    }

    protected IProcessClientService processClient() {
        return (IProcessClientService)this.teamRepository().getClientLibrary(IProcessClientService.class);
    }

    private class DeleteSyncRuleRunnable
    extends ProcessRunnable {
        private final ISyncRuleHandle fSyncRuleHandle;

        public DeleteSyncRuleRunnable(ISyncRuleHandle syncRuleHandle) {
            this.fSyncRuleHandle = syncRuleHandle;
        }

        public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
            IOperationReport report = null;
            try {
                InteropManager.this.getService().deleteSyncRule(this.fSyncRuleHandle);
            }
            catch (TeamOperationCanceledException e) {
                report = e.getReport();
            }
            return report;
        }
    }

    private class SaveSyncRuleRunnable
    extends ProcessRunnable {
        private ISyncRule fSavedItem;
        private final ISyncRule fWorkingCopy;

        public SaveSyncRuleRunnable(ISyncRule workingCopy) {
            this.fWorkingCopy = workingCopy;
        }

        public ISyncRule getSavedItem() {
            return this.fSavedItem;
        }

        public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
            IItemsResponse response = InteropManager.this.getService().saveSyncRule(this.fWorkingCopy);
            this.fSavedItem = (ISyncRule)response.getFirstClientItem();
            return response.getOperationReport();
        }
    }
}

