/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.operations;

import com.ibm.team.connector.scm.operations.BuildResultUpdater;
import com.ibm.team.connector.scm.operations.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.PrintStream;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.WvcmException;

public class TaskDetailedFeedback
extends DetailedFeedback {
    private boolean _warningsOnly = false;
    private PrintStream _out;
    private boolean _activityDurationLoggingOn = false;
    private long _activityDurationStartTime = 0L;
    private String _currentActivityName;
    private BuildResultUpdater _buildResult;

    public TaskDetailedFeedback(BuildResultUpdater buildResult, boolean warningsOnly, PrintStream out) {
        this._buildResult = buildResult;
        this._warningsOnly = warningsOnly;
        this._out = out;
    }

    public TaskDetailedFeedback(BuildResultUpdater buildResult) {
        this(buildResult, false, System.out);
    }

    public TaskDetailedFeedback(PrintStream out) {
        this(null, false, out);
    }

    public BuildResultUpdater getBuildResult() {
        return this._buildResult;
    }

    public int get_last() {
        return this._last;
    }

    public PrintStream get_out() {
        return this._out;
    }

    public void notifyPercentComplete(int percentComplete) throws WvcmException {
        if (!this._warningsOnly) {
            super.notifyPercentComplete(percentComplete);
        }
    }

    public void notifyActive(String message) throws WvcmException {
        if (!this._warningsOnly) {
            if (this._activityDurationLoggingOn && this._activityDurationStartTime != 0L) {
                this.logActivityDuration();
            }
            this._out.println(message);
            if (this._activityDurationLoggingOn) {
                this._activityDurationStartTime = System.currentTimeMillis();
                this._currentActivityName = new String(message);
            }
            if (this._buildResult != null) {
                this._buildResult.startTopLevelActivity(message);
            }
            super.notifyActive(message);
        }
    }

    public void notifyNestedActive(String message) throws WvcmException {
        if (!this._warningsOnly) {
            this._out.println(NLS.bind((String)Messages.TaskDetailedFeedback_NESTED_MESSAGE, (Object)message, (Object[])new Object[0]));
            if (this._buildResult != null) {
                this._buildResult.startNestedActivity(message);
            }
        }
    }

    public void notifyWarning(String message) throws WvcmException {
        this._out.println(NLS.bind((String)Messages.TaskDetailedFeedback_WARNING, (Object)message, (Object[])new Object[0]));
        super.notifyWarning(message);
    }

    public void startActivityDurationLogging() {
        this._activityDurationLoggingOn = true;
        this._activityDurationStartTime = 0L;
    }

    public void stopActivityDurationLogging() {
        if (this._activityDurationLoggingOn && this._activityDurationStartTime != 0L) {
            this.logActivityDuration();
        }
        this._activityDurationLoggingOn = false;
    }

    private void logActivityDuration() {
        long activityDurationStopTime = System.currentTimeMillis();
        long duration = (activityDurationStopTime - this._activityDurationStartTime) / 1000L;
        String durationMessage = NLS.bind((String)Messages.TaskDetailedFeedback_ACTIVITY_DURATION, (Object)this._currentActivityName, (Object[])new Object[]{duration});
        this._out.println(durationMessage);
    }
}

