/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.operations;

import com.ibm.rational.wvcm.factory.PluginProviderFactory;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.connector.scm.cc.syncviabuild.BuildClientForCcSync;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.operations.BuildResultUpdater;
import com.ibm.team.connector.scm.operations.Messages;
import com.ibm.team.connector.scm.operations.TaskDetailedFeedback;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.service.IPermissionService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IWorkItemCommon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorOps {
    public static final String WVCM_JAZZ_PROVIDER_PATH = JzProvider.class.getName();
    private static final String EV_PREFIX = "com.ibm.team.connector.scm.operations.";
    public static final PropertyRequestItem.PropertyRequest PR_PATH_WS_PATH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE.nest(new PropertyRequestItem[]{Workspace.PATHNAME_LOCATION})});
    private static final int MAX_REFRESHES = 5;
    public static final PropertyRequestItem.PropertyRequest PR_NAMES = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION, Resource.DISPLAY_NAME});
    static Class<?>[] DEPENDENCIES = new Class[]{IAuditable.class, IFileSystemWorkItemManager.class, IInteropManager.class, ILinkManager.class, IProcessItemService.class, ITeamBuildClient.class, IWorkItemClient.class, IWorkItemCommon.class, ProviderFactory.class};
    public static final PropertyRequestItem.PropertyRequest ALL_JAZZ_STREAM_PROPERTIES = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.DISPLAY_NAME, Resource.PATHNAME_LOCATION, InteropStream.PN_INTEROP_STREAM});

    public static JzProvider createJazzProvider(String repositoryURI, String userId, String password) throws Exception {
        JzProvider jazzProvider = null;
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        JzProvider.validateNotEmpty((String)JzProvider.IA_REPOSITORY_URI, (String)repositoryURI);
        JzProvider.validateNotEmpty((String)"userId", (String)userId);
        JzProvider.validateNotNull((String)"password", (Object)password);
        Hashtable<String, String> initArgs = new Hashtable<String, String>();
        initArgs.put(JzProvider.IA_REPOSITORY_URI, repositoryURI);
        try {
            JzProvider.doLogin((String)repositoryURI, (String)userId, (String)password);
            jazzProvider = (JzProvider)PluginProviderFactory.pluginCreateProvider((String)WVCM_JAZZ_PROVIDER_PATH, null, initArgs);
            if (jazzProvider == null) {
                System.out.println("internal warning: plugin provider factory returned null");
                jazzProvider = (JzProvider)ProviderFactory.createProvider((String)WVCM_JAZZ_PROVIDER_PATH, null, initArgs);
            }
            JzProvider.validateNotNull((String)"jazzProvider", (Object)jazzProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return jazzProvider;
    }

    public static void synchronizeStream(InteropStream iStream, final TaskDetailedFeedback fb) throws WvcmException {
        boolean testingThrownExceptions;
        int refreshCount;
        BuildResultUpdater buildResultUpdater = fb.getBuildResult();
        JzProvider p = (JzProvider)iStream.thisProvider();
        if (buildResultUpdater != null) {
            InteropStream iStreamCopy;
            IBuildResult buildResult = buildResultUpdater.getBuildResult(null);
            String relativeLocationString = Location.itemLocation((IItemHandle)buildResult, null).toRelativeUri().toString();
            String storedBuildResultLocString = p.lookupBuildResultLocationString();
            if (storedBuildResultLocString == null || !storedBuildResultLocString.equals(relativeLocationString)) {
                if (storedBuildResultLocString == null) {
                    storedBuildResultLocString = "null";
                }
                fb.notifyActive(NLS.bind((String)Messages.ConnectorOps_UPDATING_BUILD_RESULT_ID_WITH_OLD_VALUE, (Object)storedBuildResultLocString, (Object[])new Object[0]));
                BuildClientForCcSync buildClient = new BuildClientForCcSync(iStream);
                buildClient.persistCurrentBuildResultId((IBuildResultHandle)buildResult, (Feedback)fb);
            }
            try {
                iStreamCopy = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_INIT_ARGS, "synchronizerProperties.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showProperties(iStreamCopy, writer, (Feedback)fb);
                    }
                });
            }
            catch (Exception e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_INIT_ARGS, (Object[])new Object[]{e.getMessage()}));
            }
            try {
                iStreamCopy = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_SYNCD_FILES_FOLDERS, "synchronizedFilesBeforeSync.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showSyncdFilesFolders(iStreamCopy, writer, fb);
                    }
                });
            }
            catch (Exception e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_SYNCD_FILES_FOLDERS, (Object[])new Object[]{e.getMessage()}));
            }
        }
        if ((refreshCount = 0) < 5) {
            try {
                try {
                    fb.startActivityDurationLogging();
                    iStream.doOperation((Feedback)fb);
                }
                finally {
                    fb.stopActivityDurationLogging();
                }
            }
            catch (WvcmException e) {
                if (!WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN.equals((Object)e.getReasonCode())) {
                    throw e;
                }
                fb.notifyActive(Messages.ConnectorOps_INFO_REFRESHING_INTEROPSTREAM);
                iStream = iStream.refresh((Feedback)fb);
            }
        }
        if (testingThrownExceptions = JzProvider.testingThrownException((String)"com.ibm.team.connector.scm.operations.forceSyncException")) {
            try {
                throw new WvcmException("Testing exception handling (first one)", WvcmException.ReasonCode.NOT_FOUND);
            }
            catch (WvcmException e) {
                if (buildResultUpdater != null) {
                    buildResultUpdater.contributeExceptionStackTrace(e);
                }
                throw new WvcmException("Testing exception handling (wrapper)", null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)e);
            }
        }
        boolean syncEndedWithoutConflicts = iStream.get_state().equals((Object)InteropStream.InteropStreamState.OK);
        if (buildResultUpdater != null) {
            InteropStream iStreamCopy;
            try {
                iStreamCopy = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_INFO_SFF_AFTER_SYNC, "synchronizedFilesAfterSync.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showSyncdFilesFolders(iStreamCopy, writer, fb);
                    }
                });
            }
            catch (Exception e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_INFO_SFF_AFTER_SYNC, (Object[])new Object[]{e.getMessage()}));
            }
            try {
                iStreamCopy = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_SYNC_STATS, "synchronizerStatistics.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showCollectedSyncStats(iStreamCopy, writer, null, fb);
                    }
                });
            }
            catch (Exception e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_SYNC_STATS, (Object[])new Object[]{e.getMessage()}));
            }
            buildResultUpdater.setCompletionStatus(syncEndedWithoutConflicts);
        }
        ConnectorOps.showCollectedSyncStats(iStream, null, fb.get_out(), fb);
        String completionMessage = syncEndedWithoutConflicts ? Messages.ConnectorOps_STATUS_SYNC_COMPLETE_NO_CONFLICTS : Messages.ConnectorOps_STATUS_SYNC_COMPLETE_WITH_CONFLICTS;
        fb.notifyActive(completionMessage);
    }

    public static Stream lookupStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        JzProvider.validateNotEmpty((String)"syncStreamLocationString", (String)syncStreamLocationString);
        JzLocation syncStreamLocation = jazzProvider.location(syncStreamLocationString);
        JzProvider.validateNotNull((String)"syncStreamLocation", (Object)syncStreamLocation);
        Stream syncStream = ConnectorOps.resolveStream(jazzProvider, (javax.wvcm.Location)syncStreamLocation, f);
        return syncStream;
    }

    public static InteropStream lookupInteropStream(JzProvider provider, String syncStreamLocationString, Feedback f) throws WvcmException {
        Stream syncStream = ConnectorOps.lookupStream(provider, syncStreamLocationString, f);
        InteropStream iStream = InteropStream.getInteropStream((Stream)syncStream, (Feedback)f);
        return iStream;
    }

    public static String getBVNMessage(JzProvider provider, String packageName) {
        return NLS.bind((String)Messages.ConnectorOps_SYNCHRONIZER_VERSION_NUMBER, (Object)ConnectorOps.getVersionNumber(provider, packageName), (Object[])new Object[0]);
    }

    private static String getVersionNumber(JzProvider provider, String packageName) {
        String result = ConnectorOps.getBundleVersionNumber(packageName);
        if (result == null) {
            result = ConnectorOps.getVersionNumberFromInstallLocation(provider);
        }
        if (result == null) {
            return Messages.ConnectorOps_UNKNOWN;
        }
        return result;
    }

    private static String getVersionNumberFromInstallLocation(JzProvider provider) {
        String result;
        block6: {
            result = null;
            File buildId = new File(new File(provider.getInstallLocation(), "ScmConnectors"), "buildId.txt");
            try {
                if (!buildId.exists()) break block6;
                FileReader r = new FileReader(buildId);
                BufferedReader br = new BufferedReader(r);
                try {
                    result = br.readLine();
                }
                finally {
                    br.close();
                    r.close();
                }
            }
            catch (FileNotFoundException e) {
                provider.logIgnoredExceptionAsAlwaysVisible("ConnectorOps.getVersionNumberFromInstallLocation", (Exception)e);
            }
            catch (IOException e) {
                provider.logIgnoredExceptionAsAlwaysVisible("ConnectorOps.getVersionNumberFromInstallLocation", (Exception)e);
            }
        }
        return result;
    }

    private static String getBundleVersionNumber(String packageName) {
        Bundle bundle = Platform.getBundle((String)packageName);
        if (bundle == null) {
            return null;
        }
        Dictionary headers = bundle.getHeaders();
        if (headers == null) {
            return null;
        }
        String bundleVersion = (String)headers.get("Bundle-Version");
        if (bundleVersion == null) {
            return null;
        }
        return bundleVersion;
    }

    public static Stream resolveStream(JzProvider provider, javax.wvcm.Location syncStreamLocation, Feedback feedback) throws WvcmException {
        SrvcFeedback sf = provider.srvcFeedback(feedback);
        JzRepoResource result = provider.lookup(syncStreamLocation, sf);
        if (result != null) {
            return (Stream)result.buildProxy(PR_NAMES, sf);
        }
        return JzRepoStream.lookupStreamByName((JzProvider)provider, (String)syncStreamLocation.string(), (PropertyRequestItem.PropertyRequest)PR_NAMES, (SrvcFeedback)sf);
    }

    public static int listOrUnlinkClones(JzProvider provider, boolean hasRemoveOption, boolean verbose) throws WvcmException {
        System.out.println(ConnectorOps.getBVNMessage(provider, "com.ibm.team.connector.scm.operations"));
        if (hasRemoveOption) {
            IClientLibraryContext context = (IClientLibraryContext)provider.getRepo();
            IPermissionService service = (IPermissionService)context.getServiceInterface(IPermissionService.class);
            try {
                service.assertPermission("JazzAdmins");
            }
            catch (PermissionDeniedException e) {
                throw new WvcmException(Messages.ConnectorOps_ERROR_REMOVE_LINKS_JAZZ_PERMISSIONS, null, WvcmException.ReasonCode.UNAUTHORIZED, (Throwable)e);
            }
        }
        final ILinkManager linkManager = JzRepoResource.getLinkManager((JzProvider)provider);
        try {
            JzRepoResource.CountingVisitor countingVisitor = hasRemoveOption ? new JzRepoResource.CountingVisitor(verbose){

                public boolean visit(ILink cloneLink) throws WvcmException {
                    super.visit(cloneLink);
                    try {
                        linkManager.deleteLink(cloneLink, null);
                    }
                    catch (TeamRepositoryException e) {
                        throw new WvcmException(Messages.ConnectorOps_ERROR_DELETION_FAILED, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                    }
                    return true;
                }
            } : new JzRepoResource.CountingVisitor(verbose);
            JzRepoResource.forEachCloneLink((JzProvider)provider, (JzRepoResource.IVisitCloneLink)countingVisitor);
            int matches = countingVisitor.getMatches();
            System.out.println(NLS.bind((String)(hasRemoveOption ? Messages.ConnectorOps_INFO_REMOVED_LINKS_WITH_COUNT : Messages.ConnectorOps_INFO_CLONE_LINKS_FOUND_COUNT), (Object)matches, (Object[])new Object[0]));
            return matches;
        }
        catch (WvcmException e) {
            throw new RuntimeException(NLS.bind((String)Messages.ConnectorOps_ERROR_COMMAND_FAILED, (Object)"clones", (Object[])new Object[0]), e);
        }
    }

    public static void checkDependencies(JzProvider provider, boolean verbose) {
        ITeamRepository repo = provider.getRepo();
        Class<?>[] classArray = DEPENDENCIES;
        int n = DEPENDENCIES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            repo.getClientLibrary(c);
            if (verbose) {
                System.out.println(NLS.bind((String)Messages.ConnectorOps_LOADED_CLASS, (Object)c.getName(), (Object[])new Object[0]));
            }
            ++n2;
        }
        System.out.println(Messages.ConnectorOps_DEPS_OK);
    }

    public static void logout(JzProvider provider) {
        ITeamRepository repo;
        ITeamRepository iTeamRepository = repo = provider != null ? provider.getRepo() : null;
        if (repo != null) {
            repo.logout();
        }
    }

    public static List<Stream> getSynchronizedStreamsInMyProcessAreas(JzProvider provider, Feedback feedback) throws WvcmException {
        ArrayList<Stream> results = new ArrayList<Stream>();
        List<Stream> streams = ConnectorOps.lookupStreamsInMyProcessAreas(provider, ALL_JAZZ_STREAM_PROPERTIES, feedback);
        if (streams != null) {
            for (Stream stream : streams) {
                if (stream.lookupProperty(InteropStream.PN_INTEROP_STREAM) == null) continue;
                results.add(stream);
            }
        }
        return results;
    }

    public static List<Stream> lookupStreamsInMyProcessAreas(JzProvider provider, PropertyRequestItem.PropertyRequest propertyRequest, Feedback feedback) throws WvcmException {
        List<IProcessArea> teamAreas = ConnectorOps.findProcessAreasFor(provider, provider.getRepo().loggedInContributor());
        ArrayList<IProcessAreaHandle> teamAreaHandles = new ArrayList<IProcessAreaHandle>(teamAreas.size());
        for (IProcessArea teamArea : teamAreas) {
            teamAreaHandles.add((IProcessAreaHandle)teamArea.getItemHandle());
        }
        List results = teamAreaHandles.size() == 0 ? null : provider.findStreams(teamAreaHandles, propertyRequest, provider.srvcFeedback(feedback));
        return results;
    }

    public static List<IProcessArea> findProcessAreasFor(JzProvider provider, IContributor contributor) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        try {
            IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
            return ConnectorOps.findProcessAreasFor(contributor, itemService);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    public static List<IProcessArea> findProcessAreasFor(IContributor contributor, IProcessItemService itemService) throws TeamRepositoryException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        List processAreas = itemService.findProcessAreas(contributor, null, IProcessClientService.ALL_PROPERTIES, (IProgressMonitor)monitor);
        return processAreas;
    }

    public static Stream getStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        Stream syncStream = ConnectorOps.lookupStream(jazzProvider, syncStreamLocationString, f);
        if (syncStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_RESOLVE_TO_WVCM_STREAM_WITH_NAME, (Object)syncStreamLocationString, (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return syncStream;
    }

    public static InteropStream getInteropStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        Stream syncStream = ConnectorOps.getStream(jazzProvider, syncStreamLocationString, f);
        InteropStream iStream = ConnectorOps.getInteropStream(syncStreamLocationString, syncStream, f);
        return iStream;
    }

    public static InteropStream getInteropStream(String syncStreamLocationString, Stream stream, Feedback f) throws WvcmException {
        InteropStream iStream = InteropStream.getInteropStream((Stream)stream, (Feedback)f);
        if (iStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_RESOLVE_TO_SYNC_STREAM_WITH_NAME, (Object)syncStreamLocationString, (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return iStream;
    }

    public static List<InteropStream> getInteropStreams(JzProvider provider, boolean locallySyncd, String thisHostname, Feedback feedback) throws WvcmException {
        ArrayList<InteropStream> results = new ArrayList<InteropStream>();
        List<Stream> synchronizedStreams = ConnectorOps.getSynchronizedStreamsInMyProcessAreas(provider, feedback);
        for (Stream stream : synchronizedStreams) {
            InteropStream interopStream = InteropStream.getInteropStream((Stream)stream, (Feedback)feedback);
            String streamsSyncHost = JzProvider.getSyncHost((Map)interopStream.thisProvider().initArgs());
            if (locallySyncd && !streamsSyncHost.equalsIgnoreCase(thisHostname)) continue;
            results.add(interopStream);
        }
        return results;
    }

    public static List<String> getSyncRoots(boolean getOther, InteropStream stream, Feedback feedback) throws WvcmException {
        Workspace ws = getOther ? stream.otherSyncWs() : stream.thisCloneWs();
        List syncRoots = getOther ? stream.otherSyncRoots(ws, feedback) : stream.thisSyncRoots(ws, feedback);
        ArrayList<String> results = new ArrayList<String>(syncRoots.size());
        for (ControllableResource root : syncRoots) {
            if (root == null) continue;
            results.add(ConnectorOps.getWorkspaceRelativePath(root));
        }
        return results;
    }

    public static String getWorkspaceRelativePath(ControllableResource crArg) throws WvcmException {
        return ConnectorOps.getWorkspaceRelativePath(crArg, File.separator);
    }

    public static String getWorkspaceRelativePath(ControllableResource crArg, String separator) throws WvcmException {
        javax.wvcm.Location wsPathname;
        ControllableResource cr = (ControllableResource)crArg.doReadProperties((Feedback)PR_PATH_WS_PATH);
        javax.wvcm.Location crPathname = cr.getPathnameLocation();
        if (crPathname.equals(wsPathname = cr.getWorkspace().getPathnameLocation())) {
            return ".";
        }
        String path = crPathname.lastSegment();
        javax.wvcm.Location location = crPathname.parent();
        while (!location.equals(wsPathname)) {
            path = String.valueOf(location.lastSegment()) + separator + path;
            location = location.parent();
        }
        return path;
    }

    public static void upgradeSyncStream(InteropStream interopStream, Feedback fb) throws WvcmException {
        BuildClientForCcSync client = new BuildClientForCcSync(interopStream);
        client.upgradeSyncStream(fb);
    }

    public static void showProperties(InteropStream interopStream, PrintWriter output, Feedback fb) throws WvcmException {
        output.println("Jazz properties:");
        ConnectorOps.printProperties(interopStream.thisProvider().initArgs(), output);
        output.println("ClearCase properties:");
        ConnectorOps.printProperties(interopStream.otherProvider().initArgs(), output);
        output.flush();
    }

    public static void printProperties(Map<String, String> thisProperties, PrintWriter writer) throws WvcmException {
        Object[] keys = thisProperties.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            writer.println(NLS.bind((String)"{0}: {1}", (Object)key, (Object[])new Object[]{thisProperties.get(key)}));
            ++n2;
        }
    }

    public static int showSyncdFilesFolders(InteropStream stream, PrintWriter writer, TaskDetailedFeedback fb) throws WvcmException {
        int otherRootsSize;
        writer.println(NLS.bind((String)"{0}: ", stream.thisProvider().initArgs().get("com.ibm.rational.wvcm.DISPLAYNAME"), (Object[])new Object[0]));
        List<String> roots = ConnectorOps.getSyncRoots(false, stream, (Feedback)fb);
        int result = otherRootsSize = roots.size();
        if (result == 0) {
            writer.println(Messages.ConnectorOps_INFO_NONE);
        } else {
            for (String root : roots) {
                writer.println(root);
            }
        }
        writer.println();
        writer.flush();
        writer.println(NLS.bind((String)"{0}: ", stream.otherProvider().initArgs().get("com.ibm.rational.wvcm.DISPLAYNAME"), (Object[])new Object[0]));
        roots = ConnectorOps.getSyncRoots(true, stream, (Feedback)fb);
        result += otherRootsSize;
        if (otherRootsSize == 0) {
            writer.println(Messages.ConnectorOps_INFO_NONE);
        } else {
            for (String root : roots) {
                writer.println(root);
            }
        }
        writer.flush();
        return result;
    }

    public static void showCollectedSyncStats(InteropStream iStream, PrintWriter writer, PrintStream stream, TaskDetailedFeedback fb) throws WvcmException {
        InteropStream.SyncStats thisCollector = iStream.getThisSyncStats();
        InteropStream.SyncStats otherCollector = iStream.getOtherSyncStats();
        String thisProviderName = NLS.bind((String)"{0}: ", iStream.thisProvider().initArgs().get("com.ibm.rational.wvcm.DISPLAYNAME"), (Object[])new Object[0]);
        String thisNumFilesCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_CREATED, (Object)thisCollector.getAmount(InteropStream.SyncStatType.FILES_CREATED), (Object[])new Object[0]);
        String thisNumFilesUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_UPDATED, (Object)thisCollector.getAmount(InteropStream.SyncStatType.FILES_UPDATED), (Object[])new Object[0]);
        String thisNumFoldersCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_CREATED, (Object)thisCollector.getAmount(InteropStream.SyncStatType.FOLDERS_CREATED), (Object[])new Object[0]);
        String thisNumFoldersUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_UPDATED, (Object)thisCollector.getAmount(InteropStream.SyncStatType.FOLDERS_UPDATED), (Object[])new Object[0]);
        String thisNumSymlinksCreated = NLS.bind((String)Messages.ConnectorOps_NUM_SYMLINKS_CREATED, (Object)thisCollector.getAmount(InteropStream.SyncStatType.SYMLINKS_CREATED), (Object[])new Object[0]);
        String otherProviderName = NLS.bind((String)"{0}: ", iStream.otherProvider().initArgs().get("com.ibm.rational.wvcm.DISPLAYNAME"), (Object[])new Object[0]);
        String otherNumFilesCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_CREATED, (Object)otherCollector.getAmount(InteropStream.SyncStatType.FILES_CREATED), (Object[])new Object[0]);
        String otherNumFilesUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_UPDATED, (Object)otherCollector.getAmount(InteropStream.SyncStatType.FILES_UPDATED), (Object[])new Object[0]);
        String otherNumFoldersCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_CREATED, (Object)otherCollector.getAmount(InteropStream.SyncStatType.FOLDERS_CREATED), (Object[])new Object[0]);
        String otherNumFoldersUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_UPDATED, (Object)otherCollector.getAmount(InteropStream.SyncStatType.FOLDERS_UPDATED), (Object[])new Object[0]);
        String otherNumSymlinksCreated = NLS.bind((String)Messages.ConnectorOps_NUM_SYMLINKS_CREATED, (Object)otherCollector.getAmount(InteropStream.SyncStatType.SYMLINKS_CREATED), (Object[])new Object[0]);
        if (writer != null) {
            writer.println(thisProviderName);
            writer.println(thisNumFilesCreated);
            writer.println(thisNumFilesUpdated);
            writer.println(thisNumFoldersCreated);
            writer.println(thisNumFoldersUpdated);
            writer.println(thisNumSymlinksCreated);
            writer.println();
            writer.flush();
            writer.println(otherProviderName);
            writer.println(otherNumFilesCreated);
            writer.println(otherNumFilesUpdated);
            writer.println(otherNumFoldersCreated);
            writer.println(otherNumFoldersUpdated);
            writer.println(otherNumSymlinksCreated);
            writer.flush();
        } else if (stream != null) {
            stream.println(thisProviderName);
            stream.println(thisNumFilesCreated);
            stream.println(thisNumFilesUpdated);
            stream.println(thisNumFoldersCreated);
            stream.println(thisNumFoldersUpdated);
            stream.println(thisNumSymlinksCreated);
            stream.flush();
            stream.println(otherProviderName);
            stream.println(otherNumFilesCreated);
            stream.println(otherNumFilesUpdated);
            stream.println(otherNumFoldersCreated);
            stream.println(otherNumFoldersUpdated);
            stream.println(otherNumSymlinksCreated);
            stream.flush();
        }
    }
}

