/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.workitems.internal.process;

import com.ibm.team.filesystem.common.workitems.internal.process.Messages;
import com.ibm.team.filesystem.common.workitems.internal.process.RequireWorkItemApprovalProblemObject;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.ProcessProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RequireWorkItemApprovalAdvisor
implements IOperationAdvisor {
    private static String ELEMENT_REQUIRES = "requires";
    private static String ELEMENT_APPROVAL = "approval";
    private static String ELEMENT_APPROVERS = "approvers";
    private static String ATTR_TYPE = "type";
    private static String ATTR_ROLE = "role";
    private static String ATTR_NUMBER_OF_APPROVERS = "number-of-approvers";
    public static String VAL_REVIEW = "Review";
    public static String VAL_APPROVAL = "Approval";
    public static String VAL_VERIFICATION = "Verification";
    public static String VAL_DEFAULT_ROLE = "default";
    public static final String ID_APPROVAL_ADVISOR = "com.ibm.team.process.deliver.requireWorkItemApproval";
    public static final String ID_APPROVAL_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemApprovalProblem";
    public static final String ID_CONFIGURATION_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemApproval.configurationProblem";
    private List fRequirements = new ArrayList();
    private ProviderFactory provider;
    private ItemProvider items;
    private ProcessProvider process;

    public RequireWorkItemApprovalAdvisor(ProviderFactory provider) {
        this.provider = provider;
        this.items = provider.getItemProvider();
        this.process = provider.getProcessProvider();
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object opData = operation.getOperationData();
        if (!(opData instanceof DeliverOperationData)) {
            return;
        }
        DeliverOperationData data = (DeliverOperationData)opData;
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.0"), 1000);
        try {
            try {
                this.initialize(advisorConfiguration);
                IProcessArea handle = operation.getProcessArea();
                IProcessArea processArea = (IProcessArea)this.items.fetchItem((IManagedItemHandle)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                if (data.getChangeSetHandles().size() > 0) {
                    this.addProblems(data, processArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
                }
            }
            catch (TeamRepositoryException e) {
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemApprovalAdvisor.1"), (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void initialize(IProcessConfigurationElement advisorConfiguration) {
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String childName = child.getName();
            if (ELEMENT_REQUIRES.equals(childName)) {
                IProcessConfigurationElement[] children2 = child.getChildren();
                int j = 0;
                while (j < children2.length) {
                    IProcessConfigurationElement child2 = children2[j];
                    String child2Name = child2.getName();
                    if (ELEMENT_APPROVAL.equals(child2Name)) {
                        String approvalType = child2.getAttribute(ATTR_TYPE);
                        ArrayList<Approvers> allApprovers = new ArrayList<Approvers>();
                        IProcessConfigurationElement[] children3 = child2.getChildren();
                        int k = 0;
                        while (k < children3.length) {
                            IProcessConfigurationElement child3 = children3[k];
                            String child3Name = child3.getName();
                            if (ELEMENT_APPROVERS.equals(child3Name)) {
                                Approvers approvers = new Approvers();
                                approvers.role = child3.getAttribute(ATTR_ROLE);
                                String numberString = child3.getAttribute(ATTR_NUMBER_OF_APPROVERS);
                                try {
                                    approvers.numberOfApprovers = Integer.parseInt(numberString);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    approvers.numberOfApprovers = 1;
                                }
                                allApprovers.add(approvers);
                            }
                            ++k;
                        }
                        Requirement requirement = new Requirement();
                        requirement.type = approvalType;
                        requirement.approvers = allApprovers.toArray(new Approvers[allApprovers.size()]);
                        this.fRequirements.add(requirement);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addProblems(DeliverOperationData data, IProcessArea processArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000 * (data.getChangeSetHandles().size() + 3));
        try {
            if (!this.checkRequirementsSpecification(processArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) {
                return;
            }
            Map links = ChangeSetLinks.resolveLinks((ProviderFactory)this.provider, (List)data.getChangeSetHandles(), (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            for (IChangeSet changeSet : links.keySet()) {
                ArrayList<IAuditable> workItemHandles = new ArrayList<IAuditable>();
                if (changeSet != null) {
                    List linkTargets = (List)links.get(changeSet);
                    for (IAuditable referencedItem : linkTargets) {
                        if (!(referencedItem instanceof IWorkItemHandle)) continue;
                        workItemHandles.add(referencedItem);
                    }
                }
                this.addProblem(data, workItemHandles, changeSet, collector, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean checkRequirementsSpecification(IProcessArea processArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.2"), 500);
        try {
            IRole[] roles = this.process.getRoles(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            boolean succeeded = true;
            for (Requirement requirement : this.fRequirements) {
                if (!this.isValidTypeValue(requirement.type)) {
                    collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemApprovalAdvisor.3"), NLS.bind((String)Messages.getString("RequireWorkItemApprovalAdvisor.4"), (Object[])new Object[]{VAL_APPROVAL, VAL_REVIEW, VAL_VERIFICATION}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
                    succeeded = false;
                }
                int i = 0;
                while (i < requirement.approvers.length) {
                    Approvers approvers = requirement.approvers[i];
                    if (!this.isValidRoleValue(approvers.role, roles)) {
                        collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemApprovalAdvisor.5"), Messages.getString("RequireWorkItemApprovalAdvisor.6"), ID_CONFIGURATION_PROBLEM));
                        succeeded = false;
                    }
                    ++i;
                }
            }
            boolean bl = succeeded;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isValidTypeValue(String typeValue) {
        return VAL_APPROVAL.equals(typeValue) || VAL_REVIEW.equals(typeValue) || VAL_VERIFICATION.equals(typeValue);
    }

    private boolean isValidRoleValue(String roleValue, IRole[] definedRoles) {
        return VAL_DEFAULT_ROLE.equals(roleValue) || this.isDefinedRole(roleValue, definedRoles);
    }

    private boolean isDefinedRole(String roleValue, IRole[] definedRoles) {
        int i = 0;
        while (i < definedRoles.length) {
            if (definedRoles[i].getId().equals(roleValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addProblem(DeliverOperationData data, List workItems, IChangeSet changeSet, IAdvisorInfoCollector collector, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.7"), 1000);
        try {
            if (workItems == null || workItems.isEmpty()) {
                collector.addInfo((IReportInfo)this.createProblem(Messages.getString("RequireWorkItemApprovalAdvisor.8"), Messages.getString("RequireWorkItemApprovalAdvisor.9"), collector, data, changeSet, workItems, processArea));
                return;
            }
            workItems = this.items.fetchItems(workItems, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            ListIterator iterator = workItems.listIterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemApprovalAdvisor.10"), (Throwable)new TeamRepositoryException(Messages.getString("RequireWorkItemApprovalAdvisor.11"))));
                iterator.remove();
            }
            String approvalProblem = this.checkApprovals(workItems, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
            if (approvalProblem != null && approvalProblem.trim().length() > 0) {
                IAdvisorInfo info = this.createProblem(Messages.getString("RequireWorkItemApprovalAdvisor.12"), approvalProblem, collector, data, changeSet, workItems, processArea);
                collector.addInfo((IReportInfo)info);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IAdvisorInfo createProblem(String summary, String description, IAdvisorInfoCollector collector, DeliverOperationData data, IChangeSet changeSet, List workItems, IProcessArea processArea) {
        RequireWorkItemApprovalProblemObject object = new RequireWorkItemApprovalProblemObject(data, changeSet, workItems, processArea);
        IAdvisorInfo problem = collector.createProblemInfo(summary, description, ID_APPROVAL_PROBLEM);
        problem.setProblemObject((Object)object);
        return problem;
    }

    private String checkApprovals(List workItems, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.13"), numWorkItems * 1000);
        StringBuffer workItemNumbers = new StringBuffer();
        try {
            for (IWorkItem workItem : workItems) {
                if (this.hasRequiredApprovals(workItem, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) {
                    return null;
                }
                if (workItemNumbers.length() != 0) {
                    workItemNumbers.append(", ");
                }
                workItemNumbers.append(workItem.getId());
            }
        }
        finally {
            monitor.done();
        }
        if (numWorkItems == 1) {
            return NLS.bind((String)Messages.getString("RequireWorkItemApprovalAdvisor.14"), (Object)workItemNumbers.toString(), (Object[])new Object[0]);
        }
        return NLS.bind((String)Messages.getString("RequireWorkItemApprovalAdvisor.15"), (Object)workItemNumbers.toString(), (Object[])new Object[0]);
    }

    private boolean hasRequiredApprovals(IWorkItem workItem, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.16"), this.fRequirements.size() * 1000);
        try {
            for (Requirement requirement : this.fRequirements) {
                if (this.meetsRequirement(requirement, workItem, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return false;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private boolean meetsRequirement(Requirement requirement, IWorkItem workItem, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IApprovalType requiredType = this.getApprovalType(requirement);
        if (requiredType != null) {
            IApprovals approvals = workItem.getApprovals();
            List descriptors = approvals.getDescriptors();
            Approvers[] approvers = requirement.approvers;
            monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.17"), 1000 * descriptors.size() * approvers.length);
            try {
                block4: for (IApprovalDescriptor descriptor : descriptors) {
                    IApprovalType actualType = WorkItemApprovals.getType((String)descriptor.getTypeIdentifier());
                    if (requiredType == actualType) {
                        int i = 0;
                        while (i < approvers.length) {
                            if (!this.checkRequiredApprovers(approvers[i], approvals, descriptor, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue block4;
                            ++i;
                        }
                        return true;
                    }
                    monitor.worked(1000 * approvers.length);
                }
            }
            finally {
                monitor.done();
            }
        }
        return false;
    }

    private boolean checkRequiredApprovers(Approvers approvers, IApprovals approvals, IApprovalDescriptor descriptor, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        List contents = approvals.getContents(descriptor);
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.18"), contents.size() * 1000);
        try {
            int missingApprovers = approvers.numberOfApprovers;
            for (IApproval approval : contents) {
                IApprovalState state = WorkItemApprovals.getState((String)approval.getStateIdentifier());
                if (WorkItemApprovals.APPROVED_STATE != state) continue;
                IContributorHandle handle = approval.getApprover();
                IRole[] contributorRoles = this.process.getContributorRoles(handle, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                int i = 0;
                while (i < contributorRoles.length) {
                    IRole role = contributorRoles[i];
                    if (approvers.role.equals(role.getId()) && --missingApprovers == 0) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private IApprovalType getApprovalType(Requirement requirement) {
        if (VAL_APPROVAL.equals(requirement.type)) {
            return WorkItemApprovals.APPROVAL_TYPE;
        }
        if (VAL_REVIEW.equals(requirement.type)) {
            return WorkItemApprovals.REVIEW_TYPE;
        }
        if (VAL_VERIFICATION.equals(requirement.type)) {
            return WorkItemApprovals.VERIFICATION_TYPE;
        }
        return null;
    }

    private static class Approvers {
        public String role;
        public int numberOfApprovers;

        private Approvers() {
        }
    }

    private static class Requirement {
        public String type;
        public Approvers[] approvers;

        private Requirement() {
        }
    }
}

