/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.workitems.internal.process;

import com.ibm.team.filesystem.common.workitems.internal.process.Messages;
import com.ibm.team.filesystem.common.workitems.internal.process.RequireWorkItemProblemObject;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.ProcessProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RequireWorkItemAdvisor
implements IOperationAdvisor {
    private static String ELEMENT_REQUIRES = "requires";
    private static String ATTR_VALUE = "value";
    public static String VAL_WORKITEM = "workitem";
    public static String VAL_COMMENT = "comment";
    public static String VAL_WORKITEM_OR_COMMENT = "workitem-or-comment";
    public static String VAL_WORKITEM_AND_COMMENT = "workitem-and-comment";
    private static String ELEMENT_WORKITEM = "workitem";
    private static String ATTR_TARGET = "target";
    private static String ATTR_OWNER = "owner";
    private static String VAL_REQUIRED = "required";
    private static String VAL_OPTIONAL = "optional";
    private static String VAL_CURRENT_ITERATION = "current-iteration";
    private static String VAL_CURRENT_CONTRIBUTOR = "current-contributor";
    public static final String ID_REQUIRE_WORK_ITEM_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemProblem";
    public static final String ID_CONFIGURATION_PROBLEM = "com.ibm.team.process.definitions.requireWorkItem.configurationProblem";
    private String fRequires = VAL_WORKITEM;
    private String fTarget = VAL_OPTIONAL;
    private String fOwner = VAL_OPTIONAL;
    private final ProviderFactory provider;
    private ItemProvider items;
    private ProcessProvider process;

    public RequireWorkItemAdvisor(ProviderFactory provider) {
        this.provider = provider;
        this.items = provider.getItemProvider();
        this.process = provider.getProcessProvider();
    }

    private void initialize(IProcessConfigurationElement advisorConfiguration) {
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String childName = child.getName();
            if (ELEMENT_REQUIRES.equals(childName)) {
                this.fRequires = child.getAttribute(ATTR_VALUE);
                IProcessConfigurationElement[] grandChildren = child.getChildren();
                int j = 0;
                while (j < grandChildren.length) {
                    IProcessConfigurationElement grandChild = grandChildren[j];
                    String grandChildName = grandChild.getName();
                    if (ELEMENT_WORKITEM.equals(grandChildName)) {
                        this.fTarget = grandChild.getAttribute(ATTR_TARGET);
                        this.fOwner = grandChild.getAttribute(ATTR_OWNER);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object opData = operation.getOperationData();
        if (!(opData instanceof DeliverOperationData)) {
            return;
        }
        DeliverOperationData data = (DeliverOperationData)opData;
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.PROGRESS"), 1000);
        try {
            try {
                this.initialize(advisorConfiguration);
                IProcessArea processArea = operation.getProcessArea();
                IProjectAreaHandle handle = processArea.getProjectArea();
                IProjectArea projectArea = (IProjectArea)this.items.fetchItem((IManagedItemHandle)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                if (data.getChangeSetHandles().size() > 0 || data.getAtomicUpdateParm() != null && data.getAtomicUpdateComment() == null) {
                    this.addProblems(data, processArea, projectArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
                }
            }
            catch (TeamRepositoryException e) {
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemAdvisor.ERROR_MSG"), (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addProblems(DeliverOperationData data, IProcessArea processArea, IProjectArea projectArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (data.getChangeSetHandles().size() == 0) {
            monitor.beginTask("", 1000);
        } else {
            monitor.beginTask("", 1000 * data.getChangeSetHandles().size() + 1);
        }
        try {
            if (!this.isValidRequiresValue(this.fRequires)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemAdvisor.INTERNAL_CONFIGURATION_ERROR"), NLS.bind((String)Messages.getString("RequireWorkItemAdvisor.3"), (Object[])new Object[]{VAL_WORKITEM, VAL_COMMENT, VAL_WORKITEM_OR_COMMENT, VAL_WORKITEM_AND_COMMENT}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
                monitor.done();
                return;
            }
            if (!this.isValidTargetValue(this.fTarget)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemAdvisor.INTERNAL_CONFIGURATION_ERROR"), NLS.bind((String)Messages.getString("RequireWorkItemAdvisor.5"), (Object[])new Object[]{VAL_OPTIONAL, VAL_REQUIRED, VAL_CURRENT_ITERATION}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
            }
            if (!this.isValidOwnerValue(this.fOwner)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemAdvisor.INTERNAL_CONFIGURATION_ERROR"), NLS.bind((String)Messages.getString("RequireWorkItemAdvisor.7"), (Object[])new Object[]{VAL_OPTIONAL, VAL_REQUIRED, VAL_CURRENT_CONTRIBUTOR}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
            }
            if (data.getChangeSetHandles().size() == 0) {
                this.addProblem(data, data.getAtomicUpdateComment(), Collections.EMPTY_LIST, null, collector, projectArea, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            Map links = ChangeSetLinks.resolveLinks((ProviderFactory)this.provider, (List)data.getChangeSetHandles(), (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            for (IChangeSet changeSet : links.keySet()) {
                String comment = null;
                ArrayList<IAuditable> workItemHandles = new ArrayList<IAuditable>();
                if (changeSet != null) {
                    comment = changeSet.getComment();
                    List linkTargets = (List)links.get(changeSet);
                    for (IAuditable referencedItem : linkTargets) {
                        if (!(referencedItem instanceof IWorkItemHandle)) continue;
                        workItemHandles.add(referencedItem);
                    }
                }
                this.addProblem(data, comment, workItemHandles, changeSet, collector, projectArea, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        }
        finally {
            monitor.done();
        }
    }

    private IAdvisorInfo createProblem(String summary, String description, IAdvisorInfoCollector collector, DeliverOperationData data, IChangeSet changeSet, List workItems, IProjectArea projectArea, boolean isNeedTarget, boolean isNeedOwner) {
        RequireWorkItemProblemObject object = new RequireWorkItemProblemObject(data, changeSet, workItems, projectArea, this.fRequires, isNeedTarget, isNeedOwner);
        IAdvisorInfo problem = collector.createProblemInfo(summary, description, ID_REQUIRE_WORK_ITEM_PROBLEM);
        problem.setProblemObject((Object)object);
        return problem;
    }

    private boolean isValidRequiresValue(String requiresValue) {
        return VAL_WORKITEM.equals(requiresValue) || VAL_COMMENT.equals(requiresValue) || VAL_WORKITEM_OR_COMMENT.equals(requiresValue) || VAL_WORKITEM_AND_COMMENT.equals(requiresValue);
    }

    private boolean isValidTargetValue(String targetValue) {
        return VAL_OPTIONAL.equals(targetValue) || VAL_REQUIRED.equals(targetValue) || VAL_CURRENT_ITERATION.equals(targetValue);
    }

    private boolean isValidOwnerValue(String ownerValue) {
        return VAL_OPTIONAL.equals(ownerValue) || VAL_REQUIRED.equals(ownerValue) || VAL_CURRENT_CONTRIBUTOR.equals(ownerValue);
    }

    private void addProblem(DeliverOperationData data, String comment, List workItems, IChangeSet changeSet, IAdvisorInfoCollector collector, IProjectArea projectArea, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.8"), 1000);
        try {
            boolean hasWorkitems = workItems != null && !workItems.isEmpty();
            boolean hasComment = comment != null && comment.trim().length() > 0;
            String problemSummary = null;
            String problemDetail = null;
            if (VAL_WORKITEM_AND_COMMENT.equals(this.fRequires) && !hasWorkitems && !hasComment) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.9");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.10");
            } else if ((VAL_WORKITEM_AND_COMMENT.equals(this.fRequires) || VAL_WORKITEM.equals(this.fRequires)) && !hasWorkitems) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.11");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.12");
            } else if ((VAL_WORKITEM_AND_COMMENT.equals(this.fRequires) || VAL_COMMENT.equals(this.fRequires)) && !hasComment) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.13");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.14");
            } else if (VAL_WORKITEM_OR_COMMENT.equals(this.fRequires) && !hasWorkitems && !hasComment) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.15");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.16");
            }
            if (problemSummary != null) {
                collector.addInfo((IReportInfo)this.createProblem(problemSummary, problemDetail, collector, data, changeSet, workItems, projectArea, false, false));
                return;
            }
            IAdvisorInfo info = null;
            if (hasWorkitems) {
                String ownerProblem;
                workItems = this.items.fetchItems(workItems, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
                ListIterator iterator = workItems.listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemAdvisor.ERROR_MSG"), (Throwable)new TeamRepositoryException(Messages.getString("RequireWorkItemAdvisor.18"))));
                    iterator.remove();
                }
                StringBuffer buffer = new StringBuffer();
                String targetProblem = this.checkTarget(workItems, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                if (targetProblem != null) {
                    buffer.append(targetProblem);
                }
                if ((ownerProblem = this.checkOwner(workItems, (IProgressMonitor)new SubProgressMonitor(monitor, 300))) != null) {
                    buffer.append(ownerProblem);
                }
                if (buffer.length() > 0) {
                    String summary = Messages.getString("RequireWorkItemAdvisor.19");
                    if (workItems.size() == 1) {
                        summary = Messages.getString("RequireWorkItemAdvisor.20");
                    }
                    info = this.createProblem(summary, buffer.toString(), collector, data, changeSet, workItems, projectArea, targetProblem != null, ownerProblem != null);
                }
            }
            if (info != null) {
                collector.addInfo(info);
            }
        }
        finally {
            monitor.done();
        }
    }

    private String checkTarget(List workItems, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        if (VAL_OPTIONAL.equals(this.fTarget) || numWorkItems == 0) {
            return null;
        }
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.21"), numWorkItems * 1000);
        try {
            for (IWorkItem workItem : workItems) {
                if (!this.hasRequiredTarget(workItem, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return null;
            }
        }
        finally {
            monitor.done();
        }
        if (VAL_REQUIRED.equals(this.fTarget)) {
            if (numWorkItems == 1) {
                return Messages.getString("RequireWorkItemAdvisor.22");
            }
            return Messages.getString("RequireWorkItemAdvisor.23");
        }
        if (numWorkItems == 1) {
            return Messages.getString("RequireWorkItemAdvisor.24");
        }
        return Messages.getString("RequireWorkItemAdvisor.25");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasRequiredTarget(IWorkItem workItem, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.26"), 1000);
        try {
            IIterationHandle handle = workItem.getTarget();
            if (VAL_REQUIRED.equals(this.fTarget)) {
                boolean bl = handle != null;
                return bl;
            }
            if (handle == null) {
                return false;
            }
            if (processArea instanceof IProjectArea) {
                return false;
            }
            IDevelopmentLine line = this.process.getDevelopmentLine((ITeamArea)processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            IIteration target = (IIteration)this.items.fetchItem((IManagedItemHandle)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            IIteration[] currentIterations = this.process.getCurrentIterations(line, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
            int i = currentIterations.length - 1;
            while (i >= 0) {
                IIteration iteration = currentIterations[i];
                if (target.sameItemId((IItemHandle)iteration)) {
                    return true;
                }
                if (iteration.hasDeliverable()) {
                    return false;
                }
                --i;
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private String checkOwner(List workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        if (VAL_OPTIONAL.equals(this.fOwner) || numWorkItems == 0) {
            return null;
        }
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.27"), numWorkItems * 1000);
        try {
            for (IWorkItem workItem : workItems) {
                if (!this.hasRequiredOwner(workItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return null;
            }
        }
        finally {
            monitor.done();
        }
        if (VAL_REQUIRED.equals(this.fOwner)) {
            if (numWorkItems == 1) {
                return Messages.getString("RequireWorkItemAdvisor.28");
            }
            return Messages.getString("RequireWorkItemAdvisor.29");
        }
        if (numWorkItems == 1) {
            return Messages.getString("RequireWorkItemAdvisor.30");
        }
        return Messages.getString("RequireWorkItemAdvisor.31");
    }

    private boolean hasRequiredOwner(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle handle = workItem.getOwner();
        if (handle == null) {
            return false;
        }
        IContributor owner = (IContributor)this.items.fetchItem((IManagedItemHandle)handle, monitor);
        if (VAL_REQUIRED.equals(this.fOwner)) {
            return this.isValidOwner(owner);
        }
        return this.items.getLoggedInContributor().sameItemId((IItemHandle)owner);
    }

    private boolean isValidOwner(IContributor owner) {
        if (owner == null) {
            return false;
        }
        String userId = owner.getUserId();
        return userId != null && userId.trim().length() > 0 && !Messages.getString("RequireWorkItemAdvisor.32").equalsIgnoreCase(userId);
    }

    public String getRequires() {
        return this.fRequires;
    }

    public String getTarget() {
        return this.fTarget;
    }
}

