/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.workitem.common.calm.CALMLinkType;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemLinkTypes {
    public static final String RELATED_WORK_ITEM = "com.ibm.team.workitem.linktype.relatedworkitem";
    public static final String DUPLICATE_WORK_ITEM = "com.ibm.team.workitem.linktype.duplicateworkitem";
    public static final String COPIED_WORK_ITEM = "com.ibm.team.workitem.linktype.copiedworkitem";
    public static final String RELATED_ARTIFACT = "com.ibm.team.workitem.linktype.relatedartifact";
    public static final String ATTACHMENT = "com.ibm.team.workitem.linktype.attachment";
    public static final String BLOCKS_WORK_ITEM = "com.ibm.team.workitem.linktype.blocksworkitem";
    public static final String PARENT_WORK_ITEM = "com.ibm.team.workitem.linktype.parentworkitem";
    public static final String RELATED_CHANGE_MANAGEMENT = "com.ibm.team.workitem.linktype.relatedChangeManagement";
    public static final String BLOCKS_EXECUTION_RECORD = "com.ibm.team.workitem.linktype.blocksTestExecutionRecord";
    public static final String AFFECTS_EXECUTION_RESULT = "com.ibm.team.workitem.linktype.affectsExecutionResult";
    public static final String TESTED_BY_TEST_CASE = "com.ibm.team.workitem.linktype.testedByTestCase";
    public static final String IMPLEMENTS_REQUIREMENT = "com.ibm.team.workitem.linktype.implementsRequirement";
    public static final String IMPLEMENTS_REQUIREMENT_COLLECTION = "com.ibm.team.workitem.linktype.implementsRequirementCollection";
    private static final Set<String> USER_WRITEABLE = new HashSet<String>(Arrays.asList("com.ibm.team.workitem.linktype.duplicateworkitem", "com.ibm.team.workitem.linktype.attachment", "com.ibm.team.workitem.linktype.blocksworkitem", "com.ibm.team.workitem.linktype.parentworkitem"));
    private static List<IEndPointDescriptor> fgWriteableDescriptors;

    public static IEndPointDescriptor getEndPointDescriptor(IReference reference) {
        ILink link = reference.getLink();
        if (link == null) {
            return null;
        }
        IEndPointDescriptor descriptor = link.getThisEndpointDescriptor(reference);
        if (!WorkItemLinkTypes.isSymmetric(descriptor)) {
            return descriptor;
        }
        return link.getLinkType().getTargetEndPointDescriptor();
    }

    public static boolean isSymmetric(IEndPointDescriptor descriptor) {
        return WorkItemLinkTypes.isSymmetric(descriptor.getLinkType());
    }

    public static boolean isSymmetric(ILinkType linkType) {
        return linkType.getSourceEndPointDescriptor().getDisplayName().equals(linkType.getTargetEndPointDescriptor().getDisplayName());
    }

    public static boolean isUserWritable(IEndPointDescriptor descriptor) {
        return WorkItemLinkTypes.isUserWritable(descriptor.getLinkType());
    }

    public static boolean isUserWritable(ILinkType linkType) {
        return !linkType.isConstrained() && !linkType.isInternal() || USER_WRITEABLE.contains(linkType.getLinkTypeId());
    }

    public static List<IEndPointDescriptor> getUserWritableDescriptors() {
        if (fgWriteableDescriptors == null) {
            ArrayList<IEndPointDescriptor> descriptors = new ArrayList<IEndPointDescriptor>();
            for (ILinkType linkType : ILinkTypeRegistry.INSTANCE.allEntries()) {
                if (WorkItemLinkTypes.isUserWritable(linkType.getTargetEndPointDescriptor())) {
                    descriptors.add(linkType.getTargetEndPointDescriptor());
                }
                if (!WorkItemLinkTypes.isUserWritable(linkType.getSourceEndPointDescriptor())) continue;
                descriptors.add(linkType.getSourceEndPointDescriptor());
            }
            fgWriteableDescriptors = descriptors;
        }
        return fgWriteableDescriptors;
    }

    public static IEndPointDescriptor findTargetEndPointDescriptor(String linkTypeId) {
        for (ILinkType linkType : ILinkTypeRegistry.INSTANCE.allEntries()) {
            if (!linkTypeId.equals(linkType.getLinkTypeId())) continue;
            return linkType.getTargetEndPointDescriptor();
        }
        return null;
    }

    public static boolean isUserDeletable(IEndPointDescriptor descriptor) {
        return WorkItemLinkTypes.isUserWritable(descriptor) || WorkItemLinkTypes.isCalmLink(descriptor);
    }

    public static boolean isCalmLink(IEndPointDescriptor type) {
        return CALMLinkType.getCALMLink(type.getLinkType()) != null;
    }

    public static List<IEndPointDescriptor> getUserDeletableDescriptors() {
        return WorkItemLinkTypes.getUserWritableDescriptors();
    }

    public static IItemReference createWorkItemReference(IWorkItem workItem) {
        return IReferenceFactory.INSTANCE.createReferenceToItem(workItem.getItemHandle(), WorkItemTextUtilities.getWorkItemText(workItem, WorkItemLinkTypes.getMaxReferenceCommentLength()));
    }

    public static IItemReference createAttachmentReference(IAttachment attachment) {
        return IReferenceFactory.INSTANCE.createReferenceToItem(attachment.getItemHandle(), WorkItemTextUtilities.getAttachmentText(attachment, WorkItemLinkTypes.getMaxReferenceCommentLength()));
    }

    public static int getMaxReferenceCommentLength() {
        return 250;
    }
}

