/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.workflow.CombinedWorkflowInfos;
import com.ibm.team.workitem.common.internal.workflow.DefaultWorkflow;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowDescriptor;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowManager;
import com.ibm.team.workitem.common.internal.workflow.Messages;
import com.ibm.team.workitem.common.internal.workflow.WorkflowException;
import com.ibm.team.workitem.common.internal.workflow.WorkflowInfo;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class WorkflowManager
extends CacheHelper
implements IWorkflowManager {
    public static final String WORK_FLOW_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.workflow";
    public static final String DEFINITION_ELEMENT = "workflowDefinition";
    public static final String DEFINITION_ELEMENT_ID_ATTRIBUTE = "id";
    public static final String WORKFLOW_ELEMENT = "workflow";
    public static final String WORKFLOW_ELEMENT_NAME_ATTRIBUTE = "name";
    public static final String ACTION_ELEMENT = "action";
    public static final String ACTION_ELEMENT_ID_ATTRIBUTE = "id";
    public static final String ACTION_ELEMENT_NAME_ATTRIBUTE = "name";
    private static final String WORK_FLOW_BINDINGS_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.workflowBinding";
    private static final String BINDING_ELEMENT = "workItemCategoryBinding";
    private static final String WORK_ITEM_CATEGORY_ID_ATTRIBUTE = "workItemCategoryId";
    private static final String WORKFLOW_ID_ATTRIBUTE = "workflowId";
    private static final String EXTENSION_POINT_PLUGIN_ID = "com.ibm.team.workitem.common";
    private static final String WORKFLOW_DESCRIPTION_EXTENSION_POINT_ID = "com.ibm.team.workitem.common.workflowDescription";
    private static final String WORKFLOW_BINDING_EXTENSION_POINT_ID = "com.ibm.team.workitem.common.workflowBinding";
    private static IWorkflowInfo NULL_WORKFLOWINFO = new IWorkflowInfo(){

        @Override
        public String getIdentifier() {
            return "com.ibm.team.workitem.nullworkflow";
        }

        @Override
        public String getName() {
            return "Null Workflow";
        }

        @Override
        public Identifier<IState>[] getAllStateIds() {
            return new Identifier[0];
        }

        @Override
        public Identifier<IState>[] getStateIds(int stateGroups) {
            return new Identifier[0];
        }

        @Override
        public boolean stateGroupContains(int stateGroups, Identifier<IState> stateId) {
            return false;
        }

        @Override
        public int getStateGroup(Identifier<IState> stateId) {
            return 0;
        }

        @Override
        public String getStateName(Identifier<IState> stateId) {
            return null;
        }

        @Override
        public URL getStateIconName(Identifier<IState> stateId) {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction>[] getActionIds(Identifier<IState> stateId) {
            return new Identifier[0];
        }

        @Override
        public Identifier<IResolution>[] getStateResolutionIds(Identifier<IState> stateId) {
            return new Identifier[0];
        }

        @Override
        public boolean getShowResoution(Identifier<IState> state) {
            return false;
        }

        @Override
        public Identifier<IWorkflowAction> getStartActionId() {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction> getResolveActionId() {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction> getReopenActionId() {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction>[] getAllActionIds() {
            return new Identifier[0];
        }

        @Override
        public String getActionName(Identifier<IWorkflowAction> actionId) {
            return null;
        }

        @Override
        public URL getActionIconName(Identifier<IWorkflowAction> actionId) {
            return null;
        }

        @Override
        public Identifier<IResolution>[] getResolutionIds(Identifier<IWorkflowAction> actionId) {
            return new Identifier[0];
        }

        @Override
        public Identifier<IState> getActionResultState(Identifier<IWorkflowAction> actionId) {
            return null;
        }

        @Override
        public Identifier<IResolution>[] getAllResolutionIds() {
            return new Identifier[0];
        }

        @Override
        public String getResolutionName(Identifier<IResolution> resolutionId) {
            return null;
        }

        @Override
        public URL getResolutionIconName(Identifier<IResolution> resolutionId) {
            return null;
        }
    };
    private ProjectAreaRegistry fGlobalMapping = new ProjectAreaRegistry(null);
    private Map<UUID, ProjectAreaRegistry> fProjectAreaRegistry = new HashMap<UUID, ProjectAreaRegistry>();

    public WorkflowManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
        IExtensionRegistry registry = WorkflowManager.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement ce;
            int j;
            IConfigurationElement[] elements;
            int i;
            IExtension[] extensions;
            IExtensionPoint extensionPoint = registry.getExtensionPoint(WORKFLOW_DESCRIPTION_EXTENSION_POINT_ID);
            if (extensionPoint != null) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (i < extensions.length) {
                    elements = extensions[i].getConfigurationElements();
                    j = 0;
                    while (j < elements.length) {
                        ce = elements[j];
                        String id = ce.getAttribute("id");
                        if (id != null) {
                            this.fGlobalMapping.fRegistry.put(id, ce);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if ((extensionPoint = registry.getExtensionPoint(WORKFLOW_BINDING_EXTENSION_POINT_ID)) != null) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (i < extensions.length) {
                    elements = extensions[i].getConfigurationElements();
                    j = 0;
                    while (j < elements.length) {
                        ce = elements[j];
                        this.fGlobalMapping.fBinding.put(ce.getAttribute(WORK_ITEM_CATEGORY_ID_ATTRIBUTE), ce.getAttribute(WORKFLOW_ID_ATTRIBUTE));
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void registerWorkflow(String workflowId, IWorkflowDescriptor descriptor) {
        if (workflowId != null) {
            descriptor.setId(workflowId);
            this.fGlobalMapping.fRegistry.put(workflowId, descriptor);
        }
    }

    public String getWorkflowId(IWorkItem wi, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkflowId(wi, false, monitor);
    }

    private String getWorkflowId(IWorkItem workItem, boolean shortOp, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon peer;
        if (shortOp) {
            Assert.isTrue((boolean)workItem.isPropertySet(IWorkItem.TYPE_PROPERTY));
            Assert.isTrue((boolean)workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY));
        } else if (!(workItem.isPropertySet(IWorkItem.TYPE_PROPERTY) && workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) || workItem.isNewItem())) {
            workItem = this.getAuditableCommon().resolveAuditable(workItem, IWorkItem.SMALL_PROFILE, monitor);
        }
        String workItemType = workItem.getWorkItemType();
        if (workItemType != null && (peer = this.getAuditableCommon().getPeer(IWorkItemCommon.class)) != null) {
            IWorkItemType wt = null;
            wt = shortOp ? peer.findCachedWorkItemType(workItem.getProjectArea(), workItemType) : peer.findWorkItemType(workItem.getProjectArea(), workItemType, monitor);
            if (wt != null) {
                String category = wt.getCategory();
                return this.getWorkflowIdForCategory(workItem.getProjectArea(), category, shortOp, monitor);
            }
        }
        return null;
    }

    public String getWorkItemTypeCategory(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemType wt;
        IWorkItemCommon peer;
        String workItemType = workItem.getWorkItemType();
        if (workItemType != null && workItemType.length() > 0 && (peer = this.getAuditableCommon().getPeer(IWorkItemCommon.class)) != null && (wt = peer.findWorkItemType(workItem.getProjectArea(), workItemType, monitor)) != null) {
            return wt.getCategory();
        }
        return null;
    }

    public String getWorkflowIdForCategory(IProjectAreaHandle projectArea, String category, boolean shortOp, IProgressMonitor monitor) {
        String workflowId;
        if (projectArea != null && (workflowId = this.getProjectAreaRegistry(projectArea, shortOp, monitor).getWorkflowIdForCategory(category)) != null) {
            return workflowId;
        }
        return (String)this.fGlobalMapping.fBinding.get(category);
    }

    public IWorkflowDescriptor getWorkflowDescriptor(IProjectAreaHandle projectArea, String workflowId, boolean shortOp, IProgressMonitor monitor) throws WorkflowException {
        IWorkflowDescriptor workflowDescriptor = null;
        ProjectAreaRegistry projectAreaMapping = null;
        if (projectArea != null && (projectAreaMapping = this.getProjectAreaRegistry(projectArea, shortOp, monitor)) != null) {
            workflowDescriptor = projectAreaMapping.getWorkflowDescriptor(workflowId);
        }
        if (workflowDescriptor == null) {
            projectAreaMapping = this.fGlobalMapping;
        }
        return projectAreaMapping.getWorkflowDescriptor(workflowId);
    }

    public IWorkflowInfo getWorkflowInfo(IProjectAreaHandle projectArea, String workflowId, boolean shortOp, IProgressMonitor monitor) {
        IWorkflowInfo info = null;
        ProjectAreaRegistry projectAreaMapping = null;
        if (projectArea != null && (projectAreaMapping = this.getProjectAreaRegistry(projectArea, shortOp, monitor)) != null) {
            info = projectAreaMapping.getWorkflowInfo(workflowId);
        }
        if (info == null) {
            projectAreaMapping = this.fGlobalMapping;
        }
        return projectAreaMapping.getWorkflowInfo(workflowId);
    }

    public IWorkflowInfo getCachedWorkflowInfo(IWorkItem workItem) {
        String workflowId = null;
        try {
            workflowId = this.getWorkflowId(workItem, true, null);
        }
        catch (TeamRepositoryException e) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.CANNOT_RETRIEVE_WORKFLOWID_FROM_WORKITEM"), (Exception)((Object)e));
        }
        if (workflowId == null) {
            return null;
        }
        return this.getWorkflowInfo(workItem.getProjectArea(), workflowId, true, null);
    }

    public IWorkflowInfo getWorkflowInfo(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkflowInfo info = this.getBoundWorkflowInfo(workItem, monitor);
        if (info == null) {
            info = NULL_WORKFLOWINFO;
        }
        return info;
    }

    public IWorkflowInfo getBoundWorkflowInfo(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        String workflowId = this.getWorkflowId(workItem, false, monitor);
        IWorkflowInfo info = null;
        if (workflowId != null) {
            info = this.getWorkflowInfo(workItem.getProjectArea(), workflowId, false, monitor);
        }
        return info;
    }

    public ICombinedWorkflowInfos getCachedCombinedWorkflowInfos(IProjectAreaHandle projectArea) {
        ProjectAreaRegistry projectAreaMapping;
        if (projectArea != null && (projectAreaMapping = this.getCachedProjectAreaRegistry(projectArea)) != null) {
            return projectAreaMapping.getfCombinedWorkflowInfos();
        }
        return this.fGlobalMapping.getfCombinedWorkflowInfos();
    }

    public ICombinedWorkflowInfos getCombinedWorkflowInfos(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ProjectAreaRegistry projectAreaMapping;
        if (projectArea != null && (projectAreaMapping = this.getProjectAreaRegistry(projectArea, false, monitor)) != null) {
            return projectAreaMapping.getfCombinedWorkflowInfos();
        }
        return this.fGlobalMapping.getfCombinedWorkflowInfos();
    }

    public static boolean containsOnlyBuiltinWorkflows(ICombinedWorkflowInfos info) {
        if (info instanceof CombinedWorkflowInfos) {
            return ((CombinedWorkflowInfos)info).containsOnlyBuiltinWorkflows();
        }
        return false;
    }

    private ProjectAreaRegistry getCachedProjectAreaRegistry(IProjectAreaHandle projectArea) {
        if (projectArea == null) {
            return null;
        }
        UUID itemId = projectArea.getItemId();
        ProjectAreaRegistry projectAreaRegistry = this.fProjectAreaRegistry.get(itemId);
        if (projectAreaRegistry == null) {
            projectAreaRegistry = new ProjectAreaRegistry(projectArea);
            this.fProjectAreaRegistry.put(itemId, projectAreaRegistry);
        }
        return projectAreaRegistry;
    }

    private ProjectAreaRegistry getProjectAreaRegistry(IProjectAreaHandle projectArea, boolean shortOp, IProgressMonitor monitor) {
        if (projectArea == null) {
            return null;
        }
        UUID itemId = projectArea.getItemId();
        if (shortOp) {
            ProjectAreaRegistry projectAreaRegistry = this.fProjectAreaRegistry.get(itemId);
            if (projectAreaRegistry == null) {
                projectAreaRegistry = new ProjectAreaRegistry(projectArea);
                this.fProjectAreaRegistry.put(itemId, projectAreaRegistry);
            }
            return projectAreaRegistry;
        }
        try {
            this.checkCache(projectArea, monitor);
        }
        catch (TeamRepositoryException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.CANT_RESOLVE_WORKFLOW"), (Exception)((Object)x));
        }
        return this.fProjectAreaRegistry.get(itemId);
    }

    private static IExtensionRegistry getExtensionRegistry() {
        IExtensionRegistry registry = null;
        try {
            registry = Platform.getExtensionRegistry();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (registry == null) {
            registry = WorkflowManager.getWorkplaceRegistry();
        }
        if (registry == null) {
            throw new IllegalStateException();
        }
        return registry;
    }

    private static IExtensionRegistry getWorkplaceRegistry() {
        try {
            Class<?> clazz = Class.forName("com.ibm.workplace.extension.ExtensionRegistryFactory");
            Field field = clazz.getField("INSTANCE");
            Object factory = field.get(null);
            Method method = clazz.getMethod("getExtensionRegistry", null);
            return (IExtensionRegistry)method.invoke(factory, new Object[0]);
        }
        catch (ClassNotFoundException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (SecurityException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (NoSuchFieldException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (IllegalArgumentException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (IllegalAccessException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (NoSuchMethodException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (InvocationTargetException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        return null;
    }

    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationElement configurationElement;
        int i;
        IProcessConfigurationElement[] configurationElements;
        if (auditableCommon == null) {
            return;
        }
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        if (projectArea == null) {
            return;
        }
        ProjectAreaRegistry projectAreaMapping = new ProjectAreaRegistry(projectAreaHandle);
        IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(WORK_FLOW_CONFIGURATION_DATA_POINT, monitor);
        if (processConfiguration != null) {
            configurationElements = processConfiguration.getElements();
            i = 0;
            while (i < configurationElements.length) {
                String workflowId;
                configurationElement = configurationElements[i];
                if (DEFINITION_ELEMENT.equals(configurationElement.getName()) && (workflowId = configurationElement.getAttribute("id")) != null && workflowId.length() > 0) {
                    DefaultWorkflow wdesc = new DefaultWorkflow(configurationElement);
                    wdesc.setId(workflowId);
                    projectAreaMapping.fRegistry.put(workflowId, wdesc);
                }
                ++i;
            }
        }
        if ((processConfiguration = process.findProcessConfiguration(WORK_FLOW_BINDINGS_CONFIGURATION_DATA_POINT, monitor)) != null) {
            configurationElements = processConfiguration.getElements();
            i = 0;
            while (i < configurationElements.length) {
                String workflowId;
                String categoryId;
                configurationElement = configurationElements[i];
                if (BINDING_ELEMENT.equals(configurationElement.getName()) && (categoryId = configurationElement.getAttribute(WORK_ITEM_CATEGORY_ID_ATTRIBUTE)) != null && categoryId.length() > 0 && (workflowId = configurationElement.getAttribute(WORKFLOW_ID_ATTRIBUTE)) != null && workflowId.length() > 0) {
                    projectAreaMapping.fBinding.put(categoryId, workflowId);
                }
                ++i;
            }
        }
        projectAreaMapping.resolveImageURLs(auditableCommon, monitor);
        this.fProjectAreaRegistry.put(projectArea.getItemId(), projectAreaMapping);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectAreaRegistry {
        private Map<String, String> fBinding = new HashMap<String, String>();
        private Map<String, Object> fRegistry = new HashMap<String, Object>();
        private Map<String, IWorkflowInfo> fWorkflowInfos = new HashMap<String, IWorkflowInfo>();
        private ICombinedWorkflowInfos fCombinedWorkflowInfos;
        private IProjectAreaHandle fProjectArea;

        ProjectAreaRegistry(IProjectAreaHandle projectArea) {
            this.fProjectArea = projectArea;
        }

        String getWorkflowIdForCategory(String categoryId) {
            return this.fBinding.get(categoryId);
        }

        IWorkflowDescriptor getWorkflowDescriptor(String workflowId) throws WorkflowException {
            Object object = this.fRegistry.get(workflowId);
            if (object instanceof IConfigurationElement) {
                IConfigurationElement ce = (IConfigurationElement)object;
                try {
                    object = ce.createExecutableExtension("class");
                    if (object instanceof IWorkflowDescriptor) {
                        IWorkflowDescriptor wd = (IWorkflowDescriptor)object;
                        wd.setId(workflowId);
                        this.fRegistry.put(workflowId, wd);
                        return wd;
                    }
                }
                catch (CoreException e) {
                    throw new WorkflowException(NLS.bind((String)Messages.getString("WorkflowManager.CANT_CREATE_WORKFLOW"), (Object)workflowId, (Object[])new Object[0]), (Exception)((Object)e));
                }
            }
            if (object instanceof IWorkflowDescriptor) {
                return (IWorkflowDescriptor)object;
            }
            return null;
        }

        IMemento getWorkflowMemento(String workflowId) {
            IWorkflowDescriptor wfd = null;
            try {
                wfd = this.getWorkflowDescriptor(workflowId);
            }
            catch (WorkflowException workflowException) {}
            if (wfd == null) {
                return null;
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)"workflows");
            wfd.getWorkflowInfo((IMemento)memento);
            return memento;
        }

        IWorkflowInfo getWorkflowInfo(String workflowId) {
            IMemento memento;
            IWorkflowInfo info = this.fWorkflowInfos.get(workflowId);
            if (info == null && (memento = this.getWorkflowMemento(workflowId)) != null) {
                IAuditableCommon auditableCommon = WorkflowManager.this.getAuditableCommon();
                info = new WorkflowInfo(this.fProjectArea, workflowId, memento, auditableCommon != null ? auditableCommon.getRepositoryURI() : null);
                this.fWorkflowInfos.put(workflowId, info);
            }
            return info;
        }

        void collectWorkflowInfos(ArrayList<IWorkflowInfo> result) {
            for (String workflowId : this.fRegistry.keySet()) {
                IWorkflowInfo info = this.getWorkflowInfo(workflowId);
                if (info == null) continue;
                int indexOf = result.indexOf(info);
                if (indexOf >= 0) {
                    result.set(indexOf, info);
                    continue;
                }
                result.add(info);
            }
        }

        ICombinedWorkflowInfos getfCombinedWorkflowInfos() {
            if (this.fCombinedWorkflowInfos == null) {
                ArrayList<IWorkflowInfo> result = new ArrayList<IWorkflowInfo>();
                this.collectWorkflowInfos(result);
                IWorkflowInfo[] infos = result.toArray(new IWorkflowInfo[result.size()]);
                this.fCombinedWorkflowInfos = new CombinedWorkflowInfos(infos);
            }
            return this.fCombinedWorkflowInfos;
        }

        void resolveImageURLs(IAuditableCommon auditableCommon, IProgressMonitor monitor) {
            ArrayList<IWorkflowInfo> result = new ArrayList<IWorkflowInfo>();
            this.collectWorkflowInfos(result);
            for (IWorkflowInfo workflowInfo : result) {
                ((WorkflowInfo)workflowInfo).resolveImageURLs(auditableCommon, monitor);
            }
        }
    }
}

