/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.internal.registry.LinkTypeEntry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.workitem.common.internal.identifiers.IAttributeType;
import com.ibm.team.workitem.common.internal.identifiers.IInternalTypeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IPublicAttribute;
import com.ibm.team.workitem.common.internal.identifiers.IPublicType;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierRegistry;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateIdentifierRegistry
extends IdentifierRegistry {
    private static final String REF_ID = "refId";
    private static final String ID = "id";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String NS_REF = "ns";
    private static final String NS_PREFIX = "prefix";
    private static final String NS_URI = "uri";
    private static final String DEFAULT = "default";
    private static final String ATTRIBUTE_TYPE = "attributeType";
    private Map<String, Object[]> fInternalAttributeMap = new HashMap<String, Object[]>();
    private String fDefaultNs;

    @Override
    protected URL getConfigurationFile() {
        return FileLocator.find((String)"com.ibm.team.workitem.common", (IPath)new Path("resources/rest/oslc-attribute-definitions.xml"));
    }

    @Override
    public void writeDefinition(IdentifierMapping def) {
        super.writeDefinition(def);
        Identifier<IPublicType> pubWiTempl = IdentifierMapping.createPublicTypeIdentifier("WorkItemTemplate");
        Identifier<IAttributeType> intWiTempl = IdentifierMapping.createInternalTypeIdentifier("WorkItemTemplate");
        this.getDefinition().declarePublicIdentifier(intWiTempl, pubWiTempl, "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declareInternalIdentifier(pubWiTempl, intWiTempl);
        Identifier<IPublicType> pubWiDesc = IdentifierMapping.createPublicTypeIdentifier("workItems");
        Identifier<IAttributeType> intWiDesc = IdentifierMapping.createInternalTypeIdentifier("workItems");
        this.getDefinition().declarePublicIdentifier(intWiDesc, pubWiDesc, "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declareInternalIdentifier(pubWiDesc, intWiDesc);
        Collection linkTypes = ILinkTypeRegistry.INSTANCE.allEntries();
        for (LinkTypeEntry curType : linkTypes) {
            this.declareLink(curType.getTargetEndPointDescriptor());
            this.declareLink(curType.getSourceEndPointDescriptor());
        }
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.INTEGER, IdentifierMapping.createPublicTypeIdentifier("integer"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.LONG, IdentifierMapping.createPublicTypeIdentifier("long"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.FLOAT, IdentifierMapping.createPublicTypeIdentifier("float"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.BOOLEAN, IdentifierMapping.createPublicTypeIdentifier("boolean"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.FILE_SIZE, IdentifierMapping.createPublicTypeIdentifier("fileSize"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.LONG, IdentifierMapping.createPublicTypeIdentifier("long"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.SMALL_STRING, IdentifierMapping.createPublicTypeIdentifier("smallString"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.MEDIUM_STRING, IdentifierMapping.createPublicTypeIdentifier("mediumString"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.LARGE_STRING, IdentifierMapping.createPublicTypeIdentifier("string"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.MEDIUM_HTML, IdentifierMapping.createPublicTypeIdentifier("mediumHtml"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.LARGE_HTML, IdentifierMapping.createPublicTypeIdentifier("html"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.DURATION, IdentifierMapping.createPublicTypeIdentifier("duration"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.PRIORITY, IdentifierMapping.createPublicTypeIdentifier("priority"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.PROCESS_AREA, IdentifierMapping.createPublicTypeIdentifier("processArea"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.SEVERITY, IdentifierMapping.createPublicTypeIdentifier("severity"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.SUBSCRIPTIONS, IdentifierMapping.createPublicTypeIdentifier("subscriptions"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declarePublicIdentifier(IInternalTypeIdentifiers.TAGS, IdentifierMapping.createPublicTypeIdentifier("tags"), "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.fInternalAttributeMap = null;
    }

    private void declareLink(IEndPointDescriptor endPoint) {
        if (endPoint == null) {
            return;
        }
        Identifier<IAttributeType> intTypId = IdentifierMapping.createInternalTypeIdentifier(endPoint.getLinkType());
        Identifier<IPublicType> pubTypId = IdentifierMapping.createPublicTypeIdentifier(endPoint.getLinkType());
        this.getDefinition().declarePublicIdentifier(intTypId, pubTypId, "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declareInternalIdentifier(pubTypId, intTypId);
        Identifier<ILink> intLinkId = IdentifierMapping.createInternalLinkIdentifier(endPoint);
        Identifier<IPublicAttribute> pubLinkId = IdentifierMapping.createPublicLinkIdentifier(this.getDefinition().getPublicIdentifier(IInternalTypeIdentifiers.WORK_ITEM), endPoint);
        this.getDefinition().declarePublicIdentifier(intLinkId, pubLinkId, "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/");
        this.getDefinition().declareInternalIdentifier(pubLinkId, intLinkId);
        this.getDefinition().declareAttributeType(pubLinkId, pubTypId);
        this.getDefinition().declareAttributeType(intLinkId, intTypId);
    }

    @IdentifierRegistry.XMLPath(value="/configuration/namespaces/ns")
    public void handleNamespace(Attributes attributes) {
        String prefix = attributes.getValue(NS_PREFIX);
        String nsUri = attributes.getValue(NS_URI);
        Boolean isDefault = Boolean.parseBoolean(attributes.getValue(DEFAULT));
        Assert.isNotNull((Object)prefix);
        Assert.isNotNull((Object)nsUri);
        if (isDefault.booleanValue()) {
            this.fDefaultNs = prefix;
        }
        this.getDefinition().declareNamespace(prefix, nsUri);
    }

    @IdentifierRegistry.XMLPath(value="/configuration/attributes/attribute")
    public String handleAttributeDeclaration(Attributes attributes) {
        String intAttrName = attributes.getValue(REF_ID);
        Assert.isNotNull((Object)intAttrName);
        Assert.isTrue((!this.fInternalAttributeMap.containsKey(intAttrName) ? 1 : 0) != 0);
        this.fInternalAttributeMap.put(intAttrName, new Object[3]);
        return intAttrName;
    }

    @IdentifierRegistry.XMLPath(value="/configuration/attributes/attribute/identifier#content")
    public void handleAttributeId(Attributes attributes, String content, String intAttrName) {
        String[] pubAttrId;
        String nsUri = this.getNamespace(attributes.getValue(NS_REF));
        Assert.isNotNull((Object)content);
        Assert.isNotNull((Object)nsUri);
        this.fInternalAttributeMap.get((Object)intAttrName)[0] = pubAttrId = new String[]{nsUri, content};
    }

    @IdentifierRegistry.XMLPath(value="/configuration/attributes/attribute/type#content")
    public void handleAttributeType(Attributes attributes, String content, String intAttrName) {
        Assert.isNotNull((Object)content);
        this.fInternalAttributeMap.get((Object)intAttrName)[1] = content;
    }

    @IdentifierRegistry.XMLPath(value="/configuration/attributes/attribute/name#content")
    public void handleAttributeName(Attributes attributes, String content, String intAttrName) {
        Assert.isNotNull((Object)content);
        this.fInternalAttributeMap.get((Object)intAttrName)[2] = content;
    }

    @IdentifierRegistry.XMLPath(value="/configuration/types/type")
    public Identifier<IAttributeType> handleType(Attributes attributes) {
        String intTypeName = attributes.getValue(ATTRIBUTE_TYPE);
        String pubTypeName = attributes.getValue(ID);
        String nsUri = this.getNamespace(attributes.getValue(NS_REF));
        Assert.isNotNull((Object)intTypeName);
        Assert.isNotNull((Object)pubTypeName);
        Assert.isNotNull((Object)nsUri);
        Identifier<IAttributeType> intTypeId = IdentifierMapping.createInternalTypeIdentifier(intTypeName);
        Identifier<IPublicType> pubTypeId = IdentifierMapping.createPublicTypeIdentifier(pubTypeName);
        this.getDefinition().declarePublicIdentifier(intTypeId, pubTypeId, nsUri);
        this.getDefinition().declareInternalIdentifier(pubTypeId, intTypeId);
        return intTypeId;
    }

    @IdentifierRegistry.XMLPath(value="/configuration/types/type/reference#content")
    public void handleReference(Attributes attributes, String content, Identifier<IAttributeType> intContainerTypeId) {
        Assert.isNotNull((Object)content);
        Object[] attrProps = this.fInternalAttributeMap.get(content);
        Assert.isNotNull((Object)attrProps);
        Identifier<IAttributeType> intTypeId = IdentifierMapping.createInternalTypeIdentifier((String)attrProps[1]);
        Identifier<Object> pubTypeId = this.getDefinition().getPublicIdentifier(intTypeId);
        if (pubTypeId == null) {
            pubTypeId = IdentifierMapping.createPublicTypeIdentifier(intTypeId.getStringIdentifier());
            this.getDefinition().declarePublicIdentifier(intTypeId, pubTypeId, this.getNamespace(this.fDefaultNs));
        }
        Assert.isNotNull(intTypeId);
        Assert.isNotNull(pubTypeId);
        this.getDefinition().declareInternalIdentifier(pubTypeId, intTypeId);
        Identifier<IPublicType> pubContId = this.getDefinition().getPublicIdentifier(intContainerTypeId);
        Identifier<IAttribute> intAttrId = IdentifierMapping.createInternalAttributeIdentifier(intContainerTypeId, content);
        String[] pubAttrPair = (String[])attrProps[0];
        Identifier<IPublicAttribute> pubAttrId = IdentifierMapping.createPublicAttributeIdentifier(pubContId, pubAttrPair[1]);
        String displayName = (String)attrProps[2];
        Assert.isNotNull(intAttrId);
        Assert.isNotNull(pubAttrId);
        Assert.isNotNull((Object)displayName);
        Assert.isTrue((!this.getDefinition().hasIdentifier(pubAttrId) ? 1 : 0) != 0);
        Assert.isTrue((!this.getDefinition().hasIdentifier(intAttrId) ? 1 : 0) != 0);
        this.getDefinition().declarePublicIdentifier(intAttrId, pubAttrId, pubAttrPair[0]);
        this.getDefinition().declareInternalIdentifier(pubAttrId, intAttrId);
        this.getDefinition().declareAttributeType(intAttrId, intTypeId);
        this.getDefinition().declareAttributeType(pubAttrId, pubTypeId);
        this.getDefinition().declareDisplayName(intAttrId, displayName);
        this.getDefinition().declareDisplayName(pubAttrId, displayName);
    }

    @IdentifierRegistry.XMLPath(value="/configuration/types/type/map")
    public void handleMapping(Attributes attributes, Identifier<IAttributeType> intContainerTypeId) {
        if ("workItem".equals(intContainerTypeId.getStringIdentifier())) {
            String attrName = attributes.getValue(FROM);
            String pubAttrName = attributes.getValue(TO);
            String nsUri = this.getNamespace(attributes.getValue(NS_REF));
            String intAttrName = WorkItemAttributes.getAttributeId(Identifier.create(IAttribute.class, attrName));
            Assert.isNotNull((Object)intAttrName);
            Assert.isNotNull((Object)pubAttrName);
            Assert.isNotNull((Object)nsUri);
            Identifier<IPublicType> pubContainerTypeId = this.getDefinition().getPublicIdentifier(intContainerTypeId);
            Assert.isNotNull(intContainerTypeId);
            Assert.isNotNull(pubContainerTypeId);
            Identifier<IAttribute> intAttrId = IdentifierMapping.createInternalAttributeIdentifier(intContainerTypeId, intAttrName);
            Identifier<IPublicAttribute> pubAttrId = IdentifierMapping.createPublicAttributeIdentifier(pubContainerTypeId, pubAttrName);
            Assert.isTrue((!this.getDefinition().hasIdentifier(intAttrId) ? 1 : 0) != 0);
            Assert.isTrue((!this.getDefinition().hasIdentifier(pubAttrId) ? 1 : 0) != 0);
            this.getDefinition().declarePublicIdentifier(intAttrId, pubAttrId, nsUri);
            this.getDefinition().declareInternalIdentifier(pubAttrId, intAttrId);
        }
    }

    private String getNamespace(String nsPrefix) {
        return this.getDefinition().getNamespace(nsPrefix == null ? this.fDefaultNs : nsPrefix);
    }
}

