/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.workitem.common.internal.oslc.Namespaces;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeRegistry;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import org.eclipse.core.runtime.Assert;

public class WorkItemAttributeDescriptor
implements IAttributeDescriptor {
    private IAttribute fAttribute;
    private String fExternalAttributeId;
    private String fNamespace;

    public WorkItemAttributeDescriptor(IAttribute attribute) {
        Assert.isNotNull((Object)attribute);
        this.fAttribute = attribute;
        AttributeRegistry registry = AttributeRegistry.getInstance();
        this.fExternalAttributeId = registry.getExternalWorkItemAttributeId(attribute.getIdentifier());
        this.fNamespace = registry.getExternalWorkItemAttributeNamespace(attribute.getIdentifier());
    }

    public IAttribute getAttribute() {
        return this.fAttribute;
    }

    public String getOwnerType() {
        return "workItem";
    }

    public String getAttributeType() {
        return this.fAttribute.getAttributeType();
    }

    public String getDisplayName() {
        return this.fAttribute.getDisplayName();
    }

    public String getIdentifier() {
        if (this.fExternalAttributeId != null) {
            return this.fExternalAttributeId;
        }
        return this.fAttribute.getIdentifier();
    }

    public boolean isReadOnly() {
        return this.fAttribute.isReadOnly();
    }

    public boolean isCollection() {
        return AttributeTypes.isListAttributeType(this.getAttributeType());
    }

    public String getNamespace() {
        return this.fNamespace == null ? "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/" : this.fNamespace;
    }

    public String getQName() {
        return Namespaces.qualify(this.getNamespace(), this.getIdentifier());
    }
}

