/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ConfigurationItemManager;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Configuration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderConfiguration;
import com.ibm.team.workitem.common.internal.model.Attribute;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.model.WorkItemType;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemTypeManager
extends ConfigurationItemManager<WorkItemType> {
    private static final String EXTENSION_NAME = "workItemType";
    private static final String EXTENSION_POINT_ID = "com.ibm.team.workitem.common.workItemType";
    public static final String ID_ATTRIBUTE = "id";
    private static final String CATEGORY_ATTRIBUTE = "category";
    public static final String NAME_ATTRIBUTE = "name";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String DIMMEDICON_ATTRIBUTE = "dimmedicon";
    private static final String ALIAS_ELEMENT = "alias";
    private static final List<WorkItemType> fgTypes = new ArrayList<WorkItemType>();
    public static final String WORK_ITEM_TYPES_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.workItemTypes";
    public static final String TYPE_ELEMENT = "type";
    private static final String TYPE_GROUP = "types";
    private static final String TYPE_ATTRIBUTE = "type";
    public static final String CUSTOM_ATTRIBUTES_ELEMENT = "customAttributes";
    public static final String CUSTOM_ATTRIBUTE_ELEMENT = "customAttribute";
    public static final String ATTRIBUTE_DEFINITIONS_ELEMENT = "attributeDefinitions";
    public static final String ATTRIBUTE_DEFINITION_ELEMENT = "attributeDefinition";
    private static final String READ_ONLY_ATTRIBUTE = "readOnly";
    private static final String DEPENDS_ON_ELEMENT = "dependsOn";
    private static final String PROVIDERS_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.providers";
    private Map<UUID, Map<String, ItemHandleAwareHashSet<IAttributeHandle>>> fCustomAttributeCache = new HashMap<UUID, Map<String, ItemHandleAwareHashSet<IAttributeHandle>>>();
    private Map<UUID, Map<String, WorkItemType>> fStaticTypesCache = new HashMap<UUID, Map<String, WorkItemType>>();
    private Map<UUID, Map<String, ProviderConfiguration>> fProviderConfigurations = new HashMap<UUID, Map<String, ProviderConfiguration>>();

    static {
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(EXTENSION_NAME)) {
                        String id = element.getAttribute(ID_ATTRIBUTE);
                        String category = element.getAttribute(CATEGORY_ATTRIBUTE);
                        String name = element.getAttribute(NAME_ATTRIBUTE);
                        IConfigurationElement[] aliases = element.getChildren(ALIAS_ELEMENT);
                        ArrayList<String> aliasList = new ArrayList<String>();
                        IConfigurationElement[] iConfigurationElementArray = aliases;
                        int n = aliases.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement alias = iConfigurationElementArray[n2];
                            aliasList.add(alias.getAttribute(NAME_ATTRIBUTE));
                            ++n2;
                        }
                        if (id != null && category != null && name != null) {
                            String dimmedIcon;
                            URL url = null;
                            URL dimmedUrl = null;
                            String icon = element.getAttribute(ICON_ATTRIBUTE);
                            if (icon != null && icon.length() > 0 && (url = FileLocator.find((String)extensions[i].getNamespaceIdentifier(), (IPath)new Path(icon), null)) == null) {
                                try {
                                    url = new URL(icon);
                                }
                                catch (MalformedURLException x) {
                                    WorkItemCommonPlugin.log(x.getMessage(), x);
                                }
                            }
                            if ((dimmedIcon = element.getAttribute(DIMMEDICON_ATTRIBUTE)) != null && dimmedIcon.length() > 0 && (dimmedUrl = FileLocator.find((String)extensions[i].getNamespaceIdentifier(), (IPath)new Path(dimmedIcon), null)) == null) {
                                try {
                                    dimmedUrl = new URL(dimmedIcon);
                                }
                                catch (MalformedURLException x) {
                                    WorkItemCommonPlugin.log(x.getMessage(), x);
                                }
                            }
                            WorkItemTypeManager.put(id, new WorkItemType(null, id, category, Collections.<IAttributeHandle>emptyList(), name, aliasList, url, dimmedUrl, fgTypes.size()));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static WorkItemType[] getWorkItemTypes() {
        return fgTypes.toArray(new WorkItemType[fgTypes.size()]);
    }

    private static void put(String identifier, WorkItemType type) {
        fgTypes.add(type);
    }

    public WorkItemTypeManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    @Override
    public WorkItemType findConfigurationItem(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemType type = (WorkItemType)super.findConfigurationItem(projectArea, identifier, monitor);
        if (type == null) {
            return this.findStaticConfigurationItem(projectArea, identifier);
        }
        return type;
    }

    @Override
    public WorkItemType findCachedConfigurationItem(IProjectAreaHandle projectArea, String identifier) {
        WorkItemType type = (WorkItemType)super.findCachedConfigurationItem(projectArea, identifier);
        if (type == null) {
            return this.findStaticConfigurationItem(projectArea, identifier);
        }
        return type;
    }

    private WorkItemType findStaticConfigurationItem(IProjectAreaHandle projectArea, String identifier) {
        Map<String, WorkItemType> map = this.fStaticTypesCache.get(projectArea.getItemId());
        if (map == null) {
            return null;
        }
        return map.get(identifier);
    }

    @Override
    protected String getConfigurationDataPoint() {
        return WORK_ITEM_TYPES_CONFIGURATION_DATA_POINT;
    }

    @Override
    protected String getElement() {
        return "type";
    }

    @Override
    protected String getGroupElement() {
        return TYPE_GROUP;
    }

    @Override
    protected WorkItemType readElement(IProjectAreaHandle projectArea, IProcessConfigurationElement configurationElement, int sequenceValue, IProgressMonitor monitor) throws TeamRepositoryException {
        String identifier = configurationElement.getAttribute(ID_ATTRIBUTE);
        if (identifier == null) {
            return null;
        }
        String category = configurationElement.getAttribute(CATEGORY_ATTRIBUTE);
        if (category == null) {
            return null;
        }
        String displayName = configurationElement.getAttribute(NAME_ATTRIBUTE);
        if (displayName == null) {
            return null;
        }
        IProcessConfigurationElement[] aliases = configurationElement.getChildren();
        ArrayList<String> aliasList = new ArrayList<String>();
        if (aliases != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                if (element.getName().equals(ALIAS_ELEMENT) && (name = element.getAttribute(NAME_ATTRIBUTE)) != null) {
                    aliasList.add(name);
                }
                ++n2;
            }
        }
        String icon = configurationElement.getAttribute(ICON_ATTRIBUTE);
        URL iconURL = this.createResourceURL((IProcessContainerHandle)projectArea, icon, monitor);
        String dimmedIcon = configurationElement.getAttribute(DIMMEDICON_ATTRIBUTE);
        URL dimmedIconURL = this.createResourceURL((IProcessContainerHandle)projectArea, dimmedIcon, monitor);
        List<IAttributeHandle> attributes = Collections.emptyList();
        ItemHandleAwareHashSet<IAttributeHandle> list = this.getCustomAttributesMap(projectArea, monitor).get(category);
        if (list != null) {
            attributes = new ArrayList<IAttributeHandle>(list);
        }
        return new WorkItemType(projectArea, identifier, category, attributes, displayName, aliasList, iconURL, dimmedIconURL, fgTypes.size() + sequenceValue);
    }

    @Override
    protected List<WorkItemType> readStaticConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, WorkItemType> types = new HashMap<String, WorkItemType>();
        WorkItemType[] staticTypes = WorkItemTypeManager.getWorkItemTypes();
        int i = 0;
        while (i < staticTypes.length) {
            WorkItemType type = staticTypes[i];
            ItemHandleAwareHashSet<IAttributeHandle> list = this.getCustomAttributesMap(projectArea, monitor).get(type.getCategory());
            ArrayList<IAttributeHandle> attributes = list != null ? new ArrayList<IAttributeHandle>(list) : Collections.emptyList();
            WorkItemType newType = new WorkItemType(projectArea, type.getIdentifier(), type.getCategory(), attributes, type.getDisplayName(), type.getAliases(), type.getIconURL(), type.getDimmedIconURL(), i);
            types.put(newType.getIdentifier(), newType);
            ++i;
        }
        this.fStaticTypesCache.put(projectArea.getItemId(), types);
        return Collections.emptyList();
    }

    @Override
    protected void readConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCustomAttributeCache.remove(projectArea.getItemId());
        this.fProviderConfigurations.remove(projectArea.getItemId());
        super.readConfigurationItems(projectArea, monitor);
    }

    public void updateWorkItemTypes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.getAuditableCommon().resolveAuditable((IAuditableHandle)projectArea, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return;
        }
        this.updateCustomAttributes(projectArea, monitor);
    }

    public ProviderConfiguration getProviderConfiguration(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID projectItemId = attribute.getProjectArea().getItemId();
        Map<String, ProviderConfiguration> configurations = this.fProviderConfigurations.get(projectItemId);
        if (configurations == null) {
            configurations = new HashMap<String, ProviderConfiguration>();
            Map<String, AttributeConfiguration> configuration = this.computeCustomAttributeConfiguration(attribute.getProjectArea(), false, monitor);
            ProviderDefinitions providerDefinitions = this.computeProviderDefinitions(attribute.getProjectArea(), monitor);
            for (AttributeConfiguration attributeConfiguration : configuration.values()) {
                IProcessConfigurationElement element = attributeConfiguration.getElement();
                String identifier = WorkItemTypeManager.getAttributeId(element.getAttribute(ID_ATTRIBUTE));
                if (identifier == null) continue;
                ProviderConfiguration providerConfiguration = new ProviderConfiguration(new IConfiguration[0]);
                IProcessConfigurationElement[] iProcessConfigurationElementArray = element.getChildren();
                int n = iProcessConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcessConfigurationElement definition;
                    String providerId;
                    IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
                    if (ProviderConfiguration.PROVIDERS.contains(child.getName()) && (providerId = child.getAttribute("providerId")) != null && (definition = providerDefinitions.getProvider(child.getName(), providerId)) != null) {
                        providerConfiguration.addConfiguration(new Configuration(definition, child));
                    }
                    ++n2;
                }
                configurations.put(identifier, providerConfiguration);
            }
            this.fProviderConfigurations.put(projectItemId, configurations);
        }
        return configurations.get(attribute.getIdentifier());
    }

    private Map<String, ItemHandleAwareHashSet<IAttributeHandle>> getCustomAttributesMap(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<String, ItemHandleAwareHashSet<IAttributeHandle>> customAttributes = this.fCustomAttributeCache.get(projectArea.getItemId());
        if (customAttributes == null) {
            Map<String, AttributeConfiguration> configuration = this.computeCustomAttributeConfiguration(projectArea, true, monitor);
            customAttributes = new HashMap<String, ItemHandleAwareHashSet<IAttributeHandle>>();
            for (AttributeConfiguration attributeConfiguration : configuration.values()) {
                for (String category : attributeConfiguration.getCategories()) {
                    ItemHandleAwareHashSet<IAttributeHandle> handles = customAttributes.get(category);
                    if (handles == null) {
                        handles = new ItemHandleAwareHashSet();
                        customAttributes.put(category, handles);
                    }
                    if (attributeConfiguration.getAttribute() == null) continue;
                    handles.add((IAttributeHandle)attributeConfiguration.getAttribute().getItemHandle());
                }
            }
            this.fCustomAttributeCache.put(projectArea.getItemId(), customAttributes);
        }
        return customAttributes;
    }

    private void updateCustomAttributes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationElement configurationElement;
        Map<String, AttributeConfiguration> configuration = this.computeCustomAttributeConfiguration(projectArea, true, monitor);
        IWorkItemCommon workItemCommon = this.getWorkItemCommon();
        for (AttributeConfiguration attributeConfiguration : configuration.values()) {
            String name;
            configurationElement = attributeConfiguration.getElement();
            if (attributeConfiguration.getAttribute() == null) {
                String type;
                String identifier = WorkItemTypeManager.getAttributeId(configurationElement.getAttribute(ID_ATTRIBUTE));
                if (identifier == null || (type = configurationElement.getAttribute("type")) == null || !AttributeTypes.isSupportedCustomAttributeType(type)) continue;
                IAttribute attribute = workItemCommon.createNewAttribute(projectArea, identifier, type, "_meta", monitor);
                attributeConfiguration.setAttribute(attribute);
            }
            if ((name = configurationElement.getAttribute(NAME_ATTRIBUTE)) == null) continue;
            Boolean readOnly = Boolean.valueOf(configurationElement.getAttribute(READ_ONLY_ATTRIBUTE));
            IAttribute workingCopy = (IAttribute)attributeConfiguration.getAttribute().getWorkingCopy();
            if (name != null && !name.equals(workingCopy.getDisplayName())) {
                workingCopy.setDisplayName(name);
                attributeConfiguration.setAttribute(workingCopy);
            }
            if (readOnly.booleanValue() == workingCopy.isReadOnly()) continue;
            ((Attribute)workingCopy).setReadOnly(readOnly);
            attributeConfiguration.setAttribute(workingCopy);
        }
        for (AttributeConfiguration attributeConfiguration : configuration.values()) {
            if (!attributeConfiguration.hasChildElement(DEPENDS_ON_ELEMENT)) continue;
            configurationElement = attributeConfiguration.getElement();
            ItemHandleAwareHashSet<IAttribute> dependentAttributes = new ItemHandleAwareHashSet<IAttribute>();
            IProcessConfigurationElement[] iProcessConfigurationElementArray = configurationElement.getChildren();
            int n = iProcessConfigurationElementArray.length;
            int workingCopy = 0;
            while (workingCopy < n) {
                String dependentAttributeId;
                IProcessConfigurationElement dependencyElement = iProcessConfigurationElementArray[workingCopy];
                if (DEPENDS_ON_ELEMENT.equals(dependencyElement.getName()) && (dependentAttributeId = WorkItemTypeManager.getAttributeId(dependencyElement.getAttribute(ID_ATTRIBUTE))) != null) {
                    IAttributeHandle dependentAttribute = null;
                    if (configuration.containsKey(dependentAttributeId)) {
                        AttributeConfiguration dependentConfiguration = configuration.get(dependentAttributeId);
                        dependentAttribute = (IAttributeHandle)dependentConfiguration.getAttribute().getItemHandle();
                    } else {
                        dependentAttribute = workItemCommon.findAttribute(projectArea, dependentAttributeId, monitor);
                    }
                    if (dependentAttribute != null) {
                        dependentAttributes.add((IAttribute)dependentAttribute);
                    }
                }
                ++workingCopy;
            }
            ItemHandleAwareHashSet<IAttributeHandle> existing = new ItemHandleAwareHashSet<IAttributeHandle>(attributeConfiguration.getAttribute().getDependencies());
            if (existing.containsAll(dependentAttributes) && dependentAttributes.containsAll(existing)) continue;
            IAttribute workingCopy2 = (IAttribute)attributeConfiguration.getAttribute().getWorkingCopy();
            workingCopy2.getDependencies().clear();
            workingCopy2.getDependencies().addAll(dependentAttributes);
            attributeConfiguration.setAttribute(workingCopy2);
        }
        for (AttributeConfiguration attributeConfiguration : configuration.values()) {
            if (!attributeConfiguration.isUpdated()) continue;
            workItemCommon.saveAttribute(attributeConfiguration.getAttribute(), monitor);
        }
    }

    private Map<String, AttributeConfiguration> computeCustomAttributeConfiguration(IProjectAreaHandle projectArea, boolean resolveAttributes, IProgressMonitor monitor) throws TeamRepositoryException {
        int n;
        IProcessConfigurationElement configurationElement;
        IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(WORK_ITEM_TYPES_CONFIGURATION_DATA_POINT, null);
        if (processConfiguration == null) {
            return Collections.emptyMap();
        }
        IProcessConfigurationElement[] configurationElements = processConfiguration.getElements();
        HashMap<String, AttributeConfiguration> attributeConfiguration = new HashMap<String, AttributeConfiguration>();
        IWorkItemCommon workItemCommon = this.getWorkItemCommon();
        int i = 0;
        while (i < configurationElements.length) {
            configurationElement = configurationElements[i];
            if (ATTRIBUTE_DEFINITIONS_ELEMENT.equals(configurationElement.getName())) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray = configurationElement.getChildren();
                n = iProcessConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String identifier;
                    IProcessConfigurationElement attributeElement = iProcessConfigurationElementArray[n2];
                    if (ATTRIBUTE_DEFINITION_ELEMENT.equals(attributeElement.getName()) && (identifier = WorkItemTypeManager.getAttributeId(attributeElement.getAttribute(ID_ATTRIBUTE))) != null) {
                        IAttribute attribute = resolveAttributes ? workItemCommon.findAttribute(projectArea, identifier, monitor) : null;
                        attributeConfiguration.put(identifier, new AttributeConfiguration(attribute, attributeElement));
                    }
                    ++n2;
                }
            }
            ++i;
        }
        i = 0;
        while (i < configurationElements.length) {
            String category;
            configurationElement = configurationElements[i];
            if (CUSTOM_ATTRIBUTES_ELEMENT.equals(configurationElement.getName()) && (category = configurationElement.getAttribute(CATEGORY_ATTRIBUTE)) != null) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray = configurationElement.getChildren();
                int n3 = iProcessConfigurationElementArray.length;
                n = 0;
                while (n < n3) {
                    String identifier;
                    IProcessConfigurationElement attributeElement = iProcessConfigurationElementArray[n];
                    if (CUSTOM_ATTRIBUTE_ELEMENT.equals(attributeElement.getName()) && (identifier = WorkItemTypeManager.getAttributeId(attributeElement.getAttribute(ID_ATTRIBUTE))) != null) {
                        AttributeConfiguration definition = (AttributeConfiguration)attributeConfiguration.get(identifier);
                        if (definition == null) {
                            IAttribute attribute = resolveAttributes ? workItemCommon.findAttribute(projectArea, identifier, monitor) : null;
                            definition = new AttributeConfiguration(attribute, attributeElement);
                            attributeConfiguration.put(identifier, definition);
                        }
                        definition.addCategory(category);
                    }
                    ++n;
                }
            }
            ++i;
        }
        return attributeConfiguration;
    }

    private static String getAttributeId(String attributeId) {
        if (attributeId == null) {
            return null;
        }
        return WorkItemAttributes.getAttributeId(Identifier.create(IAttribute.class, attributeId));
    }

    private ProviderDefinitions computeProviderDefinitions(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ProviderDefinitions definitions = new ProviderDefinitions();
        IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(PROVIDERS_CONFIGURATION_DATA_POINT, null);
        if (processConfiguration != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = processConfiguration.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                IProcessConfigurationElement[] iProcessConfigurationElementArray2 = element.getChildren();
                int n3 = iProcessConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcessConfigurationElement providerElement = iProcessConfigurationElementArray2[n4];
                    if (ProviderConfiguration.PROVIDERS.contains(providerElement.getName())) {
                        definitions.add(providerElement);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return definitions;
    }

    @Override
    public void doFlushCache(IProjectAreaHandle projectArea) {
        super.doFlushCache(projectArea);
        this.fCustomAttributeCache.remove(projectArea.getItemId());
        this.fStaticTypesCache.remove(projectArea.getItemId());
        this.fProviderConfigurations.remove(projectArea.getItemId());
    }

    private IWorkItemCommon getWorkItemCommon() {
        return this.getAuditableCommon().getPeer(IWorkItemCommon.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeConfiguration {
        private Set<String> fCategories;
        private IAttribute fAttribute;
        private IProcessConfigurationElement fElement;
        private boolean fUpdated;

        public AttributeConfiguration(IAttribute attribute, IProcessConfigurationElement attributeElement) {
            this.fAttribute = attribute;
            this.fElement = attributeElement;
            this.fUpdated = false;
            this.fCategories = new HashSet<String>();
        }

        public IAttribute getAttribute() {
            return this.fAttribute;
        }

        public void addCategory(String category) {
            this.fCategories.add(category);
        }

        public Set<String> getCategories() {
            return this.fCategories;
        }

        public IProcessConfigurationElement getElement() {
            return this.fElement;
        }

        public void setAttribute(IAttribute attribute) {
            this.fAttribute = attribute;
            this.fUpdated = true;
        }

        public boolean isUpdated() {
            return this.fUpdated;
        }

        public boolean hasChildElement(String name) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = this.fElement.getChildren();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement child = iProcessConfigurationElementArray[n2];
                if (name.equals(child.getName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static class ProviderDefinitions {
        private Map<String, Map<String, IProcessConfigurationElement>> fDefinitionMap = new HashMap<String, Map<String, IProcessConfigurationElement>>();

        private ProviderDefinitions() {
        }

        public IProcessConfigurationElement getProvider(String name, String providerId) {
            Map<String, IProcessConfigurationElement> providerMap = this.fDefinitionMap.get(name);
            return providerMap != null ? providerMap.get(providerId) : null;
        }

        public void add(IProcessConfigurationElement providerElement) {
            String providerId;
            Map<String, IProcessConfigurationElement> providerMap = this.fDefinitionMap.get(providerElement.getName());
            if (providerMap == null) {
                providerMap = new HashMap<String, IProcessConfigurationElement>();
                this.fDefinitionMap.put(providerElement.getName(), providerMap);
            }
            if ((providerId = providerElement.getAttribute(WorkItemTypeManager.ID_ATTRIBUTE)) != null) {
                providerMap.put(providerId, providerElement);
            }
        }
    }
}

