/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ListAttributeType
extends AttributeType {
    private final String fContainedType;

    public ListAttributeType(String identifier, String containedType, AttributeOperation[] operations) {
        super(identifier, List.class, operations);
        this.fContainedType = containedType;
    }

    public ListAttributeType(String identifier, String containedType) {
        this(identifier, containedType, new AttributeOperation[]{AttributeOperation.CONTAINING, AttributeOperation.NOT_CONTAINING});
    }

    public Object getNullValue(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.emptyList();
    }

    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        AttributeType containedType = AttributeTypes.getAttributeType(this.getContainedType());
        return containedType.getValueSet(auditableCommon, workItem, attribute, monitor);
    }

    public String getContainedType() {
        return this.fContainedType;
    }

    public String[] getVariables() {
        AttributeType containedType = AttributeTypes.getAttributeType(this.getContainedType());
        return containedType.getVariables();
    }

    public Object valueOf(String stringValue, Object origin) {
        AttributeType containedType = AttributeTypes.getAttributeType(this.getContainedType());
        return containedType.valueOf(stringValue, origin);
    }

    public String toString(Object value) {
        AttributeType containedType = AttributeTypes.getAttributeType(this.getContainedType());
        return containedType.toString(value);
    }
}

