/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.mailconfig;

import com.ibm.team.workitem.common.internal.mailconfig.Messages;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WorkItemChange {
    COMMENT_ADDED("WorkItemChange.COMMENTS", Arrays.asList(IWorkItem.COMMENTS_PROPERTY)),
    SUMMARY_DESCRIPTION_CHANGED("WorkItemChange.SUMMARY_DESCRIPTION", Arrays.asList(IWorkItem.SUMMARY_PROPERTY, IWorkItem.DESCRIPTION_PROPERTY)),
    SEVERITY_PRIORITY_TARGET_CHANGED("WorkItemChange.SEVERITY_PRIORITY_PLANNED_FOR", Arrays.asList(IWorkItem.SEVERITY_PROPERTY, IWorkItem.PRIORITY_PROPERTY, IWorkItem.TARGET_PROPERTY)),
    OWNER_CHANGED("WorkItemChange.OWNER", Arrays.asList(IWorkItem.OWNER_PROPERTY)),
    TAG_CHANGED("WorkItemChange.TAGS", Arrays.asList(IWorkItem.TAGS_PROPERTY)),
    SUBSCRIBERS_CHANGED("WorkItemChange.SUBSCRIBERS", Arrays.asList(IWorkItem.SUBSCRIPTIONS_PROPERTY)),
    LINKS_ADDED_REMOVED("WorkItemChange.LINKS", Arrays.asList("linkAttributeIdentifier")),
    WORK_ITEM_CREATED_REOPENED("WorkItemChange.STATE_CREATED_REOPENED", null),
    WORK_ITEM_COMPLETED("WorkItemChange.STATE_CLOSED", null),
    START_STOP_WORKING_CHANGE("WorkItemChange.STATE_START_STOP_WORKING", null),
    OTHER_STATE_CHANGE("WorkItemChange.STATE_OTHER", null),
    OTHER_CHANGE("WorkItemChange.OTHER", null);

    private final String fNameKey;
    private final List<String> fRelatedAttributeIdentifiers;
    private static Set<String> fgCachedAttributeIdentifiers;

    private WorkItemChange(String nameKey, List<String> relatedAttributeIdentifiers) {
        this.fNameKey = nameKey;
        this.fRelatedAttributeIdentifiers = relatedAttributeIdentifiers;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(LocalizationContext context) {
        return Messages.getString(context, this.fNameKey);
    }

    public boolean isGeneric() {
        return this.fRelatedAttributeIdentifiers != null;
    }

    public boolean applies(Set<String> changedAttributeIdentifiers) {
        Assert.isTrue((boolean)this.isGeneric(), (String)Messages.getString("WorkItemChange.GENERIC_CHANGE_ERROR"));
        for (String identifier : changedAttributeIdentifiers) {
            if (!this.fRelatedAttributeIdentifiers.contains(identifier)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getAttributeIdenfitiers() {
        WorkItemChange[] changes;
        if (fgCachedAttributeIdentifiers != null) {
            return fgCachedAttributeIdentifiers;
        }
        fgCachedAttributeIdentifiers = new HashSet<String>();
        WorkItemChange[] workItemChangeArray = changes = WorkItemChange.values();
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemChange change = workItemChangeArray[n2];
            if (change.isGeneric()) {
                fgCachedAttributeIdentifiers.addAll(change.fRelatedAttributeIdentifiers);
            } else {
                switch (change) {
                    case WORK_ITEM_CREATED_REOPENED: 
                    case WORK_ITEM_COMPLETED: 
                    case START_STOP_WORKING_CHANGE: 
                    case OTHER_STATE_CHANGE: {
                        fgCachedAttributeIdentifiers.add(IWorkItem.STATE_PROPERTY);
                    }
                }
            }
            ++n2;
        }
        return fgCachedAttributeIdentifiers;
    }
}

