/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.internal.expression.Messages;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributorQueryAttributeFactory
implements IQueryableAttributeFactory {
    private static QueryableAttributeDescriptor[] CONTRIBUTOR_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(IContributor.EMAIL_ADDRESS_PROPERTY, Messages.getString("ContributorQueryAttributeFactory.CONTRIBUTOR_EMAIL"), "smallString"), new QueryableAttributeDescriptor(IContributor.NAME_PROPERTY, Messages.getString("ContributorQueryAttributeFactory.CONTRIBUTOR_NAME"), "smallString")};

    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = CONTRIBUTOR_ATTRIBUTES;
        int n = CONTRIBUTOR_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            if (descriptor.getIdentifier().equals(attributeIdentifier)) {
                return new QueryableAttribute(descriptor);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public List<IQueryableAttribute> findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = CONTRIBUTOR_ATTRIBUTES;
        int n = CONTRIBUTOR_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            attributes.add(new QueryableAttribute(descriptor));
            ++n2;
        }
        return attributes;
    }

    public ItemProfile<IContributor> computeProfile(List<IQueryableAttribute> attributes) {
        ArrayList<String> attributeIds = new ArrayList<String>(attributes.size());
        for (IQueryableAttribute attribute : attributes) {
            attributeIds.add(attribute.getIdentifier());
        }
        return ItemProfile.CONTRIBUTOR_DEFAULT.createExtension(attributeIds);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Arrays.asList(IContributor.NAME_PROPERTY, IContributor.EMAIL_ADDRESS_PROPERTY);
    }
}

