/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.AttributeValueProviderDescriptor;
import com.ibm.team.workitem.common.internal.attributeValueProviders.FallbackProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueProviderRegistry
extends ExtensionRegistryReader<AttributeValueProviderDescriptor> {
    private static AttributeValueProviderRegistry fgRegistry;
    private static final String EXTENSION_POINT_ID = "attributeValueProviders";
    private static final String VALUE_PROVIDER = "valueProvider";
    private static final String VALUE_SET_PROVIDER = "valueSetProvider";
    private static final String DEFAULT_VALUE_PROVIDER = "defaultValueProvider";
    private Map<String, AttributeValueProviderDescriptor> fValueProviderMap = new HashMap<String, AttributeValueProviderDescriptor>();
    private Map<String, AttributeValueProviderDescriptor> fValueSetProviderMap = new HashMap<String, AttributeValueProviderDescriptor>();
    private Map<String, AttributeValueProviderDescriptor> fDefaultValueProviderMap = new HashMap<String, AttributeValueProviderDescriptor>();
    private FallbackProvider fDefaultValueProvider = new FallbackProvider();

    public static synchronized AttributeValueProviderRegistry getInstance() {
        if (fgRegistry == null) {
            fgRegistry = new AttributeValueProviderRegistry();
            fgRegistry.start();
        }
        return fgRegistry;
    }

    protected AttributeValueProviderRegistry() {
        super("com.ibm.team.workitem.common", EXTENSION_POINT_ID);
    }

    public IValueProvider<?> getValueProvider(String id, String attributeType) {
        AttributeValueProviderDescriptor descriptor = this.fValueProviderMap.get(id);
        if (id != null && descriptor == null) {
            WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.VALUE_PROVIDER_NOT_FOUND"), (Object)id, (Object[])new Object[0]), null);
        }
        return (descriptor = this.validateType(descriptor, attributeType)) != null ? new SafeValueProvider((IValueProvider)descriptor.getProvider()) : this.fDefaultValueProvider;
    }

    public IValueSetProvider<?> getValueSetProvider(String id, String attributeType) {
        AttributeValueProviderDescriptor descriptor = this.fValueSetProviderMap.get(id);
        if (id != null && descriptor == null) {
            WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.VALUESET_PROVIDER_NOT_FOUND"), (Object)id, (Object[])new Object[0]), null);
        }
        return (descriptor = this.validateType(descriptor, attributeType)) != null ? new SafeValueSetProvider((IValueSetProvider)descriptor.getProvider()) : this.fDefaultValueProvider;
    }

    public IDefaultValueProvider<?> getDefaultValueProvider(String id, String attributeType) {
        AttributeValueProviderDescriptor descriptor = this.fDefaultValueProviderMap.get(id);
        if (id != null && descriptor == null) {
            WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.DEFAULTVALUE_PROVIDER_NOT_FOUND"), (Object)id, (Object[])new Object[0]), null);
        }
        return (descriptor = this.validateType(descriptor, attributeType)) != null ? new SafeDefaultValueProvider((IDefaultValueProvider)descriptor.getProvider()) : this.fDefaultValueProvider;
    }

    private AttributeValueProviderDescriptor validateType(AttributeValueProviderDescriptor descriptor, String attributeType) {
        if (descriptor != null && !descriptor.canHandle(attributeType)) {
            WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.CANNOT_HANDLE_TYPE"), (Object)descriptor.getId(), (Object[])new Object[]{attributeType}), null);
            return null;
        }
        return descriptor;
    }

    protected AttributeValueProviderDescriptor handleExtensionAdded(IConfigurationElement element) throws Exception {
        AttributeValueProviderDescriptor descriptor = new AttributeValueProviderDescriptor(element);
        Map<String, AttributeValueProviderDescriptor> map = this.getMap(element);
        if (map != null) {
            map.put(descriptor.getId(), descriptor);
        }
        return descriptor;
    }

    protected void handleExtensionRemoved(IConfigurationElement element, AttributeValueProviderDescriptor descriptor) throws Exception {
        Map<String, AttributeValueProviderDescriptor> map = this.getMap(element);
        if (map != null) {
            map.remove(descriptor.getId());
        }
    }

    private Map<String, AttributeValueProviderDescriptor> getMap(IConfigurationElement element) {
        if (VALUE_PROVIDER.equals(element.getName())) {
            return this.fValueProviderMap;
        }
        if (VALUE_SET_PROVIDER.equals(element.getName())) {
            return this.fValueSetProviderMap;
        }
        if (DEFAULT_VALUE_PROVIDER.equals(element.getName())) {
            return this.fDefaultValueProviderMap;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SafeDefaultValueProvider
    implements IDefaultValueProvider<Object> {
        private final IDefaultValueProvider<?> fDelegate;

        private SafeDefaultValueProvider(IDefaultValueProvider<?> delegate) {
            Assert.isNotNull(delegate);
            this.fDelegate = delegate;
        }

        @Override
        public Object getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getDefaultValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_DEFAULTVALUE_PROVIDER"), (Object)configuration.getIdentifier(), (Object[])new Object[0]), e);
                return new FallbackProvider().getDefaultValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SafeValueProvider
    implements IValueProvider<Object> {
        private final IValueProvider<?> fDelegate;

        private SafeValueProvider(IValueProvider<?> delegate) {
            Assert.isNotNull(delegate);
            this.fDelegate = delegate;
        }

        @Override
        public Object getValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_VALUE_PROVIDER"), (Object)configuration.getIdentifier(), (Object[])new Object[0]), e);
                return new FallbackProvider().getValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SafeValueSetProvider
    implements IValueSetProvider<Object> {
        private final IValueSetProvider<?> fDelegate;

        private SafeValueSetProvider(IValueSetProvider<?> delegate) {
            Assert.isNotNull(delegate);
            this.fDelegate = delegate;
        }

        @Override
        public List<?> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getValueSet(attribute, workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_VALUESET_PROVIDER"), (Object)configuration.getIdentifier(), (Object[])new Object[0]), e);
                return new FallbackProvider().getValueSet(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }
}

