/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.calm;

import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CALMDocument {
    protected final Document fDocument;
    protected final XPath fXPath;

    public CALMDocument(String xmlContent) throws DocumentParseException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.fDocument = db.parse(new InputSource(new StringReader(xmlContent)));
            XPathFactory factory = XPathFactory.newInstance();
            this.fXPath = factory.newXPath();
            this.fXPath.setNamespaceContext(new NamespaceContextImpl());
        }
        catch (SAXException e) {
            throw new DocumentParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new DocumentParseException(e);
        }
        catch (IOException e) {
            throw new DocumentParseException(e);
        }
    }

    public String getText(String xPathQuery) throws DocumentParseException {
        return this.getText(xPathQuery, this.fDocument);
    }

    public String getText(String xPathQuery, Object node) throws DocumentParseException {
        try {
            return this.fXPath.evaluate(xPathQuery, node);
        }
        catch (XPathExpressionException e) {
            throw new DocumentParseException(e);
        }
    }

    public NodeList getNodes(String xPathQuery) throws DocumentParseException {
        try {
            return (NodeList)this.fXPath.evaluate(xPathQuery, this.fDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new DocumentParseException(e);
        }
    }

    protected static String concatURL(String first, String ... others) {
        StringBuilder buf = new StringBuilder(first);
        String[] stringArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            boolean slash1 = buf.charAt(buf.length() - 1) == '/';
            boolean slash2 = s.startsWith("/");
            if (!slash1 && !slash2) {
                buf.append('/');
            } else if (slash1 && slash2) {
                buf.setLength(buf.length() - 1);
            }
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public static class DocumentParseException
    extends TeamRepositoryException {
        private static final long serialVersionUID = 1L;

        public DocumentParseException(Exception wrapped) {
            super((Throwable)wrapped);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamespaceContextImpl
    implements NamespaceContext {
        private HashMap<String, String> fNamespaces = new HashMap();

        public NamespaceContextImpl() {
            this.fNamespaces.put("dc", "http://purl.org/dc/terms/");
            this.fNamespaces.put("oslc_cm", "http://open-services.net/xmlns/cm/1.0/");
            this.fNamespaces.put("oslc_qm", "http://open-services.net/xmlns/qm/1.0/");
            this.fNamespaces.put("oslc_rm", "http://open-services.net/xmlns/rm/1.0/");
            this.fNamespaces.put("oslc_rdm", "http://open-services.net/xmlns/rdm/1.0/");
            this.fNamespaces.put("oslc_disc", "http://open-services.net/xmlns/discovery/1.0/");
            this.fNamespaces.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.fNamespaces.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            this.fNamespaces.put("calm", "http://jazz.net/xmlns/prod/jazz/calm/1.0/");
            this.fNamespaces.put("jp", "http://jazz.net/xmlns/prod/jazz/process/1.0/");
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String ns = this.fNamespaces.get(prefix);
            if (ns != null) {
                return ns;
            }
            return "";
        }

        @Override
        public String getPrefix(String namespace) {
            for (Map.Entry<String, String> entry : this.fNamespaces.entrySet()) {
                if (!entry.getValue().equals(namespace)) continue;
                return entry.getKey();
            }
            return null;
        }

        public Iterator<?> getPrefixes(String arg0) {
            return null;
        }
    }
}

