/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.WorkspaceComponentGrouping$ComponentFlow;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

class WorkspaceComponentGrouping$ComponentFlowGroup {
    IChangeHistorySyncReport syncReport;
    final List components = new LinkedList();
    final IWorkspaceHandle sourceHandle;
    IWorkspaceConnection source;
    final IWorkspaceHandle targetHandle;
    IWorkspaceConnection target;
    final IClientConfiguration config;

    private WorkspaceComponentGrouping$ComponentFlowGroup(IWorkspaceHandle iWorkspaceHandle, IWorkspaceConnection iWorkspaceConnection, IClientConfiguration iClientConfiguration) {
        this.sourceHandle = iWorkspaceHandle;
        this.target = iWorkspaceConnection;
        this.targetHandle = (IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace();
        this.config = iClientConfiguration;
    }

    private void addFlow(WorkspaceComponentGrouping$ComponentFlow workspaceComponentGrouping$ComponentFlow) {
        this.components.add(workspaceComponentGrouping$ComponentFlow.getComponent());
    }

    private IChangeHistorySyncReport getSyncReport() throws FileSystemClientException, TeamRepositoryException {
        if (this.syncReport == null) {
            if (this.target == null) {
                try {
                    this.target = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getFlowSource().teamRepository()).getWorkspaceConnection(this.targetHandle, null);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.WorkspaceComponentGrouping_0, (Object)this.targetHandle.getItemId()), teamRepositoryException, new IndentingPrintStream(this.config.getContext().stderr()));
                }
            }
            this.syncReport = this.source.compareTo((IFlowNodeConnection)this.target, WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO | WorkspaceComparisonFlags.INCLUDE_EMPTY_BASELINES, RepoUtil.componentComplement((IFlowNodeConnection)this.source, this.components, this.config), null);
        }
        return this.syncReport;
    }

    public IConnection getFlowSource() throws FileSystemClientException {
        if (this.source == null) {
            try {
                this.source = SCMPlatform.getWorkspaceManager((ITeamRepository)this.target.teamRepository()).getWorkspaceConnection(this.sourceHandle, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.WorkspaceComponentGrouping_0, (Object)this.sourceHandle.getItemId()), teamRepositoryException, new IndentingPrintStream(this.config.getContext().stderr()));
            }
        }
        return (IConnection)this.source;
    }

    public IConnection getFlowTarget() throws FileSystemClientException {
        if (this.target == null) {
            try {
                this.target = SCMPlatform.getWorkspaceManager((ITeamRepository)this.source.teamRepository()).getWorkspaceConnection(this.targetHandle, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.WorkspaceComponentGrouping_0, (Object)this.targetHandle.getItemId()), teamRepositoryException, new IndentingPrintStream(this.config.getContext().stderr()));
            }
        }
        return (IConnection)this.target;
    }

    static /* synthetic */ IChangeHistorySyncReport access$0(WorkspaceComponentGrouping$ComponentFlowGroup workspaceComponentGrouping$ComponentFlowGroup) throws FileSystemClientException, TeamRepositoryException {
        return workspaceComponentGrouping$ComponentFlowGroup.getSyncReport();
    }

    /* synthetic */ WorkspaceComponentGrouping$ComponentFlowGroup(IWorkspaceHandle iWorkspaceHandle, IWorkspaceConnection iWorkspaceConnection, IClientConfiguration iClientConfiguration, WorkspaceComponentGrouping$ComponentFlowGroup workspaceComponentGrouping$ComponentFlowGroup) {
        this(iWorkspaceHandle, iWorkspaceConnection, iClientConfiguration);
    }

    static /* synthetic */ void access$2(WorkspaceComponentGrouping$ComponentFlowGroup workspaceComponentGrouping$ComponentFlowGroup, WorkspaceComponentGrouping$ComponentFlow workspaceComponentGrouping$ComponentFlow) {
        workspaceComponentGrouping$ComponentFlowGroup.addFlow(workspaceComponentGrouping$ComponentFlow);
    }
}

