/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIBackupHandler;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException$Type;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil$$Cold;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil$1;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.LightweightEventSource;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPreOperationRefresh;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public abstract class SubcommandUtil {
    private static final LightweightEventSource eventSource = new LightweightEventSource();
    public static final String PROPERTY_WORKSPACE_ROOT = "com.ibm.team.filesystem.cli.core.WorkspaceRoot";
    private static String ELLIPSIS = Messages.SubcommandUtil_25;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$cli$core$util$RepoUtil$SelectorException$Type;

    public static File findAncestorCFARoot(String string) throws FileSystemClientException {
        return SubcommandUtil.findAncestorCFARoot(new File(string));
    }

    public static boolean isEclipseWorkspaceRootSet() {
        Location location = Platform.getInstanceLocation();
        return location.isSet();
    }

    public static IShareable makeShareable(IShare iShare) {
        return iShare.getShareable();
    }

    public static FileSystemCore.UserConfigDir getConfigRoot(String string) throws FileSystemClientException {
        if (string == null) {
            return ClientConfiguration.getDefaultConfigDirectory();
        }
        return new FileSystemCore.UserConfigDir(string, false);
    }

    public static void addPropertyChangeListener(ILightweightEventListener iLightweightEventListener) {
        eventSource.addListener(iLightweightEventListener);
    }

    public static File canonicalize(File file) throws FileSystemClientException {
        return SubcommandUtil$$Cold.canonicalize(file);
    }

    public static String canonicalize(String string) throws FileSystemClientException {
        return SubcommandUtil$$Cold.canonicalize(string);
    }

    public static void addRepoLocationToOptions(Options options) throws ConflictingOptionException {
        SubcommandUtil$$Cold.addRepoLocationToOptions(options);
    }

    public static File findAncestorCFARoot(File file) throws FileSystemClientException {
        return SubcommandUtil$$Cold.findAncestorCFARoot(file);
    }

    public static File findNamedAncestorCFARoot(String string) throws FileSystemClientException {
        return SubcommandUtil$$Cold.findNamedAncestorCFARoot(string);
    }

    public static void initializeEclipseWorkspaceRoot(File file) throws FileSystemClientException {
        URL uRL;
        Location location = Platform.getInstanceLocation();
        if (location.isSet()) {
            throw (Throwable)StatusHelper.internalError(Messages.SubcommandUtil_7);
        }
        String string = file.getAbsolutePath();
        try {
            uRL = new URL("file", null, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw (Throwable)StatusHelper.internalError(Messages.SubcommandUtil_8);
        }
        boolean bl = location.setURL(uRL, true);
        if (!bl) {
            throw (Throwable)StatusHelper.cfaInUse(uRL);
        }
        eventSource.fireEvent((ILightweightEvent)new SubcommandUtil$1(file));
    }

    public static File getEclipseWorkspaceRoot() throws FileSystemClientException {
        return SubcommandUtil$$Cold.getEclipseWorkspaceRoot();
    }

    public static IPath getCFARoot(IPath iPath, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        return SubcommandUtil$$Cold.getCFARoot(iPath, iClientConfiguration);
    }

    public static Map getAffectedShareRoots(ISandbox iSandbox, IPath iPath) throws FileSystemClientException {
        return SubcommandUtil$$Cold.getAffectedShareRoots(iSandbox, iPath);
    }

    public static Object findExceptionByType(Class clazz, TeamRepositoryException teamRepositoryException) throws  {
        return SubcommandUtil$$Cold.findExceptionByType(clazz, teamRepositoryException);
    }

    public static ICopyFileAreaView getAffectedComponentsAndShares(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        return SubcommandUtil$$Cold.getAffectedComponentsAndShares(iClientConfiguration);
    }

    public static ICopyFileAreaView getAffectedComponentsAndShares(IClientConfiguration iClientConfiguration, ISandbox iSandbox, IPath iPath) throws FileSystemClientException {
        return SubcommandUtil$$Cold.getAffectedComponentsAndShares(iClientConfiguration, iSandbox, iPath);
    }

    public static void addToMapOfLists(Map map, Object object, Object object2) throws  {
        SubcommandUtil$$Cold.addToMapOfLists(map, object, object2);
    }

    public static void addToMapOfSets(Map map, Object object, Object object2) throws  {
        SubcommandUtil$$Cold.addToMapOfSets(map, object, object2);
    }

    public static IPath makeRelativeToCFARoot(IPath iPath, IPath iPath2) throws  {
        return SubcommandUtil$$Cold.makeRelativeToCFARoot(iPath, iPath2);
    }

    public static void displaySelectorException(RepoUtil$SelectorException repoUtil$SelectorException, IClientConfiguration iClientConfiguration) {
        IndentingPrintStream indentingPrintStream = new IndentingPrintStream(iClientConfiguration.getContext().stderr());
        if (repoUtil$SelectorException.isSelectorAmbiguous()) {
            if (!$assertionsDisabled && repoUtil$SelectorException.hasMultipleSelectors()) {
                throw (Throwable)((Object)new AssertionError());
            }
            indentingPrintStream.println(NLS.bind((String)Messages.SubcommandUtil_13, (Object)repoUtil$SelectorException.getSelector()));
        } else if (repoUtil$SelectorException.isSelectorUnmatched()) {
            boolean bl = repoUtil$SelectorException.hasMultipleSelectors();
            if (bl) {
                indentingPrintStream.println(SubcommandUtil.getUnmatchedSelectorMsg(bl, repoUtil$SelectorException.getType(), SubcommandUtil.getPluralizedList(repoUtil$SelectorException.getSelectors()).toString()));
            } else {
                indentingPrintStream.println(SubcommandUtil.getUnmatchedSelectorMsg(bl, repoUtil$SelectorException.getType(), repoUtil$SelectorException.getSelector()));
            }
        }
        if (repoUtil$SelectorException.getPossibilities() != null && repoUtil$SelectorException.getPossibilities().size() > 0) {
            indentingPrintStream.println(Messages.SubcommandUtil_16);
            IndentingPrintStream indentingPrintStream2 = indentingPrintStream.indent();
            for (IItem iItem : repoUtil$SelectorException.getPossibilities()) {
                indentingPrintStream2.println(AliasUtil.selector(SubcommandUtil.getNameOf(iItem), iItem.getItemId()));
            }
        }
    }

    private static String getUnmatchedSelectorMsg(boolean bl, RepoUtil$SelectorException$Type repoUtil$SelectorException$Type, String string) throws  {
        return SubcommandUtil$$Cold.getUnmatchedSelectorMsg(bl, repoUtil$SelectorException$Type, string);
    }

    private static StringBuffer getPluralizedList(Collection collection) throws  {
        return SubcommandUtil$$Cold.getPluralizedList(collection);
    }

    private static String getNameOf(IItem iItem) throws  {
        return SubcommandUtil$$Cold.getNameOf(iItem);
    }

    public static String sanitizeText(String string, int n, boolean bl) {
        String string2 = string.replaceAll("\r\n", ".");
        string2 = string2.replace('\r', '.');
        if ((string2 = string2.replace('\n', '.')).length() > n) {
            if (bl) {
                return string2.subSequence(0, n - ELLIPSIS.length()) + ELLIPSIS;
            }
            return string2.subSequence(0, n).toString();
        }
        return string2;
    }

    public static IPath makePath(IClientConfiguration iClientConfiguration, String string) throws FileSystemClientException {
        return SubcommandUtil$$Cold.makePath(iClientConfiguration, string);
    }

    public static IPath makeAbsolutePath(IClientConfiguration iClientConfiguration, String string) throws FileSystemClientException {
        String string2 = iClientConfiguration.getContext().getCurrentWorkingDirectory();
        IPath iPath = SubcommandUtil.makeAbsolutePath(new File(string2), string);
        return iPath;
    }

    public static ISandbox findSandboxContaining(IPath iPath) throws FileSystemClientException {
        return SubcommandUtil$$Cold.findSandboxContaining(iPath);
    }

    public static List makeAbsolutePaths(IClientConfiguration iClientConfiguration, List list) throws FileSystemClientException {
        ArrayList<IPath> arrayList = new ArrayList<IPath>(list.size());
        File file = new File(iClientConfiguration.getContext().getCurrentWorkingDirectory());
        for (String string : list) {
            IPath iPath = SubcommandUtil.makeAbsolutePath(file, string);
            arrayList.add(iPath);
        }
        return arrayList;
    }

    private static IPath makeAbsolutePath(File file, String string) throws FileSystemClientException {
        return SubcommandUtil$$Cold.makeAbsolutePath(file, string);
    }

    public static void printDebugTiming(String string, PrintStream printStream) throws  {
        SubcommandUtil$$Cold.printDebugTiming(string, printStream);
    }

    public static CharSequence getExecutionString(ISubcommandDefinition iSubcommandDefinition) throws  {
        return SubcommandUtil$$Cold.getExecutionString(iSubcommandDefinition);
    }

    public static IFilesystemRestClient startDaemon(ISandbox[] iSandboxArray, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        return SubcommandUtil$$Cold.startDaemon(iSandboxArray, iClientConfiguration);
    }

    public static void registerSandboxes(IFilesystemRestClient iFilesystemRestClient, ISandbox[] iSandboxArray, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        SubcommandUtil$$Cold.registerSandboxes(iFilesystemRestClient, iSandboxArray, iClientConfiguration);
    }

    public static void loginToClient(IClientConfiguration iClientConfiguration, ITeamRepository iTeamRepository, IFilesystemRestClient iFilesystemRestClient) throws FileSystemClientException {
        SubcommandUtil$$Cold.loginToClient(iClientConfiguration, iTeamRepository, iFilesystemRestClient);
    }

    public static int getTerminalWidth() throws FileSystemClientException {
        return SubcommandUtil$$Cold.getTerminalWidth();
    }

    public static void showShedUpdate(String string, IndentingPrintStream indentingPrintStream, List list) throws  {
        SubcommandUtil$$Cold.showShedUpdate(string, indentingPrintStream, list);
    }

    public static void showShedUpdate(String string, IndentingPrintStream indentingPrintStream, CLIBackupHandler cLIBackupHandler) throws  {
        SubcommandUtil$$Cold.showShedUpdate(string, indentingPrintStream, cLIBackupHandler);
    }

    public static ParmsPreOperationRefresh getPreopRefreshPolicy(IClientConfiguration iClientConfiguration) throws  {
        return SubcommandUtil$$Cold.getPreopRefreshPolicy(iClientConfiguration);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$cli$core$util$RepoUtil$SelectorException$Type() {
        if ($SWITCH_TABLE$com$ibm$team$filesystem$cli$core$util$RepoUtil$SelectorException$Type != null) {
            return $SWITCH_TABLE$com$ibm$team$filesystem$cli$core$util$RepoUtil$SelectorException$Type;
        }
        int[] nArray = new int[RepoUtil$SelectorException$Type.values().length];
        try {
            nArray[RepoUtil$SelectorException$Type.BASELINE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.CHANGESET.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.COMPONENT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.CONTRIBUTOR.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.SNAPSHOT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.STREAM.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.VERSIONABLE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.WORKITEM.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RepoUtil$SelectorException$Type.WORKSPACE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$ibm$team$filesystem$cli$core$util$RepoUtil$SelectorException$Type = nArray;
        return nArray;
    }
}

